Function Secnds:Real;
{
    This function returns the seconds past midnight as Real number

    Input        None

    Output       Secnds   Seconds past midnight as a Real number

    Strategy     (1)      Call DOS to get the time

                 (2)      Convert to floating point seconds past midnight

}
Type
    Result=Record
                 Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags:Integer;
    End;
Var
   Sys:Result;
Begin
     SYS.AX:=$2C00          { AH is get time };
     Intr($21,Sys);
     If Odd(Sys.Flags) then
     Begin
          Writeln('Error getting the time');
          Halt;
     End;
     Secnds:=Lo(SYS.DX)/100.+Hi(SYS.DX)+60.*(Lo(SYS.CX)+60.*Hi(SYS.CX));
End;

