/*  mshdir.c    -- show a Minix file directory */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MSHDIR.C_V 1.4 91/03/19 13:50:20 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    "mfs.h"
#include    "dev.h"

READ_FILE
SHOW_ENT
SHOW_NAME

extern BOOL     Nonly ;


/*==================================================================*/
PRIVATE int dcompare (elem1, elem2)
struct directory    *elem1 ;
struct directory    *elem2 ;
{
    return (strncmp(elem1->d_name, elem2->d_name, NAME_SIZE)) ;

} /* dcompare() */


/*==================================================================*/
void show_dir (ddata, iarea, ip, path)
struct devdata  *ddata ;
struct inode    *iarea ;
struct inode    *ip ;
char            *path ;
{
    struct directory    *darea, *dp ;
    int                 dn, dnz ;

    int         i, j, k, n ;
    char        c, *p ;
    char        npath[MAX_PATH+1] ;


    dn = ip->i_size / sizeof(struct directory) ;
    dnz = dn * sizeof(struct directory) + BLOCK_SIZE - 1 ;
    dnz /= BLOCK_SIZE ;
    dnz *= BLOCK_SIZE ;
    dnz /= sizeof(struct directory) ;
    darea = calloc (dnz+1, sizeof(struct directory)) ;
    if (!darea)
        exit(3) ;

    read_file (darea, ip, ddata) ;

/*  Sort the directory entries by filename
 */
    qsort (darea, dn, sizeof(struct directory), dcompare) ;

/*  First show the directory contents
 */
    if (!Nonly)
        printf("Directory: %s\n", path) ;

    dp = darea ;
    for (i=0; i<dn; i++, dp++)
    {
        if (dp->d_inum)
        {
            if (Nonly)
                show_name(path, dp, iarea) ;
            else
                show_ent (iarea, dp) ;
        }

    }
    if (!Nonly)
        printf ("\n") ;

/*  Now, for those entries that are themselves directories,
 *  display them recursively.
 */
    dp = darea + 2 ;            /* skip over . and .. entries */
    for (i=2; i<dn; i++, dp++)
    {
        if (n = dp->d_inum) /*assignok*/
            if ((iarea[n].i_mode & I_TYPE) == I_DIRECTORY)
            {
                strcpy(npath, path) ;
                if (npath[1])
                    strcat(npath, "/") ;
                p = npath + strlen(npath) ;
                for (j=0; (j<NAME_SIZE) && (c=dp->d_name[j]);
                          j++, p++) /*assignok*/
                    *p = c ;
                *p = '\0' ;
                show_dir(ddata, iarea, &iarea[n], npath) ;
            }
    }

/*  Clean up
 */
    free (darea) ;

} /* show_dir() */


/*---eof---*/
