.TH DVIX 1 "26 April 1989" "X Version 11"
.SH NAME
dvix \- DVI Previewer for X Window System Version 11
.SH SYNOPSIS
.B dvix
[-s \fIshrink\fP] [-S \fIdensity\fP] [-p \fIpixels\fP] [-l] [-rv]
[-fg \fIcolor\fP] [-bg \fIcolor\fP] [-bd \fIcolor\fP] [-ms \fIcolor\fP]
[-geometry \fIgeometry\fP | =\fIgeometry\fP]
[-clip \fIgeometry\fP | -clip \fIoff\fP ]
[-nopixmap | -ps \fIKbytes\fP]
[-display \fIhost:display\fP | \fIhost:display\fP] dvi_file

.SH DESCRIPTION
.I Dvix
is a program which runs under version 11 of the X window system. It
may be used to preview DVI files, such as produced by TeX and LaTeX.
It also includes limited support for tpic.
.PP
One major difference between
.I dvix
and its cousin
.I xdvi
is that this program constructs the textual portion of the page image
in the client and then ships the image to the server resulting in faster
rendering on some systems.  It is also useful in conjunction with
X servers that have limited resources for display memory, such as
X terminals.
.SH OPTIONS
.PP
The 
\fB-p\fP
option defines the pixels per inch for font selection.
This determines which size TeX fonts are to be used as the 1:1 mapping.
Default value is 300.
.PP
The 
\fB-s\fP
option defines the initial shrink factor.
.I Dvix
can shrink the fonts in order to fit more of the page into the window
at once.  Of course, resolution is lost when the fonts are reduced, so
the text is harder to read.
Default value is 4.
The
\fB-S\fP
option defines the initial density factor [1/threshold used when shrinking].
Default value is 3.
.PP
The 
\fB-l\fP
option causes the fonts used to be listed on diagnostic output.
.PP
The \fB-clip\fP option may be used to constrain the maximum size of the
window created at start-up time.  The window size may be specified
using either the ``<width>x<height>'' or the ``[+-]<x>[+-]<y>''
component of an X geometry specification.  In the first case, the
clipping size is absolute, while in the second case it is relative to
the size of the screen.  If both components are specified, the smallest
positive specification takes precendence in each dimenesion.  A value
of ``off'' or ``0x0'' may be used to clipping of the window size.  The
default is ``-0-0''.
.PP
The \fB-nopixmap\fP option may be used to turn off the backing pixmap.
This will cause scrolling to operate less smoothly, but will not
significantly affect the page display or refresh time.  This may
be used on servers where pixmap memory is a scarce or costly resource,
such as NCD display terminals or overloaded Sun 3/50s.
.PP
The \fB-ps\fP option may be used to set a threshold size for the
backing pixmap.  A backing pixmap will be used to speed up scrolling
only if it will occupy less than the given amount of server memory (in
Kbytes).  This value can also be specified using the \fBpixmapSize\fP
resource option.  The default value is 8192KB or 8MB.
.PP
The remaining options have their usual meaning.
.SH MOUSE
.PP
Clicking the right button will display the next page.  Clicking the left
button will display the previous page.
Clicking the right button with the Shift key held down will display the next
window full to the right.
Clicking the left button with the Shift
key held down will display the previous window full to the left.
Dragging with the middle button will drag the page image across the window
for scrolling.
Clicking the middle button with the Shift key held down
will move the indicated point near to the center of the window.
Dragging with the middle button while the Control key is down activates the
relative (accelerated) scroll mode.
.SH KEYBOARD
.PP
You can exit the program by typing `q', control-C, or control-D.
You can move to the next page with `n', `f', or SPACE.
You can move the the previous page with `p', `b', or control-H.
You can move up a window-full with `u', down with `d', left with `l',
and right with `r'.
You can change the shrink factor by typing in the number (one or more digits),
followed by `s'.
If you type `s' without a number, the smallest factor that makes the entire
page fit in the window will be used.
You can force redisplay with control-L.
You can move a relative number of pages by typing an optional `-',
a number (one or more digits) and then carriage return or line feed.
You can move to a specific page by typing a number (one or more digits)
and then `g'.
You can move to the last page by typing `g' without a number.
.PP
A number of ``new'' commands and modes have also been added.
You can change the density factor using `S' with a numeric argument.
A reference grid can be toggled on and off with 'G'.
The solid lines represent one inch of printer resolution;
The scale of the dotted lines varies with the shrink-factor.
You can move up a quarter window with 'U',
down a quarter window with 'D', left a quarter window with 'L',
and right a quarter window with 'R'.  A positive integer argument may
be provided to {lrud} and {LRUD} commands; the units are 1/10 inch in
printer resolution.  Relative positioning is accomplished using n{lrud},
while n{LRUD} performs absolute positioning.  Finally, \fIdvix\fP has
been changed to detect a change in the input file.  Each time a page is
refreshed, it checks to see if the file has changed; if so, the session
is re-initialized.  The user can also force the system to reload the
file using the 'i' command.
.SH "XDEFAULTS"
.I Dvix
will look for the following .Xdefaults options.  The default values are
indicated in square brackets.
.PP
background [white]
.PP
borderColor [black]
.PP
borderWidth [2]
.PP
clip [-0-0]
.PP
densityFactor [3]
.PP
foreground [black]
.PP
geometry [depends on the shrink factor]
.PP
pixelsPerInch [300]
.PP
pointerColor [black]
.PP
reverseVideo [off|on]
.PP
shrinkFactor [4]
.PP
pixmapSize [8192]
.SH ENVIRONMENT
.PP
Uses the environment variable ``DISPLAY'' to specify which bit map display
terminal to use.
.PP
Uses the environment variable ``TEXFONTS'' to determine the search path
for fonts.
.SH "SEE ALSO"
latex(1), tex(1), texx(1), tpic(l), X(1).
.SH "BUGS"
.PP
-does not use the mouse color (-\fIms\fP).
.PP
-may not scroll properly on color Suns (due to a server bug).
.PP
-does not support GF fonts.
.PP
-always assumes it is previewing an 8.5 by 11 inch page.
.PP
-internal debugging code is now out of date and needs to be fixed.
.SH "AUTHORS"
Eric Cooper, CMU, did a version for direct output to a QVSS.
.PP
Modified for X by
Bob Scheifler, MIT Laboratory for Computer Science.
.PP
Reworked for X11 by
Jeff Lee, Department of Computer Science, University of Toronto (formerly at UWO).
