/*
 *   MDVXHELP - A utility to create DV/X Help Files
 *
 *   Copyright 1992 by Daniel J. Bodoh
 *
 *   File: mdvxhelp.h
 *
 *   Description: Contains data structure definitions and prototypes
 *
 *   History:
 *      28-MAY-92   Created by DJB
 *
 */

#define VERSION "0.9"

#define BUFFER_SIZE 1024        /* Size of buffer for reading files into */
#define MAXFILES    100         /* max # of input files */

typedef struct header_t {       /* First 6 bytes of Help file */
    unsigned long dir_off;      /* offset of directory */
    unsigned short dir_size;    /* size, in bytes of directory */
} Header;

typedef struct tag_t {          /* element of a linked list of tags */
    char *tagstr;               /* string of data for tag */
    struct tag_t *flink;        /* Link to next element of list */
} Tag;

typedef struct directory_t {    /* directory entry */
    char sect_name[12];         /* name of a section */
    unsigned long offset;       /* offset of section in file */
} Dir_elem;

/* prototypes */
void err_exit(char *msg);
void process_section(char *file);
void process_xpm(char *file);
void create_dir_entry(char *path, long offset, int i);
void create_tag(char *tagtxt);

