/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/obj.c,v 2.35.2.1 1992/10/21 04:32:25 william Exp $";
#endif

#include <math.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "attr.e"
#include "auxtext.e"
#include "box.e"
#include "cursor.e"
#include "group.e"
#include "oval.e"
#include "poly.e"
#include "polygon.e"
#include "rcbox.e"
#include "setup.e"
#include "spline.e"
#include "text.e"
#include "xbitmap.e"
#include "xpixmap.e"

struct ObjRec	* topObj = NULL, * botObj = NULL;

void AddObj (PrevPtr, NextPtr, ObjPtr)
   struct ObjRec	* PrevPtr, * NextPtr, * ObjPtr;
   /* add ObjPtr between PrevPtr and NextPtr */
{
   ObjPtr->prev = PrevPtr;
   ObjPtr->next = NextPtr;

   if (PrevPtr == NULL)
      topObj = ObjPtr;
   else
      PrevPtr->next = ObjPtr;

   if (NextPtr == NULL)
      botObj = ObjPtr;
   else
      NextPtr->prev = ObjPtr;
}

void UnlinkObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;
}

void FreeObj (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   switch (ObjPtr->type)
   {
      case OBJ_POLY: DelAllAttrs(ObjPtr->fattr); FreePolyObj (ObjPtr); break;
      case OBJ_BOX: DelAllAttrs(ObjPtr->fattr); FreeBoxObj (ObjPtr); break;
      case OBJ_OVAL: DelAllAttrs(ObjPtr->fattr); FreeOvalObj (ObjPtr); break;
      case OBJ_TEXT: FreeTextObj (ObjPtr); break;
      case OBJ_POLYGON: DelAllAttrs(ObjPtr->fattr); FreePolygonObj (ObjPtr);
         break;
      case OBJ_ARC: DelAllAttrs(ObjPtr->fattr); FreeArcObj (ObjPtr); break;
      case OBJ_RCBOX: DelAllAttrs(ObjPtr->fattr); FreeRCBoxObj (ObjPtr); break;
      case OBJ_XBM: DelAllAttrs(ObjPtr->fattr); FreeXBmObj (ObjPtr); break;
      case OBJ_XPM: DelAllAttrs(ObjPtr->fattr); FreeXPmObj (ObjPtr); break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP: DelAllAttrs(ObjPtr->fattr); FreeGroupObj (ObjPtr); break;
   }
}

void DelObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;

   FreeObj (ObjPtr);
}

void DelAllObj ()
{
   register struct ObjRec	* ptr, * next_obj;

   if (topObj == NULL) return;

   for (ptr = topObj; ptr != NULL; ptr = next_obj)
   {
      next_obj = ptr->next;
      FreeObj (ptr);
   }

   topObj = botObj = NULL;
}

void AdjObjBBox (ObjPtr)
   struct ObjRec        * ObjPtr;
{
   register int			w = 0;
   register struct ObjRec	* obj_ptr;
   register struct AttrRec	* attr_ptr;
   struct PolyRec		* poly_ptr;
   int				ltx, lty, rbx, rby;
   int				oltx, olty, orbx, orby;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         poly_ptr = ObjPtr->detail.p;
         CalcPolyBBox (ObjPtr->obbox, poly_ptr->n, poly_ptr->vlist,
               poly_ptr->style, poly_ptr->width, poly_ptr->aw, poly_ptr->ah,
               &(ObjPtr->bbox.ltx), &(ObjPtr->bbox.lty), &(ObjPtr->bbox.rbx),
               &(ObjPtr->bbox.rby));
         break;
      case OBJ_ARC:
         CalcArcBBox (ObjPtr->detail.a, ObjPtr->obbox, &(ObjPtr->bbox));
         break;
      case OBJ_POLYGON: w = round((double)ObjPtr->detail.g->width/2.0); break;
      case OBJ_BOX: w = round((double)ObjPtr->detail.b->width/2.0); break;
      case OBJ_OVAL: w = round((double)ObjPtr->detail.o->width/2.0); break;
      case OBJ_RCBOX: w = round((double)ObjPtr->detail.rcb->width/2.0); break;
      case OBJ_XBM: break;
      case OBJ_XPM: break;

      case OBJ_SYM:
      case OBJ_GROUP:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->last;
         ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
         rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
         oltx = obj_ptr->obbox.ltx; olty = obj_ptr->obbox.lty;
         orbx = obj_ptr->obbox.rbx; orby = obj_ptr->obbox.rby;
         for (obj_ptr = obj_ptr->prev; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
         {
            if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
            if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
            if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
            if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
            if (obj_ptr->obbox.ltx < oltx) oltx = obj_ptr->obbox.ltx;
            if (obj_ptr->obbox.lty < olty) olty = obj_ptr->obbox.lty;
            if (obj_ptr->obbox.rbx > orbx) orbx = obj_ptr->obbox.rbx;
            if (obj_ptr->obbox.rby > orby) orby = obj_ptr->obbox.rby;
         }
         ObjPtr->bbox.ltx = ltx; ObjPtr->bbox.lty = lty;
         ObjPtr->bbox.rbx = rbx; ObjPtr->bbox.rby = rby;
         ObjPtr->obbox.ltx = oltx; ObjPtr->obbox.lty = olty;
         ObjPtr->obbox.rbx = orbx; ObjPtr->obbox.rby = orby;
         break;
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
      case OBJ_ARC:
         break;
      case OBJ_POLYGON:
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_XPM:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - w;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - w;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + w;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + w;
         break;
      case OBJ_TEXT:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - 2;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - 2;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + 2;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + 2;
         break;
   }

   attr_ptr = ObjPtr->fattr;

   ltx = ObjPtr->bbox.ltx;
   lty = ObjPtr->bbox.lty;
   rbx = ObjPtr->bbox.rbx;
   rby = ObjPtr->bbox.rby;
   for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
   {
      if (attr_ptr->shown)
      {
         if (attr_ptr->obj->bbox.ltx < ltx) ltx = attr_ptr->obj->bbox.ltx;
         if (attr_ptr->obj->bbox.lty < lty) lty = attr_ptr->obj->bbox.lty;
         if (attr_ptr->obj->bbox.rbx > rbx) rbx = attr_ptr->obj->bbox.rbx;
         if (attr_ptr->obj->bbox.rby > rby) rby = attr_ptr->obj->bbox.rby;
      }
   }
   ObjPtr->bbox.ltx = ltx;
   ObjPtr->bbox.lty = lty;
   ObjPtr->bbox.rbx = rbx;
   ObjPtr->bbox.rby = rby;

   if (ObjPtr->type == OBJ_SYM)
   {
      if (ObjPtr->obbox.ltx-QUARTER_INCH < ObjPtr->bbox.ltx)
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - QUARTER_INCH;
      if (ObjPtr->obbox.lty-QUARTER_INCH < ObjPtr->bbox.lty)
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - QUARTER_INCH;
      if (ObjPtr->obbox.rbx+QUARTER_INCH > ObjPtr->bbox.rbx)
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + QUARTER_INCH;
      if (ObjPtr->obbox.rby+QUARTER_INCH > ObjPtr->bbox.rby)
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + QUARTER_INCH;
   }
}

#define RETREAT (0.8)

void AdjObjSplineVs (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register int			i;
   register struct ObjRec	* ptr;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->curved)
         {
            if (ObjPtr->detail.p->svlist != NULL)
               free (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX, drawOrigY,
                  ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         else
         {
            if (ObjPtr->detail.p->svlist != NULL)
               free (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakePolyVertex (
                  drawOrigX, drawOrigY, ObjPtr->detail.p->n,
                  ObjPtr->detail.p->vlist);
            ObjPtr->detail.p->sn = ObjPtr->detail.p->n;
         }

         if (ObjPtr->detail.p->style != LS_PLAIN)
         {
            struct PolyRec	* poly_ptr = ObjPtr->detail.p;
            XPoint		* v = poly_ptr->vlist, * v_copy;
            int			aw = poly_ptr->aw;
            int			n = poly_ptr->n, dx, dy;
            double		len, sin, cos;

            if (ObjPtr->detail.p->asvlist != NULL)
               free (ObjPtr->detail.p->asvlist);

            v_copy = (XPoint *) calloc (n+1, sizeof(XPoint));
            for (i = 0; i < n; i++)
            {
               v_copy[i].x = v[i].x;
               v_copy[i].y = v[i].y;
            }

            if (aw == 0) aw = 1;

            dx = v_copy[1].x - v_copy[0].x;
            dy = v_copy[1].y - v_copy[0].y;
            if ((poly_ptr->style & LS_LEFT) && (dx != 0 || dy != 0))
            {
               len = (double) sqrt((double)(dx*dx+dy*dy));
               sin = ((double)dy)/len;
               cos = ((double)dx)/len;

               v_copy[0].x = round(v_copy[0].x+RETREAT*aw*cos);
               v_copy[0].y = round(v_copy[0].y+RETREAT*aw*sin);
            }

            dx = v_copy[n-1].x - v_copy[n-2].x;
            dy = v_copy[n-1].y - v_copy[n-2].y;
            if ((poly_ptr->style & LS_RIGHT) && (dx != 0 || dy != 0))
            {
               len = (double) sqrt((double)(dx*dx+dy*dy));
               sin = ((double)dy)/len;
               cos = ((double)dx)/len;

               v_copy[n-1].x = round(v_copy[n-1].x-RETREAT*aw*cos);
               v_copy[n-1].y = round(v_copy[n-1].y-RETREAT*aw*sin);
            }
            if (ObjPtr->detail.p->curved)
               poly_ptr->asvlist = MakeSplinePolyVertex (&(poly_ptr->asn),
                     drawOrigX, drawOrigY, n, v_copy);
            else
            {
               poly_ptr->asvlist = MakePolyVertex (drawOrigX, drawOrigY,
                     n, v_copy);
               poly_ptr->asn = poly_ptr->n;
            }
            free (v_copy);
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->curved)
         {
            if (ObjPtr->detail.g->svlist != NULL)
               free (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX, drawOrigY,
                  ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         else
         {
            if (ObjPtr->detail.g->svlist != NULL)
               free (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakePolygonVertex (
                  drawOrigX, drawOrigY, ObjPtr->detail.g->n,
                  ObjPtr->detail.g->vlist);
            ObjPtr->detail.g->sn = ObjPtr->detail.g->n;
         }
         break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            AdjObjSplineVs (ptr);
         break;
   }
}

void AdjSplineVs ()
{
   register struct ObjRec	* obj_ptr, * ptr;

   if (topObj == NULL) return;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
         case OBJ_POLYGON:
            AdjObjSplineVs (obj_ptr);
            break;
         case OBJ_SYM:
         case OBJ_ICON:
         case OBJ_GROUP:
            for (ptr = obj_ptr->detail.r->first; ptr != NULL; ptr = ptr->next)
               AdjObjSplineVs (ptr);
            break;
      }
}

void AdjObjCache (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* ptr;
   register struct AttrRec	* attr_ptr;
   int				w, h, num_rows, num_cols;
   struct TextRec		* text_ptr;
   struct XBmRec		* xbm_ptr;
   struct XPmRec		* xpm_ptr;

   w = ObjPtr->obbox.rbx - ObjPtr->obbox.ltx;
   h = ObjPtr->obbox.rby - ObjPtr->obbox.lty;

   switch (ObjPtr->type)
   {
      case OBJ_TEXT:
         if (zoomScale!=0 || ObjPtr->detail.t->rotate!=ROTATE0)
         {
            text_ptr = ObjPtr->detail.t;

            if (text_ptr->rotate != ROTATE0 ||
                  !(text_ptr->cached_bitmap != None &&
                  text_ptr->cached_zoomed == zoomedIn &&
                  text_ptr->cached_zoom == zoomScale))
            {
               if (text_ptr->cached_bitmap != None)
                  XFreePixmap (mainDisplay, text_ptr->cached_bitmap);
               text_ptr->cached_zoom = 0;
               text_ptr->cached_bitmap = None;
            }
         }
         break;
      case OBJ_XBM:
         xbm_ptr = ObjPtr->detail.xbm;
         num_cols = (zoomedIn) ? (w<<zoomScale) : (w>>zoomScale);
         num_rows = (zoomedIn) ? (h<<zoomScale) : (h>>zoomScale);
         if (NeedsToCacheXBmObj (ObjPtr) && !(
               xbm_ptr->cached_bitmap!=None &&
               xbm_ptr->cached_zoomed==zoomedIn &&
               xbm_ptr->cached_zoom==zoomScale &&
               xbm_ptr->cached_w==num_cols && xbm_ptr->cached_h==num_rows &&
               xbm_ptr->cached_rotate==xbm_ptr->rotate &&
               xbm_ptr->cached_flip==xbm_ptr->flip
               ))
         {
            if (xbm_ptr->cached_bitmap != None)
               XFreePixmap (mainDisplay, xbm_ptr->cached_bitmap);
            xbm_ptr->cached_bitmap = None;
            if (zoomScale != 0)
               xbm_ptr->cached_zoom = 0;
            else
               xbm_ptr->cached_rotate = INVALID;
         }
         break;
      case OBJ_XPM:
         xpm_ptr = ObjPtr->detail.xpm;
         num_cols = (zoomedIn) ? (w<<zoomScale) : (w>>zoomScale);
         num_rows = (zoomedIn) ? (h<<zoomScale) : (h>>zoomScale);
         if (NeedsToCacheXPmObj (ObjPtr) && !(
               xpm_ptr->cached_pixmap!=None &&
               xpm_ptr->cached_zoomed==zoomedIn &&
               xpm_ptr->cached_zoom==zoomScale &&
               xpm_ptr->cached_w==num_cols && xpm_ptr->cached_h==num_rows &&
               xpm_ptr->cached_rotate==xpm_ptr->rotate &&
               xpm_ptr->cached_flip==xpm_ptr->flip
               ))
         {
            if (xpm_ptr->cached_pixmap != None)
               XFreePixmap (mainDisplay, xpm_ptr->cached_pixmap);
            xpm_ptr->cached_pixmap = None;
            if (zoomScale != 0)
               xpm_ptr->cached_zoom = 0;
            else
               xpm_ptr->cached_rotate = INVALID;
         }
         break;

      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            AdjObjCache (ptr);
         break;
   }
   for (attr_ptr=ObjPtr->fattr; attr_ptr!=NULL; attr_ptr=attr_ptr->next)
      if (attr_ptr->shown)
         AdjObjCache (attr_ptr->obj);
}

void AdjCaches ()
{
   register struct ObjRec	* obj_ptr, * ptr;
   register struct AttrRec	* attr_ptr;

   if (topObj == NULL) return;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
         case OBJ_XBM:
         case OBJ_XPM:
            AdjObjCache (obj_ptr);
            break;
         case OBJ_SYM:
         case OBJ_ICON:
         case OBJ_GROUP:
            for (ptr = obj_ptr->detail.r->first; ptr != NULL; ptr = ptr->next)
               AdjObjCache (ptr);
            break;
      }
      for (attr_ptr=obj_ptr->fattr; attr_ptr!=NULL; attr_ptr=attr_ptr->next)
         if (attr_ptr->shown)
            AdjObjCache (attr_ptr->obj);
   }
}
