/*
 * Name:	MicroGnuEmacs
 *		OS9/68k Spawn Shell
 */
#include	"def.h"

#include	<sgstat.h>

extern	struct	sgbuf	oldtty;		/* There really should be a	*/
extern	struct	sgbuf	newtty;		/* nicer way of doing this	*/

spawncli(f, n)
{
	register int	pid;
	register int	wpid;
	int		status;
	register char	*cp;
	int		os9fork();
	static char	*argv[2] = {"shell", NULL};
	extern char	**environ;
	char		*getenv();

	ttcolor(CTEXT);
	ttnowindow();
	ttmove(nrow-1, 0);
	if (epresf != FALSE) {
		tteeol();
		epresf = FALSE;
	}
	ttflush();
	if((cp=getenv("SHELL")) != NULL) argv[0] = cp;
	if(_ss_opt(0, &oldtty) == -1) {
		ewprintf("_ss_opt #1 to terminal failed");
		return FALSE;
	}
	if((pid=os9exec(os9fork, argv[0], argv, environ, 0, 0)) == -1) {
		ewprintf("Failed to create process");
		return FALSE;
	}
	while ((wpid=wait(&status))>=0 && wpid!=pid) {}
	sgarbf = TRUE;				/* Force repaint.	*/
	if(_ss_opt(0, &newtty) == -1) {
		ewprintf("_ss_opt #2 to terminal failed");
		return FALSE;
	}
	return TRUE;
}
