#include "pt.h"
#include "malloc.h"

void pascal
/* XTAG:processBlock */
processBlock(ch, w, insertString, cp2, textAttr, selAttr)
	unsigned char ch, insertString[];
	struct window *w;
	long *cp2;
	unsigned char *textAttr, *selAttr;
{
	extern unsigned char msgBuffer[];
	extern union REGS rin, rout;
	extern struct SREGS segRegs;
	extern unsigned char *userMessages[];
	extern unsigned char *stktop;
	extern int debug;

	unsigned int *p;
	unsigned char *saveStktop;

	/* set up the argument to the interrupt in the registers */
	rin.x.ax = (unsigned int)w;
	rin.h.bl = *textAttr;
	rin.h.bh = *selAttr;
	rin.x.cx = (unsigned int)&insertString[0];
	rin.x.dx = segRegs.ds;
	p = (unsigned int *)cp2;
	rin.x.si = *p++;
	rin.x.di = *p;

	/* Ana will call us back so get up a stack for that */
	saveStktop = stktop;
	stktop = malloc(2048);
	if( stktop == NULL ) {
		msg(userMessages[NOSPACEMSG], 3);
		return;
	}
	stktop += 2040;

	/* make the interrupt call */
	int86(0x62, &rin, &rout);

	/* free the stack we were using */
	stktop -= 2040;
	free(stktop);
	stktop = saveStktop;

	/* get the returned arguments out of the registers */
	*textAttr = rout.h.bl;
	*selAttr = rout.h.bh;
	p = (unsigned int *)cp2;
	*p++ = rout.x.si;
	*p = rout.x.di;
}

