#include "pt.h"
#include "stdlib.h"

/* delay to start scrolling */
static int hsecToWait;

int pascal
/* XTAG:mouseButton */
mouseButton(evhead)
	int evhead;
{
	extern unsigned char msgBuffer[];
	extern union REGS rin, rout;
	extern int menuRow, menuCol;
	extern struct menuBlock far *menus[];
	extern int debug;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern struct window *activeWindow;
	extern int scrRows, scrCols;
	extern struct event events[];
	extern unsigned char buttonVector[];
	extern unsigned char toplineVector[];
	extern int passEvhead;
	extern long passCp;
	extern int mousePresent;
	extern int menuLine;
	extern int helpMode;
	extern int descrFileId;
	extern int menuShowing;
	extern int lastOnTopline;
	extern int lastCommand;
	extern int isMessage;
	extern int searchMode;
	extern int smoothScroll;
	extern int scrollDelay;
	extern unsigned char windowPoints[];
	extern struct openFile *files;
	extern unsigned char *outOfWindows;
	extern int toplineMenu;

	struct window *w;
	struct window  *newW;
	int anchorRow, anchorCol, curRow, curCol;
	int row1, col1, row2, col2;
	int where, buttons, i, n, fid;
	int menuNumber, buttonMask, thisShift, thisButton;
	long cp, thumbcp, size;

	hsecToWait = scrollDelay;
	anchorRow = events[evhead].vertical>>3;
	anchorCol = events[evhead].horizontal>>3;
	thisButton = events[evhead].buttons;
	buttonMask = events[evhead].mask;
	/* if no buttons down and not a mouse movement command */
	/* thit it must be a left over button up event */
	/* ignore left over button up events */
	if( thisButton == 0 && buttonMask != 1 )
		return 0;
	if( thisButton == 0 ) {
		/* is this the (top or bottom) menu line? */
		if( anchorRow != (menuLine > 0 ? 0 : (scrRows-1) ) ) {
			/* if we are displaying top line descriptions */
			/* then erase them when you leave the top line */
			if( helpMode > 1 && lastOnTopline == 1 ) {
				lastOnTopline = 0;
				msg("", 1);
			}
			return 0;
		}

		/* if it is a menu, the figure out which item on it */
		if( menuShowing != 0 ) {
			n = FindMenuItem( menuShowing, anchorCol );
			/* remember the last command selected */
			lastCommand = n;
			if( helpMode > 1 ) {
				readLine(descrFileId, 80L*(long)n,
							&msgBuffer[0], 0);
				msgBuffer[78] = '\0';
				msg(msgBuffer, 1);
				lastOnTopline = 1;
			}
		}
		return 0;
	}

	/* handle things that we need to do every command */
	handleTempItems();

	switch( thisButton ) {
		case 1:
			buttons = LEFTBUTTON;
			break;
		case 2:
			buttons = RIGHTBUTTON;
			break;
		case 3:
		case 4:
		default:
			buttons = BOTHBUTTONS;
			break;
	}

	/* find out what window (if any) and where this mouse was */
	xyToPos(&anchorRow, &anchorCol, &where, &cp, &w);
	
	/* set these now that anchorRow and anchorCol are set by xyToPos */
	curRow = anchorRow;
	curCol = anchorCol;

	/* execute the appropriate command for the mouse position */
	/* and mouse buttons that were pressed */
	switch( buttons+where ) {
	
	/* Any corner, Left => Top/Bottom */
	case LEFTBUTTON+UPPERLEFT:
		if( waitUp(1) )
			goto bothUpperLeft;
		else
			return command(windowPoints[0], 0, w);
	case LEFTBUTTON+LOWERLEFT:
		if( waitUp(1) )
			goto bothLowerLeft;
		else
			return command(windowPoints[4], 0, w);
	case LEFTBUTTON+UPPERRIGHT:
		if( waitUp(1) )
			goto bothUpperRight;
		else
			return command(windowPoints[2], 0, w);
	case LEFTBUTTON+LOWERRIGHT:
		if( waitUp(1) )
			goto bothLowerRight;
		else
			return command(windowPoints[6], 0, w);

	/* Any corner -- Right => Stretch Window */
	case RIGHTBUTTON+UPPERLEFT:
		row1 = w->row2;
		col1 = w->col2;
		goto allStretch;
	case RIGHTBUTTON+UPPERRIGHT:
		row1 = w->row2;
		col1 = w->col1;
		goto allStretch;
	case RIGHTBUTTON+LOWERLEFT:
		row1 = w->row1;
		col1 = w->col2;
		goto allStretch;
	case RIGHTBUTTON+LOWERRIGHT:
		row1 = w->row1;
		col1 = w->col1;
	allStretch:
		if( getBox(row1, col1, &row1, &col1, &row2, &col2, 1) )
			goto noAction;
		/* move the window */
		if( moveWindow(w, row1, col1, row2, col2) != 0 )
			msg("Window too small, not changed", 1);
		break;

	/* upper border, right button ==> move window */
	case RIGHTBUTTON+UPPERBORDER:
		row1 = w->row1;
		col1 = w->col1;
		row2 = w->row2;
		col2 = w->col2;
		if( getBox(curRow, curCol, &row1, &col1, &row2, &col2, 2) )
			goto bothUpper;

		/* move the window */
		if( moveWindow(w, row1, col1, row2, col2) != 0 )
			msg("Window too small, not changed", 1);
		break;

	/* Upper and Right, Both => Split Window */
	case BOTHBUTTONS+UPPERBORDER:
	bothUpper:
		/* do the action on buttons up */
		up2Buttons(&anchorRow, &anchorCol);
		/* do not allow splits that are too small */
		col2 = w->col2;	/* save this for the createWindow */
		if( col2 < anchorCol + 10 || w->row2 < anchorRow + 2 ) {
			msg("Split window too small, not created", 1);
			break;
		}
		newW = createWindow(files[w->fileId].origName, anchorRow,
			anchorCol, w->row2, col2, CRTOP, 0);
		if( newW == NULL )
			break;
		newW->posTopline = w->posTopline;
		newW->numTopline = w->numTopline;
		newW->indent = w->indent;
		redrawWindow(newW);
		break;

	case BOTHBUTTONS+RIGHTBORDER:
	bothRight:
		/* do the action on buttons up */
		up2Buttons(&anchorRow, &anchorCol);
		/* do not allow splits that are too small */
		row2 = w->row2;	/* save this for the createWindow */
		if( anchorCol < w->col1 + 10 || row2 < anchorRow + 2 ) {
			msg("Split window too small, not created", 1);
			break;
		}
		newW = createWindow(files[w->fileId].origName, anchorRow,
			w->col1, row2, anchorCol, CRTOP, 0);
		if( newW == NULL )
			break;
		row1 = anchorRow+1;
		col1 = w->col1+1;
		newW->posTopline = xyToWindow(w, &row1, &col1);
		newW->numTopline = w->numTopline + anchorRow - w->row1;
		newW->indent = w->indent;
		redrawWindow(newW);
		break;

	/* Lower border, Left, Right => Scroll, Both => Thumb */
	case LEFTBUTTON+LOWERBORDER:
	moreRightScrolling:
		if( !smoothScroll && waitUp(1) )
			goto bothLower;
		if( (where = anchorCol - w->col1 - 1) < 1 )
			where = 1;
		if( (w->indent -= where) < 0 )
			w->indent = 0;
		redrawWindow(w);
		if( ScrollSomeMore() )
			goto moreRightScrolling;
		break;

	case RIGHTBUTTON+LOWERBORDER:
	moreLeftScrolling:
		if( !smoothScroll && waitUp(1) )
			goto bothLower;
		if( (where = anchorCol - w->col1 - 1) < 1 )
			where = 1;
		w->indent += where;
		redrawWindow(w);
		if( ScrollSomeMore() )
			goto moreLeftScrolling;
		break;

	case BOTHBUTTONS+LOWERBORDER:
	bothLower:
		/* do the action on buttons up */
		up2Buttons(&anchorRow, &anchorCol);
		where = anchorCol - w->col1 - 1;
		w->indent = where;
		redrawWindow(w);
		break;

	/* Left border, left and right => scroll, both => thumb */
	case LEFTBUTTON+LEFTBORDER:
	rev1scr:
		if( !smoothScroll && waitUp(1) )
			goto bothLeft;
		where = anchorRow - w->row1 - 1;
		if( where < 1 )
			where = 1;
		/* set up the screen map and scroll the window */
		setMap( w->row1, w->col1, w->row2, w->col2, 1, 0x07);
		maskTop(w);
		downScroll(w, where);
		if( ScrollSomeMore() )
			goto rev1scr;
		break;

	case RIGHTBUTTON+LEFTBORDER:
	rev2scr:
		if( !smoothScroll && waitUp(1) )
			goto bothLeft;
		where = anchorRow - w->row1 - 1;
		if( where < 1 )
			where = 1;
		/* set up the screen map and scroll the window */
		setMap(w->row1, w->col1, w->row2, w->col2, 1, 0x7);
		maskTop(w);
		upScroll(w, where);
		if( ScrollSomeMore() )
			goto rev2scr;
		break;

	case BOTHBUTTONS+LEFTBORDER:
	bothLeft:
		/* do the action on buttons up */
		up2Buttons(&anchorRow, &anchorCol);
		/* remember where we came from */
		w->rowLastline = w->numTopline;

		fid = w->fileId;
		size = fileSize(fid);
		n = w->row2 - w->row1 - 2; /* find the size of the window */
		where = anchorRow - w->row1 - 1;
		if( where < 0 )
			where = 0;
		else if( where > n )
			where = n;
		/* handle going to EOF as a special case */
		if( where  == n ) {
			/* this puts the EOF mark on the bottom line */
			i = n + 1;
			thumbcp = prevLine(fid, size-1, &i);
		} else {
			if(n == 0 )	/* eschew zerodivide */
				n = 1;
			thumbcp = ((long)where * (size+1L)) / (long)n;
		}
		i = 1;
		if( thumbcp != 0 )
			thumbcp = nextLine(fid, thumbcp, &i);
		cp = w->posTopline;
		n = w->numTopline;
		while( cp < thumbcp ) {
			i = 1;
			cp = nextLine(fid, cp, &i);
			n += i;
		}
		while( cp > thumbcp ) {
			i = 1;
			cp = prevLine(fid, cp, &i);
			n -= i;
		}
		w->posTopline = cp;
		w->numTopline = n;
		redrawWindow(w);
		break;

	/* Inside a window or outside any window */
	case LEFTBUTTON+INSIDEWINDOW:
	case LEFTBUTTON+OUTSIDEWINDOW:
	case RIGHTBUTTON+INSIDEWINDOW:
	case RIGHTBUTTON+OUTSIDEWINDOW:
	case BOTHBUTTONS+INSIDEWINDOW:
	case BOTHBUTTONS+OUTSIDEWINDOW:
		/* find the shift state of the keyboard */
		rin.h.ah = 2;
		int86(0x16, &rin, &rout);

		/* mask of the Ins, Caps, Num, and Scroll states */
		thisShift = rout.h.al & 0xF;
		
		/* adjust for cursor simulation of the mouse */
		if( !mousePresent )
			thisShift = buttonMask>>8;

		/* fix thisShift so that either shift keys implies shift */
		/* shift over bit1 and OR bit0 with it */
		thisShift = (thisShift>>1) | (thisShift&0x1);

		/* get the command number from the table */
		i = (thisShift<<3) + thisButton;
		n = buttonVector[i];

		/* record where to put the menu */
		menuRow = curRow;
		menuCol = curCol;

		/* pass some things command might need */
		passEvhead = evhead;
		passCp = cp;

		/* let the general command processor handle it */
		return command(n, 0, w);

	case LEFTBUTTON+UPPERBORDER:
		if( waitUp(1) )
			goto bothUpper;
		else {
			activeWindow = w;
			redoBorders(0);
			updateScreen(0, scrRows-1);
			break;
		}
	case RIGHTBUTTON+RIGHTBORDER:
		if( waitUp(1) )
			goto bothRight;
		return command(windowPoints[9], 0, w);

	case LEFTBUTTON+RIGHTBORDER:
		if( waitUp(1) )
			goto bothRight;
		return command(windowPoints[8], 0, w);

	/* top line menus and commands */
	case LEFTBUTTON+TOPLINE:
	case RIGHTBUTTON+TOPLINE:
	case BOTHBUTTONS+TOPLINE:
		/* find the shift state of the keyboard */
		rin.h.ah = 2;
		int86(0x16, &rin, &rout);

		/* mask of the Ins, Caps, Num, and Scroll states */
		thisShift = rout.h.al & 0xF;
		
		/* adjust for cursor simulation of the mouse */
		if( !mousePresent )
			thisShift = 0x0;

		/* fix thisShift so that either shift keys implies shift */
		/* shift over bit1 and OR bit0 with it */
		thisShift = (thisShift>>1) | (thisShift&0x1);

		/* get the menu number from the table */
		i = (thisShift<<3) + thisButton;
		n = toplineVector[i];
		
		/* figure out if it is menu or a command */
		menuNumber = CommandToMenuNumber( n );
		
		/* redraw the menu if necessary */
		if( menuNumber != 0 ) {
			/* redraw the correct menu */
			row1 = (menuLine > 0 ? 0 : (scrRows-1) );
			setMap(row1, 0, row1, scrCols-1, 2, 0x07);
			pulldown(menuNumber);
			updateScreen(row1, row1);
			menuShowing = menuNumber;
		}

		if( (abs(menuLine) > 1) ) {
			/* execute the command at button release time */
			up2Buttons(&menuRow, &menuCol);
		} else {
			menuRow = curRow;
			menuCol = curCol;
		}

		/* if it is a menu, the figure out which item on it */
		if( menuNumber != 0 ) {
			toplineMenu = menuNumber;
			n = FindMenuItem( menuNumber, menuCol );
		}

		/* if not still on the menu line, cancel */
		if( (menuLine > 0 && menuRow != 0)
		 || (menuLine < 0 && menuRow != (scrRows-1)) ) {
			if( menuNumber == 0 )
				/* cancel a single command */
				n = FDONOTHING;
			else
				/* use the default command for a menu */
				n = menus[menuNumber]->cmdNumber[0];
		}

		w = activeWindow;

		/* pass some things command might need */
		passEvhead = evhead;
		passCp = cp;

		/* record where to put the menu */
		menuRow = curRow + 1;	/* 1 down from the top line */
		menuCol = curCol;

		/* let the general command processor handle it */
		return command(n, 0, w);

	/* these are programmed by the user */
	case BOTHBUTTONS+UPPERLEFT:
	bothUpperLeft:
		n = command(windowPoints[1], 0, w);
		waitUp(0);
		return n;
	case BOTHBUTTONS+LOWERLEFT:
	bothLowerLeft:
		n = command(windowPoints[5], 0, w);
		waitUp(0);
		return n;
	case BOTHBUTTONS+UPPERRIGHT:
	bothUpperRight:
		n = command(windowPoints[3], 0, w);
		waitUp(0);
		return n;
	case BOTHBUTTONS+LOWERRIGHT:
	bothLowerRight:
		n = command(windowPoints[7], 0, w);
		waitUp(0);
		return n;

	noAction:
		/* wait for buttons up */
		up2Buttons(&n, &n);
		msg("No action is defined for that mouse button", 1);
		break;
	default:
		;	/* ignore no button events */
	}

	return 0;
}


int pascal
/* XTAG:ScrollSomeMore */
ScrollSomeMore() {
	extern int smoothScroll;
	extern union REGS rin, rout;
	extern int mousePresent;
	extern int scrollRate;

	int timeBegin, timeEnd, hsecElapsed;

	/* if there is no button up then keep scrolling */
	if( smoothScroll && mousePresent ) {
		timeBegin = GetTime();
		while( 1 ) {
			/* if the mouse moves, stop scrolling */
			if( isMouseEvent(1) )
				return 0;
			/* get the current button state */
			rin.x.ax = 3;
			int86(51, &rin, &rout);
			/* if the buttons are up, stop scrolling */
			if( (rout.x.bx & 0x7) == 0 )	/* all buttons up */
				return 0;
			timeEnd = GetTime();
			hsecElapsed = timeEnd - timeBegin;
			/* if overflow add 60sec = 6000hsec */
			if( hsecElapsed < 0 )
				hsecElapsed += 6000;
			/* if enough time has passed, scroll again */
			if( hsecToWait < hsecElapsed ) {
				/* reset wait time to repeat rate */
				hsecToWait = scrollRate;
				return 1;
			}
		}
	} else
		return 0;
}


int pascal
/* XTAG:waitUp */
waitUp(twoButtons)
	int twoButtons;
{
	extern struct event events[];

	register int evhead;

	while( 1 ) {
		while( !isMouseEvent(1) )
			;	/* wait for a mouse event */
		evhead = getMouseEvent();
		switch( events[evhead].buttons ) {
			/* return 0 if the buttons are all up */
			case 0:
				return 0;
			/* keep waiting if only one button is down */
			case 1:
			case 2:
			case 4:
				break;
			/* return 1 if more than one button is down */
			default:
				if( twoButtons )
					return 1;
				break;
		}
	}
}
