#include "pt.h"
#include "malloc.h"
#include "string.h"
#include "process.h"
#include "io.h"
#include "stdlib.h"
#include "conio.h"

#define STACKSIZE 2048

int pascal
/* XTAG:command */
command(fn, c, w)
	int fn;
	unsigned char c;
	register struct window *w;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int debug;
	extern struct window *selWindow;
	extern struct window *activeWindow;
	extern long selBegin, selEnd;
	extern union REGS rin, rout;
	extern int overType;
	extern int searchMode;
	extern int realSearchMode;
	extern int mousePresent;
	extern int scrRows, scrCols;
	extern int i43lines;
	extern unsigned char buttonVector[];
	extern int menuRow, menuCol;
	extern int lastOnTopline;
	extern int lastCommand;
	extern int macroIndex;
	extern int macroSize;
	extern int macroState;
	extern int selMode;
	extern int lastFn;
/*	extern int errno;  */
#ifdef OVERLAYS
	extern int filesToOpen;
	extern int primaryFilesToOpen;
	extern struct openFile *ffsToOpen[];
	extern unsigned char *overlayMap[];
	extern unsigned char *stktop;
	extern unsigned char primaryOverlay[];
	extern unsigned char secondaryOverlay[];
	extern unsigned char overlayString[];
	extern unsigned char *overlayArguments;
	extern int overlayState;
	extern int quitExecuted;
#endif
	extern unsigned char *userMessages[];
	extern struct openFile *files;
	extern unsigned char maxTextCycles;
	extern unsigned char maxBorderCycles;
	extern struct SREGS segRegs;
	extern struct menuBlock far *menus[];
	extern struct optionItem options[];
	extern unsigned char saveVideoMode;
	extern union REGS rin, rout;
	extern unsigned int dispMemory;

	int row1, col1;
	int r1, r2;
	int i, n;
	long cp;
	unsigned char ch;
	unsigned char *fileName;
	struct window *w2;
	unsigned char *s, buffer[64];
#ifdef OVERLAYS
	unsigned char *userArgs;
	unsigned char *saveStktop;
#endif

/* since we are about to issue a command, we do not need to erase */
/* the command description on the top line (so don't) */
lastOnTopline = 0;

startOver:

#ifdef OVERLAYS
if( 200 <= fn && fn <= 255 ) {
	fileName = overlayMap[fn-200];
doOverlay:

	n = strlen(fileName) - 1;
	if( fileName[n] == ' ' )
		userArgs = getInput("Execute: ", fileName, 5);
	else
		userArgs = fileName;

	/* allow user to cancel */
	if( userArgs == NULL ) {
		msg("Command cancelled", 1);
		goto returnLocation;
	}

	/* make a copy of the command line */
	strncpy(overlayString, userArgs, 128);

	overlayArguments = strchr(overlayString, ' ');
	if( overlayArguments != NULL )
		*overlayArguments++ = '\0';
	else
		overlayArguments = "";

	/* see if this overlay is loaded and inactive */

	/* see if this is a primary or secondary overlay */
	n = strlen(overlayString) - 1;
	if( overlayString[n] == '*' ) {	/* primary overlay is to be loaded */
		/* eliminate the '*' which means the overlay is primary */
		overlayString[n] = '\0';

		if( (overlayState & 0x1) != 0 ) {
			/* a primary overlay is already loaded */
			if( strcmp(primaryOverlay, overlayString) == 0 ) {
				/* same overlay, reactivate this one */
				if( (overlayState & 0x2) != 0 ) {
					strcpy(textBuffer, "0");
					secondaryOverlay[0] = '\0';
					overlayState &= ~0x2;
					overlayState |= 0x14;
				} else {
					strcpy(textBuffer, overlayArguments);
				}
			} else {
				/* remember the name of the new overlay */
				strcpy(primaryOverlay, overlayString);
				strcpy(textBuffer, "0");
				/* indicate we are unloading a primary */
				/* overlay */
				overlayState |= 0x8;
				/* check for secondary overlay */
				if( (overlayState & 0x2) != 0 ) {
					overlayState &= ~0x2;
					overlayState |= 0x4;
					secondaryOverlay[0] = '\0';
				} else {
				}
			}
			/* Drop out of command loop. This will return to */
			/* "overlayDriver()" which will return (from the */
			/* software interrupt)to the overlay. */
			return 1;
		} else {
			strcpy(primaryOverlay, overlayString);
			overlayState |= 0x1;
			/* see if we have to unload the secondary overlay */
			if( (overlayState & 0x2) != 0 ) {
				strcpy(textBuffer, "0");
				overlayState &= ~0x2;
				overlayState |= 0x4;
				secondaryOverlay[0] = '\0';
				return 1;
			}
			/* else, drop though and load the overlay */
		}
	} else {	/* secondary overlay is to be loaded */
		if( (overlayState & 0x2) != 0 ) {
			/* a secondary overlay is already loaded */
			if( strcmp(secondaryOverlay, overlayString) == 0 ) {
				/* same overlay, reactivate this one */
				strcpy(textBuffer, overlayArguments);
			} else {
				/* different overlay, unload this one */
				/* 0 argument means to exit the overlay */
				strcpy(textBuffer, "0");
				strcpy(secondaryOverlay, overlayString);
				/* indicate we are unloading an overlay */
				overlayState |= 0x4;
			}
			/* Drop out of command loop. This will return to */
			/* "overlayDriver()" which will return (from the */
			/* software interrupt)to the overlay. */
			return 1;
		} else {
			strcpy(secondaryOverlay, overlayString);
			overlayState |= 0x2;
			/* drop though and load the overlay */
		}
	}

retryOverlay:
	/* save the old value of stktop */
	saveStktop = stktop;

	/* set up the stack to use when the overlay calls us back */
	stktop = malloc(STACKSIZE);
	if( stktop == NULL ) {
		msg(userMessages[NOSPACEMSG], 3);
		goto returnLocation;
	}
	stktop += STACKSIZE-8;

	/* We have to reopen any files opened by the overlay when it */
	/* exits since DOS will close them automatically. If fileToOpen */
	/* is already non-zero then an overlay is already loaded. */
	if( filesToOpen == 0 )
		filesToOpen = 1;
	else
		primaryFilesToOpen = filesToOpen;

	n = spawnlp(0, overlayString, overlayString, overlayArguments, NULL);
	if( n == -1 ) {
		sprintf(msgBuffer,
"Overlay %s could NOT be executed [Press any key to continue]",
			overlayString);
		msg(msgBuffer, 3);
	} else if( n > 0 ) {
		sprintf(msgBuffer, "Overlay %s returned error code of 0x%X",
			overlayString, n);
		msg(msgBuffer, 1);
	} 

	/* free up the stack space */
	stktop -= STACKSIZE-8;
	free(stktop);
	/* now restore the previous value of stktop */
	stktop = saveStktop;

	/* reopen any files that were opened during the overlay */
	/* since DOS will have closed them automatically */
	/* if this is a secondary overlay that is exiting, then only */
	/* reopen the files that were opened since the secondary */
	/* overlay was loaded */
	if( primaryFilesToOpen > 0 )
		n = primaryFilesToOpen;
	else
		n = 1;
	for(i = n; i < filesToOpen; ++i) {
		ff = ffsToOpen[i-1];
		ff->origHandle = openls(ff->origName, 0);
	}
	if( primaryFilesToOpen > 0 ) {
		filesToOpen = primaryFilesToOpen;
		primaryFilesToOpen = 0;
	} else
		filesToOpen = 0;
	
	if( quitExecuted )
		return 1;

	if( (overlayState & 0x4) != 0 ) {
		/* see if we have to unload the primary overlay also */
		overlayState &= ~0x4;
		if( (overlayState & 0x8) != 0 ) {
			strcpy(textBuffer, "0");  /* unload overlay arg. */
			return 1;
		}
		if( (overlayState & 0x10) != 0 ) {
			overlayState &= ~0x10;
			strcpy(textBuffer, overlayArguments);
			return 1;
		}
		goto retryOverlay;
	} else if( (overlayState & 0x8) != 0 ) {
		overlayState &= ~0x8;
		goto retryOverlay;
	} else if( (overlayState & 0x2) != 0 ) {
		overlayState &= ~0x2;
		secondaryOverlay[0] = '\0';
	} else {	/* overlayState == 0x1 (primary overlay only) */
		primaryOverlay[0] = '\0';
		overlayState = 0;
	}

	initMouse(5, 10, 0);
	goto returnLocation;
}
#endif

if( fn < 50 ) {
	n = command2(fn, c, w);
	if( fn != FMOUSECOM1 && fn != FMOUSECOM2
		&& fn != FDONOTHING && fn > 0 ) {
		lastCommand = fn;
	}
	lastFn = fn;
	if( n != 2 )
		return n;
	/* return value of 2 means that select and extend want the */
	/* change menu command to be executed */
	fn = FCHANGEMENU;
	/* and drop through since change menu >= 50 */
}

/* else do commands 50 and up */

switch( fn ) {

case FAUTOSAVEINTERVAL:case FAUTOSCROLLRATE:case FAUTOINDENT:
case FBORDERCOLORS:case FCENTERMENUS:
case FDOUBLECLICKDELAY:case FFILEPATTERN:case FFILESORT:case FFINDWHOLEWORDS:
case FFSDIRS:case FFSMENU:case FFSPATTERNS:case FHELPMODE:case FI43LINES:
case FIGNORECASE:  case FLINESOVERFIND: case FMSGCOLORS:	
case FPATHNAMES:   case FOVERTYPE: case FRESEARCH:
case FOREADONLY:   case FREDEFINE:      case FRIGHTMARGIN:
case FSCROLLDELAY: case FSCROLLRATE:    case FSEARCHMODE: case FSMOOTHSCROLL:
case FTABWIDTH:    case FTOPONFIND:  case FTAGPATTERN:
case FTAGMARKER:   case FTEXTCOLORS:    case FUNIXMODE:   case FVIDEOMODE:
	n = 0;
	while( options[n].commandNumber != fn ) {
		if( options[n].index == OLASTITEM ) {
			/* this "cannot happen" */
			msg("System Error (command.c:~300)", 3);
			break;
		}
		++n;
	}
	r1 = options[n].type;
	if( r1 == OINTEGER || r1 == OSTRING
	 || r1 == UINTEGER || r1 == USTRING ) {
		if( r1 == OINTEGER || r1 == UINTEGER )
			sprintf(buffer, "%d", *(options[n].variable));
		else
			strcpy(buffer,
				(unsigned char *)(options[n].variable));
		sprintf(textBuffer, "New value for option `%s': ",
			options[n].name );
		s = getInput(textBuffer, buffer, 0);
		if( s == NULL ) {
			msg("Option value not changed", 1);
			break;
		}
	} else
		s = NULL;
	setOption(n, s, w);
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);
	break;

case FTAG:
case FTAGSEL:
case FCTAG:
case FCTAGSEL:
	(void)findTag(fn);
	break;

case FKEYWORD:
case FKEYWORDSEL:
	(void)findKeyword(fn);
	break;

#ifdef GENIUS66
case F66LINES:	/* special code for the Genius display */
	msg("Setting up MDS 66 line text mode for Genius monitor", 1);
	dispMemory = 0xB000;
	saveVideoMode = 8;
	rin.h.al = 8;	/* 80x66 MDS (Genius) */
	rin.h.ah = 0;	/* set video mode */
	int86(0x10, &rin, &rout);
	outpw(0x3B0, 0x1);
	outpw(0x3B8, 0x28);
	outpw(0x3D8, 0x0);
	initMouse(5, 10, 1);
	goto redrawScreen;
#endif

case FREPLACECMD:
	execCmd(fn);
	break;

case FCYCLECOLORS:

#ifdef BARNEY
/* determine the current display mode */
rin.h.ah = 15;
int86(0x10, &rin, &rout);
i = rout.h.al;
sprintf(msgBuffer, "mode=0x%X, new mode?", i);
s = getInput(msgBuffer, "2", 0);
sscanf(s, "%x", &saveVideoMode);
rin.h.al = saveVideoMode;
rin.h.ah = 0;	/* set video mode */
int86(0x10, &rin, &rout);
initMouse(5, 10, 1);
redrawBox(0, 0, scrRows-1, scrCols-1);
updateScreen(0, scrRows-1);
break;
#endif
	if( w == NULL )
		break;
/******************************************
	fileName = getInput("t(ext), b(order), a(ll): ", "a", 1);
	ch = tolower(*fileName);
******************************************/
	ch = 'a';
	if( ch == 't' || ch == 'a' ) {
		if( ++(w->textCycle) >= maxTextCycles )
			w->textCycle = 0;
	}
	if( ch == 'b' || ch == 'a' ) {
		if( ++(w->borderCycle) >= maxBorderCycles )
			w->borderCycle = 0;
	}
	setWindowColors(w);
	goto redrawScreen;

case FREADONLY:
	if( w == NULL )
		break;
	if( files[w->fileId].readOnly ) {
		/* file is readOnly now.  Only allow writing if the */
		/* file being edited has DOS write permission */
		/* check for read and write permissions (6 => RW) */
		if( access(files[w->fileId].origName, 6) == 0 )
			files[w->fileId].readOnly = 0;
	} else
		/* allow any file to be readOnly */
		files[w->fileId].readOnly = 1;
redrawScreen:
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);
	break;

#ifdef OVERLAYS
case FOVERLAY:
	fileName = getInput("File to execute (and arguments): ", "", 0);
	goto doOverlay;
#endif

case FSWAPTOP:
	if( w == NULL )
		break;
	doTopWindow(w, 3);
	break;

case FRECAPITALIZE:
	if( selWindow == NULL )
		break;
	ch = readChar(selWindow->fileId, selBegin);
	selEnd = selBegin;
	if( !isascii(ch) ) {
		++selBegin;
		break;
	}
	if( ch == '\r' ) {
		/* scan past all newlines and returns */
		while( 1 ) {
			ch = readChar(selWindow->fileId, ++selBegin);
			if( ch != '\r' && ch != '\n' )
				break;
		}
		selEnd = selBegin;
		goto redrawScreen;
	}
	if( isupper(ch) )
		ch = _tolower(ch);
	else if( islower(ch) )
		ch = _toupper(ch);
	deleteChars(selWindow->fileId, NOUPDATE, 0);
	insChar(ch, 1);
	break;

case FTOPSELFILE:
	if( w == NULL )
		break;
	/* remember where we came from */
	w->rowLastline = w->numTopline;
	w->posTopline = 0;
	w->numTopline = 1;
	w->indent = 0;

	/* move the selection to the top of the file */
	eraseSelection();
	selWindow = w;
	selBegin = 0;
	selEnd = 0;
	if( readChar(w->fileId, 0L) == '\r' ) {
		if( readChar(w->fileId, 1L) == '\n' )
			selEnd = 1;
	}
	redrawWindow(w);
	break;

case FRECORDMACRO:
	switch( macroState ) {
	case 0:
		macroIndex = 0;
		macroState = 1;
		msg("Recording keystrokes in macro buffer", 4);
		break;
	case 1:
		/* remove the FRECORDMACRO keystroke */
		macroSize = macroIndex - 2;
		macroState = 0;
		msg("", 0);	/* erase the sticky message */
		msg("End recording keystrokes", 1);
		break;
	case 2:
		msg("No recursive macros", 1);
		break;
	}
	break;

case FPLAYMACRO:
	macroState = 2;
	macroIndex = 0;
	break;

case FJUSTIFY:
	if( w == NULL )
		break;
	justifyLines();
	break;

case FMENU1:  case FMENU2:  case FMENU3:  case FMENU4:
case FMENU5:  case FMENU6:  case FMENU7:  case FMENU8:
case FMENU9:  case FMENU10: case FMENU11: case FMENU12:
case FMENU13: case FMENU14: case FMENU15: case FMENU16:
	fn = menu(menus[CommandToMenuNumber(fn)], menuRow, menuCol);
	goto startOver;

case FCHANGEMENU:
	/* find the button and shift state and look up the command */

	/* get the present mouse button state into r1 */
	if( mousePresent ) {
		rin.x.ax = 3;
		int86(51, &rin, &rout);
		r1 = rout.x.bx;
		/* record where to put the menu */
		menuRow = rout.x.dx>>3;
		menuCol = rout.x.cx>>3;
	} else {
		r1 = 0x0;
		/* record where to put the menu */
		getCPos(&menuRow, &menuCol);
	}

	/* find the shift state of the keyboard */
	rin.h.ah = 2;
	int86(0x16, &rin, &rout);

	/* mask of the Ins, Caps, Num, and Scroll states */
	r2 = rout.h.al & 0xF;

	/* fix r2 so that either shift keys implies shift */
	/* shift over bit1 and OR bit0 with it */
	r2 = (r2>>1) | (r2&0x1);

	/* adjust for cursor simulation of the mouse */
	if( !mousePresent )
		r2 = 0x0;

	/* get the command number from the table */
	i =  (r2<<3) + r1;
	fn= buttonVector[i];
	goto startOver;

case FCONTEXTMENU:
	doContextMenu();
	break;

case FMATCHCHAR:	/* find the matching character */
	matchChar();
	break;

case FCOPYTO:	/* copy selection to this point */
	n = COPY;
	goto moveAndCopy;

case FMOVETO:	/* move selection to this point */
	n = MOVE;
moveAndCopy:
	if( w == NULL )
		break;
	up2Buttons(&row1, &col1);
	/* find out what window (if any) and where the mouse was */
	xyToPos(&row1, &col1, &i, &cp, &w2);
	/* if the user moves outside the window then abort the move or copy */
	if( i != INSIDEWINDOW || w2 != w )
		break;
	/* adjust to the selection mode */
	cp = adjustSelMode(w->fileId, cp);
	copyMove(selWindow, selBegin, selEnd, w, cp, n);
	break;

case FBACKSEARCH:
	if( w == NULL )
		break;
	realSearchMode = searchMode;
	if( n != 1 )
		searchMode = 1;
	else
		searchMode = 0;
	searchFor(1, w);
	searchMode = realSearchMode;
	realSearchMode = -1;
	break;

case FHELP:
	help(lastCommand);
	break;

case FGOTOSELECTION:
	if( w == NULL )
		break;
	doGoSel(w);
	break;

case FEXCHSCRAP:
	if( selWindow == NULL )
		break;
	exchWithScrap();
	break;

case FCOPYSCRAP:
	if( selWindow == NULL )
		break;
	copyToScrap(selWindow, selBegin, selEnd);
	msg("The selection has been copied to the scrap buffer", 1);
	break;

case FGOBACKTO:
	if( w == NULL )
		break;
	doGoto(w, w->rowLastline);
	break;

case FINSKEY:
	if( selWindow == NULL )
		break;
	insScrap(1);
	break;

case FWORDLEFT:
case FWORDRIGHT:
	cursor(fn, mousePresent);
	/* only move the cursor if the mouse is present */
	break;

case FLOADSEL:
	if( w == NULL )
		doNewWindow(FNEWWINDOW, 0);
	else
		loadWindow(w, fn);
	break;

case FDELNOSCRAP:
	if( selWindow == NULL )
		break;
	deleteChars(selWindow->fileId, UPDATEWINDOWS, 0);
	break;

case FNEWSEL:
	doNewWindow(fn, 0);
	break;

case FSAVEFILE:
	if( w == NULL )
		break;
	saveFile(w);
	redoBorders(0);
	/* use scrRows-2 to avoid erasing the "File saved ..." message */
	updateScreen(0, scrRows-2);
	break;

case FSELGOTO:
	if( w == NULL )
		break;
	fileName = getSelection(&textBuffer[0]);
	/* skip past any non-numeric characters at the front */
	while( 1 ) {
		ch = *fileName;
		if( ch == '\0' || ('0'<=ch && ch<='9') )
			break;
		++fileName;
	}
	n = atoi(fileName);
	if( n != 0 )
		doGoto(w, n);
	else
		msg("Invalid line number", 2);
	break;

case FCLOSESAVE:
	if( w == NULL )
		break;
	closeWindow(w, 0, 1);
	break;

default:
	msg("No action is defined for that key [Alt-h for HELP]", 1);
	break;
}
lastFn = fn;
if( fn != FDONOTHING && fn > 0 ) 
	lastCommand = fn;
return 0;
}
