#include "pt.h"
#include "string.h"

static int menuType;
static int prevScreen = 100;

int pascal
/* XTAG:help */
help(index)
	int index;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern union REGS rin, rout;
	extern int debug;
	extern int scrRows, scrCols;
	
	long cp;
	int n, fid, retValue;
	unsigned char *p;

	p = findFile("pt.hlp");
	if( p == NULL ) {
		msg("Cannot find pt.hlp in PATH", 3);
		return 0;
	} else
		fid = getFileId(p);

	retValue = 0;
	n = index;
	cp = 0;
	while( n > 0 ) {
		/* cp now points to the beginning of the next screen */
		cp = findScreen(n, fid);

		/* cp now points to the data part of the screen */
		/* after the screen header info has been read */
		cp = showScreen(fid, cp, &n);

		if( n == -1 )
			retValue = 1;
	}
	
	closeFile(fid, 2);
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);

	return retValue;
}

/* list of goto pages from the page header */
/* the first two are the previous (PgUp) and next (PgDn) pages */
/* the rest are the 1-9,0 or a-t pages */
int screens[22];
int screenNumber;

int pascal
/* XTAG:nextScreen */
nextScreen()
{
	extern unsigned char msgBuffer[];
	extern union REGS rin, rout;
	extern struct event events[];
	extern int mousePresent;

	int n, evhead;
	unsigned char ch, scan;
	
	while( 1 ) {
		/* any mouse button down? */
		if( mousePresent && isMouseEvent(0) ) {
			evhead = getMouseEvent();
			switch( events[evhead].buttons ) {
				case 0:	/* no buttons */
					break;
				case 1:	/* left button */
					return prevScreen;
				case 2:	/* right button */
					return screens[1];
				default:	/* middle or both */
					return 0;
			}
		}
		if( !isKeystroke() )
			continue;
		ch = getKeystroke(&scan);
		switch( ch ) {
		case 0:
			switch( scan ) {
			case 73:	/* PgUp */
				return prevScreen;
			case 81:	/* PgDn */
				return screens[1];
			default:
				goto defLabel;
			}
			break;
		case '\r':	/* Enter key */
		case ' ':	/* space bar */
			return 0;
		case 27:	/* ESCape key */
			return -1;
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			n = screens[ch - '0' + 2];
			if( n == -1 )
				goto defLabel;
			return n;
		case 'a': case 'b': case 'c': case 'd': case 'e':
		case 'f': case 'g': case 'h': case 'i': case 'j':
		case 'k': case 'l': case 'm': case 'n': case 'o':
		case 'p': case 'q': case 'r': case 's': case 't':
			n = screens[ch - 'a' + 2];
			if( n == -1 )
				goto defLabel;
			return n;
		default:
		defLabel:
			msg("", 0);	/* blink the line */
			msg(
"Please make one of the choices listed above, PgDn (next), or PgUp(previous)",
2);
			break;
		}
	}
}

long pascal
/* XTAG:findScreen */
findScreen(n, fileId)
	int n, fileId;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	
	long cp2;
	register unsigned char *p;

	/* find the location of the screen in the index at the front */
	(void) readLine(fileId, (long)(8*n), textBuffer, 0);
	sscanf(textBuffer, "%ld", &cp2);

	/* now read the first line of the help screen description */
	cp2 = readLine(fileId, cp2, textBuffer, 0);

	/* get the goto screen numbers on the header line */
	n = 0;
	p = &textBuffer[0];
	while( n < 22 ) {
		/* find the next blank */
		p = strchr(p, ' ');
		if( p == NULL )
			break;
		while( *p == ' ' || *p == '\t' || *p == '\r' || *p == '\n' )
			++p;
		if( p == NULL )
			break;
		sscanf(p, "%d", &screens[n++]);
	}
	/* put the default values in the unspecified screen numbers */
	while( n < 22 )
		screens[n++] = -1;
	return cp2;
}

extern unsigned char far *menuSpace;
extern int nextSpace;

long pascal
/* XTAG:showScreen */
showScreen(fileId, cp, next)
	int fileId, *next;
	long cp;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct menuBlock far *menus[];
	extern int scrCols;
	
	int n, iChar, iLine, iMenu, menuRow, menuCol;
	unsigned char ch;
	
	/* see if this is a menu screen */
	cp = readLine(fileId, cp, textBuffer, 0);
	if( textBuffer[0] == '\\' ) {
		/* no menu, must be a regular screen */
		cp = dispScreen(fileId, cp);
		n = nextScreen();
		prevScreen = *next;	/* remember the last screen shown */
		*next = n;
		return cp;
	}
	/* read in the menu name */
	iChar = nextSpace;
	menus[0]->cmdName[0] = &menuSpace[iChar];
	iLine = 1;	/* skip past the " */
	while( 1 ) {
		ch = textBuffer[iLine++];
		if( ch == '"' || iLine >= scrCols )
			break;
		menuSpace[iChar++] = ch;
	}
	menuSpace[iChar++] = '\0';
	sscanf(&textBuffer[iLine], "%d%d%d", &menuType, &menuRow, &menuCol);

	/* read in the menu strings */
	menus[0]->cmdNumber[0] = 0;
	iMenu = 1;
	/* one iteration for each menu item */
	while( 1 ) {
		cp = readLine(fileId, cp, textBuffer, 0);
		if( textBuffer[0] == '\\' )
			break;
		/* read in the string from the help file */
		iLine = 1;	/* char 0 is the opening " */
		menus[0]->cmdName[iMenu] = &menuSpace[iChar];
		while( 1 ) {
			ch = textBuffer[iLine++];
			if( ch == '"' )
				break;
			menuSpace[iChar++] = ch;
			if( iChar >= MENUSPACE ) {
				sprintf(msgBuffer,
"Menu too large before char position %ld in pt.hlp [space to continue]", cp);
				msg(msgBuffer,3);
				incon();
				goto error1;
			}
		}
		menuSpace[iChar++] = '\0';
		/* now get the screen number */
		sscanf(&textBuffer[iLine], "%d", &n);
		menus[0]->cmdNumber[iMenu] = n;
		++iMenu;
		if( iMenu >= 22 ) {
			sprintf(msgBuffer,
"Menu too long before char position %ld in pt.hlp [space to continue]", cp);
			msg(msgBuffer,3);
			incon();
			goto error1;
		}
	}
error1:
	menus[0]->nItems = iMenu;
	cp = dispScreen(fileId, cp);
	prevScreen = *next;	/* remember the last screen shown */
	if( menuType == 1 ) {
		n = menu(menus[0], menuRow, menuCol);
	} else
		n = nextScreen();
	prevScreen = *next;	/* remember the last screen shown */
	*next = n;
	return cp;
}

long pascal
/* XTAG:dispScreen */
dispScreen(fileId, cp)
	int fileId;
	long cp;
{
	extern unsigned char *screenChars;
	extern int tabWidth;
	extern unsigned char textColor, selColor;
	extern int scrRows, scrCols;
	extern unsigned char textBuffer[];

	long cp2;
	int n, col, iText, moreLines;
	int currentRow;
	unsigned char ch, *p, *nextRow, attr;

	attr = textColor;
	moreLines = 1;
	currentRow = 0;
	p = screenChars;
	while( currentRow < scrRows ) {
		if( moreLines ) {
			cp2 = readLine(fileId, cp, textBuffer, 0);
			if( textBuffer[0] == '\\' || cp2 == cp )
				moreLines = 0;
		}
		if( currentRow == scrRows - 1 ) {
			moreLines = 1;
			/* put this message on the bottom line */
			strcpy(textBuffer,
"\\bSpace\\r,\\bEsc\\r=return to Point           \\bPgDn\\r=next screen       \\bPgUp\\r=prev screen");
		}
		cp = cp2;
		iText = 0;
		col = 0;
		nextRow = p + (scrCols<<1);
		if( moreLines )
			ch = 0;
		else
			ch = '\n';
		while( ch != '\r' && ch != '\n' && p < nextRow ) {
			ch = textBuffer[iText++];
			switch( ch ) {
			case '\n':
			case '\r':
				attr = textColor;
				break;
			case '\t':
				n = tabWidth - (col % tabWidth);
				col += n;
				while( n-- > 0 ) {
					*p++ = ' ';
					*p++ = attr;
				}
				break;
			case '\\':
				ch = textBuffer[iText++];
				switch( ch ) {
				case 'b': attr = textColor|0x8; break;
				case 's': attr = selColor; break;
				case 'B': attr = selColor|0x80; break;
				case '\\': goto printBackSlash;
				default: attr = textColor; break;
				}
				break;
			default:
			printBackSlash:
				*p++ = ch;
				*p++ = attr;
				++col;
				break;
			}
		}
		/* fill the rest of the line with blanks */
		while( p < nextRow ) {
			*p++ = ' ';
			*p++ = attr;
		}
		updateScreen(currentRow, currentRow);
		++currentRow;
	}
	return cp;
}
