#include "pt.h"
#include "ctype.h"
#include "string.h"
#include "io.h"

void pascal
/* XTAG:doNewWindow */
doNewWindow(fn, fullScreen)
	int fn;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int scrRows, scrCols;
	extern int menuLine;

	register unsigned char *fileName;
	int n, row1, row2, col1, col2;

	if( fullScreen ) {
		row1 = row2 = (menuLine > 0 ? 1 : 0);
		col1 = col2 = 0;
	} else if( getBox(0, 0, &row1, &col1, &row2, &col2, 0) == 2 )
		goto cancelWindow;

	if( row1 == row2 && col1 == col2 ) {
		row2 = scrRows-1;
		if( menuLine < 0 )
			--row2;
		col2 = scrCols-1;
	}
	/* do not allow very small windows */
	if( row2 < row1+2 || col2 < col1+10 ) {
		msg("Size too small, no window created", 1);
		return;
	}
	if( fn == FNEWWINDOW )
		fileName = getFileName("File to load into the new window: ");
	else	/* fn == FNEWSEL -- file name is the selection */
		fileName = getSelection(&textBuffer[0]);
	if( fileName == NULL ) {
cancelWindow:
		msg("Window create cancelled", 1);
		return;
	}
	if( fileName[0] == '\0' ) {
		strcpy(fileName, "UnNamed.a");
		(void)makeName(fileName);
	}
	fileName = noWhiteSpace(fileName);
	strcpy(textBuffer, fileName);
	if( access(textBuffer, 0) == -1 ) {
		sprintf(msgBuffer, "y to create %s: ", textBuffer);
		fileName = getInput(msgBuffer, "y", 1);
		if( fileName == NULL || tolower(*fileName) != 'y' )
			goto cancelWindow;
		n = creatls(textBuffer, 0);
		if( n < 0 ) {
			sprintf(msgBuffer, "Cannot create %s: ",
				textBuffer);
			msg(msgBuffer, 3);
			goto cancelWindow;
		} else
			closels(n);
	}
	createWindow(textBuffer, row1, col1, row2, col2, CRTOP, 0);
}

unsigned char * pascal
/* XTAG:noWhiteSpace */
noWhiteSpace(fileName)
	register unsigned char *fileName;
{
	register int n;

	if( fileName != NULL || fileName[0] == '\0' ) {
		/* eliminate white space around fileName */

		/* first white space in the beginning */
		while( isspace(*fileName) )
			++fileName;

		/* now white space at the end */
		n = strlen(fileName) - 1;
		while( isspace(fileName[n]) )
			--n;
		fileName[n+1] = '\0';
	}
	return fileName;
}

void pascal
/* XTAG:bottomFile */
bottomFile(w)
	register struct window *w;
{
	extern int debug;

	long cp;
	int fid, j;
	register int i;

	if( w == NULL )
		return;
	/* remember where we came from */
	w->rowLastline = w->numTopline;
	cp = w->posBotline;

	fid = w->fileId;	/* we'll use this a lot */

	/* find the last line of the file */
	i = 0;
	while( 1 ) {
		j = 1;
		cp = nextLine(fid, cp, &j);
		/* if j==0, we could not go down a line */
		/* so we are at the end */
		if( j == 0 )
			break;
		++i;
	}
	++i;	/* one more line so EOF mark shows */

	/* now move the window down and redraw it */
	j = i;	/* since i is a register variable, we must use j here */
	w->posTopline = nextLine(fid, w->posTopline, &j);
	w->posBotline = cp;
	w->numTopline += j;
	w->numBotline += j;
	w->indent = 0;
	redrawWindow(w);
}

void pascal
/* XTAG:loadWindow */
loadWindow(w, fn)
	register struct window *w;
	int fn;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct openFile *files;

	int n;
	unsigned char *fileName, saveName[64];

	if( fn == FLOADFILE )
		fileName = getFileName("File to load in window: ");
	else	/* fn == FLOADSEL -- get file name from the selection */
		fileName = getSelection(&textBuffer[0]);
	if( fileName == NULL )
		goto cancelFileLoad;
	if( fileName[0] == '\0' ) {
		strcpy(fileName, "UnNamed.a");
		makeName(fileName);
	}
	fileName = noWhiteSpace(fileName);
	strcpy(saveName, fileName);
	n = 0;	/* we did NOT create 'saveName' */
	if( access(saveName, 0) == -1 ) {
		sprintf(msgBuffer, "y to create %s: ", saveName);
		fileName = getInput(msgBuffer, "y", 1);
		if( fileName == NULL || tolower(*fileName) != 'y' )
			goto cancelFileLoad;
		n = creatls(saveName, 0);
		if( n < 0 ) {
			sprintf(msgBuffer, "Cannot create %s: ", saveName);
			msg(msgBuffer, 3);
			goto cancelFileLoad;
		} else
			closels(n);
		n = 1;	/* we did create 'saveName' */
	}
	if( closeFile(w->fileId, 1) == -1 ) {
		if( n )	/* delete 'saveName' if we created it */
			delete(saveName);
cancelFileLoad:
		msg("File load cancelled", 1);
		return;
	}
	w->fileId = getFileId(saveName);
	w->nameOffset = getBaseName(files[w->fileId].origName);
	w->posTopline = 0;
	w->numTopline = 1;
	w->posCurLast = 0;
	w->lastPosTop = 0;
	w->rowCurLast = 0;
	w->indent = 0;
	if( w == selWindow ) {
		selBegin = selEnd = 0;
		if( readChar(w->fileId, 0L) == '\r' ) {
			if( readChar(w->fileId, 1L) == '\n' )
				selEnd = 1;
		}
	}
	/* get the state of unixMode */
	w->state = getUnixState(w->fileId);
	redrawWindow(w);
}

void pascal
/* XTAG:hideWindow */
hideWindow(w)
	register struct window *w;
{
	extern struct window *windowList;
	extern struct window *activeWindow;
	extern struct window *hiddenList;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int scrRows, scrCols;
	
	if( w == NULL )
		return;

	/* unlink the window from the list of active windows */
	if( w->prevWindow != NULL )
		w->prevWindow->nextWindow = w->nextWindow;
	else	/* must be first on the list -- the top window */
		windowList = w->nextWindow;
	if( w->nextWindow != NULL )
		w->nextWindow->prevWindow = w->prevWindow;

	/* stack w onto the hidden list */
	w->nextWindow = hiddenList;
	hiddenList = w;

	/* is the selection in this window? */
	if( w == selWindow ) {
		/* move the selection to the top window */
		selWindow = windowList;
		if( selWindow != NULL ) {
			selBegin = 0;
			selEnd = 0;
			if( readChar(selWindow->fileId, 0L) == '\r' ) {
				if( readChar(selWindow->fileId, 1L) == '\n' )
					selEnd = 1;
			}
		}
	}

	/* is this the active window? */
	if( w == activeWindow )
		activeWindow = windowList;

	/* redraw the screen */
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);
}

void pascal
/* XTAG:doContextMenu */
doContextMenu()
{
	extern struct window *windowList;
	extern struct window *hiddenList;
	extern int menuRow, menuCol;
	extern struct menuBlock far *menus[];
	extern struct openFile *files;
	extern int pathNames;
	
	int i, n, k;
	struct window *newW;
	register struct window *w2;

	/* put in the title of the menu */
	menus[0]->cmdName[0] = (unsigned char far *)"TOPLIST";
	menus[0]->cmdNumber[0] = 0;

	/* go through the list of visible windows */
	n = 1;
	i = 1;
	w2 = windowList;
	while( w2 != NULL && n < MAXMENUITEMS ) {
		k = (pathNames ? 0 : w2->nameOffset);
		menus[0]->cmdName[n] = (unsigned char far *)
					&(files[w2->fileId].origName[k]);
		menus[0]->cmdNumber[n] = i;
		w2 = w2->nextWindow;
		++n;
		++i;
	}

	if( hiddenList != NULL && n < MAXMENUITEMS ) {
		/* put in a divider line */
		menus[0]->cmdName[n] = (unsigned char far *)"";
		menus[0]->cmdNumber[n] = 0;
		++n;
	}

	/* now go through the list of hidden windows */
	w2 = hiddenList;
	/* use "command" numbers in the 300's to indicate hidden */
	/* windows.  This avoids conflicts with the real command */
	/* number from 1 to ~150.  For ~100 to ~150 they are option */
	/* setting commands and so they ignore the string you send in. */
	i = 301;	/* number the entries */
	while( w2 != NULL && n < MAXMENUITEMS ) {
		k = (pathNames ? 0 : w2->nameOffset);
		menus[0]->cmdName[n] =
			(unsigned char far *)&(files[w2->fileId].origName[k]);
		menus[0]->cmdNumber[n] = i;
		w2 = w2->nextWindow;
		++n;
		++i;
	}

	/* now display the menu */
	menus[0]->nItems = n;
	i = menu(menus[0], menuRow, menuCol);

	/* find out which window to top (or unhide and top) */
	if( i == 0 )
		return;
	if( i > 300 ) {	/* unhide and top a hidden window */
		i -= 301;
		if( i == 0 ) {
			newW = hiddenList;
			hiddenList = hiddenList->nextWindow;
		} else {
			w2 = hiddenList;
			while( --i > 0 )
				w2 = w2->nextWindow;
			newW = w2->nextWindow;
			/* unlink it from the hidden list */
			w2->nextWindow = newW->nextWindow;
		}
		/* put it on the windowList */
		newW->nextWindow = windowList;
		newW->prevWindow = NULL;
		if( windowList != NULL )
			windowList->prevWindow = newW;
		windowList = newW;
	} else {	/* top a visible window */
		newW = windowList;
		while( --i > 0 )
			newW = newW->nextWindow;
	}
	doTopWindow(newW, 0);
}

void pascal
/* XTAG:zoomWindow */
zoomWindow(w)
	register struct window *w;
{
	extern struct window *windowList;
	extern int scrRows, scrCols;

	/* top window, if not already on top */
	if( w != windowList )
		topWindow(w);

	/* if zoomed then make regular else zoom */
	if( w->row1==1 && w->row2==(scrRows-1)
	 && w->col1==0 && w->col2==(scrCols-1) ) {
		w->row1 = w->saveRow1;
		w->col1 = w->saveCol1;
		w->row2 = w->saveRow2;
		w->col2 = w->saveCol2;
	} else {
		w->saveRow1 = w->row1;
		w->saveCol1 = w->col1;
		w->saveRow2 = w->row2;
		w->saveCol2 = w->col2;

		w->row1 = 1;
		w->col1 = 0;
		w->row2 = (scrRows-1);
		w->col2 = (scrCols-1);
	}
	redrawBox(0, 0, (scrRows-1), (scrCols-1));
	updateScreen(0, (scrRows-1));
}

void pascal
/* XTAG:doTopWindow */
doTopWindow(w, howToTop)
	register struct window *w;
	int howToTop;
{
	extern int scrRows, scrCols;
	extern struct window *activeWindow;
	extern struct window *windowList;
	extern int debug;
	
	int row1, row2;
	struct window *w1;

	if( w == NULL )
		return;

	switch( howToTop ) {

	case 0:		/* top only */
		if( w != windowList )
			topWindow(w);
		else {
			activeWindow = w;
			redoBorders(0);
			/* break rather than return here so the the */
			/* unhide will work correctly */
			break;
		}
		break;

	case 1:	/* top if not already on top, else bottom */
		if( w != windowList ) {
			topWindow(w);
			break;
		} /* else drop through to bottom code */

	case 2:		/* bottom only */
		/* find the end of the window list */
		w1 = w;
		while( w1->nextWindow != NULL )
			w1 = w1->nextWindow;
		if( w == w1 )	/* already on the bottom? */
			break;
		/* unlink from window list */
		/* we know w->nextWindow != NULL, else would be last */
		w->nextWindow->prevWindow = w->prevWindow;
		if( w->prevWindow != NULL )
			w->prevWindow->nextWindow = w->nextWindow;
		else		/* must be first on the list */
			windowList = w->nextWindow;
			/* windowList->prevWindow set to NULL above */
		/* link it on to the end */
		w1->nextWindow = w;
		w->prevWindow = w1;
		w->nextWindow = NULL;
		if( w == activeWindow )
			activeWindow = windowList;
		break;

	case 3:		/* swap the top two windows */
		if( windowList == NULL )	/* no windows to swap */
			break;
		w1 = windowList->nextWindow;
		if( w1 == NULL )	/* not two windows to swap */
			break;
		/* swap the windows */
		w = w1->nextWindow;
		windowList->nextWindow = w;
		if( w != NULL )
			w->prevWindow = windowList;
		w1->nextWindow = windowList;
		windowList->prevWindow = w1;
		w1->prevWindow = NULL;
		activeWindow = windowList = w1;
		break;
	}

	/* set up the screen map for the old window location */
	/* and clear the area where the window was */
	setMap(0, 0, scrRows-1, scrCols-1, 1, 0x07);

	/* redraw all the windows that might have changed */
	w1 = windowList;
	/* try to minimize redrawing when there are full screens */
	row1 = scrRows;
	row2 =-1;
	while( w1 != NULL ) {
		/* have these rows already been written? */
		if( w1->row1 >= row1 && w1->row2 <= row2 )
			goto nextOne;
		/* if the window is full width, remember the rows */
		if( w1->col1 == 0 && w1->col2 == (scrCols-1) ) {
			/* will this cover some rows below row1? */
			if( w1->row1 < row1 )
				row1 = w1->row1;
			/* will this cover some rows above row2? */
			if( w1->row2 > row2 )
				row2 = w1->row2;
		}
		drawWindow(w1);
	nextOne:
		w1 = w1->nextWindow;
	}
	updateScreen(0, scrRows-1);
}
