#include "pt.h"
#include "string.h"

/* XTAG:maxLineLength */
static int maxLineLength = 1;

void pascal
/* XTAG:drawWindow */
drawWindow(w)
	register struct window *w;
{
	extern unsigned char border1[], border2[], border3[], border4[];
	extern struct window *activeWindow;
	extern int debug;
	
	register unsigned char *border;

	fillWindow(w, 1);
	/* put in the banner first so the box will not overwrite it */
	banner(w);
	if( w != activeWindow )
		border = &border1[0];
	else
		border = &border2[0];
	drawBorder(border, w->row1, w->col1, w->row2, w->col2,
		w->borderColor, 0);
	updateScreen(w->row1, w->row2);
}

void pascal
/* XTAG:drawBorder */
drawBorder(border, row1, col1, row2, col2, borderColor, bottomLineOnly)
	unsigned char *border;
	int row1, row2, col1, col2, borderColor, bottomLineOnly;
{
	register int i;
	
	if( !bottomLineOnly ) {
		/* put in the top two corners */
		displayChar(row1, col1, 254, borderColor);
		displayChar(row1, col2, 254, borderColor);

		/* put in the top border of the box */
		displayChar(row1, col1, border[0], borderColor);
		for(i = col1+1; i < col2; i++)
		displayChar(row1, i, border[1], borderColor);
		displayChar(row1, col2, border[2], borderColor);

		/* put in the sides of the box */
		for(i = row1+1; i < row2; i++) {
			displayChar(i, col1, border[3], borderColor);
			displayChar(i, col2, border[4], borderColor);
		}
	}

	/* put in the bottom two corners */
	displayChar(row2, col1, 254, borderColor);
	displayChar(row2, col2, 254, borderColor);
	/* put in the bottom row of the box */
	displayChar(row2, col1, border[5], borderColor);
	for(i = col1+1; i < col2; i++)
		displayChar(row2, i, border[6], borderColor);
	displayChar(row2, col2, border[7], borderColor);
}

void pascal
/* XTAG:banner */
banner(w)
	register struct window *w;
{
	extern unsigned char border1[8];
	extern unsigned char textBuffer[];
	extern int overType;
	extern struct openFile *files;
	extern int pathNames;
	extern struct window *activeWindow;
	extern unsigned int piecesLeft;
	extern unsigned int bytesLeft;
	extern int debug;

	register int i;
	int row1, row2, col, len;
	int stopBlink, color;
	unsigned char fillChar;
	long lp;
	struct openFile *ff;

	/* see if we need a scroll bar on the bottom border */
	len = w->col2 - w->col1 - 1;
	if( len < maxLineLength || w->indent > 0 ) {
		/* fill in the highlighted, bottom side position bar */
		/* we are reusing the row1, row2 variables */
		/* they really represent columns here */
		row1 = 1 + (w->col1) + (len*w->indent) / maxLineLength;
		row2 = 1 + (w->col1) + (len*(len+w->indent)) / maxLineLength;
		if( row2 >= w->col2 )
			row2 = w->col2 - 1;
		if( row1 > row2 )
			row1 = row2;
		for(i = row1; i <= row2; i++)
			displayChar(w->row2, i, 196, w->elevColor);
	}

	/* does this window have a banner at all? */
	if( (w->state & 0x8) == 0x8 )
		return;
	if( w != activeWindow )
		fillChar = ' ';
	else
		fillChar = 205;
	if( w->fileId == -1 ) {
		lp = 0;
		w->numTopline = 0;
		w->numBotline = 1;
	} else {
		ff = &files[w->fileId];
		lp = ff->fileSize;
	}
	i = 0;
	if(  w->numTopline >= w->numBotline )
		i = 1;
	col = (pathNames ? 0 : w->nameOffset);
	stopBlink = ((bytesLeft < SPACELOW)  && (piecesLeft == 0) ? 5 : 0);
	sprintf(textBuffer,
		"%c%s \256%s\257%s%s%s%s  lines %d-%d  columns %d-%d",
		fillChar,
		(stopBlink == 5 ? "SAVE" : ""),
		&((files[w->fileId].origName)[col]),
		/* three state flags */
		(files[w->fileId].isChanged ? "*" : ""),
		(overType ? "  OverType" : ""),
		(ff->readOnly ? "  ReadOnly" : ""),
		( ( (w->state & 0x2) == 0x2) ? "  UNIX" : ""),
		/* line and column numbers */
		w->numTopline - i, w->numBotline - 1,
		w->indent + 1, (w->col2 - w->col1 + w->indent - 1));
	len = strlen(textBuffer);
	row1 = w->row1;
	col = w->col1 + 1;
	for(i = 0; textBuffer[i] != '\0'; i++) {
		if( i < stopBlink && i > 0 )
			color = 0xF8;
		else
			color = w->bannerColor;
		displayChar(row1, col++, textBuffer[i], color);
		if( col >= w->col2 )
			break;
	}
	/* fill top row with reverse video spaces */
	while( col < w->col2 )
		displayChar(row1, col++, fillChar, w->bannerColor);

	/* fill in the highlighted, left side position bar */
	row1 = 1 + (w->row1) +
		(int)(((long)(w->row2-w->row1-1) * w->posTopline) / (lp+1L));
	row2 = 1 + (w->row1) +
		(int)(((long)(w->row2-w->row1-1) * w->posBotline) / (lp+1L));
	for(i = row1; i <= row2; i++) {
		displayChar(i, w->col1, 179, w->elevColor);
	}
}

void pascal
/* XTAG:fillWindow */
fillWindow(w, doUpdates)
	register struct window *w;
{
	extern unsigned char *screenMap;
	extern unsigned char *screenChars;
	extern unsigned char scrMapReset;
	extern unsigned int dispMemory;
	extern int debug;
	extern int scrRows, scrCols;

	long cp;
	int n;
	int row1, row2, col1, col2;
	unsigned char *sChars, *sMap, *sMapLimit;
	unsigned char color;

	maxLineLength = 1;	/* reset this count */

	/* get the corners of the inside of the window */
	row1 = w->row1 + 1;
	col1 = w->col1 + 1 ;
	row2 = w->row2 - 1;
	col2 = w->col2 - 1;

	/* fill the rows one at a time */
	cp = w->posTopline;
	n = w->numTopline;

	while( row1 <= row2 ) {
		cp = fillLine(w, cp, row1, col1, col2);
		if( doUpdates )
			updateScreen(row1, row1);
		if( cp == -1 )
			break;
		n++;
		row1++;
	}
	if( cp == -1 )
		cp = fileSize(w->fileId);
	w->posBotline = cp;
	w->numBotline = n;
	color = w->textColor;
	while( ++row1 <= row2 ) {
		sMap = screenMap + scrCols*row1 + col1;
		sMapLimit = screenMap + scrCols*row1 + col2;
		sChars = screenChars + (scrCols<<1)*row1 + (col1<<1);
		while( sMap <= sMapLimit ) {
			if( *sMap != 0 ) {
				*sMap = scrMapReset;
				*sChars++ = ' ';
				*sChars++ = color;
			} else
				sChars += 2;
			++sMap;
		}
		if( doUpdates )
			updateScreen(row1, row1);
	}
}

extern void repword(unsigned int, unsigned char *, int);

long pascal
/* XTAG:fillLine */
fillLine(w, cp, row, col1, col2)
	struct window *w;
	long cp;
	int row, col1, col2;
{
	extern struct window *selWindow;
	extern struct window *windowList;
	extern long selBegin, selEnd;
	extern unsigned char msgBuffer[];
	extern int tabWidth;
	extern unsigned char *screenMap;
	extern unsigned char *screenChars;
	extern unsigned char scrMapReset;
	extern int debug;
	extern int invisibleText;
	extern int scrCols;
	extern struct SREGS segRegs;
	extern unsigned char charTable[];

	unsigned char ch, nullChar, color;
	unsigned int buf;
	register unsigned char *sMap;
	register unsigned char *sChars;
	unsigned char *sMapLimit;
	unsigned char far *firstByte;
	unsigned char far *lastByte;
	int insertIndex;
	long cp2;
	int tabStop, indent, col;
	int iBuffer, eofFlag;
	unsigned char textAttr, selAttr;
	
	eofFlag = 0;
	insertIndex = -1;
	
	/* for top window optimization */
	buf = (unsigned int)' ' + ( ((unsigned int)w->textColor) << 8 );

	/* set up the color codes */
	textAttr = w->textColor;
	selAttr = w->selColor;
	
	/* get the text in the line */
	cp2 = cp;
	firstByte = (unsigned char far *)1;
	lastByte = (unsigned char far *)0;

	/* set up for the loop */
	iBuffer = 0;
	col = 0;	/* count columns starting at 0 */
	indent = w->indent;
	sMap = screenMap + scrCols*row + col1;
	sMapLimit = screenMap + scrCols*row + col2;
	sChars = screenChars + (scrCols<<1)*row + (col1<<1);

	while( sMap <= sMapLimit ) {
		/* is char at file position cp2 part of the selection? */
		if( w == selWindow && selBegin <= cp2 && cp2 <= selEnd )
			color = selAttr;
		else
			color = textAttr;
		if( firstByte > lastByte ) {
			if(getSpan(w->fileId, cp2, &firstByte, &lastByte,0)){
				nullChar = 0;  /* end of file */
				eofFlag = 1;
				firstByte = &nullChar;
				lastByte = firstByte;
			}
		}
#ifdef ANASAZI
		if( anasazi
		 && insertIndex != -1
		 && (ch = insertString[insertIndex]) != '\0' )
			++insertIndex;
		else
#endif
		ch = *firstByte++;
		++cp2;
		switch( charTable[ch] ) {
		
		case 1:		/* newline -- end of line  */
			if( col >= indent ) {
				if( *sMap != 0 ) {
					*sMap = scrMapReset;
					*sChars++ = ' ';
					*sChars++ = color;
				} else
					sChars += 2;
				++sMap;
			}
			goto endLoop;

		case 2:		/* end of file */
			if( !eofFlag ) 
				goto showChar;
			if( col >= indent ) {
				if( *sMap != 0 ) {
					*sMap = scrMapReset;
					*sChars++ = 4;
					*sChars++ = color;
				} else
					sChars += 2;
				++sMap;
			}
			cp2 = -1;	/* indicate end of file written */
			goto endLoop;

		case 3:	/* tab */
			tabStop = tabWidth - (col % tabWidth) + col;
			while( col < tabStop )
				if( col++ >= indent ) {
					if( *sMap != 0 ) {
						*sMap = scrMapReset;
						*sChars++ = ' ';
						*sChars++ = color;
					} else
						sChars += 2;
					if( ++sMap > sMapLimit )
						break;
				}
			break;

		case 4:		/* carriage return  */
			/* We want to ignore CRs if the next character is */
			/* a NL. Also show CRs in unixMode (w->state&2==2) */
			if( firstByte > lastByte ) {
				if( getSpan(w->fileId, cp2, &firstByte,
							&lastByte, 0) ) {
					nullChar = 0;  /* end of file */
					eofFlag = 1;
					firstByte = &nullChar;
					lastByte = firstByte;
				}
			}
			if( *firstByte == '\n' && (w->state&0x2)==0 )
				break;
			/* we drop through on NL when in unixMode */
			/* else drop through and display the CR */
		case 0:	/* other (one char position) character */
		showChar:
			if( col++ >= indent ) {
				if( *sMap != 0 ) {
					*sMap = scrMapReset;
					*sChars++ = ch;
					*sChars++ = color;
				} else
					sChars += 2;
				++sMap;
			}
			break;

#ifdef ANASAZI
		case 5:		/* anasazi escape character */
			processBlock(ch, w, insertString, &cp2, &textAttr,
				&selAttr);
			insertIndex = (insertString[0]=='\0' ? -1 : 0);
			firstByte = (unsigned char far *)1;
			lastByte = (unsigned char far *)0;
			break;
#endif
		}
	}
endLoop:
	/* optimize for the top window */
	if( w == windowList ) {
		indent = sMapLimit - sMap + 1;
		if( indent > 0 ) {
			memset(sMap, scrMapReset, indent);
			repword(buf, sChars, indent);
		}
	} else {
		color = w->textColor;
		while( sMap <= sMapLimit ) {
			if( *sMap != 0 ) {
				*sMap = scrMapReset;
				*sChars++ = ' ';
				*sChars++ = color;
			} else
				sChars += 2;
			++sMap;
		}
	}
	/* find the end of the line */
	/* only look if we have not already gotten to EOF */
	if( !eofFlag )
	while( ch != '\n' ) {
		if( firstByte > lastByte ) {
			if( getSpan(w->fileId, cp2,&firstByte, &lastByte, 0) )
				break;
		}
		ch = *firstByte++;
		if( ch == '\t' )
			col += tabWidth - (col % tabWidth);
		++col;
		++cp2;
	}
	/* adjust for the CRLF */
	col -= 2;
	if( col > maxLineLength )
		maxLineLength = col;
	return cp2;
}

void pascal
/* XTAG:setMap */
setMap(row1, col1, row2, col2, clear, color)
	/*
	 * clear = 0 --> ...............  blank screenChars
	 * clear = 1 --> clear screenMap  .................
	 * clear = 2 --> clear screenMap  blank screenChars
	 */
	int row1, col1, row2, col2, clear, color;
{
	extern unsigned char *screenMap;
	extern unsigned char *screenChars;
	extern unsigned char msgBuffer[];
	extern int scrRows, scrCols;
	extern void repword(unsigned int, unsigned char *, int);

	register int i;
	int n, blank;
	unsigned int chars;

	if( clear != 0 )
		memset(screenMap, 0, scrRows*scrCols);
	blank = ((clear == 2) || (clear == 0));
	n = col2 - col1 + 1;
	chars = (unsigned int)' ' + ( ((unsigned int)color) << 8);
	for(i = row1; i <= row2; i++) {
		memset(screenMap+scrCols*i+col1, 1, n);
		if( blank )
			repword(chars,screenChars+(scrCols<<1)*i+(col1<<1),n);
	}
}

#ifdef SLOWREPMEM
void pascal
/* XTAG:repmem */
repmem(s, v, lv, nv)
	unsigned char *s;
	unsigned char *v;
	int lv, nv;
{
	register int i;
	register unsigned char *vv;
	int j;
	unsigned char ch1, ch2;

	if( lv == 2 ) {
		ch1 = *v;
		ch2 = *(v+1);
		for(i = 0; i < nv; ++i) {
			*s++ = ch1;
			*s++ = ch2;
		}
	} else {
		for(i = 0; i < nv; ++i) {
			vv = v;
			for(j = 0; j < lv; ++j)
				*s++ = *vv++;
		}
	}
}
#endif

void pascal
/* XTAG: maskTop */
maskTop(w)
	struct window *w;
{
	extern struct window *windowList;
	extern unsigned char *screenMap;
	extern int scrCols;

	register struct window *w1;
	register int i;
	int n, row2, col1, col2;

	w1 = windowList;
	while( w1 != w && w1 != NULL ) {
		col1 = w1->col1;
		row2 = w1->row2;
		col2 = w1->col2;
		n = col2 - col1 + 1;
		for(i = w1->row1; i <= row2; i++)
			memset(screenMap+scrCols*i+col1, 0, n);
/* LATER: should this be screenMapReset instead of always 0? */
		w1 = w1->nextWindow;
	}
}

void pascal
/* XTAG:displayChar */
displayChar(row, col, ch, attr)
	int row, col, attr;
	unsigned char ch;
{
	extern unsigned char *screenMap;
	extern unsigned char *screenChars;
	extern unsigned int dispMemory;
	extern unsigned char scrMapReset;
	extern int scrCols;
	extern int debug;

	register unsigned char *p, *q;

	p = screenMap + scrCols*row + col;
	if( *p != 0 ) {
		q = screenChars + (scrCols<<1)*row + (col<<1);
		*q++ = ch;
		*q = (unsigned char)attr;
		*p = scrMapReset;
	}
} 

extern void horvid(int, unsigned char *, int);
extern void hor1vid(int, unsigned char *, int);

void pascal
/* XTAG:updateScreen */
updateScreen(row1, row2)
	int row1, row2;
{
	extern union REGS rin, rout;
	extern unsigned char *screenChars;
	extern int mousePresent;
	extern unsigned int dispMemory;
	extern int videoMode;
	extern int scrCols;
	extern struct SREGS segRegs;

	int row, col, saveCx, saveDx, dupCount, dupCol, *pw;
	unsigned char *p;

	switch( videoMode ) {

	default:
	case 0:	/* monochrome, just write into the buffer */
	monochrome:
		movedata(segRegs.ds,
			(unsigned int)(screenChars+(scrCols<<1)*row1),
			dispMemory, (scrCols<<1)*row1,
			(scrCols<<1)*(row2-row1+1));
		break;

	case 2:	/* color/graphics, write only during horizontal retrace */
		if( dispMemory != 0xB800 )
			goto monochrome;
		horvid((scrCols<<1)*row1, screenChars+(scrCols<<1)*row1,
			scrCols*(row2-row1+1));
		break;

	case 3:	/* color/graphics, write only during horizontal retrace */
		if( dispMemory != 0xB800 )
			goto monochrome;
		hor1vid((scrCols<<1)*row1, screenChars+(scrCols<<1)*row1,
			(scrCols<<1)*(row2-row1+1));
		break;

	case 1:	/* use BIOS calls */
		/* remember the current mouse cursor position */
		if( mousePresent ) {
			setCType(0x20,0x20);	/* make cursor invisible */
			/* Roy Smith says CX=0x2007 also turns off the cursor */
		} else
			getCPos(&saveCx, &saveDx);
		p = screenChars+(scrCols<<1)*row1;
		rin.h.bh = 0;
		for(row = row1; row <= row2; row++) {
			dupCount = 1;
			dupCol = 0;
			for(col = 0; col < scrCols; col++) {
				pw = (int *)p;
				if( *pw != *(pw+1) ) {
					rin.h.ah = 2;
					rin.h.dh = (unsigned char)row;
					rin.h.dl = (unsigned char)dupCol;
					int86(0x10, &rin, &rout);
					rin.h.ah = 9;
					rin.h.al = *p++;
					rin.h.bl = *p++;
					rin.x.cx = dupCount;
					int86(0x10, &rin, &rout);
					dupCount = 1;
					dupCol = col + 1;
				} else {
					++dupCount;
					p += 2;
				}
			}
		}
		if( mousePresent ) {
			/* reset the cursor */
			if( dispMemory == 0xB000 )
				setCType(4, 9);
			else
				setCType(2, 5);
		} else
			setCPos(saveCx, saveDx);
		break;
	}
}

void pascal
/* XTAG:updateLine */
updateLine(row1)
	int row1;
{
	extern union REGS rin, rout;
	extern unsigned char screenLine[];
	extern int mousePresent;
	extern unsigned int dispMemory;
	extern int videoMode;
	extern int scrCols;
	extern struct SREGS segRegs;
	extern void horvid(int, unsigned char *, int);
	extern void hor1vid(int, unsigned char *, int);

	int row, col, saveCx, saveDx, dupCount, dupCol, *pw;
	unsigned char *p;

	switch( videoMode ) {

	default:
	case 0:	/* monochrome, just write into the buffer */
	monochrome:
		movedata(segRegs.ds, (unsigned int)screenLine, dispMemory,
			(scrCols<<1)*row1, scrCols<<1 );
		break;

	case 2:	/* color/graphics, write only during horizontal retrace */
		if( dispMemory != 0xB800 )
			goto monochrome;
		horvid((scrCols<<1)*row1, screenLine, scrCols);
		break;

	case 3:	/* color/graphics, write only during horizontal retrace */
		if( dispMemory != 0xB800 )
			goto monochrome;
		hor1vid((scrCols<<1)*row1, screenLine, scrCols<<1);
		break;

	case 1:	/* use BIOS calls */
		/* remember the current mouse cursor position */
		if( mousePresent ) {
			setCType(0x20,0x20);	/* make cursor invisible */
			/* Roy Smith says CX=0x2007 also turns off the cursor */
		} else
			getCPos(&saveCx, &saveDx);
		p = screenLine;
		rin.h.bh = 0;
		/* display the row */
		dupCount = 1;
		dupCol = 0;
		for(col = 0; col < scrCols; col++) {
			pw = (int *)p;
			if( *pw != *(pw+1) ) {
				rin.h.ah = 2;
				rin.h.dh = (unsigned char)row;
				rin.h.dl = (unsigned char)dupCol;
				int86(0x10, &rin, &rout);
				rin.h.ah = 9;
				rin.h.al = *p++;
				rin.h.bl = *p++;
				rin.x.cx = dupCount;
				int86(0x10, &rin, &rout);
				dupCount = 1;
				dupCol = col + 1;
			} else {
				++dupCount;
				p += 2;
			}
		}
		if( mousePresent ) {
			/* reset the cursor */
			if( dispMemory == 0xB000 )
				setCType(4, 9);
			else
				setCType(2, 5);
		} else
			setCPos(saveCx, saveDx);
		break;
	}
}

void pascal
/* XTAG:downScroll */
downScroll(w, nLines)
	register struct window *w;
	int nLines;
{
	extern struct window *activeWindow;
	extern unsigned char border1[], border2[], border3[], border4[];
	extern unsigned char msgBuffer[];
	extern int isMessage;
	extern int debug;
	
	unsigned char *border;

	if( nLines <= 0 )
		return;
	w->posTopline = prevLine(w->fileId, w->posTopline, &nLines);
	w->numTopline -= nLines;
	fillWindow(w, 1);
	banner(w);
	if( w != activeWindow )
		border = &border1[0];
	else
		border = &border2[0];
	drawBorder(border, w->row1, w->col1, w->row2, w->col2,
		w->borderColor, 0);
	updateScreen(w->row1, w->row2);
	if( isMessage == 4 )
		msg("", 1);
}

void pascal
/* XTAG:upScroll */
upScroll(w, nLines)
	register struct window *w;
	int nLines;
{
	extern struct window *activeWindow;
	extern unsigned char border1[], border2[], border3[], border4[];
	extern unsigned char msgBuffer[];
	extern int isMessage;
	extern int debug;
	
	unsigned char *border;

	if( nLines <= 0 )
		return;
	w->posTopline = nextLine(w->fileId, w->posTopline, &nLines);
	w->numTopline += nLines;
	fillWindow(w, 1);
	banner(w);
	if( w != activeWindow )
		border = &border1[0];
	else
		border = &border2[0];
	drawBorder(border, w->row1, w->col1, w->row2, w->col2,
		w->borderColor, 0);
	updateScreen(w->row1, w->row2);
	if( isMessage == 4 )
		msg("", 1);
}
