unit viewer;
{
This unit written for JugglePro on March 17, 1993
}

Interface

procedure makeobjects;
procedure view(initialview:byte);
procedure show(f:byte);
procedure speed;
procedure dwellratio;
procedure hite;
procedure editfirstthrow;

Implementation
uses crt,graph,header,demoinput,jpfcts,jppat;

procedure makeobjects;
var
  brad,q,maxc,c,cc:byte;

begin
  cleardevice;
  maxc:=getmaxcolor;
  if (maxc=0) or (maxc>16) then maxc:=16;
  for brad:=2 to 9 do
  begin
    q:=brad div 4;
    for c:=1 to maxc do
      begin
        if c=8 then cc:=3      {Let cc be the next non-black color}
               else cc:=c;     {color 8 is black}
        setcolor(cc);
        circle(11,11,brad);    {draw circle of radius brad at 11,11}
        setfillstyle(solidfill,cc);
        floodfill(11,11,cc);   {fill circle with color cc}
        if q>0 then
          begin
            setcolor(white);
            circle(9,9,q);         {make light spot}
            setfillstyle(solidfill,white);
            floodfill(9,9,white);
          end
                else
          putpixel(10,10,white);
        getimage(11-brad,11-brad,11+brad,11+brad,ball[c-1,brad-1]);
      end;
    setcolor(white);
    line(70-brad,11-brad,70-brad,11+brad);
    line(70-brad,11-brad,70+brad,11-brad);
    line(70+brad,11-brad,70+brad,11+brad);
    line(70-brad,11+brad,70+brad,11+brad);
    setfillstyle(solidfill,white);
    floodfill(70,11,white);
    setcolor(0);
    circle(70,11,brad);
    setfillstyle(solidfill,0);
    floodfill(70,11,0);
    {putimage(70-brad,11-brad,ball[maxc-1,brad-1],NotPut);}
    getimage(70-brad,11-brad,70+brad,11+brad,mask[brad-1]); {for erasure}
  end;
end;

procedure view(initialview:byte);
var
  x,y,z,xv,yv,zv,t:array [1..50] of real;
  hx,hy,hz:array [1..3,1..400] of real;
  ox,oz:array [1..50] of integer;
  obrad:array [1..50] of byte;
{
  x,y,z are the ball coordinate arrays
  ox,oz are the "old" coordinates needed for erasure
  obrad is the "old" ball radius needed for erasure
  xv,yv,zv are the ball velocity components
  t[1] is the air time remaining for ball 1
  hx,hy,hz are the hand position arrays initialized to hpx,hpy,hpz
}
  full:array [0..40] of boolean;
{
  Full tells if a hand is full or not (holding a ball)
  If full[0] is true, the first hand is full and the
  ball image stays with the hand image during plotting.

  If multiplex limit, m, is greater than 1, and say both
  full[0] and full[1] are true, then hand 1 is holding two
  balls.  Moreover, the full[0] indicates "slot 1" of hand 1
  while full[1] indicates "slot 2" of hand 1. Wild, eh?
}
  tohand:array [1..50] of byte;
{
  Suppose tohand[3]=1.  This means ball 3 is supposed to be
  caught by hand 1 when it lands.
}
  b:array [1..40] of byte;
{
  Suppose b[2]=3.  If m=1, this means ball 3 is being held in hand 2.
  But if m>1, then 2 would indicate "slot 2" of hand 1.
}
  x0,y0,z0,xf,yf,zf,ft,dt,airt,zz,actualt,x1,y1,z1,f,tempdwell:real;

{
  x0,y0,z0 is the initial position of a ball being thrown
  xf,yf,zf is the final position of the ball's trajectory
  ft is the frametime which is the time unit per throw
  dt is the small delta time associated with one calculation of
  all ball and hand movements.  dt=ft/smoothe.
  airt is the time a ball is to be airborn
  zz is a temporary var
  actualt is the actual time measured in (ft/ti) time intervals
  x1,y1,z1 are temp vars.
  f is a temp var used to store the fraction from actualt
  tempdwell is the dwell ratio used in animation
}
  j,k,hh,jclock,handt,throw,q,qi,ydepth,zdepth:integer;
{
  j is the frame number, which indicates what column of the
  pattern is being used
  k is the number of the most recent ball thrown
  hh is used as pattern row number or actual hand number
  jclock is incremented every dt time interval (i.e. after each
  calculation & screen update made of all new positions).
  jclock is reset when it reaches nt*smoothe, the time at which
  hand movements repeat.
  handt is time index used to access the hpx,hpy,hpz arrays
  throw is an absolute time index from the pattern
  q and qi are temp vars.
}
  nextlink,exitflg,drawfullhand,odrawfullhand,depthflg:boolean;
{
  nextlink is true if the user wants to exit the repeat (which
  is done by pressing spacebar).
  exitflg is true if there is an error during or before viewing
  or if the user chooses to exit (by pressing Esc).
  drawfullhand tells the viewer to draw the full hand icon
  odrawfullhand is used to keep track of old value for erasure
  depthflg is true by default (it shows true 3d depth)

}
  nextball,whathand:byte;
{
  nextball indexes the next new ball still waiting to be used.
  the viewer will register an error if nextball exceeds n+1.
  whathand is a temp var used to identify an actual hand.
}
  perm:array [1..20] of byte;
{
  perm tells the current permutation of the actual hands.  This
  permutation begins with the identity.  After one period of hand
  movement, it is permuted by the permutation rule (permrule).
}

  depth:array [1..70] of byte;

  hpxtmp,hpytmp,hpztmp:array [1..3,1..20] of integer;

function cvh(vh,vt:integer):integer;
{This converts the absolute pattern vector position (vh,vt) into
 the actual hand.  vh indicates pattern row.  If m>1, then vh is
 not equal to the actual hand.  If asyncflag is on, vt must be
 used to determine the correct hand since the hands alternate}
begin
  if asyncflag then cvh:=2*((vh-1) div m)+vt mod 2 +1
               else cvh:=(vh-1) div m +1;
end;

procedure getpermhand(frame:integer);
{Permutes hh by the permutation rule ppowr times.  ppowr, the permutation
 power, is greater than zero when frame>nt}
var
  ppowr,qq:integer;
begin
  if frame>0 then            {frame should always be >0}
    begin
      ppowr:=(frame-1) div nt;
      if ppowr>0 then
       for qq:=1 to ppowr do
        hh:=permrule[hh];
    end;
end;

procedure gethandt;
{Gets the time index in intervals equal to ft/ti}
begin
  if moveflag then
    handt:=throw*ti+1
  else handt:=1;
end;

function middlex(i:integer):real;
begin
  middlex:=(hx[2,i]+hx[3,i])/2;
end;

function middley(i:integer):real;
begin
  middley:=(hy[2,i]+hy[3,i])/2;
end;

function middlez(i:integer):real;
begin
  middlez:=(hz[2,i]+hz[3,i])/2;
end;

procedure finalpos;
{Calculates the final position (xf,yf,zf) of a ball}
begin
if moveflag then
  begin
    actualt:=handt-tempdwell*ti;       {real time in (ft/ti) units}
    q:=trunc(actualt);                 {time index to hpx,hpy,hpz}
    getpermhand((q-1) div ti +1);      {permute hh if necessary}
    while q>nt*ti do q:=q-nt*ti;       {reduces q so: 1<=q<=nt*ti}
    if q=0 then q:=nt*ti;
    f:=frac(actualt);                  {right of decimal}
    x1:=middlex(hi(hh,q));
    y1:=middley(hi(hh,q));             {calculate final pos. using f}
    z1:=middlez(hi(hh,q));
    if q=nt*ti then hh:=permrule[hh];  {failing to permute hh would cause}
    xf:=x1+f*(middlex(hi(hh,q+1))-x1);   {incorrect throw since nt*ti+1 is}
    yf:=y1+f*(middley(hi(hh,q+1))-y1);   {the time for hands to be permuted}
    zf:=z1+f*(middlez(hi(hh,q+1))-z1);
  end
else
  begin
    xf:=middlex(hi(hh,handt));
    yf:=middley(hi(hh,handt));
    zf:=middlez(hi(hh,handt));
  end;
end;

procedure depthtrans(var x,y,z:integer);
var
  f:real;

begin
  if depthflg then
    begin
      f:=lens+2*cy-y;
      if f<10 then f:=10;
      f:=lens/f;
      x:=round((x-cx)*f)+cx;
      z:=round((z-cy)*f)+cy;
    end;
end;

procedure drawhand(x1,z1,x2,z2,x3,z3:integer);
var
  u1x,u1z,u2x,u2z:real;
  px,pz:integer;
begin
  u1x:=(x2-x1)/6;
  u1z:=(z2-z1)/6;
  u2x:=(x3-x1)/6;
  u2z:=(z3-z1)/6;
  px:=round(x1+13*(u1x+u2x));
  pz:=round(z1+13*(u1z+u2z));
  if oktoplot(x1,z1) and oktoplot(px,pz) then
    begin
      line(x2,z2,round(x1+11*u1x+5*u2x),round(z1+11*u1z+5*u2z)); {thumb}
      line(x2,z2,round(x1+6*u1x+12*u2x),round(z1+6*u1z+12*u2z));   {index}
      line(x3,z3,x2+x3-x1,z2+z3-z1);  {ridge}
      line(x3,z3,round(x1+10*u2x),round(z1+10*u2z)); {pinky}
      line(round(x3+2*u1x),round(z3+2*u1z),
           round(x1+2*u1x+12*u2x),round(z1+2*u1z+12*u2z)); {ring}
      line(round(x3+4*u1x),round(z3+4*u1z),
           round(x1+4*u1x+13*u2x),round(z1+4*u1z+13*u2z)); {middle}
    end;
end;

procedure plothand(k:byte; x1,y1,z1,x2,y2,z2,x3,y3,z3:integer);
begin
  depthtrans(x1,y1,z1);
  depthtrans(x2,y2,z2);
  depthtrans(x3,y3,z3);
  setcolor(0);
  if oktoplot(ohpx[1,k],ohpz[1,k]) then
    begin
      if oktoplot(ohpx[2,k],ohpz[2,k])
        then line(ohpx[1,k],ohpz[1,k],ohpx[2,k],ohpz[2,k]);
      if oktoplot(ohpx[3,k],ohpz[3,k])
        then line(ohpx[1,k],ohpz[1,k],ohpx[3,k],ohpz[3,k]);
      if odrawfullhand then
       drawhand(ohpx[1,k],ohpz[1,k],ohpx[2,k],ohpz[2,k],ohpx[3,k],ohpz[3,k]);
    end;
  setcolor(3);
  if oktoplot(x1,z1) then
    begin
      if oktoplot(x2,z2) then line(x1,z1,x2,z2);
      if oktoplot(x3,z3) then line(x1,z1,x3,z3);
      if drawfullhand then drawhand(x1,z1,x2,z2,x3,z3);
    end;
  ohpx[1,k]:=x1;     {remember these coordinates for erasure}
  ohpy[1,k]:=y1;
  ohpz[1,k]:=z1;
  ohpx[2,k]:=x2;
  ohpy[2,k]:=y2;
  ohpz[2,k]:=z2;
  ohpx[3,k]:=x3;
  ohpy[3,k]:=y3;
  ohpz[3,k]:=z3;
end;

procedure plotobj(k:byte);
var
 x1,y1,z1:integer;
 brad:byte;

begin
  x1:=round(x[k]);
  y1:=round(y[k]);
  z1:=round(z[k]);
  depthtrans(x1,y1,z1);
  brad:=depth[k];
  if oktoplot(ox[k]-obrad[k],oz[k]-obrad[k]) then
    putimage(ox[k]-obrad[k],oz[k]-obrad[k],mask[obrad[k]],AndPut);
  if oktoplot(x1-brad,z1-brad) then
   begin
    putimage(x1-brad,z1-brad,mask[brad],AndPut);
    putimage(x1-brad,z1-brad,ball[k mod getmaxcolor,brad],OrPut);
   end;
  ox[k]:=x1;  {remember these old coordinates for erasure}
  oz[k]:=z1;
  obrad[k]:=brad;
end;

procedure findft;
var
  i,j,jj,limit:integer;
  tmin,t:real;

procedure findt;
var
  z1,z2:real;
  trt,trh:integer;
begin
  trh:=rh[p(i,j)];              {store these for efficiency}
  trt:=rt[p(i,j)];
  throw:=jj-1;                  {let throw be current frame minus one}
  hh:=cvh(i,aswitch);           {determine actual hand, hh}
  getpermhand(jj);              {permute hh if necessary}
  gethandt;                     {get handt, the time in (ft/ti) units}
  while handt>nt*ti do handt:=handt-nt*ti;
  if handt=0 then handt:=nt*ti; {reduce handt so: 1<=handt<=nt*ti}
  z0:=maxheight+6-hpz[1,hi(hh,handt)]; {calculate initial height coordinate}
  throw:=trt+jj-1; {now find the final frame-1 where the ball is to be caught}
  qi:=hh;                       {store actual hand temporarily}
  hh:=cvh(trh+i,trt+aswitch); {find actual catching hand, hh}
  tempdwell:=dwell[hh];         {assign dwell ratio}
  if holdflag and (qi=hh) then  {if hold and catching hand=throwing hand}
    begin
      if asyncflag and (trt=2) then tempdwell:=1.99;
      if (not asyncflag) and (trt=1) then tempdwell:=0.99;
    end;
  if trt<=tempdwell then tempdwell:=0.5;
  gethandt;                     {get time in (ft/ti) units}
  finalpos;                     {determine final position}
  zf:=maxheight+6-zf;
  if (z0>height-6) or (zf>height-6) then
    exitflg:=true;              {hand positions off screen!}
  if exitflg then exit;
  z1:=sqrt((z0-height+6)*2/gz);  {calculate maximum airtime possible}
  z2:=sqrt((zf-height+6)*2/gz);
  if trt=0 then t:=1E8
    else t:=(z1+z2)/(trt-tempdwell); {max frametime possible}
end;

begin
  tmin:=1E8;    {arbitrarily large}
  jj:=0;
  limit:=200;   {guarantees pattern will be on screen for 200 throws}
  aswitch:=firstthrow;
  repeat
    for j:=1 to l do
      begin
        jj:=jj+1;
        for i:=1 to h*m do
          begin
            findt;        {finds maximum frametime for given throw}
            if exitflg then exit;
            aswitch:=1-aswitch;
            if t<tmin then tmin:=t;  {take minimum of all of these}
          end;
      end;
  until (jj>limit);     {tests 200 first throws}
  ft:=tmin;             {let frametime equal the minimum}
end;

procedure movehand(k:byte);
var
  km,hidx:byte;

begin
  plothand(k,hpxtmp[1,k],hpytmp[1,k],hpztmp[1,k],
             hpxtmp[2,k],hpytmp[2,k],hpztmp[2,k],
             hpxtmp[3,k],hpytmp[3,k],hpztmp[3,k]);
  for km:=1 to m do
  begin
    hidx:=(k-1)*m+km;          {calculate multiplex hand slot}
    if asyncflag then hidx:=(((k-1) div 2)*m+km-1)*2+(k-1) mod 2 +1;
    if full[hidx] then         {have ball follow hand's move}
      begin
        x[b[hidx]]:=round((hpxtmp[2,k]+hpxtmp[3,k])/2);
        y[b[hidx]]:=round((hpytmp[2,k]+hpytmp[3,k])/2);
        z[b[hidx]]:=round((hpztmp[2,k]+hpztmp[3,k])/2);
        plotobj(b[hidx]);
      end;
  end;
end;

procedure moveobjects;
var
  k:byte;
  xx,yy,zz:real;

begin
  if nextball>0 then
    for k:=1 to nextball do           {go thru all balls}
     begin
      if t[k]>0 then           {if ball is in the air, then}
        begin
          t[k]:=t[k]-dt;       {reduce its airtime by dt}
          xx:=gx*dt/2;
          xv[k]:=xv[k]-xx;     {this algorithm is slightly more precise}
          x[k]:=x[k]+xv[k]*dt; {for calculating acc., than std. newtonian}
          xv[k]:=xv[k]-xx;
          yy:=gy*dt/2;         {now do the same for y}
          yv[k]:=yv[k]-yy;
          y[k]:=y[k]+yv[k]*dt;
          yv[k]:=yv[k]-yy;
          zz:=gz*dt/2;         {now do the same for z}
          zv[k]:=zv[k]-zz;
          z[k]:=z[k]+zv[k]*dt;
          zv[k]:=zv[k]-zz;
        end;
      if (t[k]<=0) and (full[tohand[k]]=false) then
        begin                       {if ball's airtime is out and the}
          full[tohand[k]]:=true;    {catching hand is empty, catch ball}
          b[tohand[k]]:=k;          {and let hand know which ball it has}
        end;
     end;
end;

procedure calcdepths;
var
  ydepth:integer;
  k:byte;
  f,c:real;

begin
  c:=1/3*cy;
  if nextball>0 then
    begin
      for k:=1 to nextball do
        begin
          f:=c+2*cy-y[k];
          if f<c then f:=c;
          f:=c/f;
          ydepth:=round(f*8);
          if ydepth<1 then ydepth:=1;
          if ydepth>8 then ydepth:=8;
          depth[k]:=ydepth;
        end;
    end;
  for k:=1 to hact do
    begin
      f:=c+2*cy-hpytmp[1,k];
      if f<c then f:=c;
      f:=c/f;
      ydepth:=round(f*8);
      if ydepth<1 then ydepth:=1;
      if ydepth>8 then ydepth:=8;
      depth[k+n]:=ydepth;
    end;
end;

procedure calchands;
var
  t:integer;
  jtim,f,x1,y1,z1:real;
  k,kk,o:byte;

begin
  jtim:=jclock/smoothe*ti;   {get time in (ft/ti) units}
  t:=trunc(jtim)+1;          {get time index}
  f:=frac(jtim);
  for k:=1 to hact do
   for o:=1 to 3 do
    begin
      kk:=perm[k];            {get current permutation of each hand}
      if moveflag then
        begin
          x1:=hx[o,hi(kk,t)];
          y1:=hy[o,hi(kk,t)];
          z1:=hz[o,hi(kk,t)];
          if t=nt*ti then kk:=permrule[kk];  {this hand gets permuted}
          x1:=x1+(hx[o,hi(kk,t+1)]-x1)*f;  {calculate intermediate}
          y1:=y1+(hy[o,hi(kk,t+1)]-y1)*f;  {coordinates using f}
          z1:=z1+(hz[o,hi(kk,t+1)]-z1)*f;
        end
      else
        begin
          x1:=hx[o,hi(kk,1)];
          y1:=hy[o,hi(kk,1)];
          z1:=hz[o,hi(kk,1)];
        end;
      hpxtmp[o,k]:=round(x1);       {store coordinates for plotting}
      hpytmp[o,k]:=round(y1);
      hpztmp[o,k]:=round(z1);
    end;
end;

procedure plotobjects;
var
  d,k:byte;
begin
  calchands;
  calcdepths;
  for d:=1 to 8 do
    begin
      if nextball>0 then
        for k:=1 to nextball do
          if (depth[k]=d) and (t[k]>0) then plotobj(k);
      for k:=1 to hact do
        if (depth[n+k]=d) then movehand(k);
    end;
  odrawfullhand:=drawfullhand;
end;

procedure rotxy;
var
  i,j,k:byte;
  xx,yy:real;

begin
  if nextball>0 then
    begin
      for i:=1 to nextball do            {rotate balls}
        begin
          xx:=x[i]-xorigin;
          yy:=y[i]-yorigin;
          transform(xx,yy);
          x[i]:=xx+xorigin;
          y[i]:=yy+yorigin;
          transform(xv[i],yv[i]);
          plotobj(i);
        end;
    end;
  for j:=1 to nt*ti+1 do      {rotate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        begin
          xx:=hx[k,hi(i,j)]-xorigin;
          yy:=hy[k,hi(i,j)]-yorigin;
          transform(xx,yy);
          hx[k,hi(i,j)]:=xx+xorigin;
          hy[k,hi(i,j)]:=yy+yorigin;
        end;
  transform(gx,gy);    {rotate gravity vector}
end;

procedure rotxz;
var
  i,j,k:byte;
  xx,zz:real;

begin
  if nextball>0 then
    begin
      for i:=1 to nextball do    {rotate balls}
      begin
        xx:=x[i]-xorigin;
        zz:=z[i]-cy;
        transform(zz,xx);
        x[i]:=xx+xorigin;
        z[i]:=zz+cy;
        transform(zv[i],xv[i]);
        plotobj(i);
      end;
    end;
  for j:=1 to nt*ti+1 do      {rotate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        begin
          xx:=hx[k,hi(i,j)]-xorigin;
          zz:=hz[k,hi(i,j)]-cy;
          transform(zz,xx);
          hx[k,hi(i,j)]:=xx+xorigin;
          hz[k,hi(i,j)]:=zz+cy;
        end;
  transform(gz,gx);   {rotate gravity vector}
end;

procedure rotyz;
var
  i,j,k:byte;
  yy,zz:real;

begin
  if nextball>0 then
    begin
      for i:=1 to nextball do       {rotate balls}
        begin
          yy:=y[i]-yorigin;
          zz:=z[i]-cy;
          transform(yy,zz);
          y[i]:=yy+yorigin;
          z[i]:=zz+cy;
          transform(yv[i],zv[i]);
          plotobj(i);
        end;
    end;
  for j:=1 to nt*ti+1 do     {rotate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        begin
          yy:=hy[k,hi(i,j)]-yorigin;
          zz:=hz[k,hi(i,j)]-cy;
          transform(yy,zz);
          hy[k,hi(i,j)]:=yy+yorigin;
          hz[k,hi(i,j)]:=zz+cy;
        end;
  transform(gy,gz);   {rotate gravity vector}
end;

procedure zoom(dy:real);
var
  i,j,k:integer;
begin
  if nextball>0 then
    for i:=1 to nextball do    {translate balls}
      y[i]:=y[i]+dy;
  for j:=1 to nt*ti+1 do     {translate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        hy[k,hi(i,j)]:=hy[k,hi(i,j)]+dy;
end;

procedure east(dx:real);
var
  i,j,k:integer;
begin
  if nextball>0 then
    for i:=1 to nextball do    {translate balls}
      x[i]:=x[i]+dx;
  for j:=1 to nt*ti+1 do     {translate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        hx[k,hi(i,j)]:=hx[k,hi(i,j)]+dx;
end;

procedure north(dz:real);
var
  i,j,k:integer;
begin
  if nextball>0 then
    for i:=1 to nextball do    {translate balls}
      z[i]:=z[i]+dz;
  for j:=1 to nt*ti+1 do     {translate hands}
    for i:=1 to hact do
      for k:=1 to 3 do
        hz[k,hi(i,j)]:=hz[k,hi(i,j)]+dz;
end;

procedure doframe;
var
  i,pidx:byte;
 mm:integer;

begin
  for i:=1 to h*m do              {go thru all rows of pattern}
    begin
      if rt[p(i,j)]>0 then        {this means a throw must occur}
        begin
          throw:=jclock div smoothe;  {get present time index}
          gethandt;                   {find handt in (ft/ti) units}
          qi:=perm[cvh(i,aswitch)];   {qi=actual throwing hand}
          x0:=middlex(hi(qi,handt));  {gets x0,y0,z0}
          y0:=middley(hi(qi,handt));
          z0:=middlez(hi(qi,handt));
          hh:=cvh(i+rh[p(i,j)],aswitch+rt[p(i,j)]); {find catching hand}
          throw:=(jclock div smoothe)+rt[p(i,j)]; {get index in frames and wrt jclock}
          tempdwell:=dwell[hh];             {just to assign dwell ratio}
          if asyncflag then tempdwell:=tempdwell*2;
          hh:=perm[hh];                     {adjust to follow perm}
          if holdflag and (qi=hh) then
            begin
              if asyncflag and (rt[p(i,j)]=2) then tempdwell:=1.99;
              if (not asyncflag) and (rt[p(i,j)]=1) then tempdwell:=0.99;
            end;
          if rt[p(i,j)]<=tempdwell then tempdwell:=0.5;
          airt:=(rt[p(i,j)]-tempdwell)*ft;  {calculate airtime needed}
          gethandt;
          finalpos;                         {calculate final position}
          if asyncflag then                 {determine the...}
            whathand:=(i-1)*2+aswitch+1     {"multiplex hand slot" for}
          else                              {async multiplex patterns}
            whathand:=i;
          if full[whathand] then k:=b[whathand]  {if hand is full, throw}
                     else begin                  {ball which is in hand}
                            nextball:=nextball+1;
                            k:=nextball;         {else pick up next ball}
                          end;
          if k>n then begin
                        outtext('error');   {number of balls exceeded}
                      end                   {pattern must be invalid}
                 else begin
                        full[whathand]:=false;   {no ball in hand-slot}
                        tohand[k]:=i+rh[p(i,j)]; {ball to be caught by}
                        if asyncflag then        {multiplex hand slot}
                          begin
                            tohand[k]:=(tohand[k]-1)*2 + 1
                                       +(rt[p(i,j)]+aswitch) mod 2;
                          end;
                        t[k]:=airt;              {assign airtime}
                        xv[k]:=(xf-x0)/airt+gx*airt/2;  {velocities}
                        yv[k]:=(yf-y0)/airt+gy*airt/2;
                        zv[k]:=(zf-z0)/airt+gz*airt/2;
                        x[k]:=x0;                {initial coordinates}
                        y[k]:=y0;
                        z[k]:=z0;
                      end;
        end;
    end;
    for mm:=1 to smoothe do      {calculate smoothe steps of duration dt}
      begin                      { (recall that ft=smoothe*dt by def.) }
        moveobjects;
        plotobjects;
        if keypressed then
          begin                  {get user input}
            ch:=readkey;
            if ch<>chr(0)
              then
                case ch of
                  ' ','L','l': nextlink:=true;
                  '1': rotxy;
                  '2': rotxz;
                  '3': rotyz;
                  '+','i','I': zoom(10);
                  '-','o','O': zoom(-10);
                  chr(27),chr(13): exitflg:=true;
                  'P','p': repeat until keypressed;
                  'H','h': drawfullhand:=not drawfullhand;
                  'D','d': depthflg:=not depthflg;
                  'C','c': cleardevice;
                end
              else
                begin
                  ch:=readkey;
                  case ch of
                    'H': north(-10);
                    'P': north(10);
                    'K': east(-10);
                    'M': east(10);
                  end;
                end;
          end;
        jclock:=jclock+1;        {jclock incremented for each dt}
        if exitflg then exit;
      end;
  if exitflg then exit;
  if jclock=nt*smoothe then       {if hand movement completed, }
    begin
      jclock:=0;                  {reset jclock and permute hands}
      for pidx:=1 to hact do
        perm[pidx]:=permrule[perm[pidx]];
    end;
  if asyncflag then aswitch:=1-aswitch;    {alternate right & left hands}
end;

procedure zeroall;
var
  k,o,i:byte;
{initialize all values to zero}
begin
  for k:=1 to n do
    begin
      t[k]:=0;
      x[k]:=0;
      y[k]:=0;
      z[k]:=0;
      tohand[k]:=0;
      ox[k]:=0;
      oz[k]:=0;
      obrad[k]:=1;
    end;
  for k:=1 to m*hact do
    begin
      full[k]:=false;
      b[k]:=0;
    end;
  for k:=1 to hact do
   for o:=1 to 3 do
    begin
      hpxtmp[o,k]:=40;
      hpytmp[o,k]:=40;
      hpztmp[o,k]:=40;
    end;
  for i:=1 to nt*ti+1 do             {initialize real hand arrays}
    for k:=1 to hact do
     for o:=1 to 3 do
      begin
        hx[o,hi(k,i)]:=hpx[o,hi(k,i)];
        hy[o,hi(k,i)]:=hpy[o,hi(k,i)];
        hz[o,hi(k,i)]:=hpz[o,hi(k,i)];
      end;
  for k:=1 to hact do
   for o:=1 to 3 do
    begin
      ohpx[o,k]:=0;
      ohpy[o,k]:=0;
      ohpz[o,k]:=0;
    end;
  for k:=1 to n+hact do
    depth[k]:=1;
  full[0]:=true;
  nextball:=0;
  gx:=0;         {initialize gravity vector to z axis}
  gy:=0;
  gz:=-10;
end;

{ ******** Main Body of Viewer ******** }
begin
  exitflg:=false;
  for j:=1 to hact do              {set perm to identity}
    perm[j]:=j;
  moveto(0,cy*2-8);
  zeroall;                         {initialize data}
  outtext('Fitting pattern to screen...');
  findft;                          {find greatest frametime possible to}
  if exitflg then                  {still fit the pattern to the screen}
    errmsg:='Increase height parameter';
  if exitflg then exit;
  dt:=ft/smoothe;                  {define delta t, the time/calculation}
  cleardevice;                     {clear graphics screen}
  moveto(0,cy*2-8);                {bottom line of screen}
  outtext('Esc=Exit 1-3=Rotate Arrows=Move In Out Pause Link Clear Hands Depth');
  jclock:=0;
  aswitch:=firstthrow;             {set first throwing hand for async}
  drawfullhand:=true;              {default to drawing full hand first}
  depthflg:=true;
  if initialview=2 then
  begin                            {rotate to aerial view}
    cda:=0;
    sda:=-1;
    rotyz;
    cda:=cos(da);
    sda:=sin(da);
  end;
  repeat
    if startup>1 then              {do startup sequence}
      for j:=1 to startup-1 do
        begin
          doframe;
          if exitflg then exit;
        end;
    if exitflg then exit;
    nextlink:=false;
    repeat                        {repeat "repeated sequence" of pattern}
      for j:=startup to endup do
        begin
          doframe;
          if exitflg then exit;
        end;
    until exitflg or nextlink;    {until user decides to quit or continue}
    if exitflg then exit;
    if endup<l then
      for j:=endup+1 to l do      {do endup segment of pattern}
        begin
          doframe;
          if exitflg then exit;
        end;
  until exitflg;
end;

function checkpattern:string;
var
  msg:string;
  x:array [1..800] of boolean;
  i,j,hh,tt,tmp:integer;

begin
  msg:='';
  for i:=1 to 800 do x[i]:=false;
  for i:=1 to m*h do
    for j:=1 to l do
      begin
        if rt[p(i,j)]<0 then msg:='Negative throw-height encountered';
        if (rt[p(i,j)]=0) and (rh[p(i,j)]<>0) then msg:='Zero throw-height not self';
        if length(msg)=0 then
          begin
            hh:=i+rh[p(i,j)];
            tt:=(j+rt[p(i,j)]) mod l;
            if tt=0 then tt:=l;
            tmp:=p(hh,tt);
            if x[tmp] then msg:='Continuity error in pattern'
                      else x[tmp]:=true;
          end;
      end;
  checkpattern:=msg;
end;

procedure show(f:byte);
var
  ch:char;

begin
  errmsg:='';
  if (n<0) or (n>50) then
    errmsg:='Invalid number of balls';    {check number of balls}
  if hact<>hedit then
    errmsg:='Inconsistency in hand number';
  if length(errmsg)>0 then exit;
  errmsg:=checkpattern;
  if length(errmsg)>0 then exit;
  setgraphmode(graphmode);         {set up graphics screen}
  setallpalette(pt);
  view(f);        {view the pattern}
  while keypressed do ch:=readkey; {clear key buffer}
end;

procedure speed;
begin
  window(1,2,79,8);
  clrscr;
  smoothe:=changeval(smoothe,'speed',1,10000);
  clrscr;
end;

procedure dwellratio;
var
  e:integer;
  s1,s2:string;
  z:real;
  hh:byte;

begin
  window(1,2,79,25);
  repeat
  clrscr;
  writeln('Choose all hands by typing *.  Hit ENTER to exit.');
  writeln;
  for hh:=1 to hact do
    writeln('hand #',hh,': ',dwell[hh]);
  repeat
    write('Which hand?');
    readlndemo(s1);
    val(s1,hh,e);
    if (s1='*') or (length(s1)=0) then hh:=1;
  until (hh>0) and (hh<=hact);
  if length(s1)>0 then
  begin
    z:=dwell[hh];
    repeat
      write('Enter new dwellratio (0<dwell<=1): ');
      readlndemo(s2);
      val(s2,dwell[hh],e);
      if length(s2)=0 then dwell[hh]:=z;
    until (dwell[hh]>0) and (dwell[hh]<2);
    if dwell[hh]>1 then
      begin
        writeln('WARNING: This setting may not work.');
        ch:=readkeydemo;
      end;
    if (s1='*') and (length(s2)>0) and (hact>1) then
      for hh:=2 to hact do dwell[hh]:=dwell[1];
  end;
  until length(s1)=0;
  clrscr;
end;

procedure hite;
begin
  window(1,2,79,8);
  clrscr;
  height:=changeval(height,'height',1,maxheight);
  clrscr;
end;

procedure editfirstthrow;
begin
  window(1,2,79,8);
  clrscr;
  firstthrow:=changeval(firstthrow,'first throw',0,1);
  clrscr;
end;

var i,j:byte;
begin
  for i:=1 to 20 do     {initialize global vars. pertaining to viewer}
    dwell[i]:=0.5;
  smoothe:=30;
  firstthrow:=0;
  makeobjects;
end.
