/*
 * delpath.c
 *
 * Returned status:
 *	0	OK (including case where nothing needs to be done)
 *	1	bad arguments
 *
 */
#include <io.h>
#include <string.h>
#include <stdlib.h>

void exit(int status) { _exit(status); }

#define writes(s,i)  write(i,s,strlen(s));

main(int argc, char *argv[])
{
	int len;
	char *path, *pathname, *str;

	if( argc != 2)	{
		writes("Usage: delpath pathname\n",2);
		exit(1);
	} else {
		pathname = strupr(argv[1]);
		len = strlen(pathname);
		/* strip off a trailing ";" and upper-case */
		if( *(pathname+len-1) == ';') *(pathname+len-1) = '\0';
		path = getenv("PATH");
		str = strupr(path);
		while (str)	{
			str = strstr(str, pathname);
			if(!str)	{
				/* not present in path - nothing to do */
				writes(path,1);
				break;
			} else if (*(str+len) == ';')	{
				/* appears at middle - write out the two parts */
				*str = '\0';
				writes(path,1);
				writes(str+len+1,1);
				break;
			} else if (*(str+len) == '\0')	{
				/* appears at end - truncate */
				*(str-1) = '\0';
				writes(path,1);
				break;
			} else	{
				/* incorrect match found - keep looking */
				str += len;
			}
		}
	}
	return(0);
}
