/*
 * setenv.c - set values in the parent environment
 *
 * Author:		R. Brittain						4/11/90
 *	Popen() is taken from code obtained from simtel20
 *  Recommended wildcard expansion code to use with this is wildargv.c by
 *     Frank Whaley and placed in the public domain
 *  Environment location/manipulation borrowed from various places, but now
 *  mangled beyond recognition
 *
 * Syntax:
 *		setenv variable value......
 *
 * Description:
 *  The command line is iteratively scanned for command substitutions in `...`
 *  and environment variables (%var), and the resulting text used as the value
 *  of the environment variable named in the first argument.
 *  Command substitutions are performed by calling system(), which loads a
 *  shell to run the the command.  If the first character of the command is '@'
 *  the command is exec'ed directly (much faster than calling system, but
 *  only works with .exe and .com files)
 *
 *  The magic characters %,`, and @ are set by #defines so you can change
 *  them if you don't like them (comsub.h)
 *
 *					This code placed in the public domain
 *
 *  Revision history
 *	1.0		Dec 90 RB - first posted to usenet
 *	1.01	Jan 91 RB - fixed argument parsing so `.....` can span multiple
 *				arguments without needing to be double quoted
 *			  	- fixed location of environment for pre DOS 3.3 lowest level
 *			  	command.com
 *
 */
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>

#include "comsub.h"

/* prototypes */

int 	 get_env_index(char *var, char **env_var);
int  	 getenvseg(unsigned *envseg);
unsigned get_env_var(unsigned env_addr, char ***env_var, int *count);
void 	 put_env_var(unsigned env_addr, unsigned seglen, char **env_var);
void 	 fatal(char *msg, int status);


main(int argc, char **argv)
{
	char version[] = "setenv version 1.01 of "__DATE__ ;
	char usage[] = "Usage: setenv variable value\n";
	unsigned env_addr, seglen;
	int index, i, count;
	char *value, **env_var;

	if (argc == 1)
		fatal(usage,1);

	if ( !getenvseg(&env_addr))
		fatal ("Cannot locate environment\n",2);

	/* process command line for back-quotes and unexpanded env. vars. */
	rebuild_argv(&argc,&argv);

	/* convert variable to upper case for compatibility */
	strupr(argv[1]);

	seglen = get_env_var( env_addr, &env_var, &count );
	index  = get_env_index( argv[1], env_var );
	if (index == count) env_var[index+1] = (char *)NULL;

	if (argc == 2) {
		/* no value specified - take as a request to remove this entry */
		value = "";
	} else {
    	/* set the value of the variable to the rest of the arguments */
		value = (char *) malloc(strlen(argv[1]) + 2);
		strcpy(value,argv[1]);
		strcat(value,"=");
		for (i=2; i < argc; i++) {
			value = (char *) realloc(value, strlen(value) + strlen(argv[i]) + 2);
			strcat(value,argv[i]);
			strcat(value," ");
		}
		*(endptr(value)-1) = '\0';
	}
	env_var[index] = value;
	put_env_var(env_addr, seglen, env_var);
	return(0);
}


void fatal(char *msg, int status)
{
	fputs(msg,stderr);
	exit(status);
}
