(*  Ezycom Structures  Copyright Peter Davies.  All Rights Reserved.
    Revised for Ezycom V1.02 15/08/1992.

    May be freely used by 3rd Party Developers for Ezycom.

    Written permission must be granted by Peter Davies for
    non-third party use.

    Sorry, about the mess, I'll fix it up for Ezycom V1.02 release *)

(*  Pascal to C
    typedef char unsigned byte;
    typedef int  unsigned word;
    typedef char unsigned boolean;
    typedef long signed   longint;

     All Strings require one extra character.
     The first field of a string [0] is the length of the string *)

(*   Turbo Pascal defines

     DateTime = Record
        Year,
        Month,
        Day,
        Hour,
        Min,
        Sec   : word;
     end; *)

const
    version       = '1.02';
    versionhigh   = 1;
    versionlow    = 2;
    productname   = 'Ezycom';
    copyright     = 'Peter Davies';
    copyrightyear = '1992';
    maxfree       = 685;
    userfree      = 4;
    constantfreespace = 89;
    constantfilefreespace = 816;
    maxnodes     = 128;
    maxaka       = 16;
    maxmess      = 1024;
    maxmessall   = 1024;
    maxfile      = 400;
    maxbaudrec   = 11;

    (* Message Types *)

    localmail = 0;
    netmail   = 1;
    echomail  = 2;
    passthru  = 3;
    waitthru  = 4;
    allmail   = 5;

    (* Ask Types *)

    askyes    = 0;
    askno     = 1;
    askask    = 2;
    askaskyes = 2;   (* extended ask defaults to yes *)
    askaskno  = 3;   (* extended ask defaults to no *)

    (* Phone Types *)

    business  = 0;
    data      = 1;
    nophone   = 2;

    (* File Size Types *)

    nosize    = 0;
    sizebytes = 1;
    sizekilobytes = 2;

    (* Message Kinds Type *)

    public        = 0;
    private       = 1;
    privatepublic = 2;

    (* Swapping Types *)

    SwapwithNone   = 0;
    SwapwithEMS    = 1;
    SwapwithXMS    = 2;
    SwapwithDISK   = 3;
    SwapwithEMSXMS = 4;
    SwapwithXMSEMS = 5;

    (* User Attributes *)
    usr1deleted          = 0;
    usr1clrscr           = 1;
    usr1moreprompt       = 2;
    usr1ansicapable      = 3;
    usr1nokill           = 4;
    usr1filepointignore  = 5;
    usr1fullscreened     = 6;
    usr1quietmode        = 7;
    usr2ignorefileratios = 0;
    usr2ibmextended      = 1;
    usr2dateformat       = 2;
    usr2ignorepaging     = 3;
    usr2excludeuser      = 4;
    usr2avatarcapable    = 5;
    usr2ignoretime       = 6;
    usr2ignoremessratio  = 7;
    usr3nopagesound      = 0;
    usr3pageatlogon      = 1;
    usr3holdmailbox      = 2;
    usr3combinedmailbox  = 3;

    (* Constant ScanTossAttr *)
    stdupedetection      = 0;
    stkillnullnetmail    = 1;
    stkeepechoarea       = 2;
    stimportmsgssysop    = 3;
    stroutemail          = 4;
    stkillbadarchives    = 5;
    starcmailcompat      = 6;

    (* Constant ConstantAttr *)
    casysopaliasinchat   = 0;
    caautocapturechat    = 1;
    cadisplayfullmessage = 2;
    canodelmailbundle    = 3;

    (* Config ConfigAttr *)
    comovelocaluploads   = 0;

type
     filestr        = string[12];  (* max length of a filename *)
     asktype        = byte;
     phonetype      = byte;
     msgtype        = byte;
     msgkindstype   = byte;
     showfilesizetype = byte;
     maxstr         = string[255];
     userstring     = string[35];
     date           = string[8];
     str2           = string[2];
     str3           = string[3];
     str4           = string[4];
     str8           = string[8];
     str12          = string[12];
     str23          = string[23];
     str30          = string[30];
     str72          = string[72];
     str128         = string[128];
     flagtype       = array[1..4] of byte;
     grouptype      = array[1..4] of byte;

     onoffflagtype  = record
        onflags,
        offflags    : flagtype;
     end;

     daterecord     = record
        year        : word;
        month       : byte;
        day         : byte;
     end;

     netrecord      = record
                     zone,
                     net,
                     node,
                     point   : word;
     end;

    (* **********************************************************

       Filename:    <configrec.userbasepath>USERS.BBS

       Description: Users File
                    Records in parrallel with USERSEXT.BBS

       Limitations: 65000 records (users) maximum

       ********************************************************** *)

        usersrecord    = record
           name           : userstring;
           alias          : userstring;
           password       : string[15];
           security       : word;
           attribute,
              (* Bit 0 : Deleted
                     1 : Clear Screen
                     2 : More Prompt
                     3 : Ansi Capable
                     4 : Don't Kill User
                     5 : File Points Ignore
                     6 : Full Screen Ed
                     7 : Quiet Mode        *)
           attribute2,
              (* Bit 0 : Ignore File Ratios
                     1 : Extended IBM Characters
                     2 : On = MMDDYY Off = DDMMYY
                     3 : Ignore Paging Hours
                     4 : Exclude User
                     5 : Avatar Capable
                     6 : Ignore Menu Time Restrictions
                     7 : Ignore Message Ratios         *)
           attribute3,
              (* Bit 0 : Do Not Sound Page
                     1 : Page on Logon
                     2 : Hold Mailbox
                     3 : Use Combined Mailbox
                   4-7 : [Reserved] *)
           attribute4  : byte;
              (* Bit 0-7 [Reserved] *)
           flags       : FlagType;
           dataphone,
           voicephone  : String[14];
     end;


    (* **********************************************************

       Filename:    <configrec.userbasepath>USERSEXT.BBS

       Description: Extended Users Information
                    Records in parrallel with USERS.BBS

       ********************************************************** *)


        usersextrarecord = record
           location       : string[25];
           lasttimedate   : longint;
              (* DOS Packed Date/Time *)
           credit,
              (* Users netmail credit *)
           pending        : word;
              (* Netmail cost pending export *)
           msgsposted,
           nocalls,
           uploads,
           todayk,
           timeused,
           downloads      : word;
           uploadsk,
           downloadsk     : longint;
           screenlength   : byte;
           lastpwdchange  : byte;
           timebanked,
           ksbanked,
           filepoints     : word;
           qwkcompression : byte;
           qwkdaysold     : byte;
           comment        : string[40]; (* Sysop/User Comment *)
           colour1_2,  (* To retrieve the first colour AND 15
                          To retrieve the second colour SHR 4  *)
           colour3_4,
           colour5_6,
           colour7_8,
           bkcolour        : byte;
           sessionfailures : byte; (* Number of Session Failures since last
                                      successful logon *)
           topmenu        : str8;  (* User's Top Menu *)
           filepointsgiven : word;
              (* Number of Filepoints credited since last logon *)
           dateofbirth    : daterecord;
           groups         : grouptype; (* user's group setting (compressed) *)
           regodate,                   (* Start of Registration *)
           firstdate,                  (* Date of First Logon *)
           lastfiledate   : word; (* Last Time a New Files Search was done *)
           defprotocol    : char; (* Blank means no default protocol *)
           timeleft       : word; (* Users remaining time for today *)
           filearea       : word; (* Last file area user used *)
           messarea       : word; (* Last message area user used *)
           qwkmaxmsgs     : word;
           qwkmaxmsgsperarea : word;
           todaybankwk    : integer; (* Kilobytes Withdrawn from Bank Today
                                        Negative Numbers indicate Deposited *)
           forwardto      : userstring; (* forward local mail to *)
           todaycalls     : byte; (* Times the user has called today *)
           todaybankwt    : integer; (* Time Withdrawn from Bank Today
                                        Negative Numbers indicate Deposited *)
                                     (* next byte in 1.03 will be language number *)
           extraspace     : array[1..userfree] of byte;
        end;

    (* **********************************************************

       Filename:     <userbasepath>LASTCOMB.BBS

       Description:  Used be Ezycom for lastread & combined info

       Note:         This record adjusts when the number of
                     conferences change (in steps of 16).
                     Eg: 16 conferences takes up HALF of the
                          diskspace of 32 conferences

       ********************************************************** *)

        userslastrecord = record (* LASTCOMB.BBS *)
           combinedinfo    : word;
           lastreadinfo    : array[0..15] of word;
        end;


    (* **********************************************************

       Filename:    <configrec.menupath>????????.MNU

       Description: Menu Structure
                    Record 0 has a different record structure

       Mimimum    : 1 record
       Maximum    : 51 records


       Record 0 Structure

       typ     = HiLight Colour
       display = Menu Prompt
       colour  = Menu Prompt Colour

       all others are undefined

       ********************************************************** *)


        mnurecord      = record (* *.MNU *)
           typ            : byte;
           security       : word;
           flags          : onoffflagtype;
           display        : string[90];
           hotkey         : char;
              (* Ctrl-A means Automatic Option *)
           miscdata       : string[90];
           colour         : byte;
           securityattr   : byte;
              (* 0 : Greater than/Equal to
                 1 : Greater than
                 2 : Less than/Equal to
                 3 : Less than
                 4 : Equal to
                 5 : Not Equal *)
           timeonline     : byte;
           timestart,
           timeend        : word;
              (* Hours is "* 100" *)
           baudrate       : longint;
           filepoints     : word;
           attribute      : byte;
              (* bit 0 : Test Ratio K
                     1 : Test Message/Call Ratio
                     2 : Test Age <config age> and Over
                     3 : Test Ratio Files
                     4 : Local Keyboard Only
                     5-7 [ Reserved ] *)
            node           : byte;
         end;

    (* **********************************************************

       Filename:    PROTOCOL.EZY

       Description: Protocol Record Structure

       Size       : 60 records

       ********************************************************** *)


        protocolrecord = record (* PROTOCOL.EZY *)
           name             : string[15];
           activekey        : char;
           attribute        : byte;
              (* bit 0 = enable/disable
                     1 = batch protocol
                     2 = [ Reserved ]
                     3 = both directions
                     4 = up/down
                     5 = bidirectional
                     6-7 [ Reserved ] *)
           logfilename,
           ctlfilename,
           dnctlstring      : string[60];
           dncmdstring,
           upcmdstring      : string[100];
           uplogkeyword,
           dnlogkeyword,
           uperrkeyword,
           dnerrkeyword,
           uperr2keyword,
           dnerr2keyword    : string[10];
           xfernamewordnum  : Byte;
           xfercpswordnum   : byte;
           security         : word;
           flags            : flagtype;
           efficiency       : byte;
        end;


     configrecord = record (* CONFIG.EZY *)
                     version      : str8;
                     deflanguage  : str8;
   (* unused *)      freespace50  : array[1..68] of byte;
                     logpath,
                     textpath,
                     menupath,
                     mnurampath,
                     netmailpath,
                     nodelistpath,
                     msgpath,
                     filepath,
   (* unused *)      freespace51,
                     bipath,
                     temppath,
                     userbasepath,
                     avatarpath,
                     ascpath,
                     asclowpath,
                     filemaint,
                     fileattachpath,
                     soundpath,
                     fastindexpath : string[60];
                     systempwd,                 (* Password to Logon System *)
                     sysoppwd,                  (* Password to Keyboard *)
                     newuserpwd   : string[15]; (* Password for Newuser *)
                     newtopmenu   : str8;       (* NewUser TopMenu *)
   (* unused *)      freespace52  : array[1..4] of byte;
                     inboundmail,
                     outboundmail,
                     uploadpath,
                     swapfile,
                     multipath    : string[60];
                     brackets     : string[2];
                     inactivitytime,
                     minmesscheck,
                     maxlogintime : byte;
   (* unused *)      freespace53  : byte;
                     answerdelay  : byte;
                     shellswap,
                     highbit,
                     disppass,
                     asklocalpass,
                     fastlogon,
                     sysopremote,
                     printerlog,
                     phone1ask,
                     colourask,
                     aliasask,
                     dobask,
                     phoneforce,
                     direct_video,
                     snow_check   : boolean;
   (* unused *)      freespace54  : byte;
                     screen_blank : byte;
                     oneword      : boolean;
                     checkmail,
                     checkfile,
                     ansiask,
                     fullscreenask,
                     clearask,
                     moreask,
                     avatarask,
                     extendask,
                     usdateask    : asktype;
                     phone2ask    : boolean;
                     phoneformat  : string[14];
                     nameprompt,
                     pwdprompt,
                     shellprompt,
                     shell2prompt,
                     enterprompt,
                     chatprompt,
                     listprompt   : string[60];
                     f7keylinetop,
                     f7keylinebot : string[79];
   (* unused *)      freespace55  : array[1..84] of byte;
                     chat2prompt,
                     screenlengthprompt, (* *)
                     screenclearprompt,  (* *)
                     locationprompt,
                     freeprompt,
                     loadprompt,
                     avatarprompt,       (* *)
                     aliasprompt  : string[60];
                     security,
                     logonsecurity : word;
                     flags         : flagtype;
                     minpasslength,
   (* Constant *)    dispfwind,                (* Status Bar Colour *)
   (* Constant *)    dispbwind,                (* Status Bar Colour *)
   (* Constant *)    disppopupf,               (* Popup Forground  *)
   (* Constant *)    disppopupborder,          (* Popup Border     *)
   (* Constant *)    disppopupb,               (* Popup Background *)
   (* Constant *)    dispf        : byte;      (* Foreground Colour *)
   (* Unused *)      freespace56,
                     comport,
                     passlogons   : byte;
                     doblogon     : byte;
                     printerport,
                        (* 0 : LPT1
                           1 : LPT2
                           2 : LPT3
                           3 : COM1
                           4 : COM2
                           5 : COM3
                           6 : COM4  *)
                     passtries      : byte;
                     topmenu        : string[8];
   (* unused *)      freespace100   : array[1..4] of byte;
   (* constant *)    watchmess,
   (* constant *)    netmailcredit,
                     ansiminbaud,
   (* unused *)      freespace57,
                     slowbaud,
                     minloginbaud   : word;
                     lowsecuritystart,
                     lowsecurityend,
                     slowstart,
                     slowend        : word;
                     quotestring    : string[5];
   (* unused *)      freespace58    : byte;
                     offhook        : boolean;
                     forcecrashmail,
                     optioncrashmail,
                     netmailfileattach : word;
   (* Constant *)    popuphighlight    : byte;     (* Popup Highlight Colour *)
   (* unused *)      freespace59       : byte;
                     maxpages,
                     maxpagefiles,
                     pagelength     : byte;
                     pagestart      : array[0..6] of word;
   (* constant *)    pagemessboard,
                        (* Message Board for Paging (0=Not In Use) *)
                     localfattachsec,
                     sectouploadmess,
                     sectoupdateusers,
                     readsecnewecho,
                     writesecnewecho,
                     sysopsecnewecho,
                     secreplyvianetmail : word;
                     netmailkillsent    : asktype;
                     swaponarchive      : byte;

   (* unused *)      freespace60    : array[1..9] of byte;

   (* Constant *)    popuptext      : byte;           (* Popup Text Colour *)
                     pageend        : array[0..6] of word;
   (* unused *)      freespace61    : array[1..22] of byte;
                     incomingcallstart,
                     incomingcallend : word;

                     fp_upload      : word; (* File Points Upload Credit *)

                     altf           : array[1..10] of string[60];
                     ctrlf          : array[1..10] of string[40];
   (* unused   *)    freespace63    : array[1..4] of byte;
                     fp_credit      : word; (* Newuser Filepoints *)
                     ks_per_fp,             (* Number of Kilobytes per FP *)
   (* unused *)      oldfp_upload,          (* Old Filepoints Upload Credit *)
                     rego_warn_1,
                     rego_warn_2    : byte;
   (* unused   *)    freespace64    : array[1..2] of byte;
   (* constant *)    min_space_1    : word;
                     swapbimodem    : boolean;
                     modembusy      : boolean; (* Toggle DTR or ATH1 *)
                     scrheight      : boolean; (* 43/50 line mode *)
                     msgtmptype     : boolean;
                        (* True  = MSGTMP
                           False = MSGTMP.<node> *)
                     swapupload     : boolean;
                     phonelogon     : byte;
                     carrierdetect  : byte; (* Carrier Detect (Default=$80) *)
                     newfileshighlight : boolean;
                     max_descrip    : byte;
                     min_descrip    : byte;
                     requestreceipt : word;
                     ushowdate      : boolean;
                     ufilesizek     : showfilesizetype;
                     uuploader,
                     udownloadcount,

   (* unused *)      freespace4,

                     ushowsecurity,
                     sshowdate      : boolean;
                     sfilesizek     : showfilesizetype;
                     suploader,
                     sdownloadcount,

   (* Unused *)      freespace5,

                     sshowsecurity,
                     ushowtime,
                     ushowfp,
                     sshowtime,
                     sshowfp         : boolean;
                     fp_percent      : word; (* Download Filepoints Credit *)
                     autodetect      : byte;
                        (* Bit 0 : Auto Detect ANSI
                               1 : ANSI Detect for NewUser
                               2 : Auto Detect IEMSI
                               3 : IEMSI Detect for NewUser
                               4-7 [Reserved] *)
                     dispsecurityfile,
                     askforpagereason,
                     delincompletefiles : boolean;
   (* unused *)      freespace65      : byte;
   (* Constant *)    swaponfeditview  : byte;

   (* Unused *)      freespace6,

                     secfileschar,
                     passchar        : char;
                     localinactivity : boolean;
   (* Unused *)      conversiononmaster : byte;
                     leftbracket     : string[1];
                     rightbracket    : string[1];
                     ignorefp        : word; (* Min Security to Ignore FPs *)
                     menuminage      : byte; (* Minimum Age for Age Checks *)
   (* unused *)      freespace66     : byte;
                     modemeff        : array[1..maxbaudrec] of word;
                     modembaud       : array[1..maxbaudrec] of word;
                     modemconnect    : array[1..maxbaudrec] of string[15];
   (* unused *)      freespace67     : array[1..10] of byte;
                     configattr      : word;
                        (* Bit  0 : Move Local Uploads
                               1-15 [Reserved] *)
                     usercol1_2,
                     usercol3_4,
                     usercol5_6,
                     usercol7_8,
                     userbkcol       : byte;
                     newusercol2     : byte;
                     chstatcol       : byte;
                     getentercol     : byte;
                     usdateforsysop  : boolean;
                     ezyovrpath      : string[60];
   (* Unused *)      sysfree3        : userstring;
                     ovrems          : boolean;
                     swapezy         : byte;
                     filesecpath     : string[60];
   (* unused *)      freespace28     : boolean;
                     multitasker     : byte;
                     (*  0 = Do Not Detect or Use Any MultiTasker
                         1 = Auto-Detect
                         2 = Desqview
                         3 = Double DOS
                         4 = OS 2
                         5 = MultiDOS Plus
                         6 = Taskview
                         7 = Topview
                         8 = PC MOS
                         9..255 [Reserved] *)
                     maxbaud         : word; (* longint in 1.02 *)
                     lockedport      : boolean;
                     filereqsec      : word;
                     autoanswer      : boolean;
                     initresponse    : string[10];
                     ringstring      : string[10];
                     inittries       : byte;
                     initstring1     : string[60];
                     initstring2     : string[60];
                     busystring      : string[20];
                     answerstring    : string[20];
                     mailerstring    : string[60];
                     modemstart      : word;
                     modemend        : word;
                     modemdelay      : byte;
                     sendbreak       : boolean;
                     externaleditor  : string[60];
                     defaultorigin   : string[50];
                     connectfax      : string[15];
   (* unused   *)    freespace22     : array[1..16] of byte;
                     uploadcredit    : word;
                        (* Upload Credit Percentage *)
   (* Unused *)      sysfree4        : string[35];
                     shownewfileschar : byte;
                        (* 0 - No
                           1 - ASCII Only
                           2 - Always *)
   (* unused *)      zonea            : array[1..16] of word;
                     neta             : array[1..16] of word;
                     nodea            : array[1..16] of word;
                     pointa           : array[1..16] of word;
   (* Unused   *)    freespace24     : array[1..16] of word;
   (* Unsued   *)    freespace9      : array[1..16] of string[20];
                     nocarrierstring : string[20];
                     guestaccount    : userstring;
                     freespace       : array[1..maxfree] of byte;
                  end;

        (* Note: Strings that are marked CONSTANT, should be constant
           across all CONFIG.XXX. *)

    (* **********************************************************

       Filename:    CONSTANT.EZY

       Description: Constant Configuration Information

       ********************************************************** *)

        constantrecord    = record
           version         : string[8];
           system          : string[40];
           sysopname,
           sysopalias      : userstring;
           systemlocation  : string[35];
           multiline       : boolean; (* multiline operation *)
           maxmess,                   (* maximum usable message areas *)
           maxfile,                   (* maximum usable file areas *)
           watchmess,                 (* watchdog message area *)
           pagemessboard,             (* paging message board *)
           badpwdmsgboard  : word;    (* bad logon message board *)
           mintimeforcall  : byte;    (* minimum time to register call today *)
           freespace2      : array[1..11] of byte;
           scantossattr,              (* ezymail scan/toss info *)
              (* Bit 0 : Dupe Detection
                     1 : Kill Null Netmail
                     2 : Keep EchoArea Node Receipts
                     3 : Import Messages to Sysop
                     4 : Route Mail (Off = Direct)
                     5 : Kill Bad Archives
                     6 : ArcMail 0.6 Compatability
                    7-15 [Reserved] *)
           constantattr,
              (* Bit 0 : Sysop Alias in Chat
                     1 : Auto Log Chat
                     2 : Display Full Message to User
                     3 : Do not delete outbound mail bundles with no .MSG
                    3-15 [Reserved] *)
           maxmsgsrescan   : word;    (* Maximum msgs to rescan (0=disable) *)
           qwkfilename     : str8;    (* Unique QWK Mail filename *)
           qwkmaxmail      : word;    (* Maximum Msgs for QWK archive *)
           qwkmsgboard     : word;    (* Bad QWK Message Board *)
           netaddress      : array[1..maxaka] of netrecord;
           netmailboard    : array[1..maxaka] of word;
           newareagroup    : array[1..maxaka] of char;
           newareastmess   : array[1..maxaka] of word;
                                        (* New area start msg board *)
           quotestring     : string[5]; (* quote messsage string *)
           swaponezymail   : byte;      (* ezymail swapping information *)
           unknownarea     : byte;      (* unknown new area tag action *)
              (* 0 : Kill Messages
                 1 : Make a New EchoMail Area
                 2 : Make a New PassThru Area *)
           swaponfeditview : byte;      (* FEdit swapping information *)
           swaponarchive   : byte;      (* Ezymaint swapping information *)
           minspaceupload  : word;      (* minimum space to upload *)
           textinputcolour : byte;      (* default text input colour *)
           badmsgboard     : word;      (* Bad echomail msg board *)
           freespace       : array[1..constantfreespace] of byte;
        end;

        compressrecord = record
           echounarccmd    : array[0..5] of String[12];
           echounarcpar    : array[0..5] of String[18];
           echoarccmd      : array[0..5] of String[12];
           echoarcpar      : array[0..5] of String[18];
        end;

        domainstr  = string[20];

        domaintype = array[1..maxaka] of domainstr;

        constantfilefreespacetype = array[1..constantfilefreespace] of byte;

const
        startofcompress = sizeof(constantrecord) + sizeof(constantfilefreespacetype);
        startofdomain   = startofcompress + sizeof(compressrecord);

type
        constantfilerecord = record
           constant  : constantrecord;
           freespace : constantfilefreespacetype;
           compress  : compressrecord;
           domain    : domaintype;
        end;

        limitsrecord = record (* LIMITS.EZY *)
           security     : word; (* Security level *)
           time         : word; (* Time limit per day *)
           limit        : array[1..maxbaudrec] of word;
           ratio        : byte; (* File Ratio *)
           credit       : word; (* File Ratio Credit *)
           ratiok       : byte; (* Kilobyte Ratio *)
           creditk      : word; (* Kilobyte Ratio Credit *)
           regodays     : word; (* Registration in Days *)
           creditmess   : word; (* PCR Credit *)
           mess         : word; (* PCR (%) *)
           timepercall  : word; (* Time limit per call   0=Disabled *)
           callsperday  : byte; (* Maximum Calls Per Day 0=Disabled *)
           maxbankwk,           (* Maximum Withdraw Kilobytes Bank *)
           maxbankwt,           (* Maximum Withdraw Time Bank *)
           maxbankdk,           (* Maximum Deposit Kilobytes Bank *)
           maxbankdt,           (* Maximum Deposit Time Bank *)
           maxkbank,            (* Maximum Allowable Kilobytes in Bank *)
           maxtbank     : word; (* Maximum Allowable Time in Bank *)
        end;

        filepathrecord = record (* FILEPATH.EZY *)
           filepath    : string[60];
           security    : word;
           flags       : flagtype;
           uploadarea  : word;
           password    : string[8];
           attribute   : byte;
              (* Bit 0 = CD Rom Path
                     1 = Show as Not Found
                     2 = Free Downloads
                     3 = Age Check
                     4-7 [Reserved] *)
        end;

        filesecrecord = record (* FILESEC.EZY *)
           filename    : string[12];
           security    : word;
           flags       : flagtype;
           password    : string[8];
           attribute   : byte;
             (*  Bit 0 = [Reserved]
                     1 = Show as Not Found
                     2 = Free Downloads
                     3 = Age Check
                     4-7 [Reserved] *)
        end;

        filelistrecord = record (* FILEXXX.EZY *)
           filename    : string[12];
           description : string[50];
           fsize       : longint;
           fdate       : word;
           attribute   : byte;
              (* Bit 0 : checked
                     1 : [Reserved]
                     2 : offline
                     3 : [Reserved]
                     4 : private
                     5 : deleted
                     6 : [Reserved]
                     7 : security *)
           attribute2  : byte;
              (* bit 0-7 [Reserved] *)
           uploader    : userstring;
           downloads   : word;
        end;

        filerecord = record (* FILES.EZY *)
           name        : string[30];
           attribute,
              (* bit 0 : keep files offline
                     1 : offline allowed
                     2 : sortby date
                     3 : sortby alpha
                     4 : master list
                     5 : Age Check to View
                     6-7 [ Reserved ] *)
           convert     : byte;
              (* 0     : none
                 1     : zip
                 2     : lzh
                 3     : arj
                 4     : pak
                 5     : arc
                 6     : zoo
                 7-255 : [ Reserved ] *)
           filegroup   : char;
           uptemplate,
           upfilepath  : word;

           freespace   : longint;

           security    : word;
           flags       : flagtype;
           syssecurity : word;
           sysflags    : flagtype;
        end;

        predownloadrecord = record (* EZYDOWN.<node> *)
           filename      : string[12];
           locationfile  : maxstr;
           fsize         : longint; (* KiloBytes *)
           freedown      : boolean;
           timetodown    : longint; (* Seconds *)
           deleted       : boolean;
        end;

        preuploadrecord = record  (* EZYUP.<node> *)
           filename      : string[12];
           description   : string[50];
           isdupe        : boolean;
        end;

        maint_record = record (* MAINT1.BBS, MAINT2.BBS *)
           filename      : string[12];
           filepoint     : word;
           downloader    : userstring;
           uploader      : userstring;
        end;

        fastpointerrecord = array[1..730] of longint; (* FFPTR.EZY *)

        fastindexrecord = record (* FFIDX.EZY *)
           name     : string[12];
           template : word;    (* Filearea 1 -> *)
           deleted  : boolean;
        end;

    (* **********************************************************

       Filename:     <multipath>ONLINE.BBS

       Description:  Used by Ezycom to store online information

       Minimum Size: 1 Record
       Maximum Size: 250 Records

       ********************************************************** *)

        onlinerecord   = record
           name     : userstring;
           alias    : userstring;
           status   : byte;
           (* 0 - Active
              1 - [Reserved]
              2 - Downloading
              3 - Uploading
              4 - BiModem
              5 - Message Browsing
              6 - Door
              7 - Chat with Sysop
              8 - Chat with Other Users Channel 000
              ...................................
            207 - Chat with Other Users Channel 199 (200 channels)
            208 - 252 [Reserved]
            253 - Node Not Active in Any Way
            254 - User Logging On
            255 - Waiting for Caller *)
           attribute : byte;
           (* Bit 0 - Quiet Do Not Disturb *)
           baud     : longint;
           location : string[25];
        end;

    (* **********************************************************

       Filename:     <multipath>MESSNODE.<node>

       Description:  Used by Ezycom for conferencing

       Minimum Size: 0 Records (Maybe not present!)
       Maximum Size: Unlimited

       Sharing:
            Writing: Denynone + WriteOnly
            Reading: Denyall + ReadWrite (Truncate after read)

       ********************************************************** *)

        multimessagerecord = record
            from           : userstring;
            fromnode       : word;
            message        : string[80];
            private        : boolean;
        end;

    (* **********************************************************

       Filename:     <userbase>BESTSTAT.BBS

       Description:  Used by Ezycom to store best user stats

       Minimum Size: 0 Records (Maybe not present!)
       Maximum Size: 200 Records

       ********************************************************** *)

        bestuserrecord     = record
           bestname       : array[1..7] of userstring;
           (* BestName[1] is for BestMessages
              BestName[2] is for BestCalls
              .....
              BestName[7] is for BestDownK *)
           bestmessages,
           bestcalls,
           bestups,
           bestdns,
           bestfps        : word;
           bestupk,
           bestdownk      : longint;
        end;

    (* **********************************************************

       Filename:     <msgpath>\AREA<<area-1>/4+1>\MSGH<area>.BBS

       Description:  Used by Ezycom to store message header

       ********************************************************** *)

        msghdrrecord   = record
           prevreply,
           nextreply      : word;
              (* 0 = No Reply Chain *)
           startposition,
              (* Physical Start Position in MSGT???.BBS *)
           messagelength  : longint;
             (* Message Length including Null Terminator *)
           destnet,
           orignet        : netrecord;
           cost           : word;
           msgattr,
              (*  Bit 0 : Deleted
                      1 : Netmail pending export
                      2 : [Reserved]
                      3 : Private
                      4 : Received
                      5 : Echomail pending export
                      6 : Locally generated msg
                      7 : Do not kill message *)
           netattr,
              (*  Bit 0 : Kill/sent
                      1 : Sent
                      2 : File Attach
                      3 : Crash
                      4 : File Req
                      5 : Request Receipt
                      6 : Audit Request
                      7 : Is a Return Receipt *)
           extattr   : byte;
              (*  Bit 0-7 [Reserved] *)
           posttimedate : longint;
              (* DOS Format Packed DateTime *)
           recvtimedate : longint;
              (* DOS Format Packed DateTime *)
           whoto,
           whofrom        : userstring;
           subject        : string[72];
        end;

    (* **********************************************************

       Filename:     <msgpath>\AREA<<area-1>/4+1>\MSGT<area>.BBS

       Description:  Used by Ezycom to store message text

       ********************************************************** *)

        (* Message Text

                Each text part of the message starts at 'startposition',
           and continues on until a NULL terminator is found, or end
           of file is reached (shouldn't happen, but just in case).  The
           message text length is limited by Turbo Pascal to 16 Meg
           in size.  Each message is contained of plain text, with 0x08D
           terminators for wrapped lines or 0x0D terminators for hard
           carriage returns.  No line of text should exceed 79 characters
           excluding the terminator *)

    (* **********************************************************

       Filename:     <msgpath>MSGFAST.BBS

       Description:  Used by Ezycom for mail checks

       ********************************************************** *)

        msgfastrecord  = record
           whoto     : longint;
              (* standard 32 Bit CRC on whoto in MSGH???.BBS
                 Username is CRCd in UPPERCASE, and does not
                 include null terminator or length byte *)
           msgboard  : word;
           msgnumber : word;
        end;

    (* **********************************************************

       Filename:     <msgpath>MSGEXPRT.BBS

       Description:  Used by Ezycom to tell EzyNet/EzyMail whether
                     an area needs scanning or not

       ********************************************************** *)

        needscanrecord = array[1..maxmess] of boolean;

    (* **********************************************************

       Filename:     <msgpath>MSGREPLY.BBS

       Description:  Used by MsgComp to tell it which
                     conference(s) need reply chain
                     linking

       ********************************************************** *)

        needreplytype   = array[1..maxmess] of boolean;

    (* **********************************************************

       Filename:     <msgpath>MSGCOUNT.BBS

       Description:  Used by Ezycom and Utilities for
                     message area counting.  You must lock
                     EACH two bytes, then update/read it,
                     then unlock it to update a message area
                     count.  Reading the number of records of
                     MSGHxxx.BBS gives the same effect as
                     reading the conferences count.

       ********************************************************** *)

        msgareacounttype = array[1..maxmess] of word;


    (* **********************************************************

       Filename:     <systempath>MESSAGES.EZY

       Description:  Used by Ezycom to store message areas

       Size:         1024 records

       ********************************************************** *)

        messagerecord  = record
           name           : string[30];
           areatag        : string[30];
           qwkname        : string[12];
           typ            : msgtype;
           msgkinds       : msgkindstype;
           attribute,
           (* Bit 0 : Allow Aliases
                  1 : Use Alias
                  2 : Use Alias, Ask for Aliases
                  3 : Test Age (use config age)
                  4 : Combined Area Access
                  5 : Local File attaches
                  6 : Keep Private Bit on Incoming EchoMail
                  7 : Security *)
           attribute2,
           (* Bit 0 : Show Seenby Lines
                  1 : Forced Mail Check
                  2 : Tiny Seenbys
                  3-4 [Reserved]
                  5 : Areafix Info Visible
                  6 : Initial Combined Area Access
                  7 : Do Not Use in Template *)
           attribute3     : byte;
           dayskill,
           recvkill       : byte;
           countkill,
           kilobytekill,
           readsecurity   : word;
           readflags      : flagtype;
           writesecurity  : word;
           writeflags     : flagtype;
           sysopsecurity  : word;
           sysopflags     : flagtype;
           originline     : string[50];
           originaddress  : byte;
           seenby         : array[1..maxaka div 8] of byte;
           areagroup,
           messgroup      : char;
           destnodes      : array[1..maxnodes div 8] of byte;
           (* Nodes  1 to  8 - DestNode[1]
              Nodes  9 to 16 - DestNode[2]
              Nodes 17 to 24 - DestNode[3]
              etc *)
           echomailfeed   : byte; (* 0=No Uplink *)
        end;

    (* **********************************************************

       Filename:     <systempath>ECHOMGR.EZY

       Description:  Used by Ezycom to store node information

       Size:         128 records

       ********************************************************** *)

        echomgrrecord = record
           destnet     : netrecord;
           redirectto  : byte;
           groups      : grouptype; (* compressed groups A thru Z *)
           compress    : byte;
           (* 0 : Compress to ZIP
              1 : Compress to LZH
              2 : Compress to ARJ
              3 : Compress to ARC
              4 : Compress to PAK
              5 : Compress to ZOO
              6 : Compress to SQZ *)
           attribute   : byte;
           (* Bit 0 : Node Active
                  1 : Crash Mail
                  2 : Hold Mail
                  3 : Can Create New Echos
                  4 : Add to Export on New Echo
                  5 : Can Delete/Rename Areas
                  6 : Direct Mail (Off=Routed Mail)
                  7 [Reserved] *)
           passwordto,
           passwordfr  : string[20];
           dayshold,
           sendpkttype : byte;
           (* 0 : Type 2
              1 : Type 2+
            2-255 [Reserved] *)
           maxpktsize,
           maxarcksize : word;
        end;


    (* **********************************************************

       Filename:     EVENTS.EZY (multinode file)

       Description:  Used by Ezycom to store event information

       Minimum Size: 1 record
       Maximum Size: 65000 records

       ********************************************************** *)


        eventrecord = record
           attribute   : byte;
              (* Bit 0 = Enabled *)
           starttime   : word;
              (* Hi  Bit = Hour
                 Low Bit = Min *)
           errorlevel  : byte;
           days        : byte;
              (* Bit 0 : Sunday
                     1 : Monday
                         ...
                     6 : Saturday
                     7 : [ Reserved ] *)
           lasttimerun : word;
        end;

    (* **********************************************************

       Filename:    <systempath>TODAY.BBS
                    <systempath>YESTER.BBS

       Description: Used by Ezycom to today's/yesterday's callers

       ********************************************************** *)

       ontodayrecord = record
          line        : byte;
          name        : userstring;
          alias       : userstring;
          location    : string[25];
          baudrate    : word;
          logontime   : word;
          logofftime  : word;
          didwhat     : byte;
          (* Bit 0 : (N) NewUser
                 1 : (U) Upload
                 2 : (D) Download
                 3 : (R) Read Mail
                 4 : (S) Sent Mail
                 5 : (O) Outside
                 6 : (C) Chat to Sysop and/or User
                 7 : (P) Paged *)
       end;

    (* **********************************************************

       Filename:    <systempath>TIME<node>.BBS

       Description: Used by Ezycom to store usage information

       ********************************************************** *)

       useagerecord  = record
          startdate      : word;
          busyperhour    : array[0..23] of longint; (* Minutes Used *)
          busyperday     : array[0..6]  of longint; (* Minutes Used *)
       end;

    (* **********************************************************

       Filename:    <systempath>MSGINFO.<node>

       Description: Used by Ezycom and EzyEdit to interface to
                    each other

       ********************************************************** *)

       fserecord      = record       (* MSGINFO.<node> *)
          whofrom      : userstring; (* User Who wrote message *)
          orignet      : netrecord;  (* From Net Address *)
          whoto        : userstring; (* User Who message is to *)
          destnet      : netrecord;  (* To Net Address *)
          subject      : string[72]; (* Subject of message *)
          returnstatus : byte;       (* Return Status *)
          (*   0 : FSE Record Not Used
               1 : Message Saved
               2 : Message Aborted
               3 : User  Inactivity
               4 : User  Hungup
               5 : Sysop Hungup
           6-255 : Reserved *)
          attribute    : byte;
          (*   Bit 0 : Can Change Subject
                   1 : Can Change Whoto
                   2 : Can Change Private
                   3 : Private Message
                   4 : Is Message Forwarded (False = Quoted)
                       (Providing MSGTMP.<node> exists)
                   5 : Netmail Message
                   6 : Avatar Capable (ANSI if not set)
                   7 : EchoMail Message *)
          baudrate,
          lockedbaud : longint;
          comport    : word;
          screenlength : byte;
          timeleft     : word;
       end;



    (* **********************************************************

       Filename:    <msgbasepath>MSGRSCAN.BBS

       Description: Used by EzyNet and EzyMail for Rescanning a
                    Message Area for a particular node

       ********************************************************** *)

       rescanrecord = record
          nodetorescan : byte;
          msgboard     : word;
       end;

    (* **********************************************************

       Filename:    <msgbasepath>MSGSTATS.BBS

       Description: Written by EzyMail for echomail statistics

       ********************************************************** *)

       msgstatsrecord = record
          tossedboard  : array[1..maxmessall]  of word;
             (* Number of Messages Tossed to Msg Board *)
          scannedboard : array[1..maxmessall]  of word;
             (* Number of Messages Tossed to Msg Board *)
          tossednode   : array[1..maxnodes] of longint;
             (* Number of Messages Tossed to EchoArea Node *)
       end;

    (* **********************************************************

       Filename:    <systempath>EXITINFO.<node>

       Description: Used by Ezycom in Type 15 exits to return
                    Used by Ezycom in Type 7 exits for door
                       information

       ********************************************************** *)

       exitinforecord = record
          baud           : word; (* Speed between Modem/Modem *)
          lockedbaud     : word; (* Speed between Computer/Modem *)
          comport        : byte; (* Comport 1 = Com1, etc *)
          efficiency     : word; (* Baud Rate efficiency *)
          userrecord     : word; (* User Record Number (0=User1) *)
          userinfo       : usersrecord;
          userextra      : usersextrarecord;
          extraspace     : array[1..320-sizeof(usersextrarecord)] of byte;
             (* this space will be used when the userextrarecord
                increases, thus keeping most utilities still
                compatiable with the exitinfo *)
          sysopname,             (* Sysop's Name *)
          sysopalias     : userstring;
          system         : string[40];
          downloadlimit  : word; (* Maximum Download Limit *)
          timelimit      : word; (* Daily Time Limit *)
          timetakenevent : word;
             (* Number of Minutes Taken from User for Event *)
          timecreated    : longint;
             (* Number of Seconds since Midnight *)
          timeofnextevent   : longint;
             (* Number of Seconds since Midnight *)
          timetillnextevent : longint;
             (* Number of Seconds after Time Created *)
          dayofnextevent : byte;
             (* 0 = Sunday
                ..........
                6 = Saturday
                7 = NOEVENT *)
          errorlevelofnextevent : byte;
             (* Errorlevel to return from next event *)
          ratio          : byte; (* File Ratio *)
          credit         : word; (* File Ratio Credit *)
          ratiok         : byte; (* Kilobyte Ratio *)
          creditk        : word; (* Kilobyte Ratio Credit *)
          regodays       : word; (* Registration Days *)
          creditmess     : word; (* Post Call Ratio Credit *)
          mess           : word; (* Post Call Ratio *)
          logintimedate  : datetime; (* Login Datetime *)
          stack          : array[1..20] of str8; (* Menu Stack *)
          stackpos       : byte; (* Menu Stack Position (0 = No Stack) *)
          curmenu        : str8; (* Current Menu *)
          oldpassword    : string[15];
          limitrecnum    : word; (* Limits Record Being Used *)
          baudrecnum     : byte; (* BaudRate Record Being Used *)
          freespace2     : char;
          maxpages       : byte; (* Maximum Pages *)
          pagedsysop     : byte; (* Number of Times User has Paged Sysop *)
          wantchat       : boolean;
          pagestart,
          pageend        : longint; (* Number of Seconds since Midnight *)
          pagelength     : byte; (* Page Length *)
          echoentered,
          netentered,
          nextsysop      : boolean;
          inactivitytime : word; (* Seconds *)
          protrecnum     : byte;
             (* Default Protocol Record Number 0=NoDefault *)
          protname       : string[15]; (* Default Protocol Name *)
          didwhat        : byte; (* Didwhat flag for Todays Callers *)
          pagereason     : string[60];
          mtasker        : byte;
          iemsi_session  : boolean;
          iemsi_req1,
             (* Bit 0 = News
                    1 = Mail
                    2 = File
                    3 = Clrscr
                    4 = Quiet
                    5 = More
                    6 = FSE
                    7 = [Reserved] *)
          iemsi_req2,
             (* Bit 0-7 = [Reserved] *)
          iemsi_scrlen   : byte;
             (* Screen Length for current session
                If NOIEMSI session, this is set to the
                   users screen length *)
          iemsi_prot,
             (* Bit 0 = ZModem
                    1 = SEAlink
                    2 = Kermit *)
          iemsi_crt,
             (* 0 = TTY
                1 = ANSI
                2 = AVT0+
                3 = VT100
                4 = VT52 *)
          iemsi_cap      : byte;
             (* Bit 0 = CHT
                    1 = MNU
                    2 = TAB
                    3 = ASCII8 *)
          pagesound      : boolean;
          freespace      : array[1..99] of byte;
       end;

       sysinforecord = record
          callcount      : longint;
          lastcaller     : userstring;
          filessizek     : longint; (* Updated by Ezyff -C *)
          newusers,
          newfiles,
          newmessages    : word;    (* Does NOT include Inbound Echomail *)
          lastalias      : userstring;
          laststarttime  : word;
          extraspace     : array[1..80] of byte;
       end;



const
    fnoinherit = 128;  {      No Interitence Flag }
    fdenyall   = 16;   {      These are MUTUALLY EXCLUSIVE!!!!   }
    fdenywrite = 32;   {      Only ONE of THESE SHOULD BE USED   }
    fdenynone  = 64;   {                                         }
    fdenyread  = 48;   {                                         }
    freadonly  = 0;               {     THESE ALSO!!!  }
    fwriteonly = 1;               {                    }
    freadwrite = 2;               {                    }

(*

*****************************
Sample PASCAL Source Code for
location of CONFIG, and
for date conversion.
*****************************

**************************
Returns True if file found
**************************

function find(path : maxstr) : boolean;

var
   srec : searchrec;

begin
   findfirst(path,anyfile,srec);
   if doserror = 0
      then find := true
      else find := false;
end;

****************************************************
Returns the path of where to find CONFIG

ie  findw("CONFIG") would return the path of where
it can be found.  An additionial FIND should be done
on the result, as there may not be a CONFIG in the
system dir.

itos(x : longint) is simply a function that returns
the number in a string format.

node is the variable containing the current node

systempath is the path where the environment variable
EZY points to.  If not present, it is the current
directory on start up.

****************************************************


function findw(s : maxstr) : maxstr;

begin
   if find(systempath + s + '.' + itos(node)) then
      findw := systempath + s + '.' + itos(node) else
      if find(s + '.EZY') then
         findw := s + '.EZY' else
            findw := systempath + s + '.EZY';
end;

***********************
Checks for a valid date
***********************

function checkdate(yy,mm,dd : word) : boolean;

const
   daysinmonth : array[1..12] of word =
      (31,29,31,30,31,30,31,31,30,31,30,31);

begin
   if (mm < 1) or (mm > 12) then
      begin
         checkdate := false;
         exit;
      end;
   if (dd < 1) or (dd > daysinmonth[mm]) then
      begin
         checkdate := false;
         exit;
      end;
   if (yy < 1900) then
      begin
         checkdate := false;
         exit;
      end;
   if ((yy mod 4 <> 0) and (dd = 29) and (mm=2)) then
      checkdate := false else
      checkdate := true;
end;

***********************
Converts a Date to Word
***********************

function datetoword(yy,mm,dd : word) : word;

var
   tofield        : word;
   tempbyte       : byte;

begin
   if not checkdate(yy,mm,dd) then
      begin
         datetoword := 65535;
         exit;
      end;
   tofield := dd - 1;
   tofield := tofield + ((mm - 1) shl 5);
   if (yy < 1980) or (yy > (1980 + 127)) then
      begin
         datetoword := 65535;
         exit;
      end;
   yy := yy - 1980;
   tofield := tofield + (yy shl 9);
   datetoword := tofield;
end;

***********************************
Converts a Word to a DATE

If date is ok then true is returned
***********************************

function wordtodate(temp : word;var yy,mm,dd : word) : boolean;

begin
   if (temp = 65535) then
      begin
         wordtodate := false;
         exit;
      end else
      wordtodate := true;
   dd   := temp and 31 + 1;
   temp := temp shr 5;
   mm   := temp and 15 + 1;
   temp := temp shr 4;
   yy   := (temp and 127) + 1980;
end;

*)
