{These are support routines to the mini-editor (file actions)}

PROCEDURE savefile;
(*****************************************************************************
saves the current mini editor text to a file
******************************************************************************)
VAR i:INTEGER;
LABEL loop;
BEGIN
    TextColor(LightGreen); TextBackGround(Black); clrscr;
    WRITELN('Save message text into a disk file');
    WRITELN;
    TextColor(LightCyan); WRITE('     Options:  ');
    TextColor(LightRed); WRITE('*    ');
    TextColor(Cyan); WRITELN(#26,' For directory of files');
    TextColor(LightRed); WRITE('               .    ');
    TextColor(Cyan); WRITELN(#26,' To change current directory');
    TextColor(LightRed); WRITE('             <esc>  ');
    TextColor(Cyan); WRITELN(#26,' To abort saving file and continue');
    TextColor(LightRed); WRITE('            <enter> ');
    TextColor(Cyan); WRITELN(#26,' To save message into "',sfn,'"');
    TextColor(LightRed); WRITE('               ?    ');
    TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
    TextColor(LightRed); WRITE('            _______ ');
    TextColor(Cyan); WRITELN(#26,' Or enter a different filename for message text');
loop:
    TextBackGround(Black);  WRITELN;
    TextColor(Yellow); WRITE('Enter filename to save message text (or other option) ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);
    c:=READKEY;
    WRITE(c);
    CASE c OF
    '?' : BEGIN                         {help}
              help_msg('edsave');
              clrscr;
              GOTO loop;
          END;
    '*' : BEGIN                         {file directory}
              disp_dir;
              GOTO loop
          END;
    '.' : BEGIN                         {change directory}
              chg_dir;
              GOTO loop
          END;
    #27 : BEGIN                         {abort - no action}
              dr_frame;
              dr_page;                  {redraw screen}
              exit
          END;
    ^M  : ;                             {no action}
    ELSE  BEGIN
              sfn:=get_fn(c);           {filename entered, so use it}
              WRITELN
          END;
    END; {case}

    ASSIGN(io_file,sfn);                {existing file check ...}
    {$I-} RESET(io_file); {$I+}         {open file for reading}
    err:=IORESULT;
    IF err=0 THEN BEGIN
        WRITELN; TextColor(lightMagenta);
        WRITELN('File already exists.');  TextColor(Yellow);
        WRITE('  Do you want to overwrite current file, ',sfn,'?');
        c:=READKEY; WRITELN;
        IF NOT (c IN ['y','Y']) THEN GOTO loop;
        CLOSE(io_file)
    END;

    {$I-} REWRITE(io_file); {$I+}       {open file for writing}
    err:=IORESULT;
    IF err <> 0 THEN BEGIN
        WRITELN; TextColor(LightMagenta+Blink);
        WRITELN('ERR #',err,':  Problem opening output file!');
        beep; TextColor(Cyan);
        WRITE('Strike any key to continue ...');
        c:=READKEY
    END ELSE BEGIN
        WRITE('Saving message to file ',sfn,' ... ');
        FOR i:=1 TO last_ln+1 DO          {write ed_text to file}
            WRITELN(io_file,ed_text[i]);
        WRITELN('done!');
        CLOSE(io_file)
    END;
    dr_frame; dr_page                   {redraw screen}
END; {PROCEDURE savefile}

PROCEDURE readfile(dsp_menu:BOOLEAN);
(*****************************************************************************
reads an file into the mini editor - searches for file along path!
******************************************************************************)
VAR org_ln:INTEGER;
    found,stop_msg:BOOLEAN;
LABEL loop;
BEGIN
    IF dsp_menu THEN BEGIN
        TextColor(LightGreen); TextBackGround(Black); clrscr;
        WRITELN('Read (insert) disk file into message');
        WRITELN; TextColor(LightCyan);
        WRITE('     Options:  ');
        TextColor(LightRed); WRITE('*    ');
        TextColor(Cyan); WRITELN(#26,' For directory of files');
        TextColor(LightRed); WRITE('               .    ');
        TextColor(Cyan); WRITELN(#26,' To change to different directory');
        TextColor(LightRed); WRITE('             <esc>  ');
        TextColor(Cyan); WRITELN(#26,' To abort reading file and return to editor');
        TextColor(LightRed); WRITE('            <enter> ');
        TextColor(Cyan); WRITELN(#26,' To read message from "',rfn,'"');
        TextColor(LightRed); WRITE('               ?   ');
        TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
        TextColor(LightRed); WRITE('            _______ ');
        TextColor(Cyan); WRITELN(#26,' Or enter a different filename to read text from');
        WRITELN;
        WRITELN('Note:  file will be inserted starting at current line of the message;');
        WRITELN('       any subsequent text will be overwritten by the inserted file.');
loop:
        WRITELN;
        TextColor(Yellow); WRITE('Enter filename to insert into message (or other option) ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);
        c:=READKEY;
        WRITE(c);
        CASE c OF
        '?' : BEGIN                         {help}
                  help_msg('edread');
                  clrscr;
                  GOTO loop;
              END;
        '*' : BEGIN                         {file directory}
                  disp_dir;
                  GOTO loop
              END;
        '.' : BEGIN                         {change directory}
                  chg_dir;
                  GOTO loop
              END;
        #27 : BEGIN                         {abort - no action}
                  dr_frame;
                  dr_page;                  {redraw screen}
                  exit
              END;
        ^M  : ;                             {no action}
        ELSE  BEGIN
                  rfn:=get_fn(c);           {filename entered, so use it}
                  WRITELN;
              END;
        END; {case}
    END; {if skip_menu}

    org_ln:=ln;
    WRITELN; TextColor(Cyan);
    stop_msg:=FALSE;
    IF not open_fn(rfn) THEN BEGIN         {open given file}
        beep; TextColor(LightMagenta+Blink);
        WRITELN('File: ',rfn,' not found!  ');
        stop_msg:=TRUE
    END ELSE BEGIN
        WRITELN('Reading input file ... ');
        cc:=1; tmpstr:='';
        WHILE (NOT EOF(io_file)) AND (ln<=Max_Ed_Lines) DO BEGIN
            TextColor(Cyan); WRITE(^M'reading line ',ln);
            tmpstr:=get_line;
            IF tmpstr[1]<>'.' THEN BEGIN     {don't save dot commands}
                IF wrapper>0 THEN BEGIN
                    WRITELN(^M^J'Splitting Line ',ln:2,' into two lines:');
                    WRITELN(' -> ',ed_text[ln],^M^J);
                    ln:=ln+1;
                    stop_msg:=TRUE
                END;
                ln:=ln+1
            END
        END; {while}
        IF last_ln<ln-1 THEN last_ln:=ln-1;
        CLOSE(io_file)
    END;
    IF ln>Max_Ed_Lines THEN BEGIN
        beep;
        WRITELN; TextColor(LightMagenta+blink);
        WRITELN('Note, input file had more lines than editor had available.');
        WRITELN('Input file was truncated!');
        stop_msg:=TRUE
    END;
    IF stop_msg THEN BEGIN
        WRITELN; TextColor(Yellow);
        WRITE('Strike any key to continue ... ');
        c:=READKEY
    END;
    ln:=org_ln; cc:=1;
END; {PROCEDURE readfile(dsp_menu:BOOLEAN)}
