%TITLE 'ZEN 1.9  by Martin J. Tracy'
;
;    ZEN 1.9
;    Main program
;
; Martin J. Tracy   8/7/89
; Copyright 1989    All rights reserved
;
; ANS X3J14 Standard Documentation
;   See ANSFORTH.DOC
;
; IBM MS-DOS small-model ROM-able Forth
;
;   BX register is top-of-stack.
;   Direct-Threaded Code (DTC) with JMP in code field.
;
; Listing Attributes
;
%MACS
%PAGESIZE  58,70
%BIN  10
%TEXT 50
;
; Parameters
;
Dictionary_Size   EQU 0FFF0h  ; Dictionary size in bytes
Table_Area_Size   EQU  2000h  ; Table size in bytes
Array_Area_Size   EQU 0D400h  ; Variable size in bytes

Data_Stack_Size   EQU 300h    ; Data stack size in words
Return_Stack_Size EQU 300h    ; Return stack size in words
;
; Groups
;
DGROUP  GROUP CONST, _BSS, STACK
ASSUME  CS:_TEXT, SS:DGROUP, DS:DGROUP
;
; Data segments
;
CONST   SEGMENT WORD PUBLIC 'DATA'
; Constant variables and tables go here
TORG:
INCLUDE TBL.INC
TP0     db    (Table_Area_Size-($-TORG)) DUP (?)
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'DATA'
; Uninitialized variables go here
VORG:
INCLUDE VAR.INC
VP0     db    (Array_Area_Size-($-VORG)) DUP (?)
_BSS    ENDS

STACK   SEGMENT PARA STACK 'STACK'
        dw    (Data_Stack_Size)     DUP (?)
SP0     dw    (Return_Stack_Size-2) DUP (?)
RP0     dw    ?
STACK   ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'
DORG:
INCLUDE INTERNAL.INC     ; macros and internals
INCLUDE CONTROL.INC      ; flow of control
INCLUDE STACKMEM.INC     ; stack and memory operators
INCLUDE LOGIMATH.INC     ; logic and math operators
INCLUDE STRINGS.INC      ; string operators
INCLUDE DEVICE.INC       ; device drivers
INCLUDE INPUTOUT.INC     ; I/O
INCLUDE INTRPRET.INC     ; Interpreter
INCLUDE COMPILER.INC     ; Compiler
INCLUDE STRINGS2.INC     ; Supplementary strings
INCLUDE FILES.INC        ; File system
INCLUDE FINALE.INC       ; Initialization
DP0     db    (Dictionary_Size-($-DORG)) DUP (?)
_TEXT ENDS
END     ColdStart
