/* sw_lib.c - respondfiles for the Microsoft librarian.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_lib.c'v 0.9 90/09/09 21:43:58 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <io.h>

#include "swaplib.h"


/* Build a respondfile for the Microsoft library manager from ARGV.
   We also correct for some lossage in Microsoft's syntax:  A module
   without command  inherits the one of it's predecessor.  This allows
   constructions like `lib foo.lib -+ $?' in makefiles.
   (idea stolen from Kneller's `ndmake').  */

int
_swap_build_lib_respond_file (char **argv, char **envv)
{
  FILE *respond_file;
  char *libname;
  char lib_action[3];
  int col = 0;

  _swap_respond_file_name = swap_back_slashify (swap_mktmpname ("lb"));

  respond_file = fopen (_swap_respond_file_name, "w");
  if (!respond_file)
    {
      int last_errno = errno;
      fprintf (stderr, "can't open lib respond_file: ");
      errno = last_errno;
      perror (_swap_respond_file_name);
      return -1;
    }


  argv++;

  /* Create the first line.  */

  /* Handle possible leading options.  */
  while ((*argv)[0] == '/')
    fprintf (respond_file, "%s ", *argv++);

  /* The next item *must* be the lib file.  */
  libname = *argv++;
  fprintf (respond_file, "%s ", libname);

  /* Handle possible trailing options.  */
  while ((*argv)[0] == '/')
    fprintf (respond_file, "%s ", *argv++);

  fprintf (respond_file, "\n");


  /* We now have to test for the existence of the library, since
     lib wants an additional affirmative `y' if not.  */

  if (access (libname, 0))
    {
      /* The library doesn't seem to exist */

      char *base = swap_basename (libname);

      if (strcmp (base, "lib") != 0)
	{
	  /* Try to append the extension ".lib" ... */

	  char *full_libname = (char *) malloc (strlen (libname) + 5);
	  strcat (strcpy (full_libname, libname), ".lib");

	  if (access (full_libname, 0))
	    /* It's really not there: instruct `lib' to create it.  */
	    fprintf (respond_file, "y\n");

	  free (full_libname);
	}
    }


  /* Default action: replace module.  */

  strcpy (lib_action, "-+");


  /* Loop over the remaining arguments.  */

  while (*argv)
    {
      char *p = *argv;
      char *cp;


      if (*p && strchr ("+-*", *p))
	{
	  /* Handle a possible library action.  */

	  lib_action[0] = *p++;

	  if (*p && strchr ("+-*", *p))
	    lib_action[1] = *p++;
	  else
	    lib_action[1] = '\0';

	  /* lib_action[2] is always '\0'. */
	}


      if (*p)
	{
	  /* Handle a module name.  */

	  if (strlen (p) + col > 50)
	    {
	      /* Break the line.  */

	      fprintf (respond_file, "&\n");
	      col = 0;
	    }

	  /* Print out the action, but avoid a trailing one.  */

	  if (!strchr (",;", *p))
	    col += fprintf (respond_file, "%s", lib_action);

	  while (cp = strchr (p, ','))
	    {
	      /* Break the line at a new group of responses.  */

	      *cp = '\n';

	      /* No more line breaks or actions. */
	      col = 0;
	      lib_action[0] = '\0';
	    }

	  col += fprintf (respond_file, "%s ", p);
	}

      argv++;
    }

  fprintf (respond_file, "\n\n\n");	/* avoid prompts! */
  fclose (respond_file);

  sprintf (_swap_cmdline_buf, "/nologo @%s", _swap_respond_file_name);
  return _swap_format_msdos_environment (NULL, envv, NULL);
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
