/* sw_msc.c - commandlines for Microsoft compilers.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_msc.c'v 0.9 90/09/09 21:44:04 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);


int
_swap_build_msc_environment (char *prefix, char **argv, char **envv)
{
  char **av;
  char *p;
  char *buf;
  int len;

  /* How long are we? */

  len = strlen (prefix) + 1;
  for (av = argv + 1; *av; av++)
    len += strlen (*av) + 1;

  p = buf = (char *) xmalloc (len);

  /* paste arguments together */

  strcpy (p, prefix);
  p += strlen (prefix);

  for (av = argv + 1; *av; av++)
    {
      *p++ = ' ';
      strcpy (p, *av);
      p += strlen (*av);
    }

  return _swap_format_msdos_environment (NULL, envv, buf, NULL);
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
