/* sw_shell.c - maybe invoke a shell to execute a script.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_shell.c'v 0.9 90/09/09 21:44:10 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);

char *
swap_invoke_shell (char *cmd, char ***argvp)
{
  char *p = NULL;
  char *suffix;
  char *dash_c = "";

  if (!cmd || !argvp)
    return NULL;

  suffix = strrchr (cmd, '.');

  if (!suffix)
    /* Strange..., let the caller handle this!  (Later we might
       want to support the `#!' construction.)  */
    return NULL;
  else
    suffix++;

  if (strcmp (suffix, "bat") == 0)
    {
      p = getenv ("COMSPEC");
      dash_c = "/c";
      swap_back_slashify (cmd);
    }
  else if (strcmp (suffix, "sh") == 0)
    {
      p = getenv ("SHELL");
      dash_c = "-c";
    }

  if (p)
    {
      int i;
      int argc = 0;
      char **ap = *argvp;

      char **argv;
      char *shell = (char *) xmalloc (strlen (p) + 1);

      strcpy (shell, p);

      while (*ap++)
	argc++;

      argv = (char **) xmalloc ((argc + 3) * sizeof (char *));

      /*  Shift right by two.  */
      for (i = 1; i < argc; i ++)
	argv[i + 2] = (*argvp)[i];

      /* Leave ARGV[0] intact, but insert the script's name
	 into the arguments.  */

      argv[0] = (*argvp)[0];
      argv[1] = (char *) xmalloc (3);
      strcpy (argv[1], dash_c);
      argv[2] = cmd;
      argv[argc + 2] = NULL;

      *argvp = argv;

      return shell;
    }
  else
    return NULL;
}


/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
