/* testswap.c - test swaplib.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/testswap.c'v 0.9 90/09/09 21:44:25 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>

#include "swaplib.h"

#define VERBOSE_CMD(cmd)		\
  printf ("Executing: %s...\n", #cmd);	\
  if ((cmd) == -1)			\
    {					\
      perror ("failed");		\
      exit (2);				\
    }

#define VERBOSE_PIPE(cmd, pipe)			\
  printf ("Opening pipe: %s...\n", #cmd);	\
  pipe = cmd;					\
  if (!pipe)					\
    {						\
      perror ("failed");			\
      exit (2);					\
    }


void *xmalloc (size_t size);
void *xrealloc (void *ptr, size_t size);
extern void main (int ac, char **av);

void *
xmalloc (size_t size)
{
  void *result = malloc (size);
  if (result == NULL)
    {
      fprintf (stderr, "memory exhausted");
      abort ();
    }
  return result;
}

void *
xrealloc (void *ptr, size_t size)
{
  void *result = realloc (ptr, size);
  if (result == NULL)
    {
      fprintf (stderr, "memory exhausted");
      abort ();
    }
  return result;
}

void
main (int argc, char **argv)
{
  if (argc < 2)
    fprintf (stderr, "usage: testswap cmd [args]\n");
  else
    {
      FILE *dir;
      FILE *sort;
      char buf[256];

      char *envv[2];

      envv[0] = "This = a test!";
      envv[1] = NULL;

      printf ("Exporting the environment \"%s\"\n", envv[0]);
      VERBOSE_CMD (swap_spawnlpe ("command", "command", "/c",
				  "set", NULL, envv));

      VERBOSE_CMD (swap_spawnvp (argv[1], argv + 1));

      VERBOSE_PIPE (swap_popen ("dir", "r"), dir);

      VERBOSE_PIPE (swap_popen ("sort", "w"), sort);

      while (fgets (buf, 255, dir))
	{
	  printf ("dir:  %s", buf);
	  fprintf (sort, "sort: %s", buf);
	}

      printf ("Closing the `dir' pipe...\n");
      printf ("return code %d.\n", swap_pclose (dir));

      printf ("The `sort' pipe will be closed `atexit'...\n");
    }
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
