# twovar.plt - example of plotting a function with two variables
#
# gcd(x,y) finds the greatest common divisor of x and y,
#          using Euclid's algorithm
# as this is defined only for integers, first round to the nearest integer

paper size 11 by 8.5

min(x,y) = (x < y) ? x : y
max(x,y) = (x > y) ? x : y

gcd(x,y) = gcd1(rnd(max(x,y)),rnd(min(x,y)))
gcd1(x,y) = (y == 0) ? x : gcd1(y, x - x/y * y)
rnd(x) = int(x+0.5)

sampling 59
map x 1,59
format x 0 y 0
divi x 6,2

color red
plot gcd(x, 60)

color green
map x 0 60
draw x y
ylabel 'Greatest Common Divisor'

color lblue
char font 3 size 0.2 slant 10
title 'Example of a Two-Variable Function'
