/*****************************************************************************
*   Local definitions of the EELibs?.c modules.				     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Oct. 1989    *
*****************************************************************************/

#ifndef EELIBSL_H
#define EELIBSL_H

#define PART_NAME_LEN	15		     /* Maximum length of part name. */
#define PREFIX_NAME_LEN	5      /* Maximum length of prefix (IC, R, SW etc.). */
#define PIN_SEPERATOR	"\n"		  /* See Pins in LibraryEntryStruct. */
#define FILE_IDENT	"EEDRAW-LIB"	   /* Must be at the lib file start. */
#define PIN_WIDTH	96		  /* Width between 2 pins in pixels. */
#define PIN_LENGTH	192		  /* Length of each pin to be drawn. */
/* Between height and width of chip (for pin desc. text inside/outside).     */
#define CHIP_BOX_ASPECT_TO 0.4
#define CHIP_BOX_ASPECT_TI 0.7
#define INVERT_PIN_RADIUS LIB_SCALE_DRAW   /* Radius of inverted pin circle. */

/* THe width/height of one character in drawing space: */
#define DRAW_TEXT_WIDTH  (8 << IG_DEFAULT_ZOOM_FACTOR)
#define DRAW_TEXT_HEIGHT  (8 << IG_DEFAULT_ZOOM_FACTOR)

/* Normalize angle to be in the 0..360 range: */
#define	NORMALIZE_ANGLE(Angle)	{ while (Angle < 0) Angle += 360; \
				  while (Angle > 360) Angle -= 360; }

typedef enum {
    ARC_DRAW_TYPE,
    CIRCLE_DRAW_TYPE,
    TEXT_DRAW_TYPE,
    SQUARE_DRAW_TYPE,
    LINE_DRAW_TYPE,
    POLYLINE_DRAW_TYPE
} LibDrawStructType;

typedef struct LibraryDrawArc {
    int x, y, r, t1, t2;
} LibraryDrawArc;
typedef struct LibraryDrawCircle {
    int x, y, r;
} LibraryDrawCircle;
typedef struct LibraryDrawText {
    TextOrientationType Horiz;
    int x, y;
    char *Text;
} LibraryDrawText;
typedef struct LibraryDrawSquare {
    int x1, y1, x2, y2;
} LibraryDrawSquare;
typedef struct LibraryDrawLine {
    int x1, y1, x2, y2;
    BooleanType Invert;
} LibraryDrawLine;
typedef struct LibraryDrawPolyline {
    int n, *PolyList;
    BooleanType Fill;
} LibraryDrawPolyline;

typedef struct LibraryDrawEntryStruct {
    LibDrawStructType DrawType;
    char Layer;
    union {
	LibraryDrawArc Arc;
	LibraryDrawCircle Circ;
	LibraryDrawText Text;
	LibraryDrawSquare Sqr;
	LibraryDrawLine Line;
	LibraryDrawPolyline Poly;
    } U;
    struct LibraryDrawEntryStruct *Pnext;
} LibraryDrawEntryStruct;

typedef struct LibraryEntryStruct {
    char Name[PART_NAME_LEN + 1];			       /* Part name. */
    char Prefix[PREFIX_NAME_LEN + 1];
    int NumOfPins, NumOfUnits, PinsPerUnit;
    BooleanType TextInside, DrawNums, DrawName;
    char *Pins;		       /* All pin names, seperated by PIN_SEPERATOR. */
    LibraryDrawEntryStruct *Drawings;		   /* How to draw this part. */
    int *Multi;		       /* Hold MULTI/ENDMULTI block as linear array. */
    int BBoxMinX, BBoxMaxX, BBoxMinY, BBoxMaxY;     /* BBox around the part. */
} LibraryEntryStruct;

extern LibraryStruct *LibraryList;	    /* All part libs are saved here. */

/* Functions common to all EELibs?.c modules: */
int LibraryEntryCompare(LibraryEntryStruct *LE1,
			LibraryEntryStruct *LE2);

#endif EELIBSL_H
