/*****************************************************************************
*   Program to draw EE diagrams.					     *
*									     *
* This module redraw/draw all structs.					     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Oct. 1989    *
*****************************************************************************/
#include <stdio.h>	/* needed for eelayer.h, it uses FILES */
#include "program.h"
#include "igraph.h"
#include "EELayer.h"
#include "eeredraw.h"
#include "eestring.h"

static void RedrawStructList(DrawGenericStruct *Structs);
static void RedrawOneStruct(DrawGenericStruct *Struct);
static void RedrawPolylineStruct(DrawPolylineStruct *Struct);
static void RedrawConnectionStruct(DrawConnectionStruct *Struct);
static void RedrawTextStruct(DrawTextStruct *Struct);

/*****************************************************************************
* Routine to redraw all screen. A list of all active structs is provided.    *
*****************************************************************************/
void RedrawAllScreen(void)
{
    RedrawStructList(EEDrawList);
}

/*****************************************************************************
* Routine to redraw list of structs.					     *
* If the list is of DrawPickStruct types then the picked item are drawn.     *
*****************************************************************************/
static void RedrawStructList(DrawGenericStruct *Structs)
{
    while (Structs) {
	RedrawOneStruct(Structs);
	Structs = Structs -> Pnext;
    }
}

/*****************************************************************************
* Routine to redraw list of structs.					     *
*****************************************************************************/
static void RedrawOneStruct(DrawGenericStruct *Struct)
{
    switch (Struct -> StructType)
    {
	case DRAW_POLYLINE_STRUCT_TYPE:
	    RedrawPolylineStruct((DrawPolylineStruct *) Struct);
	    break;
	case DRAW_CONNECTION_STRUCT_TYPE:
	    RedrawConnectionStruct((DrawConnectionStruct *) Struct);
	    break;
	case DRAW_TEXT_STRUCT_TYPE:
	    RedrawTextStruct((DrawTextStruct *) Struct);
	    break;
	case DRAW_LIB_ITEM_STRUCT_TYPE:
	    DrawLibPart((DrawLibItemStruct *) Struct);
	    break;
    }
}

/*****************************************************************************
* Routine to redraw polyline struct.					     *
* Note wide lines are corrent for horizontal/vertical lines only.	     *
*****************************************************************************/
static void RedrawPolylineStruct(DrawPolylineStruct *Struct)
{
    int i, j, x, y;

    if(!ReturnLayerMode(Struct->Layer))
	return;
    if (Struct -> Width == NORM_WIDTH) {
	IGMoveTo(Struct -> Points[0], Struct -> Points[1]);
	for (i = 1; i < Struct -> NumOfPoints; i++)
	    IGLineTo(Struct -> Points[i * 2], Struct -> Points[i * 2 + 1]);
    }
    else {
	for (i = 1; i < Struct -> NumOfPoints; i++) {
	    x = Struct -> Points[(i - 1) * 2];
	    y = Struct -> Points[(i - 1) * 2 + 1];
	    if (x == Struct -> Points[i * 2]) {  /* Same X value (Vertical). */
		for (j = -1; j <= 1; j++)
		    IGLineNoMap(IGMapX(x) + j,
				IGMapY(y),
				IGMapX(Struct -> Points[i * 2]) + j,
				IGMapY(Struct -> Points[i * 2 + 1]));
	    }
	    else {		        /* Assume same Y Value (Horizontal). */
		for (j = -1; j <= 1; j++)
		    IGLineNoMap(IGMapX(x),
				IGMapY(y) + j,
				IGMapX(Struct -> Points[i * 2]),
				IGMapY(Struct -> Points[i * 2 + 1]) + j);
	    }
	}
    }
}

/*****************************************************************************
* Routine to redraw connection struct.					     *
*****************************************************************************/
static void RedrawConnectionStruct(DrawConnectionStruct *Struct)
{
    int Width = DEFAULT_SNAP_DISTANCE / 2;
    if(!ReturnLayerMode(Struct->Layer))
	return;
    IGBar(Struct -> PosX - Width, Struct -> PosY - Width,
	  Struct -> PosX + Width, Struct -> PosY + Width);
}

/*****************************************************************************
* Routine to redraw text struct.					     *
*****************************************************************************/
static void RedrawTextStruct(DrawTextStruct *Struct)
{
    if(!ReturnLayerMode(Struct->Layer))
	return;
    PutTextInfo(Struct -> Orient, Struct -> PosX, Struct -> PosY,
				       Struct -> Scale,	Struct -> Text);
}
