/*
 * EGA.C -- A collection of EGA screen manipulation routines, as used
 *          by A2I.
 */

/* INCLUDES */

#include <stdio.h>
#include <alloc.h>
#include <dir.h>
#include <mem.h>
#include <string.h>

#include "ega.h"




/* GLOBALS */

volatile UBYTE __modereg, __setres , __esetres,
	       __readmap, __bitmask, __mapmask;




/* FUNCTIONS */

void mode(WORD vmode)
{
 _AH = 0;
 _AL = (UBYTE)vmode;

 geninterrupt(0x10);
}



void cls(UWORD page)
{
 UWORD addr;
 UBYTE i = 0x01;
 int   __mm = __mapmask;


 addr = (page&7)*0x2000;

 do
  {
  mapmask(i);
  bitmask(0xFF);
  clrgwin(addr, 0x00, 40, 200);

  i<<=1;
  } while(i<0x10);

 mapmask(__mm);
}



void init_egfx(UBYTE vmode)
{
 __modereg = 0x00;
 __setres  = 0x00;
 __esetres = 0x00;
 __readmap = 0x00;
 __bitmask = 0x00;
 __mapmask = 0x00;

 mode(vmode);
}



void save_pcx(const char *fname, UBYTE far *pal)
{
 FILE  *fp;
 UBYTE  ch, old_ch, red, green, blue, color;
 int    i, j, k, add1, add2, number, num_out, line_length, end;
 int    start_line, end_line;


 if((fp=fopen(fname, "wb"))==NULL)
  {
  printf("\nUnable to open file %s.\n", fname);
  return;
  }

 fputc(0x0A, fp);
 fputc(0x05, fp);
 fputc(0x01, fp);
 fputc(0x01, fp);

 putw(  0, fp);
 putw(  0, fp);
 putw(319, fp);
 putw(199, fp);

 putw(320, fp);
 putw(200, fp);

 ch = 0x00;

 for(i=0;i<16;i++)
  {
  color = *(pal+i);
  red   = (((color & 0x20)>>5) | ((color & 0x04)>>1)) * 85;
  green = (((color & 0x10)>>4) |  (color & 0x02)    ) * 85;
  blue  = (((color & 0x08)>>3) | ((color & 0x01)<<1)) * 85;

  fputc(red  , fp);
  fputc(green, fp);
  fputc(blue , fp);
  }

 fputc(0x00, fp);
 fputc(0x04, fp);

 start_line  = 0;
 end_line    = 319/8 + 1;
 line_length = end_line;
 end         = start_line + line_length*4 + 1;

 putw(line_length, fp);

 putw(0x01, fp);

 for(i=70;i<128;i++)
  fputc(0x00, fp);

 for(k=0;k<199;k++)
  {
  add1 = 40*k;
  number = 1;
  j = 0;
  add2 = start_line;
  old_ch = rd_byte(add1+(add2++), 0);

  for(i=add2;i<end;i++)
   {
   if(i==end-1)
    ch = old_ch-1;
   else
    {
    if((add2)==end_line)
     {
     j++;
     add2 = start_line;
     }
    ch = rd_byte(add1 + add2, j);
    }
   if((ch==old_ch) && number < 63)
    number++;
   else
    {
    num_out = ((UBYTE)number | 0xC0);
    if((number != 1) || ((old_ch&0xC0)==0xC0))
     fputc(num_out, fp);
    fputc(old_ch, fp);
    old_ch = ch;
    number = 1;
    }
   add2++;
   }
  }
 fclose(fp);
}



int fload_pcx(int page, const char *file_name)
{
 FILE  *fsave;
 UBYTE  ch, ch1;
 int    line_end, i, j, k, m, pass, x1, y1, x2, y2;
 UBYTE  __bm = __bitmask, __mr = __modereg, __mm = __mapmask;
 UBYTE  __rm = __readmap, __er = __esetres, __sr = __setres;


 if((fsave = fopen(file_name, "rb")) == NULL)
  return -1;

 fseek(fsave, 4L, SEEK_SET);

 x1 = getw(fsave);
 y1 = getw(fsave);
 x2 = getw(fsave);
 y2 = getw(fsave);

 fseek(fsave, 128L, SEEK_SET);

 bitmask(0xFF);  esetres(0);  modereg(0);

 for(k=y1; k<y2; k++)
  {
  i = k*40 + (x1>>3);

  line_end = k*40 + (x2>>3) + 1;

  j = 0;

  while(j < 4)
   {
   ch1 = fgetc(fsave);

   if((ch1 & 0xC0) != 0xC0)
    {
    wrt_byte(page, i, j, ch1);

    i++;

    if(i >= line_end)
     {
     j++;

     i = k*40 + (x1>>3);
     }
    }
   else
    {
    ch1 &= 0x3F;
    pass = ch1;
    ch   = fgetc(fsave);

    for(m=0; m<pass; m++)
     {
     wrt_byte(page, i, j, ch);

     i++;

     if(i >= line_end)
      {
      j++;

      i = k*40 + (x1>>3);
      }
     }
    }
   }
  }

 fclose(fsave);

 setres( __sr);  esetres(__er);  mapmask(__mm);
 readmap(__rm);  modereg(__mr);  bitmask(__bm);

 return 1;
}



void put_pixel(int x, int y, UBYTE color)
{
 ULONG      off;
 UBYTE far *mem_addr;
 int        dummy, mask;


 off = (LONG)y * 40L + ((LONG)x / 8L);

 mem_addr = (UBYTE far *)(0xA0000000L + off);

 mask = 0x80 >> (x % 8);

 bitmask(mask);

 mapmask(0x0F);

 dummy = *mem_addr;

 *mem_addr = 0;

 mapmask(color);

 *mem_addr = 0xFF;

 mapmask(0x0F);

 bitmask(0xFF);
}


UBYTE rd_byte(ULONG addr, WORD clr_plane)
{
 UBYTE far *mem_addr;
 UBYTE      pixel;
 int        __rm = __readmap, __mr = __modereg;


 mem_addr = (UBYTE far *)(0xA0000000L + addr);

 readmap(clr_plane);

 modereg(0);

 pixel = *mem_addr;

 readmap(__rm);  modereg(__mr);

 return pixel;
}



void wrt_byte(UBYTE page, ULONG addr, WORD clr_plane, UBYTE byte)
{
 UBYTE far *mem_addr;
 UBYTE      dummy;
 UBYTE      __mm = __mapmask, __mr = __modereg, __bm = __bitmask;


 mem_addr = (UBYTE far *)(0xA0000000L + (page&7)*0x02000000L + addr);

 modereg(0);

 dummy = *mem_addr;

 mapmask(0x01 << clr_plane);

 bitmask(0xFF);

 *mem_addr = byte;

 mapmask(__mm);  modereg(__mr);  bitmask(__bm);
}
