/*
 * ega.h -- (EGA) image manipulation routines
 *          Header file
 */

#ifndef __EGA_H
#define __EGA_H

/* INCLUDES */

#include <dos.h>




/* TYPEDEFS */

typedef char          BYTE;
typedef unsigned char UBYTE;
typedef int           WORD;
typedef unsigned int  UWORD;
typedef long          LONG;
typedef unsigned long ULONG;

typedef int           boolean;
typedef unsigned char bool;




/* GLOBALS */

extern volatile UBYTE __modereg, __setres,  __esetres,
		      __readmap, __bitmask, __mapmask;




/* DEFINES */

#define _BLACK     0
#define _BLUE      1
#define _GREEN     2
#define _CYAN      3
#define _RED       4
#define _MAGENTA   5
#define _BROWN     6
#define _LGRAY     7
#define _DGRAY     8
#define _LBLUE     9
#define _LGREEN   10
#define _LCYAN    11
#define _LRED     12
#define _LMAGENTA 13
#define _YELLOW   14
#define _WHITE    15

#define modereg(mode)                   \
	 {                              \
	 outp(0x3CE,    5);             \
	 outp(0x3CF, mode);             \
	 __modereg = (UBYTE)(mode);     \
	 }

#define setres(value)                   \
	 {                              \
	 outp(0x3CE,     0);            \
	 outp(0x3CF, value);            \
	 __setres = (UBYTE)(value);     \
	 }

#define esetres(mask)                   \
	 {                              \
	 outp(0x3CE,    1);             \
	 outp(0x3CF, mask);             \
	 __esetres = (UBYTE)(mask);     \
	 }

#define readmap(mapcode)                \
	 {                              \
	 outp(0x3CE,       4);          \
	 outp(0x3CF, mapcode);          \
	 __readmap = (UBYTE)(mapcode);  \
	 }

#define bitmask(value)                  \
	 {                              \
	 outp(0x3CE,     8);            \
	 outp(0x3CF, value);            \
	 __bitmask = (UBYTE)(value);    \
	 }

#define mapmask(plane)                  \
         {                              \
         outp(0x3C4,     2);            \
	 outp(0x3C5, plane);            \
	 __mapmask = (UBYTE)(plane);    \
	 }




/* PROTOTYPES */

void  clrgwin(UWORD addr, UBYTE color, UWORD nbyte, UWORD nrow);
void  cls(UWORD page);
int   fload_pcx(int page, const char *file_name);
void  init_egfx(UBYTE mode);
void  mode(WORD vmode);
void  put_pixel(int x, int y, UBYTE color);
UBYTE rd_byte(ULONG addr, WORD clr_plane);
void  save_pcx(const char *fname, UBYTE far *pal);
void  wrt_byte(UBYTE page, ULONG addr, WORD clr_plane, UBYTE byte);

#endif __EGA_H
