/*
 *	gmtc.c -- genious mouse C interface (Turbo C, small memory model)
 *
 *
 *	2 oct 1988  Olle
 */

#include <dos.h>
/*#include <gmtc.h>  TEST */
#include "gmtc.h"

#define gmc	geninterrupt( 0x33 )

/* genious mouse functions */

int gm_init( void )
{
/* init mouse driver, return number of buttons (2 or 3) or 0  (fail) */
/* this also sets defaults: cursor hidden, arrow shaped graphic cursor,
 * text cursor in reversed video, user defined call mask all zeros,
 * light pen emulation enabled, vertical mickey/pixel ratio 16 to 8,
 * horizontal mickey/pixel ratio 8 to 8, min/max cursor postion
 * hor/vert 0..current display mode max */

_AX = 0;
gmc;
return (_AX ? _BX : 0);
}

void gm_show( void )
{
/* show cursor */
_AX = 1;
gmc;
}

void gm_hide( void )
{
/* hide cursor */
_AX = 2;
gmc;
}

void gm_getpos( struct gm_status *stat )
{
/* get mouse cursor position */
_AX = 3;
gmc;
stat -> gm_pbutton = _BX;	/* button status */
stat -> gm_xpos  = _CX;	/* horizontal position */
stat -> gm_ypos  = _DX;	/* vertical position */
}

void gm_setpos( int col, int row )
{
/* set mouse cursor position */
_AX = 4;
_CX = col;
_DX = row;
gmc;
}

void gm_press( int button, struct gm_status *stat  )
{
/* get button press information */
_AX = 5;
_BX = button;	/* 0 = left, 1 = middle, 2 = right */
gmc;
stat -> gm_pbutton = _AX;	/* button status */
stat -> gm_count = _BX;		/* number of button presses */
stat -> gm_xpos  = _CX;		/* horizontal position */
stat -> gm_ypos  = _DX;		/* vertical position */
}

void gm_release( int button, struct gm_status *stat )
{
/* get button release information */
_AX = 6;
_BX = button;	/* 0 = left, 1 = middle, 2 = right */
gmc;
stat -> gm_pbutton = _AX;	/* button status */
stat -> gm_count = _BX;		/* number of button releases */
stat -> gm_xpos  = _CX;		/* horizontal position */
stat -> gm_ypos  = _DX;		/* vertical position */
}

void gm_hlimit( int min, int max )
{
/* set cursor horizontal max and min */
_AX = 7;
_CX = min;
_DX = max;
gmc;
}

void gm_vlimit( int min, int max )
{
/* set cursor vertical max and min */
_AX = 8;
_CX = min;
_DX = max;
gmc;
}

void gm_defg( struct gm_gcurs *gcurs )
{
/* define graphics cursor */
_ES = _DS;	/* segmemt for the limit array, for sure es is al ready == ds */
_DX = (int) &gcurs -> gm_scmask; /* screen & cursor masks 16+16 words ds:dx? */
_AX = 9;
_BX = gcurs -> gm_hhot;		/* horizontal hot -16..16, upper left (0,0) */
_CX = gcurs -> gm_vhot;		/* vertical hot spot */
gmc;
}

void gm_deft( int hard, int scstart, int scstop )
{
/* define text cursor */
_AX = 10;
_BX = hard;	/* hard/soft cursor */
_CX = scstart;	/* scan line start/screen mask */
_DX = scstop;	/* scan line stop/cursor mask */
gmc;
}

void gm_getmickey( struct gm_status *stat )
{
/* get mouse motion (mickey) counters */
_AX = 11;
gmc;
stat -> gm_xpos  = _CX;	/* horizontal count */
stat -> gm_ypos  = _DX;	/* vertical count */
}

void gm_event( int mask, int (*func)() )
{
_ES = _CS;		 /* code segment, this uses _AX so do it first */
_AX = 12;
_CX = mask;		/* call mask, bit 0: position, 1..3 press, 4..6 release */
_DX = (int) func;	/* event handler */
gmc;
_ES = _DS;		/* restore (small memory model) */
}

void gm_lpon( void )
{
/* light pen enulation on */
_AX = 13;
gmc;
}

void gm_lpoff( void )
{
/* light pen enulation off */
_AX = 14;
gmc;
}

void gm_setmpr( int hrat, int vrat )
{
/* set mickey/pixel ratio */
_AX = 15;
_CX = hrat;	/* horizontal */
_DX = vrat;	/* vertical */
gmc;
}

void gm_chide( struct gm_chbox *box )
{
/* conditionally hide cursor */
_ES = _DS;	/* segmemt for the limit array, for sure es is al ready == ds */
_AX = 16;
_DX = (int) box;	/* limits for hide: left, upper, right and lower */
gmc;
}

void gm_setspl( int limit )
{
/* set double speed limit */
_AX = 17;
_DX = limit;	/* speed limit in mickeys/second */
gmc;
}

