//	WDADDR.C
//	Get the hardware address from a Wester Digital card.
//	returns a 0 if no WD card is found.
//

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>


#define OFFSET_ADDR 0x08
#define WD1 0x00
#define WD2 0x00
#define WD3 0xc0


int 	check_wdaddr( char *s )
{
unsigned char addr[6];
int i;
int m,port;
char Hex[] = "0123456789ABCDEF";        // Hex conversion array



	m = 0x200;
	while ( m <= 0x380 ) {
		port = m + OFFSET_ADDR;
		for ( i=0 ; i < 6 ; i++ ) addr[i] = inportb( port++ );
		if (( addr[0] == WD1) &&
		    ( addr[1] == WD2 ) &&
		    ( addr[2] == WD3 )) {
		    for ( i=0 ; i < 6 ; i++ ) {
			*s++ = Hex[( addr[i] & 0xf0 ) >> 4 ];
			*s++ = Hex[ addr[i] & 0x0f ];
			if (i < 5) *s++ = ':';
		    }
		    *s++ = 0;
		    return 1; // We got our address
		}
		m = m + 0x020;
	}
	strcpy( "NONE:" , s);
	return 0; // We got nada
}
