;english.lex  8-May-91
;main lexicon file for Englex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;25-Nov-91	added +' entry in LEXICON GENITIVE
;26-Nov-91	version 1.0

ALTERNATION Begin	PREFIX1 AUX PREP PRON CONJ DET
	CARDINALS ORDINALS DIGITS ROMAN
	INTJ FOREIGN ABBREV
ALTERNATION Prefix1	PREFIX2
ALTERNATION Prefix2	NOUN ADJ VERB ADV PROPER
ALTERNATION N_Prefix	NOUN
ALTERNATION V_Prefix	VERB

ALTERNATION Final_y	FINAL_Y_SUFFIXES

ALTERNATION PN	PN_SUFFIX	;proper noun
ALTERNATION N	N_SUFFIX1A	;noun
ALTERNATION N_Suffix1a	N_SUFFIX1B
ALTERNATION N_Suffix1b	N_SUFFIX2
ALTERNATION N_Suffix2	N_SUFFIX3
ALTERNATION N_Infl	NUMBER
ALTERNATION Number	GENITIVE

ALTERNATION AJ	ADJ_SUFFIX1	;adjective
ALTERNATION AJ_ic	ADJ_SUFFIX_ic
ALTERNATION AJ_Suffix1	ADJ_SUFFIX2
ALTERNATION AJ_Suffix2	ADJ_SUFFIX3
ALTERNATION AJ_Infl	ADJ_INFL

ALTERNATION V	V_SUFFIX1               ;verb
ALTERNATION V_Suffix1	V_SUFFIX2
ALTERNATION V_Infl	V_INFL
ALTERNATION PTC_SUFFIX	PTC_SUFFIX

ALTERNATION AV	CLITICS	;adverb

ALTERNATION CD	CARDINALS NUMBER ORDR	;cardinals
ALTERNATION DG	DIGITS NUMBER ORDR	;digits
ALTERNATION RN	ROMAN NUMBER ORDR	;roman numerals
ALTERNATION AB	NUMBER	;abbreviations
ALTERNATION Clitics	CLITICS

ALTERNATION N-to-V	N-to-V	;conversions
ALTERNATION N-to-AJ	N-to-AJ
ALTERNATION N-to-V-AJ	N-to-V-AJ
ALTERNATION V-to-N	V-to-N
ALTERNATION AJ-to-N	AJ-to-N
ALTERNATION AJ-to-V	AJ-to-V
ALTERNATION AJ-to-N-V	AJ-to-N-V
ALTERNATION AJ-to-AV	AJ-to-AV
ALTERNATION AV-to-AJ	AV-to-AJ

ALTERNATION End	End

INCLUDE noun.lex	;file of nouns
INCLUDE verb.lex	;file of verbs
INCLUDE adjectiv.lex	;file of adjectives
INCLUDE adverb.lex	;file of adverbs
INCLUDE minor.lex	;file of minor word classes
INCLUDE proper.lex	;file of proper nouns
INCLUDE abbrev.lex	;file of acronyms and abbreviations

LEXICON INITIAL
*	Begin	""

LEXICON PREFIX1
;the following prefixes do not change the class of the word
non+	Prefix1	"NEG3+"
pseudo+	Prefix1	"PEJ3+"
arch+	Prefix1	"DEG1+" ;degree
co+	Prefix1	"DEG2+"
hyper+	Prefix1	"DEG3+"
mini+	N_Prefix	"DEG4+" ;restricted to nouns
maxi+	N_Prefix	"DEG5+" ;restricted to nouns
out+	V_Prefix	"DEG6+" ;restricted to verbs
over+	Prefix1	"DEG7+"
sub+	Prefix1	"DEG8/LOC1+"
super+	Prefix1	"DEG9/LOC2+"
;sur+	Prefix1	"DEG10+"
ultra+	Prefix1	"DEG11+"
under+	Prefix1	"DEG12+"
micro+	Prefix1	"DEG13/NUM22+"
macro+	Prefix1	"DEG14+"
para+	Prefix1	"DEG15+"
quasi+	Prefix1	"DEG16+"
supra+	Prefix1	"DEG17+"
meta+	Prefix1	"DEG18+"
omni+	Prefix1	"DEG19+"
anti+	Prefix1	"ORI1+" ;orientation
contra+	Prefix1	"ORI2+"
counter+	Prefix1	"ORI3+"
pro+	Prefix1	"ORI4+"
fore+	Prefix1	"LOC3/ORD2+" ;location
inter+	Prefix1	"LOC4+"
;trans+	Prefix1	"LOC5+"
extra+	Prefix1	"LOC6+"
intra+	Prefix1	"LOC7+"
mid+	Prefix1	"LOC9+"
circum+	Prefix1	"LOC10+"
retro+	Prefix1	"LOC10+"
poly+	Prefix1	"NUM3+"
multi+	Prefix1	"NUM4+"
ante+	Prefix1	"ORD6+"
step+	Prefix1	"ORD7+"
*	Prefix1	""
;combining forms
;self
;equi
;electro
;neuro
;photo
;psycho
;thermo
;vaso

LEXICON PREFIX2
;a+	Prefix2	"NEG1+" ;negative
in+	Prefix2	"NEG2a+"
im+	Prefix2	"NEG2b+"
il+	Prefix2	"NEG2c+"
ir+	Prefix2	"NEG2d+"
un+	Prefix2	"NEG4/REV1+"
;ab+	Prefix2	"NEG5+"
de+	V_Prefix	"REV2+" ;restricted to verbs
dis+	Prefix2	"REV3+" ;reversive
mal+	Prefix2	"PEJ1+" ;pejorative
mis+	Prefix2	"PEJ2+"
;dys+	Prefix2	"PEJ4+"
;cis+	Prefix2	"LOC8+" ;rare
ex+	Prefix2	"ORD1+" ;time and order
;fore+	Prefix2	"ORD2+" ;see LOC3
post+	Prefix2	"ORD3+"
pre+	Prefix2	"ORD4+"
re+	Prefix2	"ORD5+"
bi+	Prefix2	"NUM1+" ;number
di+	Prefix2	"NUM2+"
semi+	Prefix2	"NUM5+"
demi+	Prefix2	"NUM6+"
hemi+	Prefix2	"NUM7+"
tri+	Prefix2	"NUM8+"
uni+	Prefix2	"NUM9+"
mono+	Prefix2	"NUM10+"
deka+	Prefix2	"NUM11+"
hecto+	Prefix2	"NUM12+"
kilo+	Prefix2	"NUM13+"
mega+	Prefix2	"NUM14+"
giga+	Prefix2	"NUM15+"
tera+	Prefix2	"NUM16+"
peta+	Prefix2	"NUM17+"
exa+	Prefix2	"NUM18+"
deci+	Prefix2	"NUM19+"
centi+	Prefix2	"NUM20+"
milli+	Prefix2	"NUM21+"
;micro+	Prefix2	"DEG13/NUM22+"
nano+	Prefix2	"NUM23+"
pico+	Prefix2	"NUM24+"
femto+	Prefix2	"NUM25+"
atto+	Prefix2	"NUM26+"
auto+	Prefix2	"NEO1+" ;neo-classical
neo+	Prefix2	"NEO2+"
paleo+	Prefix2	"NEO3+"
pan+	Prefix2	"NEO4+"
proto+	Prefix2	"NEO5+"
;tele+	Prefix2	"NEO6+"
vice+	Prefix2	"NEO7+"
;exo	Prefix2	"NEO8+"
;epi+	Prefix2	"NEO9+"
;ana+	Prefix2	"NEO10+"
;for+	Prefix2	"??+"

;the following change the class of the word
;a+	Prefix2	"AJR1+" ;unproductive
;en+	Prefix2	"VR1a+"
;em+	Prefix2	"VR1b+"
;in+	Prefix2	"VR1c+"
;im+	Prefix2	"VR1d+"
;be+	Prefix2	"VR2+" ;unproductive
*	Prefix2	""

LEXICON FINAL_Y_SUFFIXES
+y	N	"+NR48"
+ous	AJ	"+AJR21a"
+ic	AJ_ic	"+AJR20a"
+er	N_Suffix1a	"+NR11"
+ess	N_Suffix1a	"+NR12"
+ist	N_Suffix1a	"+NR31"
+ize	V	"+VR6"
+ise	V	"+VR6" ;British
+ify	V	"+VR5"
+an	AJ	"+AJR4a"
+ian	AJ	"+AJR4b"
+ism	N_Suffix1b	"+NR8"

LEXICON PN_SUFFIX
+er	N_Infl	"+NR11"
+ese	AJ-to-N	"+AJR3"
+i	AJ-to-N	"+AJR40"
+an	AJ-to-N	"+AJR4a"
+ian	AJ-to-N	"+AJR4b"
+arian	AJ-to-N	"+AJR4c"
+al	AJ	"+AJR17a"
+ial	AJ	"+AJR17b"
+ual	AJ	"+AJR17c"
+ic	AJ_ic	"+AJR20a"
+ic	N	"+AJR20a.NR0"
+ish	AJ-to-N	"+AJR10"
+ism	N_Suffix1b	"+NR8"
+ist	N_Suffix1a	"+NR31"
+ite	N_Suffix1a	"+NR32"
+iana	N_Suffix1a	"+NR36"
+man	N_Suffix1a	"+NR55"
+men	Number	"+NR55.PL"
+woman	N_Suffix1a	"+NR56"
+women	Number	"+NR56.PL"
*	N_Infl	""

LEXICON N_SUFFIX1A
;noun suffixes
;denominal nouns
;+age	N_Suffix1a	"+NR1"
+dom	N_Suffix1a	"+NR2"
;+ery	N_Suffix1a	"+NR3a"
;+ry	N_Suffix1a	"+NR3b"
;+ful	N_Suffix1a	"+NR5"
;+ing	N_Suffix1a	"+NR7"  ;e.g. tubing
+eer	N_Suffix1a	"+NR10"
;+er	N_Suffix1a	"+NR11" ;causes spurious parses
+ess	N_Suffix1a	"+NR12"
+ette	N_Suffix1a	"+NR13"
+let	N_Suffix1a	"+NR14"
+ling	N_Suffix1a	"+NR15"
+ster	N_Suffix1a	"+NR16"
+an	N_Suffix1a	"+NR29a"
+ian	N_Suffix1a	"+NR29b"
+arian	N_Suffix1a	"+NR29c"
;+ese	N_Suffix1a	"+NR28"
+ist	N_Suffix1a	"+NR31"
+ite	N_Suffix1a	"+NR32"
;+ite	N_Suffix1a	"+NR60" ;minerals
;+ie	N_Suffix1a	"+NR33a" ;diminutive (causes bad parses)
;+y	N_Suffix1a	"+NR33b" ;diminutive
+iana	N_Suffix1a	"+NR36"
+scape	N_Suffix1a	"+NR37"
+nik	N_Suffix1a	"+NR44"
;+cy	N_Suffix1a	"+NR40" ;unproductive, irregular
+itis	N_Suffix1a	"+NR50"
+ectom	Final_y	"+NR51"
;+ade	N_Suffix1a	"+NR52"
;+oid	N_Suffix1a	"+NR53" ;also forms adjectives
+icide	N_Suffix1a	"+NR54"
;+ia	N_Suffix1a	"+NR61"
+man	N_Suffix1a	"+NR55"
+men	Number	"+NR55.PL"
+woman	N_Suffix1a	"+NR56"
+women	Number	"+NR56.PL"
+person	N_Suffix1a	"+NR57"
*	N_Suffix1a	""

LEXICON N_SUFFIX1B
;noun suffixes
;denominal nouns
+hood	N_Suffix1a	"+NR6"
+ism	N_Suffix1b	"+NR8"
+ship	N_Suffix1b	"+NR9"
*	N_Suffix1b	""

LEXICON N_SUFFIX2
;adjective/adverb suffixes
;denominal adjectives/adverbs
+an	AJ	"+AJR4a"
+ian	AJ	"+AJR4b"
;+ean	AJ	"+AJR4c"
+arian	AJ	"+AJR4d"
;+ed	AJ	"+AJR8"  ;not a participle
;+en	AJ	"+AJR30" ;unproductive
+ful	AJ	"+AJR9"
+ish	AJ	"+AJR10"
+less	AJ	"+AJR11"
+like	AJ	"+AJR12"
+ly	AJ	"+AJR13"
+y	AJ	"+AJR14"
;+some	AJ	"+AJR15" ;unproductive
+worthy	AJ	"+AJR16"
+ward	AV-to-AJ	"+AVR2"
+wards	AV	"+AVR2"
;+way	AV-to-AJ	"+AVR3"
;+ways	AV	"+AVR3"
+wise	AV-to-AJ	"+AVR4"
+wide	AV-to-AJ	"+AVR5" ;or compound
+fashion	AV	"+AVR6" ;or compound
+style	AV	"+AVR7" ;or compound
;foreign
+al	AJ	"+AJR17a"
+ial	AJ	"+AJR17b"
+ual	AJ	"+AJR17c"
;+inal	AJ	"+AJR17d"
;+en	AJ	"+AJR18" ;unproductive
+esque	AJ	"+AJR19"
+ic	AJ_ic	"+AJR20a"
+etic	AJ_ic	"+AJR20b"
;+atic	AJ_ic	"+AJR20c"
+ous	AJ	"+AJR21a"
;+ious	AJ	"+AJR21b"
;+eous	AJ	"+AJR21c"
;+inous	AJ	"+AJR21d"
;+uous	AJ	"+AJR21e"
;+ary	AJ	"+AJR22"
;+ory	AJ	"+AJR23"  ;unproductive
;+ate	AJ	"+AJR24"  ;unproductive
;+ar	AJ	"+AJR31a" ;unproductive
;+ular	AJ	"+AJR31b" ;unproductive
;+ine	AJ	"+AJR38"  ;unproductive
;+ile	AJ	"+AJR39"  ;unproductive
*	N_Suffix2	""

LEXICON N_SUFFIX3
;verb suffixes
;denominal verbs
;+ate	V	"+VR3"
+ify	V	"+VR5"
;+fy	V	"+VR5"
+ification	N	"+VR5+NR23"
+ize	V	"+VR6"
+ise	V	"+VR6";British
*	N_Infl	""

LEXICON V_SUFFIX1
;noun suffixes
;deverbal nouns
;+ery	N_Suffix1a	"+NR3a"
;+ry	N_Suffix1a	"+NR3b"
+ant	N	"+NR17"
;+ent	N	"+NR17b" ;unproductive
+ee	N	"+NR18"
+er	N	"+NR19"
+or	N	"+NR20"
;+trix	N	"+NR59" ;female
;+ator	N	"+NR20b" ;unproductive
+age	N_Suffix1a	"+NR1"
+al	N	"+NR22"
+ation	N	"+NR23a"
+ition	N	"+NR23b"
+tion	N	"+NR23c"
+ion	N	"+NR23d"
;+ing	N	"+NR24" ;e.g. painting
+ment	N	"+NR25"
+ance	N	"+NR26a"
+ence	N	"+NR26b"
+ency	N	"+AJR27+NR40"
;+ist	N_Suffix1a	"+NR31"
;+ory	N	"+NR34a" ;unproductive
;+atory	N	"+NR34b" ;unproductive
;+y	N	"+NR35"  ;unproductive
;+ure	N	"+NR38"  ;unproductive
;+ary	N	"+NR39"  ;unproductive
;+ate	N	"+NR46"
+ability	N	"+AJR25+NR26"
+ibility	N	"+AJR25+NR26"
*	V_Suffix1	""

LEXICON V_SUFFIX2
;adjective suffixes
;deverbal adjectives
;+ate	AJ	"+AJR24" ;unproductive
+able	AJ	"+AJR25a"
+ible	AJ	"+AJR25b"
+ably	AV	"+AJR25+AVR1"
+ibly	AV	"+AJR25+AVR1"
+ive	AJ	"+AJR26"
;+ative	AJ	"+AJR26b"
;+itive	AJ	"+AJR26c"
;+ant	AJ	"+AJR27a" ;unproductive
+ent	AJ	"+AJR27b"
+ory	AJ	"+AJR28a"
;+atory	AJ	"+AJR28b"
;+al	AJ	"+AJR17a" ;infrequent
;+ous	AJ	"+AJR21a"
;+ious	AJ	"+AJR21b"
;+ile	AJ	"+AJR39" ;unproductive
;+y	AJ	"+AJR14" ;try this to avoid multiple parses
;+en	AJ	"+AJR30" ;unproductive
;+some	AJ	"+AJR15" ;unproductive
*	V_Infl	""

LEXICON ADJ_SUFFIX1
;noun suffixes
;de-adjectival nouns
+ster	N_Suffix1a	"+NR16"
+ee	N	"+NR18"
;+ation	N	"+NR23a"
;+ition	N	"+NR23b"
;+tion	N	"+NR23c"
;+ion	N	"+NR23d"
+ity	N	"+NR21a"
;+ty	N	"+NR21b"
+ness	N	"+NR27"
+ese	N	"+NR28"
;+an	N_Suffix1a	"+NR29a"
;+ian	N_Suffix1a	"+NR29b"
+ist	N_Suffix1a	"+NR31"
+ism	N_Suffix1b	"+NR8"
;+ite	N_Suffix1a	"+NR32"  ;unproductive
+ie	N_Suffix1a	"+NR33a" ;diminutive
;+y	N_Suffix1a	"+NR33b" ;diminutive
;+cy	N_Suffix1a	"+NR40"  ;unproductive, irregular
;+ce	N	"+NR41"
;+th	N	"+NR42"  ;unproductive
;+ery	N_Suffix1a	"+NR3a"
;+ry	N_Suffix1a	"+NR3b"
;+itude	N	"+NR62"  ;unproductive
+ment	N	"+NR25"   ;to permit en-large-ment
+able	AJ	"+AJR25a" ;to permit en-large-able
+ish	AJ	"+AJR10"
*	AJ_Suffix1	""

LEXICON ADJ_SUFFIX2
;verb suffixes
;de-adjectival verbs
;+ate	V	"+VR3"
+en	V	"+VR4"
+ify	V	"+VR5" ;also +fy
+ification	N	"+VR5+NR23"
+ize	V	"+VR6"
+ise	V	"+VR6" ;British
*	AJ_Suffix2	""

LEXICON ADJ_SUFFIX3
;adjective/adverb suffixes
;de-adjectival adjectives/adverbs
+ly	AV	"+AVR1"
+most	AJ	"+AJR33"
*	AJ_Infl	""

LEXICON ADJ_SUFFIX_ic
+al	AJ	"+AJR17"
+ity	N	"+NR21a"
+ism	N_Suffix1b	"+NR8"
+ist	N_Suffix1a	"+NR31"
+ian	N_Suffix1a	"+NR29b"
+ize	V	"+VR6"
+ise	V	"+VR6" ;British
+s	Number	".NR0+PL"
*	AJ_Infl	""

LEXICON PTC_SUFFIX
;participial adverbs
+ly	AV	".AJR0+AVR1"
+ness	N	".AJR0+NR27"
+s	Number	".NR0+PL"
*	Clitics	""
LEXICON ORDR
+st	AJ	"+ORDR1"
+nd	AJ	"+ORDR2"
+d	AJ	"+ORDR2/3"
+rd	AJ-to-N	"+ORDR3"
+th	AJ-to-N	"+ORDR4"
+eth	AJ-to-N	"+ORDR4"
+fold	Clitics	"+AJR32"
+score	Clitics	"+AJR41"
+some	N_Infl	"+NR58"
*	Clitics	""

LEXICON N-to-V
*	V	".VR0"
*	N	""

LEXICON N-to-AJ
*	AJ	".AJR0"
*	N	""

LEXICON N-to-V-AJ
*	V	".VR0"
*	AJ	".AJR0"
*	N	""

LEXICON V-to-N
*	N	".NR0"
*	V	""

LEXICON AJ-to-N
*	N	".NR0"
*	AJ	""

LEXICON AJ-to-V
*	V	".VR0"
*	AJ	""

LEXICON AJ-to-N-V
*	N	".NR0"
*	V	".VR0"
*	AJ	""

LEXICON AJ-to-AV
*	AV	".AVR0"
*	AJ	""

LEXICON AV-to-AJ
*	AJ	".AJR0"
*	AV	""

LEXICON NUMBER
+s	Number	"+PL"
*	Number	""

LEXICON GENITIVE
+'s	End	"+GEN"
+'	End	"+GEN"
*	Clitics	""

LEXICON ADJ_INFL
+er	Clitics	"+CMP"
+est	Clitics	"+SPR"
*	Clitics	""

;for regular verbs
LEXICON V_INFL
+ed	PTC_SUFFIX	"+PTC" ;actually +PST/PTC
;+ed	PTC_SUFFIX	"+PST"
;+en	PTC_SUFFIX	"+PTC"
+ing	PTC_SUFFIX	"+PRG"
+in'	PTC_SUFFIX	"+PRG"
+s	End	"+3SG"
+edst	PTC_SUFFIX	"+PTC+2SG" ;archaic
+est	End	"+2SG" ;archaic
+eth	End	"+3SG" ;archaic
*	End	""

LEXICON CLITICS
;contractions/clitics
;recurses until all clitics are found
;+'s	Clitics	"+GEN" ;see LEXICON GENITIVE
+'s	Clitics	"+V(have).3SG"
+'s	Clitics	"+V(be).3SG"
+'m	Clitics	"+V(be).1SG"
+'re	Clitics	"+V(be).2SG/1PL/2PL/3PL"
+'d	Clitics	"+V(have).PST"
+'d	Clitics	"+AUX(would)"
;+'d've	Clitics	"+AUX(would)+V(have)"
+'ll	Clitics	"+AUX(will)"
;+'ll've	Clitics	"+AUX(will)+V(have)"
+'ve	Clitics	"+V(have)"
*	End	""

LEXICON End
;to disable compound parsing, comment out the next line
;to enable compound parsing, uncomment the next line
-	Begin	"-"
*	#	""

END
