;minor.lex  16-May-91
;INCLUDE file for english.lex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;26-Nov-91	version 1.0

;File Contents
;LEXICON PREP
;LEXICON DET
;  determiners
;  predeterminers
;  post-determiners
;  quantifiers (closed-class)
;  quantifiers (open-class)
;LEXICON PRON
;  demonstrative pronouns
;  existential pronouns
;  personal pronouns
;     archaic
;  indefinite pronouns
;  relative/interrogative pronouns
;LEXICON CONJ
;LEXICON INTJ
;LEXICON FOREIGN
;LEXICON CARDINALS
;LEXICON ORDINALS
;LEXICON DIGITS
;LEXICON ROMAN

LEXICON PREP
a`baft	End	"PP/AV"
a`board	End	"PP/AV"
a`bout	End	"PP/AV"
a`bove	End	"PP/AV"
ac`ross	End	"PP/AV"
`after	End	"PP/AV/CJ"
a`gainst	End	"PP"
a`long	End	"PP/AV"
along`side	End	"PP/AV"
a`mid	End	"PP"
a`midst	End	"PP"
a`mong	End	"PP"
a`mongst	End	"PP"
a`nent	End	"PP"
`anti	End	"PP"
a`round	End	"PP/AV"
as	End	"PP/CJ"
a`slant	End	"PP/AV/AJ"
a`straddle	End	"PP"
a`stride	End	"PP"
at	End	"PP"
a`top	End	"PP"
bar	End	"PP"
be`fore	End	"PP/AV/CJ"
be`hind	End	"PP/AV"
be`low	End	"PP/AV"
be`neath	End	"PP/AV"
be`side	End	"PP"
be`sides	End	"PP/AV"
be`tween	End	"PP/AV"
be`twixt	End	"PP"
be`yond	End	"PP/AV"
but	End	"PP/CJ"
by	End	"PP/AV"
`circa	End	"PP"
`contra	End	"PP"
de`spite	End	"PP"
down	End	"PP/AV"
`during	End	"PP"
`ere	End	"PP/CJ"
ex`cept	End	"PP/CJ"
for	End	"PP"
from	End	"PP"
in	End	"PP/AV"
in`side	End	"PP/AV"
`into	End	"PP"
less	End	"PP"
like	End	"PP/AV/CJ"
`minus	End	"PP"
`modulo	End	"PP"
near	End	"PP/AV"
neath	End	"PP"
notwith`standing	End	"PP/AV"
of	End	"PP"
off	End	"PP/AV"
on	End	"PP/AV"
`onto	End	"PP"
`opposite	End	"PP/AV"
out	End	"PP"
out`side	End	"PP/AV"
`over	End	"PP/AV"
`o'er	End	"PP/AV"
`pace	End	"PP"
past	End	"PP/AV"
`pending	End	"PP"
per	End	"PP"
plus	End	"PP"
pro	End	"PP"
qua	End	"PP"
re	End	"PP"
round	End	"PP/AV"
sans	End	"PP"
save	End	"PP" ;archaic
since	End	"PP/AV/CJ"
than	End	"PP"
through	End	"PP/AV"
through`out	End	"PP/AV"
till	End	"PP/CJ"
to	End	"PP"
to`ward	End	"PP"
to`wards	End	"PP"
`under	End	"PP/AV"
under`neath	End	"PP/AV"
un`like	End	"PP"
un`til	End	"PP"
`unto	End	"PP"
up	End	"PP/AV"
u`pon	End	"PP"
`versus	End	"PP"
via	End	"PP"
vis-a-`vis	End	"PP"
with	End	"PP"
with`in	End	"PP/AV"
with`out	End	"PP/AV"
worth	End	"PP"

LEXICON DET
;determiners
a	End	"DT"
an	End	"DT"
the	End	"DT"
no	End	"AV/DT"
some	Clitics	"DT/PR"
`any	Clitics	"DT"
e`nough	End	"DT"
`every	End	"DT"
each	Clitics	"DT/PR"
`either	End	"DT"
`neither	End	"DT"
`much	End	"DT"
none	Clitics	"DT/PR"

;predeterminers
all	Clitics	"DT"
both	Clitics	"DT"
;half	Clitics	"DT"
;`double	Clitics	"DT"
twice	Clitics	"AV/DT"

;post-determiners (see also the ordinals)
a`nother	Clitics	"DT/PR"
`other	N_Infl	"DT/PR"
next	Clitics	"OD"
last	AJ	"OD"

;quantifiers (closed-class)
few	AJ	"QN"
`several	Clitics	"QN"
`many	Clitics	"QN"
more	Clitics	"QN(`many).CMP"
most	Clitics	"QN(`many).SPR"
`little	Clitics	"QN"
less	Clitics	"QN(`little).CMP"
least	Clitics	"QN(`little).SPR"

;quantifiers (open-class)
lot	Clitics	"QN"
lots	Clitics	"QN"
`plenty	Clitics	"QN"

LEXICON PRON
;demonstrative pronouns
this	Clitics	"DEM.SG"
that	Clitics	"DEM.SG"
these	Clitics	"DEM.PL"
those	Clitics	"DEM.PL"

;existential
there	Clitics	"PR"

;personal pronouns
i	Clitics	"PR.1SG"
me	Clitics	"PR.1SG"
my	Clitics	"PR.1SG"
mine	Clitics	"PR.1SG"
we	Clitics	"PR.1PL"
us	Clitics	"PR.1PL"
our	Clitics	"PR.1PL"
ours	Clitics	"PR.1PL"
you	Clitics	"PR.2SG/PL"
your	Clitics	"PR.2SG/PL"
yer	Clitics	"PR.2SG/PL" ;substandard
yours	Clitics	"PR.2SG/PL"
he	Clitics	"PR.3SG"
him	Clitics	"PR.3SG"
his	Clitics	"PR.3SG"
she	Clitics	"PR.3SG"
her	Clitics	"PR.3SG"
hers	Clitics	"PR.3SG"
it	Clitics	"PR.3SG"
its	Clitics	"PR.3SG"
they	Clitics	"PR.3PL"
them	Clitics	"PR.3PL"
'em	Clitics	"PR.3PL"
their	Clitics	"PR.3PL"
theirs	Clitics	"PR.3PL"
my`self	Clitics	"PR.1SG"
one`self	Clitics	"PR.3SG"
your`self	Clitics	"PR.2SG"
her`self	Clitics	"PR.3SG"
him`self	Clitics	"PR.3SG"
his`self	Clitics	"PR.3SG" ;substandard
it`self	Clitics	"PR.3SG"
our`selves	Clitics	"PR.1PL"
your`selves	Clitics	"PR.2PL"
them`selves	Clitics	"PR.3PL"

'tis	End	"PR.3SG+AUX(be).3SG"
'twas	End	"PR.3SG+AUX(be).PST.1SG/3SG"

;archaic
thou	Clitics	"PR.2SG"
ye	Clitics	"PR.2PL"
thee	Clitics	"PR.2SG"
thy`self	Clitics	"PR.2SG"
thy	Clitics	"PR.2SG"
thine	Clitics	"PR.2SG"

`anybody	Clitics	"PR.SG"
`anyone	Clitics	"PR.SG"
`anything	Clitics	"PR.SG"
`everybody	Clitics	"PR.SG"
`everyone	Clitics	"PR.SG"
`everything	Clitics	"PR.SG"
`nobody	Clitics	"PR.SG"
`nothing	Clitics	"PR.SG"
`somebody	Clitics	"PR.SG"
`someone	Clitics	"PR.SG"
`something	Clitics	"PR.SG"

what	Clitics	"PR/AJ"
what`ever	Clitics	"PR/AJ"
whatso`ever	Clitics	"PR/AJ"
which	Clitics	"PR/AJ"
which`ever	Clitics	"PR/AJ"
whichso`ever	Clitics	"PR/AJ"
who	Clitics	"PR"
who`ever	Clitics	"PR"
`whoso	Clitics	"PR"
whoso`ever	Clitics	"PR"
whom	Clitics	"PR"
whom`ever	Clitics	"PR"
`whomso	Clitics	"PR"
whomso`ever	Clitics	"PR"
whose	Clitics	"PR/AJ(whose).SG/PL"
whos`ever	Clitics	"PR/AJ"
whoseso`ever	Clitics	"PR/AJ"

LEXICON CONJ
;`after	End	"CJ" ;see PREP
a`fore	End	"CJ"
al`beit	End	"CJ"
al`though	End	"CJ"
and	End	"CJ"
;as	End	"CJ" ;see PREP
be`cause	End	"CJ"
;be`fore	End	"CJ" ;see PREP
;but	End	"CJ" ;see PREP
;ere	End	"CJ" ;see PREP
`ergo	End	"CJ"
;ex`cept	End	"CJ" ;see PREP
`forasmuch	End	"CJ"
how	Clitics	"AV/CJ"
how`beit	End	"AV/CJ" ;archaic
how`ever	End	"CJ"
if	End	"CJ"
inas`much	End	"CJ"
inso`much	End	"CJ"
lest	End	"CJ"
;like	End	"AV/CJ" ;see PREP
nor	End	"CJ"
once	Clitics	"AV/CJ"
or	End	"CJ"
;since	End	"CJ" ;see PREP
so	Clitics	"AV/CJ/PR"
that	End	"CJ"
`therefore	End	"CJ"
though	End	"CJ"
;till	End	"CJ" ;see PREP
un`til	End	"CJ"
un`less	End	"CJ"
when	Clitics	"AV/CJ"
whence	Clitics	"AV/CJ"
when`ever	End	"CJ"
whenso`ever	End	"CJ"
where	Clitics	"AV/CJ"
where`as	End	"CJ"
where`at	End	"CJ"
where`by	End	"CJ"
where`from	End	"CJ"
where`in	Clitics	"AV/CJ"
where`into	End	"CJ"
where`of	End	"CJ"
where`on	End	"CJ"
whereso`ever	End	"CJ"
where`through	End	"CJ"
where`to	Clitics	"AV/CJ"
where`unto	Clitics	"AV/CJ"
`whereupon	End	"CJ"
wher`ever	Clitics	"AV/CJ"
where`with	End	"CJ"
`wherewithal	End	"CJ"
`whether	End	"CJ"
while	End	"CJ"
whilst	End	"CJ"
`whither	Clitics	"AV/CJ"
whitherso`ever	End	"CJ"
why	End	"CJ"
yet	End	"CJ"

LEXICON INTJ
adi`os	End	"IJ"
ah	End	"IJ"
a`ha	End	"IJ"
a`hem	End	"IJ"
a`hoy	End	"IJ"
a`las	End	"IJ"
alle`luia	N_Infl	"IJ"
a`loha	End	"IJ"
a`men	N_Infl	"IJ"
bah	End	"IJ"
boo	End	"IJ"
damn	End	"IJ"
dang	End	"IJ"
dear	End	"IJ"
drat	End	"IJ"
eh	End	"IJ"
eu`reka	End	"IJ"
gee	End	"IJ"
`golly	End	"IJ"
;good-`bye	End	"IJ"
gosh	End	"IJ"
ha	End	"IJ"
hah	End	"IJ"
halle`lujah	N_Infl	"IJ"
hal`lo	End	"IJ"
hal`loa	End	"IJ"
heck	End	"IJ"
hel`lo	End	"IJ"
hey	End	"IJ"
hi	End	"IJ"
hm	End	"IJ"
hmm	End	"IJ"
ho	End	"IJ"
`howdy	End	"IJ"
ho`sanna	N_Infl	"IJ"
ho`sannah	N_Infl	"IJ"
huh	End	"IJ"
hul`lo	End	"IJ"
humph	End	"IJ"
hur`rah	End	"IJ"
hur`ray	End	"IJ"
lo	End	"IJ"
o	End	"IJ"
oh	End	"IJ"
ouch	End	"IJ"
ow	End	"IJ"
pooh	End	"IJ"
sh	End	"IJ"
sha`lom	End	"IJ"
shh	End	"IJ"
tut	End	"IJ"
ugh	End	"IJ"
well	End	"IJ"
whee	End	"IJ"
whew	End	"IJ"
whoa	End	"IJ"
wow	End	"IJ"
yah	End	"IJ"
yeah	End	"IJ"
yuh	End	"IJ"
zounds	End	"IJ"

LEXICON FOREIGN
;these forms assume that the input has been preprocessed
; to join phrases such as 'ad hoc' to form 'ad-hoc'
;some of these may be inflected like native words
a-fortiori	End	"AV"
a-la-grecque	End	"AJ"
a-la-king	End	"AJ"
a-la-mode	End	"AJ"
a-posteriori	End	"AJ/AV"
a-priori	End	"AJ/AV"
ad-hoc	End	"AJ/AV"
ad-hominem	End	"AJ/AV"
ad-infinitum	End	"AJ/AV"
ad-interim	End	"AJ/AV"
ad-nauseum	End	"AV"
alma-mater	End	"N"
au-contraire	End	"FN"
au-courant	End	"AJ"
bete-noir	End	"N"
bon-appetit	End	"IJ"
bona-fide	End	"AJ"
bona-fides	End	"N"
c'est-la-vie	End	"IJ"
carte-blanche	End	"N"
cartes-blanches	End	"N.PL"
cause-celebre	End	"N"
corpus-delicti	End	"N"
corpora-delicti	End	"N.PL"
coup-d'etat	End	"N"
coup-de-grace	End	"N"
creme-de-la-creme	End	"N"
cum-laude	End	"AJ/AV"
de-facto	End	"AJ/AV"
de-jure	End	"AJ/AV"
de-rigueur	End	"AJ"
deja-vu	End	"N"
eminence-grise	End	"N"
eminences-grises	End	"N.PL"
en-masse	End	"AV"
enfant-terrible	End	"N"
esprit-de-corps	End	"N"
et-cetera	End	"FN"
ex-officio	End	"AJ/AV"
ex-post-facto	End	"AJ/AV"
fait-accompli	End	"N"
faux-pas	End	"N"
habeas-corpus	End	"N"
hoi-polloi	End	"N.PL"
hors-d'oeuvre	End	"N"
hors-d'oeuvres	End	"N.PL"
in-absentia	End	"AV"
in-extremis	End	"AV"
in-loco-parentis	End	"AV"
in-medias-res	End	"AV"
in-memoriam	End	"PP"
in-situ	End	"AJ/AV"
in-toto	End	"AV"
inter-alia	End	"AV"
inter-alios	End	"AV"
ipso-facto	End	"AV"
je-ne-sais-quoi	End	"FN"
joi-de-vivre	End	"N"
lingua-franca	End	"N"
lingua-francas	End	"N.PL"
linguae-francae	End	"N.PL"
magna-cum-laude	End	"AJ/AV"
maitre-d'	End	"N"
maitre-d'hotel	End	"N"
mea-culpa	End	"N"
modus-operandi	End	"N"
mutatis-mutandis	End	"AV"
nobless-oblige	End	"N"
non-compos-mentis	End	"AJ"
non-sequitur	End	"N"
nouveau-riche	End	"N"
objet-d'art	End	"N"
per-annum	End	"AV"
per-diem	End	"AV"
persona-non-grata	End	"N"
prima-donna	End	"N"
prima-facie	End	"AJ/AV"
pro-forma	End	"AJ"
que-sera-sera	End	"FN"
quid-pro-quo	End	"N"
raison-d'etre	End	"N"
rigor-mortis	End	"N"
savoir-faire	End	"N"
semper-fidelis	End	"FN"
status-quo	End	"N"
summa-cum-laude	End	"AJ/AV"
terra-firma	End	"N"
tour-de-force	End	"N"
vice-versa	End	"AV"

LEXICON CARDINALS
;the hyphen permits 'twenty-one' etc.
-	CD	"-"
`zero	CD	"CD/PR"
`one	CD	"CD"
`two	CD	"CD"
`three	CD	"CD"
`four	CD	"CD"
`five	CD	"CD"
`six	CD	"CD"
`seven	CD	"CD"
`eight	CD	"CD"
`nine	CD	"CD"
`ten	CD	"CD"
e`leven	CD	"CD"
twelve	CD	"CD"
thir`teen	CD	"CD"
four`teen	CD	"CD"
fif`teen	CD	"CD"
six`teen	CD	"CD"
seven`teen	CD	"CD"
eight`een	CD	"CD"
nine`teen	CD	"CD"
`twenty	CD	"CD"
`thirty	CD	"CD"
`forty	CD	"CD"
`fifty	CD	"CD"
`sixty	CD	"CD"
`seventy	CD	"CD"
`eighty	CD	"CD"
`ninety	CD	"CD"
`hundred	CD	"CD"
`thousand	CD	"CD"
`million	CD	"CD"
`billion	CD	"CD"
`trillion	CD	"CD"
qua`drillion	CD	"CD"
quin`tillion	CD	"CD"
sex`tillion	CD	"CD"
sep`tillion	CD	"CD"
oc`tillion	CD	"CD"
no`nillion	CD	"CD"
de`cillion	CD	"CD"
`zillion	CD	"CD"

LEXICON ORDINALS
`first	AJ-to-N	"OD"
`second	AJ-to-N	"OD"
`third	AJ-to-N	"OD"
`fifth	AJ-to-N	"OD"
`eighth	AJ-to-N	"OD"
`ninth	AJ-to-N	"OD"
`twelfth	AJ-to-N	"OD"

LEXICON DIGITS
'	DG	"" ;as in '92
0	DG	"0"
1	DG	"1"
2	DG	"2"
3	DG	"3"
4	DG	"4"
5	DG	"5"
6	DG	"6"
7	DG	"7"
8	DG	"8"
9	DG	"9"

LEXICON ROMAN
;number "i" commented out due to ambiguity with first sg. pronoun
;if you uncomment it, you should comment out all other entries that contain "i"
;i	RN	"i"
ii	RN	"ii"
iii	RN	"iii"
iv	RN	"iv"
v	RN	"v"
vi	RN	"vi"
ix	RN	"ix"
x	RN	"x"
xi	RN	"xi"
xl	RN	"xl"
l	RN	"l"
li	RN	"li"
xc	RN	"xc"
c	RN	"c"
ci	RN	"ci"
xm	RN	"xm"
m	RN	"m"
mi	RN	"mi"

END

;contractions
;these should be handled by the End sublexicon in english.lex
;he's	End	"PR.3SG+V(have).3SG"
;he's	End	"PR.3SG+V(be).3SG"
;she's	End	"PR.3SG+V(have).3SG"
;she's	End	"PR.3SG+V(be).3SG"
;it's	End	"PR.3SG+V(have).3SG"
;it's	End	"PR.3SG+V(be).3SG"
;he'd	End	"PR.3SG+V(have).PST"
;he'd	End	"PR.3SG+AUX(would)"
;he'll	End	"PR.3SG+AUX(will)"
;i'd	End	"PR.1SG+AUX(would)"
;i'll	End	"PR.1SG+AUX(will)"
;i'm	End	"PR.1SG+V(be).1SG"
;i've	End	"PR.1SG+V(have).1SG"
;she'd	End	"PR.3SG+V(have).PST"
;she'd	End	"PR.3SG+AUX(would)"
;she'll	End	"PR.3SG+AUX(will)"
;they'd	End	"PR.3PL+AUX(would)"
;they'll	End	"PR.3PL+AUX(will)"
;they're	End	"PR.3PL+V(be).3PL"
;they've	End	"PR.3PL+V(have).3PL"
;we'd	End	"PR.1PL+AUX(would)"
;we'll	End	"PR.1PL+AUX(will)"
;we're	End	"PR.1PL+V(be).1PL"
;we've	End	"PR.1PL+V(have).1PL"
;you'd	End	"PR.2SG/PL+AUX(would)"
;you'll	End	"PR.2SG/PL+AUX(will)"
;you're	End	"PR.2SG/PL+V(be).2SG/2PL"
;you've	End	"PR.2SG/PL+V(have).1PL/2PL"

;what're	End	"PR/AJ+V(be).2SG/1PL/2PL/3PL"
;where'd	End	"AV+AUX(would)"
;where're	End	"AV+V(be).2SG/1PL/2PL/3PL"
;who'd	End	"PR+AUX(would)"
;who'll	End	"PR+AUX(will)"
;who's	End	"PR+V(have).3SG"
;who've	End	"PR+V(have).3PL"
