                page    60, 132
                title   Gate A20 enable utility


;************************************************************************
;*
;*      Enable line A20.  This routine is hardware dependent and will
;*   only work properly on AT's and 100% compatibles.
;*
;************************************************************************

                ORG     100h
CODE            segment public 'CODE'
                assume cs:CODE, ds:CODE, es:CODE

Start:          jmp     EnableA20

A20OnMessage    db      13, 10, 'The A20 line is currently ENABLED.', 13, 10, '$'
A20OffMessage   db      13, 10, 'The A20 line is currently DISABLED.', 13, 10, '$'

EnableA20:      mov     ax, cs
                add     ax, 0010h
                mov     ds, ax
                mov     es, ax
                mov     ax, 1
                call    AT_A20Handler

QueryA20:       call    IsA20On
                or      ax, ax
                jz      A20Off

A20On:          mov     dx, offset A20OnMessage
                jmp     short QueryDone

A20Off:         mov     dx, offset A20OffMessage

QueryDone:      mov     ah, 09h
                int     21h

                mov     ax, 4C00h
                int     21h


;************************************************************************
;*
;*      Check line A20 status.
;*
;*      Proc    : IsA20On
;*      Params  : None
;*      Return  : AX = 1                --> A20 enabled
;*                AX = 0                --> A20 disabled
;*      Regs    : AX, CX, DI, SI & flags clobbered.
;*      Notes   :
;*
;************************************************************************

LowMemory       label   dword
                dw      00080h
                dw      00000h

HighMemory      label   dword
                dw      00090h
                dw      0FFFFh

IsA20On         proc    near

                push    ds
                push    es

                lds     si, es:LowMemory
                les     di, es:HighMemory
                mov     cx, 4
                cld
                repe    cmpsw

                pop     es
                pop     ds
                xor     ax, ax

                jcxz    IAONoWrap
                inc     ax

IAONoWrap:      xor     bl, bl
                ret

IsA20On         endp


;************************************************************************
;*
;*      Enable or disable line A20 on AT or 100% compatible.
;*
;*      Proc    : AT_A20Handler
;*      Params  : AX = 0                --> Disables A20
;*                AX = 1                --> Enables A20
;*      Return  : AX = 1                --> Operation successful
;*                AX = 0                --> Operation failed
;*      Regs    : AX, CX & flags clobbered.
;*      Notes   :
;*
;************************************************************************

AT_A20Handler   proc    near

                or      ax, ax
                jz      AAHDisable

AAHEnable:      call    Sync8042
                jnz     AAHErr

                mov     al, 0D1h
                out     64h, al
                call    Sync8042
                jnz     AAHErr

                mov     al, 0DFh
                out     60h, al
                call    Sync8042
                jnz     AAHErr

                mov     al, 0FFh
                out     64h, al
                call    Sync8042
                jnz     AAHErr
                jmp     short AAHExit

AAHDisable:     call    Sync8042
                jnz     AAHErr

                mov     al, 0D1h
                out     64h, al
                call    Sync8042
                jnz     AAHErr

                mov     al, 0DDh
                out     60h, al
                call    Sync8042
                jnz     AAHErr

                mov     al, 0FFh
                out     64, al
                call    Sync8042

AAHExit:        mov     ax, 1
                ret

AAHErr:         xor     ax, ax
                ret

AT_A20Handler   endp



;************************************************************************
;*
;*      Synchronize 8042 port.
;*
;*      Proc    : Sync8042
;*      Params  : None
;*      Return  :
;*      Regs    : AX, CX & flags clobbered.
;*      Notes   :
;*
;************************************************************************

Sync8042        proc    near

                xor     cx, cx
S8InSync:       in      al, 64h
                and     al, 2
                loopnz  S8InSync
                ret

Sync8042        endp


CODE            ends
                end     Start
