PROGRAM ConUsr;  { convert ROS v3.4 user file to PCBoard v10.0 }

{$I ROSDEF.INC}                   { Definitions }

CONST
  Zero      : char = '0';
  Dash      : char = '-';
  Colon     : char = ':';
  N         : char = 'N';
  One       : char = '1';
  Two       : char = '2';
  Space     : char = ' ';

VAR
  J         : Integer;
  UserFile  : File of user_list;
  NewFile   : Text;



  PROCEDURE ConvertStr (OldStr: StrStd; L: Integer);
  { writes string to file one character at a time and pads with blanks }

  VAR
    I: Integer;

  BEGIN
    FOR I := 1 TO L DO
      IF (I  <= (Length (OldStr)))
        THEN Write (NewFile, OldStr [I])
        ELSE Write (NewFile, ' ');
    Writeln (OldF);
  END;  { ConvertStr }



  BEGIN  { MAIN }
    Writeln ('File Conversion Utility / ROS to PCBoard - user file');
    Assign (NewFile, 'USERS');              { this is PCBoard's new user file }
    Rewrite (NewFile);
    Assign (UserFile, user_data + '.BB#');                  { ROS's user file }
    {$I-} Reset (UserFile) {$I+};
    IF IOresult = 0
      THEN
        BEGIN
          Write ('Converting user file...');
          Rewrite (NewFile);
          WHILE NOT EOF (UserFile) DO
            BEGIN
              Read (UserFile, user_rec);
              WITH user_rec DO
                BEGIN
                  IF (used = 0)               { convert record if it's active }
                    THEN
                      BEGIN
                        ConvertStr (fn+space+ln, 25);  { first and last names }
                        ConvertStr (cy+st, 24);              { city and state }
                        ConvertStr (pw, 12);                       { password }
                        ConvertStr (ph, 26);                        { phone # }
                              { last date on system - new system, so 00-00-00 }
                        Write (NewFile,Zero,Zero,Dash,Zero,Zero,Dash,Zero,Zero);
                                                    { last logon time - 00:00 }
                        Write (NewFile, Zero, Zero, Colon, Zero, Zero);
                         { Ns are for expert mode off and no default protocol }
                                     { 1 and 2 put user in conference 1 and 2 }
                        Write (NewFile, N, N, One, Two);
                        FOR J := 1 TO 7 DO    { pad rest of conference string }
                          Write (NewFile, Zero);
                        Write (NewFile, One, N);   { last conference left = 1 }
                                                           { auto rejoin = no }
                        FOR J := 1 TO 6 DO  { last date looked at a directory }
                          Write (NewFile, Zero);
                        Write (NewFile, Chr (10), Chr (0));   { security = 10 }
                        Write (NewFile, Chr (0), Chr (0));     { times on = 0 }
                        Write (NewFile, Chr (23), Chr (0));   { 23 lines/page }
                                    { zeros for last message read in each area,
                               # uploads, # downloads, elapsed time last call }
                        FOR J := 1 TO 26 DO
                          Write (NewFile, Chr (0));
                        Write (NewFile, Space);     { delete flag for packing }
                      END;  { IF }
                END;  { WITH user_rec }
            END;  { WHILE }
          Close (NewFile);
          Close (UserFile);
        END  { IF IO/result  }
      ELSE writeln ('ROS User file not found.');
    Writeln ('Conversion complete.')
  END.
