{ code from `Inside The PC's PPI' in Micro Cornucopia Issue #40 }

{ Figure 4 - Keyboard Disable/Enable Function }

PROCEDURE KeyboardOff (KbdOff: Boolean);

CONST
  PPIb = $61;            { PPI Port B address }

BEGIN
  IF KbdOff
    THEN     { turn off PB6 to kill Kbd clock }
      Port [PPIb] := Port [PPIb] AND $bf
    ELSE    { turn on PB6 to enable Kbd clock }
      Port [PPIb] := Port [PPIb] OR $40;
END;  { KeyboardOff }



{ Figure 5 - Check Installed Equipment }

TYPE  { standard register declaration }
  RegRecord = RECORD CASE Integer OF
                1:(AX,BX,CX,DX,BP,SI,
                   DI,DS,ES,Flags:Integer);
                2:(AL,AH,BL,BH,CL,CH,DL,DH:Byte);
              END;

PROCEDURE CheckEquip;
 { uses int 11h to detemine equipment installed }

VAR
  Regs: RegRecord;
  Temp: Integer;  { makes things easier to read }

BEGIN
  Intr ($11, Regs);  { do equip check interrupt }
  WITH Regs DO          { result returned in AX }
    BEGIN
      Temp := AX AND 1;      { any disk drives? }
      IF (Temp = 1)
        THEN Writeln ('Got some drives')
        ELSE Writeln ('No drives');
      { bit 1 not used }
      Temp := (AX AND $0c) SHR 2;  {how much RAM}
      Writeln (Temp+1, ' block(s) RAM');{old PCs}
      Temp := (AX AND $30) SHR 4;       { video }
      CASE Temp OF
        0: Writeln ('EGA');
        1: Writeln ('40 column CGA');
        2: Writeln ('80 column CGA');
        3: Writeln ('80 column mono');
      END;
      Temp := (AX AND $c0) SHR 6; { # of drives }
      Writeln (Temp + 1, ' drive(s)');
      { bit8 senses DMA controller on PCjr only }
      Temp:=(AX AND $0e00) SHR 9;{# serial ports}
      Writeln (Temp, ' RS232 port(s)');
      Temp := (AX AND $1000) SHR 12; {game port?}
      IF (Temp = 0)
        THEN Writeln ('Game port')
        ELSE Writeln ('No game port');
      { bit13 senses serial printer on PCjr only}
      Temp := (AX AND $c000) SHR 14; {# printers}
      Writeln (Temp, ' printer(s)');
    END;  { WITH Regs }
END;  { CheckEquip }
