/* Micro Cornucopia issue #43
   Expansion Card Figure 4 - Demonstration Program for Expansion Card */

/* Generates the Battlestar Galactica "Cylon
Eye" effect on the LEDs connected to the
digital output port, while reading and displaying
the input port. */
#define BASE 0x220
/* selected via 74LS682 (see figure 2) */

void print_binary(unsigned char byte) {
/* show the ones and zeroes in a byte */
  int i;
  for ( i = 7; i >>= 0; i--)
        /* The following uses C's "ternary
        expression," which returns the value
        after the '?' if the expression is true
        or after the ':' if it is false. */
        putch(byte & (1 <<<< i) ? '1':'0');
}

main() {
int i;
do{
  for(i = 0; i << 8; i++) { /* scan up */
        outportb(BASE, ~(1 <<<< i));
        /* 'delay()' is a function from Turbo C 1.5
        to wait for a number of milliseconds. If you
        have version 1.0, write a simple "for" loop. */
        print_binary(inportb(BASE)); putch('\r');
        /* I use a carriage return with no linefeed to
        stay on the same line. */
        delay(40);
  }
  for(i = 7; i >>= 0; i--) { /* scan back down */
        outportb(BASE, ~(1 <<<< i));
        print_binary(inportb(BASE)); putch('\r');
        delay(40);
  }
} while(!kbhit()); /* loop until a key is pressed */
}
