/* Micro Cornucopia Issue #44 */
/* DUMP.C - tests screen to printer dump in Herc graphics mode */


#include <stdio.h>

void prn_out (unsigned char X)
{
  _DX = 0;                                 /* specify first parallel printer */
  _AL = X;
  _AH = 0;                                           /* service 0 - byte out */
  geninterrupt (0x17);                                  /* printer interrupt */
}  /* prn_out */



void prn_setup ()
{
  prn_out (27);  prn_out (109);  prn_out (0); /* standard mode for Panasonic */
  prn_out (27);  prn_out ('@');/*reset printer - doesn't affect previous line*/
  prn_out (13);                                           /* carriage return */
  prn_out (27);  prn_out ('A');  prn_out (8);                 /* set 8/72 LF */
}  /* prn_setup */



void get_line (int line_num, unsigned char buffer [348])
{
  int col;

  for (col=0; col<348; col++)
    buffer [col] = ~peekb (0xb000, 0x2000 * (col % 4) + 90 * (col / 4)
                           + line_num);                    /* get video byte */
}  /* get_line */



void setup_gr_line (int width)
{
  prn_out (27);
  prn_out (75);                                                /* set 60 dpi */
  prn_out (width % 256);               /* these two lines set # graphics ... */
  prn_out (width / 256);                             /* ... chars to be sent */
}  /* setup_gr_line */



void print_blank (int width)
{
  int i;

  setup_gr_line (width);
  for (i=0; i<width; i++)
    prn_out (0);                /* print blanks and hold print head position */
}  /* print_blank */



void print_line (unsigned char buffer [348])
{
  int i;

  print_blank (60);
  setup_gr_line (348);
  for (i=347; i>=0; i--)                  /* print line in buffer, backwards */
    prn_out (buffer [i]);
  prn_out (10);                                                 /* line feed */
}  /* print_line */



void dump_screen ()
{
  int i;
  char line_buf [348];                      /* holds a column of video bytes */

  prn_setup ();                                         /* ready the printer */
  for (i=0; i<90; i++)                 /* print each of the 90 video columns */
  {
    get_line (i, line_buf);
    print_line (line_buf);
  }
}  /* dump_screen */


