/* DUMP.C - include for printer setup and screen dump in Herc graphics mode.
   Originally supported an article in Micro Cornucopia Magazine Issue #44.
   This version has altered setup_gr_line which accepts printer mode as a
   parameter. */


char prn_out (unsigned char X)                  /* send character to printer */
{
  _DX = 0;   /* specify first parallel printer */
  _AL = X;
  _AH = 0;
  geninterrupt (0x17);
  return (_AH);
}  /* prn_out */



void prn_setup ()
{
  prn_out (27);  prn_out (109);  prn_out (0); /* standard mode for Panasonic */
  prn_out (27);  prn_out ('@');/* reset printer-doesn't affect previous line */
  prn_out (13);                                           /* carriage return */
  prn_out (27);  prn_out ('A');  prn_out (8);                 /* set 8/72 LF */
/*  prn_out (27);  prn_out ('2'); */            /* for LV-1210/1215 printers */
  prn_out (10);
}  /* prn_setup */




void get_line (int line_num, unsigned char buffer [348])
{
  int col;

  for (col=0; col<348; col++)
    buffer [col] = ~peekb (0xb000, 0x2000 * (col % 4) + 90 * (col / 4)
                           + line_num);                    /* get video byte */
}  /* get_line */




void setup_gr_line (char p_mode, int width)
{
  prn_out (27);
  prn_out (p_mode);
  prn_out (width % 256);
  prn_out (width / 256);
}  /* setup_gr_line */




void print_blank (int width)
{
  int i;

  setup_gr_line (width, 75);
  for (i=0; i<width; i++)
    prn_out (0);
}  /* print_blank */





void print_line (unsigned char buffer [348])
{
  int i;

  print_blank (60);
  setup_gr_line (348, 75);
  for (i=347; i>=0; i--)
    prn_out (buffer [i]);
  prn_out (10);
}  /* print_line */




void dump_screen ()
{
  int i;
  char line_buf [348];

  prn_setup ();
  for (i=0; i<90; i++)
  {
    get_line (i, line_buf);
    print_line (line_buf);
  }
}  /* dump_screen */

