/* Figure 3 from ``Turning a PC into an embedded control system,''
   Micro Cornucopia Magazine Issue #46 */

/* Turbo C program to read and write data on the 2816 EEPROM
   by Bruce Eckel, EISYS Consulting */

#define BASE 0x220  /* address set on DIP switch */

void EEPROM_write(int address, unsigned char value) {
  /* See figures 1 and 2 to understand this function */
  outportb(BASE, address & 0xff);  /* low 8 bits */
  /* High 3 bits and CE forced low */
  outportb(BASE+1, (address >> 8) & 0x07);
  /* Write the data: */
  outportb(BASE + 2, value & 0xff);
  /* 'delay()' is a function from Turbo C 1.5
  to wait for a number of milliseconds.  If you
  have version 1.0, write a simple "for" loop. */
  delay(10); /* Wait 10 mS for EEPROM to finish writing */
}

int EEPROM_read(int address) {
  /* Place the address at the 2816 pins and force CE low: */
  outportb(BASE, address & 0xff)
;
  outportb(BASE+1, (address >> 8) & 0x07);
  /* Read the data: */
  return inportb(BASE + 2);
}

main() {
  int i, address, value;
  /* First, dump the contents of the EEPROM: */
  for (i = 0; i < 2048; i++) {
    /* Generate breaks & line numbers: */
    if ( i % 20 == 0) printf("\n%d: ",i);
    printf("%d ",EEPROM_read(i-1));
  }
  while(1) {
    printf("\nRead, Write, or Quit?\n");
    switch(getch()) {
      case 'R' : case 'r' :
        printf("address to read? ");
        scanf("%d",&address);
        printf("%d\n", EEPROM_read(address));
        break;
      case 'W' : case 'w' :
        printf("address to write? ");
        scanf("%d",&address);
        printf("\n");
        printf("value to write? ");
        scanf("%d", &value);
        printf("\n");
        EEPROM_write(address,value);
        break;
      case 'Q' : case 'q' :
        exit(0);
      default:
    }
  }
}
