/*	CALLER.h -  header for the CALLER modules

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/


#ifndef ISR_HDR_LOADED
#include <isr.h>
#endif


/*	CPUREGS - Variables that are used as CPU register copies.

	The module "CALLER.C" contains the function caller(), and
	a variable list which is in its code segment. 
	Caller() loads the CPU registers with the vars,
	does the call, then loads the vars with the CPU
	registers. The way the vars are defined, their contents can
	be accessed in a number of different ways; ergo the 
	declarations below:

	The macros int86(), call86() & pcdos() also use caller().
*/

extern unsigned char far _AH, _AL, _BH, _BL, _CH, _CL, _DH, _DL;
extern unsigned int  far _AX, _BX, _CX, _DX, _SI, _DI, _BP;
extern unsigned long far _DXAX;
extern unsigned char far * far _BPSI;
extern unsigned char far * far _DSDX;
extern unsigned char far * far _ESBX;
extern unsigned int  far _DS, _ES;
extern          void far (* far _PC)();
extern unsigned int  far _IP, _CS, _PSW;
extern unsigned char far * far _STKPTR;
extern unsigned int  far _SP, _SS;

unsigned int far caller(void);

/* the following spaghetti is a work-around... */
#define __xx1(i) (+(ulong)((i) * 4))
#define __xx2(i) ((long far *)__xx1((i)))
#define __xx3(i) (*__xx2((i)))
#define isr_get_vec(inum) ((void far (*)())__xx3((ulong)(inum)))

#define call86(farfunc) ( _PC = (farfunc), caller() )
#define int86(inum) ( call86( isr_get_vec( (inum) ) ) )
#define pcdos(func) ( _AH = (func), int86(0x21) )


