/*	CPU.h -  #defs etc. from the TPC header files. CPU related stuff...

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/

/*	8086 cpu opcodes
*/

#define OP_JMPF	 0xea		/* far jump instruction			*/
#define OP_CALLF 0x9a		/* far call instruction			*/
#define OP_RETF	 0xcb		/* far return instruction		*/
#define OP_INT   0xcd		/* software interrupt instr.		*/
#define OP_IRET  0xcf           /* return from interrupt                */

/*	CPU flag register bit masks
*/

#define FLG_RESf	0x8000	/* unused				*/
#define FLG_RESe	0x4000	/*					*/
#define FLG_RESd	0x2000	/*					*/
#define FLG_RESc	0x1000	/*					*/
#define FLG_OF		0x0800	/* overflow				*/
#define FLG_DIR		0x0400	/* Direction - 0=Auto Inc, 1=Auto Dec	*/
#define FLG_INTE	0x0200	/* Interrupt Enable			*/
#define FLG_TRAP	0x0100	/* Trap Flag - 1=single step		*/
#define FLG_SIGN	0x0080	/* Sign Flag - 1=result NEGATIVE	*/
#define FLG_ZERO	0x0040	/* Zero Flag - 1=result ZERO		*/
#define FLG_RES5	0x0020	/*					*/
#define FLG_AUXC	0x0010	/* Auxiliary carry flag			*/
#define FLG_RES3	0x0008	/*					*/
#define FLG_PE		0x0004	/* Parity Even - 1=has even #of 1 bits	*/
#define FLG_RES1	0x0002	/*					*/
#define FLG_CARRY	0x0001	/* Carry Flag				*/

#asm
FLG_OF		equ	0800h
FLG_DIR		equ	0400h
FLG_INTE	equ	0200h
FLG_TRAP	equ	0100h
FLG_SIGN	equ	0080h
FLG_ZERO	equ	0040h
FLG_AUXC	equ	0010h
FLG_PE		equ	0004h
FLG_CARRY	equ	0001h
#endasm


/*	Structure of the PSW register...

WARNING: 

"There are a number of caveats that apply to (bit) fields.  Perhaps 
most significant, fields are assigned left to right on some machines 
and right to left on others, reflecting the nature of different 
hardware. This means that although fields are quite useful for 
maintaining internally-defined data structures, the question of which 
end comes first has to be carefully considered..."
	                                    - K&R, page 138.
*/

typedef struct __FLAGS {
   unsigned carry : 1;
   unsigned res1 : 1;
   unsigned pe : 1;
   unsigned res3 : 1;
   unsigned auxc : 1;
   unsigned res5 : 1;
   unsigned zero : 1;
   unsigned sign : 1;
   unsigned trap : 1;
   unsigned inte : 1;
   unsigned dir : 1;
   unsigned of : 1;
   unsigned resc : 1;
   unsigned resd : 1;
   unsigned rese : 1;
   unsigned resf : 1;
} __flags;



