#pragma inline
#include "ppxfer.h"
#define SVE asm push AX; asm push BX; asm push CX; asm push DX; asm push F;
#define RST asm pop AX; asm pop BX; asm pop CX; asm pop DX; asm pop F;


void receive_block (dbyte * buffer, unsigned int count) {
    _CX = count;
    _BX = buffer;
    _DX = BASE + 2;
wait1:
    asm in AL,DX;
    asm test AL, 00001000B;
    asm jz wait1;	/* wait for handshake to drop */
hshake_lo:
    asm dec DX;		/* BASE + 1 */
    asm in AL,DX;
    asm and AL, 11111000B;  /* mask off pertinent bits */
    asm mov AH,AL;	   /* stash it */
    asm inc DX;		/* BASE + 2 */
    asm in AL,DX;
    asm and AL, 00000111B;  /* rest of byte */
    asm or AL,AH;	   /* combine the byte */
    asm xor AL, 10000011B;  /* flip "inverted" bits */
    asm mov byte ptr [BX], AL;       /* store the result */
    asm inc BX;             /* move the pointer to the next mem location */
    _DX = BASE;
    asm mov AL, 11111110B;
    asm out DX,AL;	    /* lower "byte recd" line */
    _DX = BASE + 2;
wait2:
    asm in AL,DX;
    asm test AL,00001000B;
    asm jnz wait2;           /* wait for handshake to rise */
    _DX = BASE;
    asm mov AL, 11111111B;
    asm out DX, AL;    /* De-assert "byte recd" */
    _DX = BASE+2;
    asm loop wait1;
}

void send_block (dbyte * buffer, unsigned int count) {
    _CX = count;
    _BX = buffer;
    _DX = BASE;
send:
    asm mov AL,byte ptr [BX];     /* get a byte to send */
    asm inc BX;
    asm out DX,AL;
    _DX = BASE + 2;
    asm mov AL, 1100B    /* lower handshake */
    asm out DX,AL;
wait3:
    asm in AL,DX;        /* wait for "byte recd" to go low */
    asm test AL,1;
    asm jz wait3;
byterecd:
    asm mov AL, 0100B;    /* raise handshake */
    asm out DX,AL;
wait4:
    asm in AL,DX;
    asm test AL,1;  	  /* wait for byte recd to go high */
    asm jnz wait4;
    _DX = BASE;
    asm loop send;
}
