/* DISPLAY.C : Functions to support displaying a voice pattern on the 
   screen using the Borland BGI graphics functions.  
   Bruce Eckel, Revolution2 Real-Time Consulting.
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>  /* va_start(), etc. */
#include <string.h>
#include <math.h>
#include "capture.h"
#include "display.h"

/* This is a "printf"-like function for printing messages while
using the BGI in graphics mode.  It is limited because it always
starts at the left and doesn't wrap at the bottom of the screen,
but it is useful for debugging. */
void gprintf(char * format, ...) {  /* graphics printf for BGI */
  static int textline = 0;
  char textbuf[80];
  va_list argptr;
  va_start(argptr, format);
  vsprintf(textbuf, format, argptr);
  va_end(argptr);
  outtextxy(0,textline, textbuf);
  textline += textheight("x");  /* move to the next line */
}

void display_series(unsigned * series, int series_size,
	int offset,
	scale_factor vertical_scale_factor,
	scale_factor horizontal_scale_factor,
	int color) {
  int i, j, step;
  /* create a local copy of the array: */
  int * lseries = (int *) calloc(series_size, sizeof(int));
  memcpy(lseries, series, series_size * sizeof(int));
  /* First, perform vertical scaling of the local array: */
  switch(vertical_scale_factor) {
    case quarter: for(i = 0; i < series_size; i++)
		    lseries[i] >>= 2;  /* divide by 4 */
		  break;
    case half:    for(i = 0; i < series_size; i++)
		    lseries[i] >>= 1;  /* divide by 2 */
		  break;
    case full:    break;  /* no change */
    case twice:  for(i = 0; i < series_size; i++)
		    lseries[i] <<= 1;  /* multiply by 2 */
		  break;
    case quad:    for(i = 0; i < series_size; i++)
		    lseries[i] <<= 2;  /* multiply by 4 */
		  break;
  }
  if(offset)
    for(i = 0; i < series_size; i++)
      lseries[i] += offset;
  /* Now display the array according to the horizontal scale factor: */
  switch(horizontal_scale_factor) {
    /* display a part of the series in the whole space: */
    case quarter: for(i = 0; i < (series_size/4); i++)
		    putpixel(i<<2,lseries[i], color);
		  break;
    case half:    for(i = 0; i < (series_size/2); i++)
		    putpixel(i<<1,lseries[i], color);
		  break;
    /* display the whole series in the whole space: */
    case full:    for(i = 0; i < series_size; i++)
		    putpixel(i,lseries[i], color);
		  break;
    /* display the whole series in a smaller space: */
    case twice:  for(i = 0; i < (series_size/2); i++)
		    putpixel(i, lseries[i<<1], color);
		  break;
    case quad:    for(i = 0; i < (series_size/4); i++)
		    putpixel(i,lseries[i<<2], color);
		  break;
  }
  free(lseries);  /* release local copy of the array */
}

void display_viewsettings(struct viewporttype view) {
  /* The following macro was used during debugging to display all the
   viewport settings.  Notice the use of the new ANSI C preprocessor
   directives: the "stringize" directive (#) which takes the argument
   and makes it into a string, and the "paste" directive (##) which
   takes two names and creates a variable name from them.  Notice also
   that in:
   #arg " = %d"
   the preprocessor concatenates the two strings together.
  */
  
  #define P(arg) gprintf(#arg " = %d", view.##arg)
  P(left); P(right); P(top); P(bottom); P(clip);
  getch();
}
