;RM132
;
;The following program will display in the upper right hand side of display
;the active (SPACE, CONTROL ON, POSITIVE VOLTAGE) RS232 signals. The DTE
;generated signals are displayed in red, the DCE in green, also uart errors
;are shown in white. ***** NOTE if you have a mono display change DISPLAY_ADDR
;to b005 and the attributes in the "RSDATA" section to your preference. ****
;
;                      DISPLAY DEFINTIONS
;TMO	TIME OUT ERROR
;FRM    FRAMING ERROR
;PAR	PARITY ERROR
;OVR	OVERRUN ERROR
;CAR	Recieve Line Signal Detected --CARRIER DETECTED
;RNG	RING INDICATOR
;DSR	DATASET READY
;CTS	CLEAR TO SEND
;DTR	DATA TERMINAL READY
;RTS	REQUEST TO SEND
;
;This program installs itself in memory and the display can be toggled off and
;on by depressing the ALT AND LEFT HAND SHIFT KEYS simultaeneously.
;
;The display is turned on initialy (if you dont see anything put your modem
;into analog or local loopback). Since this routine is active only about 18 
;times per second it will not catch all error conditions that may occur
;during a normal communications session.
;
;
;
;   **********************************************************************
;If the display is active while accessing a floppy drive(works ok on hard disk)
;it sometimes causes data errors. If so toggle the display off while accessing
;the floppy. I suspect a routine such as this screws up the dos software timing?
;If anyone has any info about this I would appreciate hearing from you.
;
;
;I would like to hear your comments and suggesstions
;
;                               Tim Burmeister
;                           (COMPUSERVE 74736,2402)
;
;
;PS  Be gentle this is my first attemp at a useful assembly language program
;
;
title   BREAKOUT BOX
page    65,132
;
;		EQUATES
;
DISPLAY_ADDR	equ 0b805H	;second half of the top line
;
;		MACROS
;
ERASE   MACRO			;moves spaces to the display area
.xlist
	cld
	mov ax,DISPLAY_ADDR
	mov es,ax
	mov cx,28H
	mov ax,0020H
        mov di,0
rep     stosw
.list
        endm
;
SHOW_232 MACRO	LINE
.xlist
	cli
	push cs
	pop ds
	sti
	mov ax,DISPLAY_ADDR
	mov es,ax			;set the destination segment up
	mov cx,DATAEND - DATASTART	;set the count (BYTE VALUE)
	shr cx,1		;divide count by 2 to equal number of words to move
	cld			;direction flag clear so stos will increment di
	mov si,offset DATASTART	;point to begining of the data
	mov di,LINE*160		;point dest to video memory
        rep movsw
.list
	endm
;
MOVE	MACRO
LOCAL BLANK,THATSIT
.xlist
	jnc blank		;if bit not set 
	rep movsw
	jmp THATSIT
blank:	push si			;save source index
	mov si,offset spaces	;new source index
	rep movsw
	pop si			;restore si and add 8
	add si,8
thatsit: mov cx,4		;restore cx:
.list
	endm
;
GET_STATUS MACRO  PORT
.xlist
	cli
	push ds
	pop es			;set es to point within dataseg(needed for the move macro)
	sti
	mov dx,03fdH		;the first com port to look at
	in al,dx
	inc dx
	mov ah,al
	in al,dx
	mov si,offset rsdata	;point to the begining of ascii data
	mov di,offset datastart	;point to where we want to build message
	mov cx,4		;all messages are 4 words
	shl ax,1
	move			;timeout
	shl ax,1			;ignore shift register
	shl ax,1			;ignore buffer register
	shl ax,1			;ignore break
	shl ax,1
	move			;framing error
	shl ax,1
	move			;parity error
	shl ax,1
	move			;overrun error
	shl ax,1			;ignore data ready
	shl ax,1
	move			;carrier detect
	shl ax,1
	move			;ring detected
	shl ax,1
	move			;dataset ready
	shl ax,1
	move			;clear to send
	mov dx,03fcH		;now get rts and dtr
	in al,dx		;get the bits
	shr al,1		;dtr to carry flag
	move
	shr al,1		;rts to carry flag
	move
.list
	endm
;
NEED	segment at 0
zero	proc far
zero	endp
NEED	ends
;
cseg	segment
	org	100H
	assume	cs:cseg
	assume	ds:cseg
BEGIN	proc	near
	jmp INIT
;
;			DATA AREA
;
DATASTART	equ $
DATA	dw	40 dup(0020H)
DATAEND equ $
;
RSDATA		equ $
TMO	DB	' ',7,'T',7,'M',7,'O',7
FRM	DB	' ',7,'F',7,'R',7,'M',7
PAR	DB	' ',7,'P',7,'A',7,'R',7
OVR	DB	' ',7,'O',7,'V',7,'R',7
CAR	DB	' ',2,' ',2,'C',2,'D',2
RNG	DB	' ',2,' ',2,'R',2,'I',2
DSR	DB	' ',2,'D',2,'S',2,'R',2
CTS	DB	' ',2,'C',2,'T',2,'S',2
DTR	DB	' ',4,'D',4,'T',4,'R',4
RTS	DB	' ',4,'R',4,'T',4,'S',4
RSDATAEND	EQU $
;
SPACES	DW	4 DUP(0020H)
;
DISPLAY_FLAG  DB 1
KEYS_RELEASED DB 1		;will be 1 if keys (ALT AND LEFT SHIFT) are released
;
				;this is the entry point from the interupt
ITRENT	equ $
        push ax		;save the registers
        push bx
        push cx
        push dx
        push ds
        push es
        push si
        push di
	push bp
	mov ax,cs
	mov ds,ax	;set up my dataseg
        sti		;enable interupts
;
			;THE MAIN PROGRAM
;
	xor ax,ax		;set es so we can get the keyboard flags
	mov es,ax
	mov ax,es:[417H]	;KB_FLAG
	and al,10		;get rid of the other bits
	sub al,10		;if zero flag set the l shift and alt keys are pressed
	jnz NOTPR
	cmp KEYS_RELEASED,1	;if transition just took place then toggle display
	jnz CONT
	xor DISPLAY_FLAG,1	;toggle display_flag
	and KEYS_RELEASED,0	;reset so the display will not toggle until next release and press
	JMP CONT
NOTPR:	or KEYS_RELEASED,1
CONT:	cmp DISPLAY_FLAG,1
	jz doit
	cmp KEYS_RELEASED,0	;if no display and keys were just released then erase
	jnz bye
	erase
bye:	jmp exit
;
doit:	GET_STATUS
	INSTCHCK equ $
	mov ax,DISPLAY_ADDR
	mov es,ax		;set es up to point to video memory
 	SHOW_232 0		;display on line 0
;
exit:	cli
	pop bp			;restore the registers
	pop di
	pop si
	pop es
	pop ds
	pop dx
	pop cx
	pop bx
	pop ax
	sti
jmpout: jmp	zero		;will be filled
				;in with the address of the timer int routine
INIT:				;initial entry point to set up vectors, this code
        push    ds		;will be discarded upon installing itself in memory
        sub     ax,ax		;zero ax
        mov     ds,ax                   ;address interrupt vectors
        mov     si,ds:[70H]             ;get the present interrupt values
        mov     cx,ds:[72H]		;usually points to an iret
        mov     ds,cx                   ;entry to present interupt handler
;					 Next lines determine if this program is
;					 already installed
        mov bx,cs:INSTCHCK
 	cmp word ptr [si+INSTCHCK-ITRENT],bx
	jne instal
	pop ds
	call beep			;complain LOUDLY if this program alredy in memory
	int 20H				;exit
instal: pop ds
        mov word ptr jmpout+1,si	;move timer int addr to jmpout
        mov word ptr jmpout+3,cx
        mov dx,offset ITRENT		;give dos the intr entry to this code
        mov ax,251CH			;request dos to set up a vector
        int 21H				;do it
	mov dx,offset INIT		;move the ending addr of the resident
					;portion of the code
	int     27H                     ;terminate and stay resident
BEGIN endp
;
beep proc near			;beep the speaker
	mov  bx,1000
	in   al,61h
	push ax
more:	and  al,0fch
	out  61h,al
	mov  cx,50
ab:     LOOP	ab
	or al,2
	out  61h,al
	mov  cx,50
bc:	loop bc
	dec  bx
	jnz  more
	pop  ax
	out  61h,al
	ret
beep	endp

cseg ends
end BEGIN
