;****	TRACE ON		; Debugging
;
; ----- COM-AND BBS file maintenance script (Files file)
;	Commenced: 11/90 R.McG
; -----------------------------------------------------------------------
;	Purpose:
;	   The script, named BBMAINT2.CMD, produces the main window for
;	Filedir functions of BBMAINT, and implements its functions.  It
;	is not directly callable itself.
; -----------------------------------------------------------------------
;	Usage:
;	   N99 -> Text attribute value (Setup by BBMAINT.CMD)
;	   N98 -> BBMAINT Mainline cursor position
;	   N97 -> BBMAINT Mainline cursor position
;	   N96 -> our mainline cursor position
;	   N95 -> our mainline cursor position
; -----------------------------------------------------------------------
;
;	This script is intended ONLY to be used for FCALL
;
	IF NOT FCALLED
	   WOPEN 10,10,13,70 (cont) NOFIEsc
	   ATSAY 10,12 (cont) " BBS Files "
	   ATSAY 11,12 (cont) " The script: "*"_SCRIPT"
	   ATSAY 12,12 (cont) " is not used by itself... it is called through BBMAINT"
	   ATSAY 13,26 (cont) " Press any key to continue "
	   ;
	   ;	Wait a keypress
	   ;
	   KEYGET S0		; Wait for any key
	   WCLOSE		; Close open window
	   EXIT 		; Terminate right here
	   ENDIF
	GOSUB FileFile		; Invoke function
	FRETURN 		; Return to caller
; -----------------------------------------------------------------------
; ----- NoFile:  Inform that there's no BBS-FIle file to modify
;
NoFile:
	WOPEN 10,10,13,70 (cont) NOFIEsc
	ATSAY 10,12 (cont) " BBS FileDir "
	ATSAY 11,12 (cont) " The file: "*S23&"\BBS-File"
	ATSAY 12,12 (cont) " does not exist.  Please create subdirectories first."
	ATSAY 13,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
NOFIEsc:
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: FileFile -> Update FILE directory
;
FileFile:
	GOSUB NewFile		; Create if not there
	IF NOT ISFILE S23&"\BBS-FIle"
	   GOSUB NoFile 	; Inform there's no file
	   RETURN		; .. so we can't continue
	   ENDIF
;
;	Open a window
;
	WOPEN 0,0 23,79 (defa) File_Esc
	ATSAY 0,2 (defa)   " BBS Files "
	ATSAY 23,25 (defa) " Press ESC to cancel BBMAINT "
;
;	Paint the window
;
FIFI100:
	CLEAR			; Clear window
	LOCATE 2,2

	MESS " 1) Add a file to the up/download list"
	MESS " 2) Delete a file from the list"
	MESS " 3) Modify a file's listing"
	MESS " 4) Print the file list"
	MESS " 5) View the file list"
	MESS " "
	MESS "Note: Alt-Q to edit a file"
	MESS "      Alt-F for a directory search"
	MESS "      Alt-F10 to shell to DOS"
	MESS " "
	MESS " "
	MESS " "
	MESS "Select item (carriage return = previous): "
	CURSOR N96,N95		; Read current cursor
;
;	Wait for entry, and interpret
;
FIFI200:
	LOCATE N96 N95		; Reposition cursor
	KEYGET S0		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB AddFile
	       ENDCASE
	  CASE "2"
	       GOSUB DelFile
	       ENDCASE
	  CASE "3"
	       GOSUB ModFile
	       ENDCASE
	  CASE "4"
	       GOSUB PrnFile
	       ENDCASE
	  CASE "5"
	       GOSUB ViewFile
	       GOTO FIFI100	; Repaint after this
	       ENDCASE
	  CASE "0d"             ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; and return to caller
	       ENDCASE
	  CASE "_NULL"          ; ESC -> Null
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  CASE "2100"           ; Alt-F
	       MANUAL "0x2100"  ; Perform Dir cmd
	       ENDCASE
	  CASE "1000"           ; Alt-Q
	       MANUAL "0x1000"  ; Edit a file
	       ENDCASE
	  CASE "7100"           ; Alt-F10
	       SHELL
	       DWINDOW 1,2,22,78; Reset dwindow after shell
	       LEGEND "_LEGEND" ; Redo the legend
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO FIFI200		; Repaint screen and ask again
;
;	End of Files procedure
;
File_Esc:
	S0 = ""                 ; Fake null entry
	RETURN			; Leave files routine
; -----------------------------------------------------------------------
; ----- AddFile:  Add a file to the File directory
;
AddFile:
	SET FLAG(0) OFF 	; Flag for ESCAPE
	WOPEN 10,10,16,75 (cont) ADFIEsc
	ATSAY 10,12 (cont) " BBS Files Add "
	ATSAY 11,12 (cont) "Enter the file to be added: "
	ATSAY 16,26 (cont) " Press ESC to cancel "
	;
	;    Wait a keypress
	;
	LOCATE 11,42
	GET S0 12		; get fname
	IF FLAG(0) GOTO ADFIEnd ; Exit if ESC hit
	LJ S0			; Left justify - don't upper case
	IF NULL S0 GOTO ADFIEnd ; get out on empty entry
	GOSUB LkpFile		; Lookup name in files file
	IF FOUND		; If its there we can't add it
	   WCLOSE		; Close open window
	   GOTO ModFI_Add	; Skip if file found
	   ENDIF
	S10 = S0		; Save File name
	GOTO ADFI100		; And branch around parallel code
;
;	Entry from ModFile... Nothing to modify
;
AddFI_Mod:
	WOPEN 10,10,16,75 (cont) ADFIEsc
	ATSAY 10,12 (cont) " BBS Files Add "
	ATSAY 11,12 (cont) "Enter the file to be added: "
	ATSAY 11,42 (cont) S0
	ATSAY 16,26 (cont) " Press ESC to cancel "
	S10 = S0		; Copy it for remainder
;
;	Look for the file - Add date and size to listing
;
ADFI100:
	FDATE S1 S23&"\"&S0     ; Ask for the file date (bbs-file subdir)
	IF FAILED GOTO ADFI110	; Skip if d.n.e
	S10(12:19) = S1 	; Place date of file
	FSIZE S1 S23&"\"&S0     ; Ask for the file size (bbs-file subdir)
	IF FAILED GOTO ADFI110	; Skip if d.n.e
	S10(21:27) = S1 	; Place size of file (7 digits)
	ATSAY 12,12 (cont) "File date and size:"
	ATSAY 12,42 (cont) S10(12:27)
	GOTO ADFI200		; SKip around error handler
;
;	File does not exist...
;
ADFI110:
	ATSAY 12,12 (cont) "File d.n.e. Add anyway (y/n): "
	LOCATE 12,42
	GET S0 1		; get resp
	IF FLAG(0) GOTO ADFIEnd ; Exit if ESC hit
	IF NULL S0 or NOT FIND "YN" S0(0)
	   SOUND 100,100	; Indicate displeasure
	   GOTO ADFI110 	; Try again
	   ENDIF
	IF FIND "N" S0(0)
	   WCLOSE		; Close window
	   GOTO AddFile 	; And try again
	   ENDIF
	S10(12:27) = "******** ********"
;
;	Ask for a comment field
;
ADFI200:
	ATSAY 13,12 (cont) "Comment text: "
	LOCATE 13,26
	GET S0 40		; get resp
	LJ S0			; Left justify
	IF FLAG(0) GOTO ADFIEnd ; Exit if ESC hit
	IF NULL S0
	   SOUND 100,100	; Indicate displeasure
	   GOTO ADFI200 	; Try again
	   ENDIF
	S10(28:79) = S0 	; Save comment text
;
;	Ask for privileged flag
;
ADFI250:
	ATSAY 14,12 (cont) "Priveleged access (y/n):  "
	LOCATE 14,42
	GET S0 1		; get resp
	IF FLAG(0) GOTO ADFIEnd ; Exit if ESC hit
	IF NULL S0 or NOT FIND "YN" S0(0)
	   SOUND 100,100	; Indicate displeasure
	   GOTO ADFI250 	; Try again
	   ENDIF
	IF FIND "Y" S0(0) S10(20:20) = "P" ; Save priveleged access
;
;	Ask for one more look
;
ADFI300:
	ATSAY 15,12 (cont) "OK to add this record?:   "
	LOCATE 15,42
	GET S0 1		; get resp
	IF FLAG(0) GOTO ADFIEnd ; Exit if ESC hit
	IF NULL S0 or NOT FIND "YN" S0(0)
	   SOUND 100,100	; Indicate displeasure
	   GOTO ADFI300 	; Try again
	   ENDIF
	IF FIND "N" S0(0)
	   WCLOSE		; Close window
	   GOTO AddFile 	; And try again
	   ENDIF
;
;	Write the record
;
	GOSUB AddFRec		; Write to Files file
;
;	End of add procedure
;
ADFIEnd:
	WCLOSE
ADFIEsc:
	SET FLAG(0) ON
	RETURN
; -----------------------------------------------------------------------
; ----- AddFRec:  Add a record to the file file...
;	.. S10 passes the record to be written
;
AddFRec:
	FOPENO S23&"\BBS-File" TEXT APPEND
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
	PRESERVE S10		; Preserve ^'s and !'s
	WRITE S10		; Write the record
	WRITE "!^Z"             ; And finish it
	FCLOSEO
	RETURN
; -----------------------------------------------------------------------
; ----- LkpFile:  Lookup a file in the BBS-File file
;	.. S0 passes the fname to be tested
;	.. S10 returns the record read
;
LkpFIle:
	FOPENI S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   SET FOUND OFF	; Not found
	   RETURN		; And we're done
	   ENDIF
;
;	Read loop
;
LOFI100:
	READ S10 80 N0		; Read a record
	IF EOF GOTO LOFI200	; Skip on EOF
	IF STRCMP S10(0:0) "<" GOTO LOFI110
	IF STRCMP S10(0:11) S0(0:11) GOTO LOFI300
;
;	Record longer than 80 chars
;
LOFI110:
	IF N0 LT 80 GOTO LOFI100; If exactly 80 rtnd, c/r wasn't read
	READ S10 80 N0		; Read remainder of rec
	GOTO LOFI110		; Read until less than 80
;
;	We have end-of-file - not found
;
LOFI200:
	SET FOUND OFF		; Indicate not found
	GOTO LOFIEnd
;
;	We have a hit - return found
;
LOFI300:
	SET FOUND ON		; Indicate found
;
;	And exit
;
LOFIEnd:
	FCLOSEI
	RETURN
; -----------------------------------------------------------------------
; ----- DelFile:  Delete a file  from Files file
;
DelFile:
	SET FLAG(0) OFF 	; Flag for ESCAPE
	WOPEN 10,10,15,70 (cont) DEFIEsc
	ATSAY 10,12 (cont) " BBS Files Delete "
	ATSAY 11,12 (cont) "Enter the file to be deleted: "
	ATSAY 15,26 (cont) " Press ESC to cancel "
	;
	;    Wait a keypress
	;
	LOCATE 11,42
	GET S0 12		; get resp
	IF FLAG(0) GOTO DEFIEnd ; Exit if ESC hit
	LJ S0			; Left justify - don't upper case
	IF NULL S0 GOTO DEFIEnd ; get out on empty entry
;
;	Open the File file and a temp copy file
;
	GOSUB DelFRec		; Try to delete a record
	IF FLAG(1) GOTO DEFIEnd ; Skip if record deleted
	ATSAY 12,12 (cont) "File not in listing...     "
	ATSAY 13,12 (cont) "Press any key to continue..."
	KEYGET S0
;
;	End of add procedure
;
DEFIEnd:
	WCLOSE
DEFIEsc:
	SET FLAG(0) ON
	RETURN
; -----------------------------------------------------------------------
; ----- DelFRec:  Delete a record from the Files file...
;	.. S0 passes the File name key
;	.. S1 destroyed in the process
;	.. FLAG(1) if rtn'd set, indicates record was FOUND
;
DelFRec:
;
;	Open the Files file and a temp copy file
;
	SET FLAG(1)  OFF	; Initialize for found flag
	FOPENI S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   GOTO DEFREnd 	; And we're done
	   ENDIF

	FOPENO S23&"\TempFile" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\TempFile"
	   GOSUB Error		; Report
	   GOTO DEFREnd 	; And we're done
	   ENDIF
	N10 = 0 		; Count recs written
;
;	Read records (40 chars at a time to allow PRESERVE)
;
DEFR100:
	READ S1 40 N0		; Read 1st 40 chars
	IF EOF GOTO DEFR300	; Skip on EOF
	IF STRCMP S1(0:11) S0(0:11) GOTO DEFR200
	INC N10
;
;	Copy the record read to the output file
;
DEFR110:
	PRESERVE S1		; Save !'s and ^'s
	WRITE S1		; Write text

	IF N0 LT 40		; If we wrote end of record
	   WRITE "!"            ; Finish w/cr/lf
	   GOTO DEFR100 	; And continue copying
	   ENDIF
	READ S1 40 N0		; Read remainder of rec
	IF NOT EOF GOTO DEFR110 ; Skip if not eof
	WRITE "!"               ; Finish record
	GOTO DEFR300		; End of file
;
;	We have a hit
;
DEFR200:
	SET FLAG(1) ON		; Flag we deleted item
	IF N0 LT 40 GOTO DEFR100
	READ S1 40 N0		; Read remainder of rec
	IF NOT EOF GOTO DEFR200 ; Skip if not found
;
;	We hit EOF - may or may not have found the target rec
;
DEFR300:
	IF NOT FLAG(1) GOTO DEFR400 ; skip if not found
	WRITE "^Z"              ; Finish ASCII file
	FCLOSEO 		; Close output
	FCLOSEI 		; Close input
	DELETE S23&"\BBS-File"  ; Delete original
	RENAME S23&"\TempFile" S23&"\BBS-File"
	IF ZERO N10 DELETE S23&"\BBS-File" ; Delete empty file
	GOTO DEFREnd
;
;	We hit EOF - we did not find the record
;
DEFR400:
	FCLOSEO 		; Close output
	FCLOSEI 		; Close input
	DELETE S23&"\TempFile"  ; Delete copy file
;
;	End of procedure...
;
DEFREnd:
	RETURN
; -----------------------------------------------------------------------
; ----- ModFile:  Modify a file in the Files file
;
ModFile:
	SET FLAG(0) OFF 	; Flag for ESCAPE
	WOPEN 10,10,17,75 (cont) MOFIEsc
	ATSAY 10,12 (cont) " BBS Files Modify "
	ATSAY 11,12 (cont) "Enter the fname to change: "
	ATSAY 17,26 (cont) " Press ESC to cancel "
	;
	;    Wait a keypress
	;
	LOCATE 11,42
	GET S0 12		; get resp
	IF FLAG(0) GOTO MOFIEnd ; Exit if ESC hit
	LJ S0			; Left justify - don't upper case
	IF NULL S0 GOTO MOFIEnd ; get out on empty entry
	GOSUB LkpFile		; Lookup File in Files file
	IF NOT FOUND		; If its there we can't add it
	   WCLOSE		; Close open window
	   GOTO AddFI_Mod	; Skip if NOT found
	   ENDIF
	GOTO MOFI100		; And branch around parallel code
;
;	Entry from AddFile... We have a rec in S10 - needs adding
;
ModFI_Add:
	WOPEN 10,10,17,75 (cont) MOFIEsc
	ATSAY 10,12 (cont) " BBS Files Modify "
	ATSAY 11,12 (cont) "Enter the File to change: "
	ATSAY 11,42 (cont) S0
	ATSAY 17,26 (cont) " Press ESC to cancel "
;
;	Display the original values (rtnd in S10 by LkpFile)
;
MOFI100:
	ATSAY 10,54 (cont) " Old vals "
	ATSAY 11,55 (cont) S10(0:11)
	ATSAY 12,55 (cont) S10(12:19)*" "*S10(21:27)
	ATSAY 14,26 (cont) S10(28:79)
	IF NOT NULL S10(20:20)
	   ATSAY 15,55 (cont) "y"
	ELSE
	   ATSAY 15,55 (cont) "n"
	   ENDIF
;
;	Look for the file - Add date and size to listing
;
	FDATE S1 S23&"\"&S0     ; Ask for the file date (bbs-file subdir)
	IF FAILED GOTO MOFI110	; Skip if d.n.e
	S10(12:19) = S1 	; Place date of file
	FSIZE S1 S23&"\"&S0     ; Ask for the file size (bbs-file subdir)
	IF FAILED GOTO MOFI110	; Skip if d.n.e
	S10(21:27) = S1 	; Place size of file (7 digits)
	ATSAY 12,12 (cont) "File date and size:"
	ATSAY 12,33 (cont) S10(12:19)*" "*S10(21:27)
	GOTO MOFI200		; SKip around error handler
;
;	File does not exist...
;
MOFI110:
	ATSAY 12,12 (cont) "File d.n.e. Add anyway (y/n): "
	LOCATE 12,42
	GET S0 1		; get resp
	IF FLAG(0) GOTO MOFIEnd ; Exit if ESC hit
	IF NULL S0 or NOT FIND "YN" S0(0)
	   SOUND 100,100	; Indicate displeasure
	   GOTO MOFI110 	; Try again
	   ENDIF
	IF FIND "N" S0(0)
	   WCLOSE		; Close window
	   GOTO ModFile 	; And try again
	   ENDIF
	S10(12:27) = "******** ********"
;
;	Ask for a comment field
;
MOFI200:
	ATSAY 13,12 (cont) "Comment text: "
	LOCATE 13,26
	GET S0 40		; get resp
	LJ S0			; Left justify
	IF FLAG(0) GOTO MOFIEnd ; Exit if ESC hit
	IF NULL S0		; If null entry...
	   ATSAY 13,26 (cont) S10(28:67)
	   GOTO MOFI250 	; Skip store
	   ENDIF
	S10(28:79) = S0 	; Save comment text
;
;	Ask for privileged flag
;
MOFI250:
	ATSAY 15,12 (cont) "Priveleged access (y/n):  "
	LOCATE 15,42
	GET S0 1		; get resp
	IF FLAG(0) GOTO MOFIEnd ; Exit if ESC hit
	IF NULL S0 ATSCR 13,55 1 S0 ; Read back previous value
	IF NOT FIND "YN" S0(0)  ; If not y/n
	   SOUND 100,100	; Indicate displeasure
	   GOTO MOFI250 	; Try again
	   ENDIF
	S10(20:20) = " "        ; Default no priv
	IF FIND "Y" S0(0)       ; If privilege 'y'
	   S10(20:20) = "P"     ; Set priveleged access
	   ENDIF
;
;	Ask for one more look
;
MOFI300:
	ATSAY 16,12 (cont) "OK to add this record?:   "
	LOCATE 16,42
	GET S0 1		; get file
	IF FLAG(0) GOTO MOFIEnd ; Exit if ESC hit
	IF NULL S0 or NOT FIND "YN" S0(0)
	   SOUND 100,100	; Indicate displeasure
	   GOTO MOFI300 	; Try again
	   ENDIF
	IF FIND "N" S0(0)
	   WCLOSE		; Close window
	   GOTO ModFile 	; And try again
	   ENDIF
;
;	Delete the previous value... and add the new
;	.. Could do a Delete/add but don't want file re-ordered
;
	GOSUB ModFRec		; Delete the previous key
	IF NOT FLAG(1)		; If not deleted
	   S0 = "Error modifying record for: "*S0
	   GOSUB Error		; Report
	   GOTO MOFIEnd 	; And we're done
	   ENDIF
;
;	End of add procedure
;
MOFIEnd:
	WCLOSE
MOFIEsc:
	SET FLAG(0) ON
	RETURN
; -----------------------------------------------------------------------
; ----- ModFRec:  Modify a record from the Files file...
;	.. S10 passes the new record (same file name key)
;	.. S1 destroyed in the process
;
ModFRec:
;
;	Open the Files file and a temp copy file
;
	SET FLAG(1)  OFF	; Initialize for found flag
	FOPENI S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   GOTO MOFREnd 	; And we're done
	   ENDIF

	FOPENO S23&"\TempFile" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\TempFile"
	   GOSUB Error		; Report
	   GOTO MOFREnd 	; And we're done
	   ENDIF
	N10 = 0 		; Count recs written
;
;	Read records (40 chars at a time to allow PRESERVE)
;
MOFR100:
	READ S1 40 N0		; Read 1st 40 chars
	IF EOF GOTO MOFR300	; Skip on EOF
	IF STRCMP S1(0:11) S10(0:11) GOTO MOFR200
	INC N10
;
;	Copy the record read to the output file
;
MOFR110:
	PRESERVE S1		; Save !'s and ^'s
	WRITE S1		; Write text

	IF N0 LT 40		; If we wrote end of record
	   WRITE "!"            ; Finish w/cr/lf
	   GOTO MOFR100 	; And continue copying
	   ENDIF
	READ S1 40 N0		; Read remainder of rec
	IF NOT EOF GOTO MOFR110 ; Skip if not eof
	WRITE "!"               ; Finish record
	GOTO MOFR300		; End of file
;
;	We have a match on the key.
;
MOFR200:
	SET FLAG(1) ON		; Flag we deleted item
	S1 = S10(0:39)		; Take 1st part of rec to write
	PRESERVE S1		; Save !s and ^s
	WRITE S1		; Write text

	LENGTH S10 N1		; Get new rec length
	IF N1 LT 40 GOTO MOFR210

	S1 = S10(40:79) 	; Take 2nd part of rec to write
	PRESERVE S1		; Save !s and ^s
	WRITE S1		; Write text
;
;	Finish the new record
;
MOFR210:
	WRITE "!"               ; Finish record
;
;	Finish reading the original record
;
MOFR220:
	IF N0 LT 40 GOTO MOFR100
	READ S1 40 N0		; Read remainder of rec
	IF NOT EOF GOTO MOFR220 ; Skip if not found
;
;	We hit EOF - may or may not have found the target rec
;
MOFR300:
	IF NOT FLAG(1) GOTO MOFR200 ; skip if not found
	WRITE "^Z"              ; Finish ASCII file
	FCLOSEO 		; Close output
	FCLOSEI 		; Close input
	DELETE S23&"\BBS-File"  ; Delete original
	RENAME S23&"\TempFile" S23&"\BBS-File"
	IF ZERO N10 DELETE S23&"\BBS-File" ; Delete empty file
;
;	End of procedure...
;
MOFREnd:
	RETURN
; -----------------------------------------------------------------------
; ----- PrnFIle:  Print a file listing
;
PrnFile:
	FOPENI S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
;
;	Initialize a counter
;
	N10 = 0 		; # Lines printed
	N11 = 1 		; Page number
;
;	Read loop
;
PRFI100:
	READ S10 80 N0		; Read a record
	IF EOF GOTO PRFI200	; Skip on EOF
	IF STRCMP S10(0:0) "*" GOTO PRFI120 ; skip comments
	IF ZERO N0 GOTO PRFI100 ; skip blank lines
;
;	Print a heading...
;
	IF N10 GT 0 and N10 LE 50 GOTO PRFI110
	PRINT "COM-AND Scripted BBS File list as of "*"_DATE"*", "*"_TIME"*"      Page "*N11*"^M^J"
	PRINT "From: "*"_IFILE"*"^M^J"
	PRINT "---------------------------------------------------------------------^M^J"
	PRINT "Name         Priv Date     Size    Description^M^J"
	PRINT "------------ ---- -------- ------- ----------------------------------^M^J"
	N10 = 0
	INC N11
;
;	Build a record and print it
;
PRFI110:
	S0 = S10(0:11)		; File name
	IF NOT NULL S10(20:20) S0(14:16) = "yes"
	S0(18:79)  = S10(12:19) ; Date
	S0(27:79)  = S10(21:27) ; size
	S0(35:79)  = S10(28:79) ; comment field
	PRESERVE S0
	PRINT S0
	PRINT "^M^J"            ; FInish line
	INC N10 		; COunt lines printed
;
;	Handle record longer than 80 chars
;
PRFI120:
	IF N0 LT 80 GOTO PRFI100; If exactly 80 rtnd, c/r wasn't read
	READ S10 80 N0		; Read remainder of rec
	GOTO PRFI120		; Read until less than 80
;
;	We have end-of-file
;
PRFI200:
	PRINT "^L"              ; Do a final top-of-form
;
;	And exit
;
PRFIEnd:
	FCLOSEI
	RETURN
; -----------------------------------------------------------------------
; ----- ViewFile: View a list of files
;
ViewFile:
	FOPENI S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error opening: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
;
;	Initialize a counter
;
	N10 = 0 		; # Lines printed
	N11 = 0 		; Page number
	SET FLAG(0) OFF 	; Initialize esc flag
	S11 = "_ONESC"
	ON ESCAPE GOSUB VIFIESC
;
;	Print a heading...
;
VIFI100:
	IF N10 GT 0 GOTO VIFI110
	CLEAR			; Clear the window
	ATSAY 1,2 (defa) "Name         Priv Date     Size    Description"
	ATSAY 2,2 (defa) "------------ ---- -------- ------- ----------------------------------"
	N10 = 3 		; Set starting line no
	INC N11 		; Set next page
;
;	Save the file position for the start of this page
;
	FSAVEI
	IF NOT SUCCESS
	   FSAVEI SHIFT 	; Save last 20 pos'ns
	   FSAVEI
	   ENDIF
;
;	Read loop
;
VIFI110:
	READ S10 80 N0		; Read a record
	IF EOF GOTO VIFI200	; Skip on EOF
	IF STRCMP S10(0:0) "*" GOTO VIFI120 ; skip comments
	IF ZERO N0 GOTO VIFI110 ; skip blank lines
;
;	Build a record and print it
;
	S0 = S10(0:11)		; File name
	IF NOT NULL S10(20:20) S0(14:16) = "yes"
	S0(18:74)  = S10(12:19) ; Date
	S0(27:74)  = S10(21:27) ; size
	S0(35:74)  = S10(28:79) ; comment field
	PRESERVE S0
	ATSAY N10,2 (defa) S0
	INC N10 		; COunt lines printed
;
;	Handle record longer than 80 chars
;
VIFI120:
	IF N0 LT 80 GOTO VIFI200; If exactly 80 rtnd, c/r wasn't read
	READ S10 80 N0		; Read remainder of rec
	GOTO VIFI120		; Read until less than 80
;
;	Look for end of screen/end of file
;
VIFI200:
	IF (NOT EOF) and N10 LT 21 GOTO VIFI100
	IF EOF
	   ATSAY 22,2 (defa) "End of file; Home (top), PgDn (forward), PgUp (back)"
	ELSE
	   ATSAY 22,2 (defa) "Page "*N11*"; Home (top), PgDn (forward), PgUp (back)"
	   ENDIF
;
;	Read a key and interpret
;
VIFI210:
	IF FLAG(0) RETURN	; End of routine when flag set
	KEYGET S1
	IF FLAG(0) RETURN	; End of routine when flag set
	SWITCH S1
	  CASE "4900"           ; Pgup
	    GOTO PgUp
	    ENDCASE
	  CASE "5100"           ; PgDn
	    GOTO PgDn
	    ENDCASE
	  CASE "4700"           ; Home
	    GOTO Home
	    ENDCASE
	  CASE "0D"             ; C/r
	    IF EOF GOTO VIFIEnd
	    GOTO PgDn
	    ENDCASE
	  CASE "2100"           ; Alt-F
	    MANUAL "0x2100"     ; Perform Dir cmd
	    ENDCASE
	  CASE "1000"           ; Alt-Q
	    MANUAL "0x1000"     ; Edit a file
	    ENDCASE
	  CASE "7100"           ; Alt-F10
	    SHELL
	    DWINDOW 1,2,22,78	; Reset dwindow after shell
	    LEGEND "_LEGEND"    ; Redo the legend
	    ENDCASE
	  DEFAULT
	    MESS S1
	    SOUND 100,100
	    ENDCASE
	  ENDSWITCH
	GOTO VIFI210
;
;	Page up (go backwards)
;
PgUp:
	N10 = 0 		; Clear line ctr
	FRESTOREI		; Backup current pg
	N11 = N11-1		; Reset Page # for redisplay
	FRESTOREI		; Backup one more
	IF NOT SUCCESS
	   SOUND 200,100	; Indicate problem
	   GOTO Home
	   ENDIF
	N11 = N11-1		; Reset Page # for redisplay
	GOTO VIFI100
;
;	Home (go to top)
;
Home:
	N10 = 0 		; Clear line ctr
	N11 = 0 		; Set new pg number
	FSAVEI CLEAR		; Clear saved pages
	REWIND			; Rewind input
	GOTO VIFI100
;
;	Page down (go forwards)
;
PgDn:
	IF EOF GOTO Home	; Wrap to home at EOF
	N10 = 0 		; Clear line ctr
	GOTO VIFI100
;
;	And exit
;
VIFIEnd:
	FCLOSEI
	RETURN
;
;	Escape entered
;
VIFIESC:
	SET FLAG(0) ON
	ON ESCAPE GOSUB S11	; Restore previous ON ESC
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: NewFile -> Create a new BBS-File file
;
NewFile:
	IF ISFILE S23&"\BBS-File" RETURN
	FOPENO S23&"\BBS-File" TEXT
	IF NOT SUCCESS RETURN	; Open failed
	WRITE "!^Z"             ; Make it empty
	FCLOSEO 		; Done with it
	RETURN
; -----------------------------------------------------------------------
; ----- Error:	Open a window, display a message, and wait for keypress
;	S0 passes the error message
;
Error:
	WOPEN 10,10,12,70 (cont) Err_Esc
	ATSAY 10,12 (cont) " Error "
	ATSAY 11,12 (cont) S0(0:55); Max msg width 55 chars
	ATSAY 12,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
Err_Esc:
	RETURN
