; ----- DSZUP: Invoke DSZ to upload.
; ----------------------------------------------------------------
;	Note: This script invokes DSZ, using the current comm port
;	settings.  Note that the 'sz' sent to DSZ invokes a ZMODEM
;	download.  Change 'sz' to 'rb' for YMODEM-BAtch...
; ----------------------------------------------------------------
;
;	Get the file spec to upload
;
	GOSUB Get_Name		; Read file name into S0
	IF FAILED		; If ESC pressed
	   EXIT 		; Stop here
	   ENDIF
;
;	Set-up and run DSZ
;
	COMPARMS S1		; read current settings
	S2 =  "DSZ.COM port " * S1(14:14) * " sz " * S0 ; e.g. "DSZ port 2 sz"
	RUN S2			; Load and run DSZ
;
;	Play a tune to signal completion
;
	IF SUCCESS
	   PLAY "T200MNO2G24O3C24E24G8G24G24G24G8E8E24E24E24E8C8E8C8O2G8"
	ELSE
	   PLAY "ms t250 o2 c2d8e-cp4 >c2d8e-cp4g-1 p2"
	ENDIF
	EXIT
;
; ----- Subroutine: Open a window and ask for a file name
;	SUCCESS/Failed returned to indicate ESCape
;	S0 returns the name
;
Get_Name:
	WOPEN 10 10 13 70 (Default) ESC
	ATSAY 10 ,12 (default)	" DSZ upload "
	ATSAY 11 ,11 (default)	" Specify the file name:"
	ATSAY 13  30 (default) " Press ESC to exit "
	ATGET 12, 12 (default) 54 S0
	WCLOSE
	;
	;	If null response, return failed
	;
	SET SUCCESS ON		; Default return
	LJ S0			; Left justify
	IF NULL S0
	   SET SUCCESS OFF
	   ENDIF
	RETURN
	;
	;	ESC hit during entry
	;
ESC:
	S0 = ""                 ; Make a null return
	RETURN
