{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$R-}    {Range checking off}
{$M 4096,8192,8192}

program transmit;

{  This file transmission package by was written by Peter Summers.
   The program (including source) may be distributed freely, but
   copyright is retained by the Cardiology Department at Royal Melbourne
   Hospital.    }

Uses
  Dos,
  Crt,
  Mufasync;

const
  default     = -1;
  defportnum  = 1;
  defbaudrate = 9600;

var
  portnum,baudrate : word;
  code,time        : integer;
  ch,rcvd          : char;
  infile           : text;
  checking         : boolean;

begin

  checkbreak:=false;

  if paramcount=0 then
    begin
       writeln(^M+^J+'File transmission utility with echo-back error detection.'+^M+^J);
       writeln('TRANSMIT <filename> [<port> [<speed> [nocheck]]]');
       halt(1);
    end
  else
    begin
      assign(infile,paramstr(1));
      reset(infile);
      if IOresult<>0 then
        begin
          writeln(^M+^J+'Error opening file "'+paramstr(1),'".');
          sound(100);
          delay(1000);
          nosound;
          halt(1);
        end;
    end;

  if paramcount>1 then
    val(paramstr(2),portnum,code)
  else
    portnum:=defportnum;

  Async_Init(default,default,default,default,default);
  Async_Setup_Port(portnum,default,default,default);

  if paramcount>2 then
    val(paramstr(3),baudrate,code)
  else
    baudrate:=defbaudrate;

  if not(Async_Open(portnum,baudrate,'N',8,1)) then
    begin
      write('Can''t find port number ',portnum,'.');
      halt(1);
    end;

  Async_Clear_Errors;

  checking:=(paramcount<3) and not
    ((paramstr(4)='NOCHECK') or (paramstr(4)='nocheck'));

  while not eof(infile) do
    begin
      read(infile,ch);
      if ord(ch) in [13,32..126] then
        begin
          Async_Send(ch);
          time:=0;
          repeat
            if Async_Receive(rcvd) then
              begin
                if ord(rcvd) in [10,13,32..126] then write(rcvd);
                if rcvd<>ch then time:=0;
              end
            else
              begin
                delay(1);
                time:=time+1;
              end;
          until (rcvd=ch) or (time=10000);

          if keypressed and (readkey=chr(27)) then
            begin
              write(^M+^J+'Escape key pressed, transfer terminated.'+^M+^J);
              close(infile);
              Async_Close(false);
              halt(2);
            end;

          if (rcvd<>ch) and checking then
            begin
              write(^M+^J+'Incorrect echo-back, transfer terminated.'+^M+^J);
              sound(100);
              delay(1000);
              nosound;
              close(infile);
              Async_Close(false);
              halt(3);
            end;

        end;
    end;

  close(infile);
  Async_Close(false);
end.
