page	58,132
TITLE	RS203	6-23-86	[10-1-91]

LF	EQU	0AH
CR	EQU	0DH

CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	ORG	100H

RS_100	proc	near
	JMP	RS_532

;COM1 port address table
com1tbl_103	DW	03F8H	;[BX]	;UART base
		dw	03F9H	;[BX+2]	;base+1 IER
		dw	03F9H	;[BX+4]	;base+1 IER
		dw	03FBH	;[BX+6]	;base+3, LCR
		DW	03FCH	;[BX+8]	;base+4, MCR
		dw	03FDH	;[BX+0A];base+5, LSR
		dw	03FEH	;[BX+0C];base+6, MSR
;COM2 port address table
com2tbl_111	DW	02F8H,2 DUP(02F9H),02FBH
		DW	02FCH,02FDH,02FEH

bauddiv_11F	DW	0		;baudrate divisor
ier_121		db	0		;Interrupt Enable Register status
lcr_122		db	0		;Line Control Register status
mcr_123		db	0		;Modem Control Register status
lsr_124		db	0		;Line Status Register status
msr_125		db	0		;Modem Status Register status
lcr_126		db	0		;LCR status w/8-bit OR'ed
		db	0

vidpage_128	db	0		;current video mode
buff_129	db	6 dup(0)
numbuff_12F	DB	'      $'

msg_136	DB	'                RS  $'
	DB	'Copyright Fred E. Davis 1986$'
	DB	'    Ver. 2.03$'
com1$176	DB	CR,'COM1:$'
com2$17D	DB	CR,'COM2:$'
msg_184	DB	' not installed!$'
msg_194	DB	CR,LF,'A. Protocol:                    B. Handshake Status:'
	db	CR,LF,'  1. Data Bits: $'
msg_1DD	DB	'            1. DTR Out: $'
msg_1F6	DB	CR,LF,'  2. Stop Bits: $'
msg_209	DB	'            2. RTS Out: $'
msg_222	DB	CR,LF,'  3. Parity   : $'
msg_235	DB	'            3. CTS In : $'
msg_24E	DB	CR,LF,'  4. Rate     : $'
msg_261	DB	'            4. DSR In : $'
msg_27A	DB	CR,LF,'  5. Stick    : $'
msg_28D	DB	'            5. CD In  : $'
msg_2A6	DB	CR,LF,'  6. Break    : $'
msg_2B9	DB	'            6. RI In  : $'
msg_2D2	DB	CR,LF,CR,LF
	DB	'C. Line Status:                 D. Error Status:',CR,LF
	DB	'  1. Receive Buffer : $'
msg_31F	DB	'      1. Overrun: $'
msg_332	DB	CR,LF,'  2. Transmit Buffer: $'
msg_34B	DB	'      2. Parity : $'
msg_35E	DB	CR,LF,'  3. Break Status   : $'
msg_377	DB	'      3. Frame  : $'
msg_38A	DB	CR,LF,'  4. Loop Back      : $'
msg_3A3	DB	CR,LF,CR,LF
	DB	'E. Interrupt Status:'
	db	CR,LF,'  1. Output      : $'
msg_3D1	DB	CR,LF,'  2. Data Ready  : $'
msg_3E7	DB	CR,LF,'  3. Xmit Empty  : $'
msg_3FD	DB	CR,LF,'  4. Line Status : $'
msg_413	DB	CR,LF,'  5. Modem Status: $'
crlf_429	DB	CR,LF,'$'
msg_42C		DB	'1     $'
msg_433		DB	'2     $'
msg_43A		DB	'5     $'
msg_441		DB	'6     $'
msg_448		DB	'7     $'
msg_44F		DB	'8     $'
odd$456		DB	'odd   $'
even$45D	DB	'even  $'
none$464	DB	'none  $'
norm$46B	DB	'normal$'
set$472		DB	'set   $'

baudtbl_479	label	byte
	DB	'50    $'
	dw	0900H		;DB	0,9
	db	'75    $'
	dw	0600H		;DB	0,6
	db	'110   $'
	dw	0417H		;DB	17H,4
	db	'134.5 $'
	dw	0359H		;DB	59H,3
	db	'150   $'
	dw	0300H		;DB	0,3
	db	'300   $'
	dw	0180H		;DB	80H,1
	db	'600   $'
	dw	00C0H		;DB	0C0H,0
	db	'1200  $'
	dw	0060H		;DB	60H,0
	db	'1800  $'
	dw	0040H		;DB	40H,0
	db	'2000  $'
	dw	003AH		;DB	3AH,0
	db	'2400  $'
	dw	0030H		;DB	30H,0
	db	'3600  $'
	dw	0020H		;DB	20H,0
	db	'4800  $'
	dw	0018H		;DB	18H,0
	db	'7200  $'
	dw	0010H		;DB	10H,0
	db	'9600  $'
	dw	000CH		;DB	0CH,0

msg_500	DB	'fast!!$'
msg_507	DB	'empty $'
msg_50E	DB	'full  $'
msg_515	DB	'low   $'
msg_51C	DB	'high  $'
msg_523	DB	'enable$'
msg_52A	DB	'disable$'

RS_100	endp

;L0532	  RS_100 CJ
RS_532	proc	near
	MOV	AH,0FH
	INT	10H
	MOV	vidpage_128,BH			;save current video mode

	MOV	DX,OFFSET crlf_429		;CR,LF,'$'
	MOV	AH,9
	INT	21H
	MOV	SI,OFFSET msg_136		;'copyright ...'
	MOV	BL,0FH
	CALL	PrStr_93B
	MOV	BL,9
	CALL	PrStr_93B
	MOV	BL,7
	CALL	PrStr_93B
	MOV	DX,OFFSET crlf_429		;CR,LF,'$'
	MOV	AH,9
	INT	21H
	MOV	AH,9
	MOV	AL,20H			;display space
	MOV	CX,4FH			;this many of them
	MOV	BH,vidpage_128		;display page
	MOV	BL,7			;attribute
	INT	10H			;via BIOS

	MOV	DI,81H			;PSP cmdline
	MOV	AL,20H	;' '		;gobble leading spaces
	MOV	CX,44H			;max cmdline length
	CLD
	REPZ	SCASB
	MOV	AL,[DI-1]		;get last pre-space char
	JCXZ	Use_COM1_585		;zeroed out cmdline, use COM1

	CMP	AL,0DH			;No cmd parm ...
	JZ	Use_COM1_585		;.. so use COM1
	CMP	AL,31H	;'1'		;COM1?
	JZ	Use_COM1_585		;yep, use COM1
	CMP	AL,32H	;'2'		;COM2?
	JZ	Use_COM2_58E		;yep

;Use default COM1
Use_COM1_585:
	MOV	BX,OFFSET com1tbl_103	;use COM1's table
	MOV	DX,OFFSET com1$176	;CR,'COM1:$'
	JMP	SHORT	Skp594

;	NOP
Use_COM2_58E:
	MOV	BX,OFFSET com2tbl_111	;use COM2's table
	MOV	DX,OFFSET com2$17D	;CR,'COM2:$'

Skp594:	MOV	AH,9			;display "COMn:"
	INT	21H

	MOV	DX,[BX+6]		;base+3, LCR Line Control Register
	IN	AL,DX
	OR	AL,80H			;turn on 8-bit
	MOV	lcr_126,AL		;save it
	OUT	DX,AL

	MOV	AH,AL
	MOV	CX,03E8H		;delay value
Lup5A7:	LOOP	Lup5A7			;delay a bit
	IN	AL,DX
	CMP	AH,AL
	JNZ	Not_Installed_5CE	;'Not installed', die

	MOV	DX,[BX]			;UART base
	IN	AL,DX			;get baudrate divisor lsb
	MOV	byte ptr bauddiv_11F,AL	;save
	INC	DX			;bump to divisor msb
	IN	AL,DX
	MOV	byte ptr bauddiv_11F+1,AL	;save it
	MOV	DX,[BX+6]		;base+3, LCR
	MOV	AL,lcr_126		;saved LCR status w/8-bit OR'ed
	AND	AL,7FH			;mask that bit off again
	OUT	DX,AL			;out the port

	MOV	AH,AL
	MOV	CX,03E8H		;delay value
Lup5C7:	LOOP	Lup5C7			;delay a bit
	IN	AL,DX			;read the port
	CMP	AH,AL			;match?
	JZ	Skp5F3			;yep, continue

Not_Installed_5CE:
	MOV	BL,0CH			;video attrib
	OR	BL,80H			;mask for non-blinking?
	MOV	SI,OFFSET msg_184	;'not installed!'
	CALL	PrStr_93B
	MOV	DX,OFFSET crlf_429	;CR,LF,'$'
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET crlf_429	;CR,LF,'$'
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET crlf_429	;CR,LF,'$'
	MOV	AH,9
	INT	21H
	MOV	AL,1			;ERRORLEVEL 1
	JMP	Term_937		;terminate

Skp5F3:
	MOV	DX,[BX+4]		;base+1, IER Interrupt Enable Register
	IN	AL,DX
	MOV	ier_121,AL		;save IER status
	MOV	DX,[BX+6]		;base+3, LCR
	IN	AL,DX
	MOV	lcr_122,AL		;save LCR status
	MOV	DX,[BX+8]		;base+4, MCR Modem Control Register
	IN	AL,DX
	MOV	mcr_123,AL		;save MCR status
	MOV	DX,[BX+0AH]		;base+5 LSR Line Status Register
	IN	AL,DX
	MOV	lsr_124,AL		;save LSR status
	MOV	DX,[BX+0CH]		;base+6 MSR Modem Status Register
	IN	AL,DX
	MOV	msr_125,AL		;save MSR status

	MOV	DX,OFFSET msg_194	;CR,LF,'A. Protocol:
					;B. Handshake Status:'
					;CR,LF,'  1. Data Bits: $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122
	AND	AL,3			;mask to data bits
	JZ	Skp63E			;0 = 5
	DEC	AL
	JZ	Skp638			;1 = 6
	DEC	AL
	JZ	Skp632			;2 = 7
	MOV	DX,OFFSET msg_44F	;'8     $' bit data
	JMP	SHORT	Pr_641

;	NOP
Skp632:	MOV	DX,OFFSET msg_448	;'7     $' bit data
	JMP	SHORT	Pr_641

;	NOP
Skp638:	MOV	DX,OFFSET msg_441	;'6     $' bit data
	JMP	SHORT	Pr_641

;	NOP
Skp63E:	MOV	DX,OFFSET msg_43A	;'5     $' bit data
Pr_641:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_1DD	;'            1. DTR Out: $'
	MOV	AH,9
	INT	21H
	MOV	AL,mcr_123		;MCR status
	AND	AL,1			;mask for DTR
	JNZ	Skp659			;1 = high
	 MOV	DX,OFFSET msg_515	;'low   $'
	 JMP	SHORT	Pr_65C

;	NOP
Skp659:	MOV	DX,OFFSET msg_51C	;'high  $'
Pr_65C:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_1F6	;CR,LF,'  2. Stop Bits: $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122
	AND	AL,4			;mask for stop bits
	JNZ	Skp674			;1 = 2 stop bits
	 MOV	DX,OFFSET msg_42C	;'1     $' stop bits
	 JMP	SHORT	Pr_677

;	NOP
Skp674:	MOV	DX,OFFSET msg_433	;'2     $' stop bits
Pr_677:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_209	;'            2. RTS Out: $'
	MOV	AH,9
	INT	21H
	MOV	AL,mcr_123		;MCR status
	AND	AL,2			;mask for RTS
	JNZ	Skp68F			;non-0 = high
	 MOV	DX,OFFSET msg_515	;'low   $' RTS
	 JMP	SHORT	Pr_692

;	NOP
Skp68F:	MOV	DX,OFFSET msg_51C	;'high  $' RTS
Pr_692:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_222	;CR,LF,'  3. Parity   : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122
	AND	AL,8			;mask for parity bit
	JZ	Pr_6BA			;none
	MOV	AL,lcr_122
	AND	AL,10H			;mask for parity bit
	JNZ	Skp6B1
	 MOV	DX,OFFSET odd$456	;'odd   $'
	 JMP	SHORT	Pr_6B4

;	NOP
Skp6B1:	MOV	DX,OFFSET even$45D	;'even  $'
Pr_6B4:	MOV	AH,9
	INT	21H
	JMP	SHORT	Skp6C1

Pr_6BA:	MOV	DX,OFFSET none$464	;'none  $'
	MOV	AH,9
	INT	21H

Skp6C1:	MOV	DX,OFFSET msg_235	;'            3. CTS In : $'
	MOV	AH,9
	INT	21H

	MOV	AL,msr_125		;MSR status
	AND	AL,10H			;mask to CTS bit
	JNZ	Skp6D5			;non-0 = high
	 MOV	DX,OFFSET msg_515	;'low   $' CTS In
	 JMP	SHORT	Pr_6D8

;	NOP
Skp6D5:	MOV	DX,OFFSET msg_51C	;'high  $' CTS in
Pr_6D8:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_24E	;CR,LF,'  4. Rate     : $'
	MOV	AH,9
	INT	21H

	MOV	AX,bauddiv_11F		;baudrate divisor
	MOV	DI,7
	MOV	CX,10H			;total 16 records
Lup6EC:	CMP	AX,word ptr [DI+baudtbl_479]
	JZ	GotBaud_6F9
	ADD	DI,9			;next record
	LOOP	Lup6EC
	JCXZ	No_TableBaud_709

GotBaud_6F9:
	MOV	AX,DI			;record end
	SUB	AX,7			;back up to the string
	ADD	AX,OFFSET baudtbl_479	;table start
	MOV	DX,AX
	MOV	AH,9
	INT	21H
	JMP	SHORT	Check_DSR_763	;skip to DSR check

;Baudrate wasn't in our table
No_TableBaud_709:
	CMP	AX,2			;divisor < 2?
	JB	FastBaud_75C		;yep, just say fast!!

;Compute and display the raw baudrate
	PUSH	BX			;dumb
	PUSH	CX
	PUSH	DX
	PUSH	DI

	MOV	BX,AX			;divisor into BX
	MOV	CL,4
	SHL	BX,CL			;*16
	MOV	DX,1CH			;long division
	MOV	AX,2000H
	DIV	BX

	MOV	DI,OFFSET buff_129	;Asciify the result
	XOR	BX,BX			;buffer base
	MOV	CX,6			;6-byte buffer
Lup728:	MOV	BYTE PTR [BX+DI],0	;initialize buffer
	INC	BX
	LOOP	Lup728

	XCHG	BX,DI			;BX -> buffer start
	DEC	BX			;back up 1
	MOV	DI,0AH			;10 constant for dividing
Lup734:	XOR	DX,DX			;clear overflow
	DIV	DI			;/10
	INC	BX			;bump buffer ptr
	INC	CX			;bump digit counter
	MOV	[BX],DL			;stuff Ascii char in buffer
	OR	AX,AX			;done?
	JNZ	Lup734			;nope

	XOR	DI,DI			;string buffer base offset
Lup742:	MOV	AL,[BX]			;Ascii char
	OR	AL,30H			;mask to uppercase?
	MOV	[DI+numbuff_12F],AL	;stuff in blank string
	DEC	BX
	INC	DI
	DEC	CX
	JNZ	Lup742

	MOV	DX,OFFSET numbuff_12F	;display ASCII number
	MOV	AH,9
	INT	21H

	POP	DI
	POP	DX
	POP	CX
	POP	BX
	JMP	SHORT	Check_DSR_763	;skip to DSR check

FastBaud_75C:
	MOV	DX,OFFSET msg_500	;'fast!!$'
	MOV	AH,9
	INT	21H

Check_DSR_763:
	MOV	DX,OFFSET msg_261	;'            4. DSR In : $'
	MOV	AH,9
	INT	21H
	MOV	AL,msr_125		;MSR status
	AND	AL,20H			;mask to MSR bit
	JNZ	Skp777			;non-0 = high
	 MOV	DX,OFFSET msg_515	;'low   $'
	 JMP	SHORT	Pr_77A

;	NOP
Skp777:	MOV	DX,OFFSET msg_51C	;'high  $'
Pr_77A:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_27A	;'CR,LF,'  5. Stick    : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122		;get LCR status
	AND	AL,20H			;mask to "stick" status
	JNZ	Skp792			;non-0 means "set"
	 MOV	DX,OFFSET norm$46B	;'normal$'
	 JMP	SHORT	Pr_795

;	NOP
Skp792:	MOV	DX,OFFSET set$472	;'set   $'
Pr_795:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_28D	;'            5. CD In  : $'
	MOV	AH,9
	INT	21H
	MOV	AL,msr_125		;MSR status
	AND	AL,80H			;mask to Carrier Detect status
	JNZ	Skp7AD			;non-0 means high
	 MOV	DX,OFFSET msg_515	;'low   $'
	 JMP	SHORT	Pr_7B0

;	NOP
Skp7AD:	MOV	DX,OFFSET msg_51C	;'high  $'
Pr_7B0:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_2A6	;CR,LF,'  6. Break    : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122		;get LCR status
	AND	AL,40H			;mask break bit
	JNZ	Skp7C8			;non-0 = set
	 MOV	DX,OFFSET norm$46B	;'normal$'
	 JMP	SHORT	Pr_7CB

;	NOP
Skp7C8:	MOV	DX,OFFSET set$472	;'set   $'
Pr_7CB:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_2B9	;'            6. RI In  : $'
	MOV	AH,9
	INT	21H
	MOV	AL,msr_125		;MSR status
	AND	AL,40H			;mask Ring Indicator bit
	JNZ	Skp7E3
	 MOV	DX,OFFSET msg_515	;'low   $'
	 JMP	SHORT	Pr_7E6

;	NOP
Skp7E3:	MOV	DX,OFFSET msg_51C	;'high  $'
Pr_7E6:	MOV	AH,9
	INT	21H

;'C. Line Status:                 D. Error Status:',CR,LF
;'  1. Receive Buffer : $'
	MOV	DX,OFFSET msg_2D2
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,1			;mask Receive Buffer status byte
	JNZ	Skp7FE			;non-0 = full
	 MOV	DX,OFFSET msg_507	;'empty $'
	 JMP	SHORT	Pr_801

;	NOP
Skp7FE:	MOV	DX,OFFSET msg_50E	;'full  $'
Pr_801:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_31F	;'      1. Overrun: $'
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,2			;mask Overrun error bit
	JNZ	Skp819
	 MOV	DX,OFFSET none$464	;'none  $'
	 JMP	SHORT	Pr_81C

;	NOP
Skp819:	MOV	DX,OFFSET set$472	;'set   $'
Pr_81C:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_332	;CR,LF,'  2. Transmit Buffer: $'
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,20H			;mask Transmit Buffer status bit
	JNZ	Skp834			;non-0 = empty
	 MOV	DX,OFFSET msg_50E	;'full  $'
	 JMP	SHORT	Pr_837

;	NOP
Skp834:	MOV	DX,OFFSET msg_507	;'empty $'
Pr_837:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_34B	;'      2. Parity : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,4			;mask Parity error bit
	JNZ	L084F
	 MOV	DX,OFFSET none$464	;'none  $'
	 JMP	SHORT	L0852

;	NOP
L084F:	MOV	DX,OFFSET set$472	;'set   $'
L0852:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_35E	;'  3. Break Status   : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,10H			;mask Break Status bit
	JNZ	L086A
	 MOV	DX,OFFSET none$464	;'none  $'
	 JMP	SHORT	L086D

;	NOP
L086A:	MOV	DX,OFFSET set$472	;'set   $'
L086D:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_377	;'      3. Frame  : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lsr_124		;LSR status
	AND	AL,8			;mask Frame error bit
	JNZ	L0885
	 MOV	DX,OFFSET none$464	;'none  $'
	 JMP	SHORT	L0888

;	NOP
L0885:	MOV	DX,OFFSET set$472	;'set   $'
L0888:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_38A	;'  4. Loop Back      : $'
	MOV	AH,9
	INT	21H
	MOV	AL,mcr_123		;MCR status
	AND	AL,10H			;mask Loop Back error bit
	JNZ	L08A0
	 MOV	DX,OFFSET norm$46B	;'normal$'
	 JMP	SHORT	L08A3

;	NOP
L08A0:	MOV	DX,OFFSET set$472	;'set   $'
L08A3:	MOV	AH,9
	INT	21H

;"E. Interrupt Status:'
	MOV	DX,OFFSET msg_3A3	;CR,LF,'  1. Output      : $'
	MOV	AH,9
	INT	21H
	MOV	AL,mcr_123		;MCR status
	AND	AL,8			;mask Output Int Status bit
	JNZ	L08BB			;non-0 = disabled
	 MOV	DX,OFFSET msg_523	;'enable$'
	 JMP	SHORT	L08BE

;	NOP
L08BB:	MOV	DX,OFFSET msg_52A	;'disable$'
L08BE:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3D1	;'  2. Data Ready  : $'
	MOV	AH,9
	INT	21H
	MOV	AL,ier_121		;Interrupt Enable Status
	AND	AL,1			;mask to Data Ready
	JNZ	L08D6			;non-0 = enabled
	 MOV	DX,OFFSET msg_52A	;'disable$'
	 JMP	SHORT	L08D9

;	NOP
L08D6:	MOV	DX,OFFSET msg_523	;'enable$'
L08D9:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3E7	;'  3. Xmit Empty  : $'
	MOV	AH,9
	INT	21H
	MOV	AL,ier_121		;IER status
	AND	AL,2			;mask to Xmit buffer empty
	JNZ	L08F1			;non-0 = enabled
	 MOV	DX,OFFSET msg_52A	;'disable$'
	 JMP	SHORT	L08F4

;	NOP
L08F1:	MOV	DX,OFFSET msg_523	;'enable$'
L08F4:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3FD	;'  4. Line Status : $'
	MOV	AH,9
	INT	21H
	MOV	AL,ier_121		;IER status
	AND	AL,4			;mask Line Status int status
	JNZ	L090C
	 MOV	DX,OFFSET msg_52A	;'disable$'
	 JMP	SHORT	L090F

;	NOP
L090C:	MOV	DX,OFFSET msg_523	;'enable$'
L090F:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_413	;'  5. Modem Status: $'
	MOV	AH,9
	INT	21H
	MOV	AL,ier_121		;IER status
	AND	AL,8			;mask Modem Status int status
	JNZ	L0927
	 MOV	DX,OFFSET msg_52A	;'disable$'
	 JMP	SHORT	L092A

;	NOP
L0927:	MOV	DX,OFFSET msg_523	;'enable$'
L092A:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET crlf_429	;CR,LF,'$'
	MOV	AH,9
	INT	21H

	MOV	AL,0			;ERRORLEVEL 0
Term_937:
	MOV	AH,4CH			;terminate, ERRORLEVEL in AL
	INT	21H

RS_532	endp

;BL : display attribute
;DS:SI -> $-terminated string to display

PrStr_93B	proc	near
	LODSB
	CMP	AL,24H	;'$'
	JZ	L0957

	MOV	BH,vidpage_128	;original display page
	MOV	CX,1		;1 copy
	MOV	AH,9		;write char & attrib
	INT	10H		;via BIOS
	MOV	AH,3		;read cursor psn
	INT	10H
	INC	DL		;bump to next column
	MOV	AH,2		;set cursor psn
	INT	10H
	JMP	PrStr_93B	;loop

L0957:	RET

PrStr_93B	endp

	DB	28H DUP(0)

CSEG	ENDS
	END	RS_100
