	PAGE	62,132
	TITLE	TDD VERSION 5.6 BY JOHN W. SPALDING 2/86

;------------------------------ DISCLAIMER ------------------------------------

;This program is in the public domain.	As such, it is distributed without
;warranty of any kind.	SOLE RESPONSIBILITY FOR DETERMINING ITS USEFULNESS
;FOR ANY PARTICULAR PURPOSE, SAFETY TO COMPUTER EQUIPMENT, AND LEGAL CONNECTION
;TO THE PUBLIC TELEPHONE SYSTEM RESTS WITH THE END USER.

;--------------------------- END OF DISCLAIMER --------------------------------

;This program allows an IBM PC to be used as a Telecommunications Device for
;the Deaf (TDD).  The cassette port of the PC must be coupled to the telephone
;line by a modified telephone amplifier or other suitable means.  Note that
;the modem function is provided by this program, not the coupling device.

;The cassette port pinouts, as described in the PC Technical Reference
;Manual from IBM are as follows:

;	1 and 3: Relay contacts normally used for cassette motor control.
;		Used here for pulse dialing.

;	2:	Ground.

;	4:	Data in (received data) rated at +/- 13v max.

;	5:	Data out (transmitted data) rated at .075 vdc, may
;		be jumpered to .68vdc

;NOTE: This version is coded to produce an .EXE file to simplify installation.
;The following commands should be issued to assemble and link the program:

;		MASM TDD54;
;		LINK TDD54;
;		ERASE TDD54.OBJ

;If the FIGSTTY EQU is changed to TRUE, uppercase ASCII characters will
;be mapped to TTY FIGS characters, for example, you can send "#" by
;typing SHIFT-H or by typing "#".

;Linefeeds may be sent by typing ;CTRL-J; however the program
;will insert them automatically as needed.

;version 5.6 changes 2/86

;	- some restructuring -- main loop deals in ASCII, not BAUDOT

;version 5.5 changes 1/86

;	- upper case ASCII characters are no longer mapped to TTY FIGS,
;	  but this can be turned back on by setting FIGSTTY to TRUE.

;	- runs in whatever video mode is in effect, and will work
;	  correctly in 40 column mode.

;	- after disconnect, program returns to the phone number
;	  prompt instead of terminating.

;	- eliminated 2 second wait when no phone number is entered.

;	- all keyboard/screen I/O changed to DOS calls, except the
;	  <SIGNAL> display, to allow continuous printing via ^P.

;	- INT 23H (^C) and INT 24H (fatal error) handlers added,
;	  ROM BIOS ^Brk interrupt (INT 1BH) handler eliminated.

;	- added PUBLIC entry point BTDD, callable from compiled BASIC:
;	  CALL BTDD(N$) where N$ is the phone number or "".  Control
;	  is returned to caller at disconnect (user types ^C).	Several
;	  minor changes to allow this program to be LINKed with a
;	  compiled BASIC program.

;VERSION 5.4 CHANGES 3/85:

;	- support for PC JR
;	- receive and transmit routines totally interrupt driven
;	- 256 byte receive buffer, 1 byte transmit buffer

;PC JR CASSETTE PORT CONNECTIONS VIEWED FROM REAR OF SYSTEM UNIT:

;	A1  A2	A3  A4
;	    B2	B3  B4

;	A4-B3	motor relay (used to control on/off hook and pulse dialing)
;	A2	data in (audio signal from the phone line) +/- 13V max
;	A3	mic out (audio signal to the phone line) .075V DC
;	A1	signal ground (common return for A2 and A3)
;	B2-B4	no connection

;------------------------ END OF COMMENTARY -------------------------------

;---------------------CONFIGURATION EQUATES----------------------------;

FALSE		EQU	0
TRUE		EQU	NOT FALSE
					;IF TRUE:
MONITOR 	EQU	FALSE		;MONITOR SPEAKER ON DURING TRANSMIT
FIGSTTY 	EQU	FALSE		;MAP UPPERCASE ASCII TO FIGS TTY

;-----------------------HARDWARE EQUATES-------------------------------;

;PC JR NMI PORT ADDRESS

JR_NMI_PORT	EQU	0A0H

;8253 COUNTER/TIMER EQUATES

TIMER_MODE	EQU	43H		;PORT TO WRITE MODE WORD
TIMER_0 	EQU	40H		;TIMER 0 FOR XMIT/RECV TIMING
TIMER_2 	EQU	42H		;TIMER 2 FOR CARRIER GENERATION
TIMER_0_MODE	EQU	00110110B	;MODE WORD FOR TIMER 0
TIMER_2_MODE	EQU	10110110B	;MODE WORD FOR TIMER 2

NEW_TIMER_TICK	EQU	305		;GENERATE TICKS AT 3912 HZ

BAUD_RATE	EQU	86		;22 MILLISECONDS
SEND_TIMEOUT	EQU	3912/2		;ABOUT A HALF A SECOND
RECEIVE_TIMEOUT EQU	3912*3/4	;ABOUT 3/4 SECOND
JR_NMI_CORRECT	EQU	17		;ADD TO OUR CLOCKS ON EACH NMI

SPACE_TONE	EQU	663		;1800 HZ SPACE
MARK_TONE	EQU	852		;1400 HZ MARK

DIAL_WAIT	EQU	3912*2		;TWO SECOND DIAL TONE WAIT
DIAL_SPACE	EQU	3912*6/10	;600 MS SPACE BETWEEN DIGITS
DIAL_BREAK	EQU	3912*5/100	;50 MS BREAK
DIAL_MAKE	EQU	3912/10-DIAL_BREAK ;MAKE+BREAK MUST = 100 MS (10/SEC)

;CASSETTE PORT EQUATES

PPI_B		EQU	061H		;8255 PPI PORT B
T2_GATE 	EQU	01H		;SET ON TO GATE TIMER 2 OUTPUT
SPEAKER_DATA	EQU	02H		;SET ON TO TURN ON SPEAKER
MOTOR_OFF	EQU	08H		;BIT OFF TO ENABLE CASSETTE CIRCUIT

PPI_C		EQU	062H		;8255 PPI PORT C
CASS_DATA_IN	EQU	10H		;SAMPLE CASSETTE INPUT
CASS_SHIFTS	EQU	4		;BITS TO SHIFT LEFT TO GET CASS DATA

;8259 PROGRAMMABLE INTERRUPT CONTROLLER EQUATES

INT_CONTROL	EQU	20H		;PORT ADDRESS OF 8259
EOI_COMMAND	EQU	20H		;END OF INTERRUPT COMMAND

;-------------------------INTERRUPT VECTORS----------------------------;

ABSOLUTE_ZERO	SEGMENT AT 0H

		ORG	4*02H		;NMI INT FOR PC JUNIOR
NMI_INT 	DD	?

		ORG	4*08H		;TIMER_INT IS INT 08H
TIMER_INT	DD	?

		ORG	4*23H		;CTRL-BRK INTERRUPT VECTOR
BRK_INT 	DD	?

		ORG	4*24H		;FATAL ERROR VECTOR
ERR_INT 	DD	?

ABSOLUTE_ZERO	ENDS

;----------------------------------------------------------------------;

TDD_CODE	SEGMENT 'CODE'
		ASSUME	CS:TDD_CODE,DS:TDD_CODE,ES:TDD_CODE,SS:NOTHING

;-----------------------CONSTANTS AND VARIABLES------------------------;

BANNER		DB	13,10,'TDD Version 5.6 (IBM PC OR PCJR)',13,10
		DB	'by John W. Spalding 2/86',13,10,'$'

DIAL_PROMPT	DB	13,10,'To quit: <Ctrl-C>'
		DB	13,10,'To answer a call: <Return>'
		DB	13,10,'To dial: phone-number<Return>'
		DB	13,10,'> $'
DIAL_MSG	DB	13,10,'Dialing: $'
DIAL_ENDMSG	DB	13,10,10,'+++ Connected +++ <Ctrl-C> disconnects',13,10,'$'
PHONE_BUF	DB	LENGTH PHONE_NO, 0
PHONE_NO	DB	32 DUP(' ')	;PHONE NUMBER
END_MSG 	DB	13,10,10,'+++ Disconnected +++',13,10,10,'$'
BEL_MSG 	DB	'<BEL>$'	;SUBSTITUTED FOR ^G  (07H)
BKSP_ECHO	DB	8,' ',8,'$'
BUFFER		DB	256 DUP(0)
BUFFOUT 	DW	0		;CIRCULAR BUFFER POINTERS
BUFFIN		DW	0
BAN_SW		DB	0	;BANNER FIRST TIME SWITCH
VID_PAGE	DB	0	;CURRENT VIDEO PAGE NUMBER
SHIFT_REG	DB	0	;INCOMMING SIGNAL SHIFTED IN HERE
OUR_CLOCK	DW	0	;INCREMENTED AT 1909 HZ, USED BY MAIN TASK
INT_CLOCK	DB	0	;DITTO, USED BY INTERRUPT LEVEL ROUTINES
SYSTEM_CLOCK	DW	0	;TO GENERATE 18HZ TICKS FOR SYSTEM
SAVE_PPI_B	DB	0	;ORIGINAL CASSETTE PORT SETTINGS
TIMER_SAVE	DD	0	;ORIGINAL TIMER INTERRUPT VECTOR
BREAK_SAVE	DD	0	;ORIGINAL BREAK KEY INTERRUPT
ERR_SAVE	DD	0	;ORIGINAL FATAL ERROR ROUTINE
NMI_SAVE	DD	0	;ORIGINAL PC JUNIOR NMI INTERRUPT
SHIFT_STATE	DB	0H	;FIGS, LTRS STATUS OF SCREEN/KEYBOARD
XSHIFT_STATE	DB	0FFH	;TRANSMIT SHIFT STATE
FIGS_SHIFT	EQU	20H	;CURRENTLY IN FIGS SHIFT, OFF=LTRS SHIFT
LAST_CHAR	DB	0	;LAST CHAR SENT/RCVD, TO FORCE LF IF REQ
HOLD_CHAR	DB	000H	;HELD KEYBOARD CHARACTER		INE
STACK_SAVE	DW	0	;SAVE STACK PTR FOR CANCEL PROCESSING
SS_SAVE 	DW	0
RECV_TASK	DW	RCV_1		;RECEIVE FUNCTION "SUBTASK"
XMIT_TASK	DW	XMT_1		;TRANSMIT FUNCTION "SUBTASK"
TTY_WORK	DB	0		;BAUDOT CHARACTER SHIFT REGISTER
XMIT_CHAR	DB	-1		;HOLDING AREA FOR CHAR TO XMIT
MACHINE 	DB	0		;MACHINE TYPE
TYPE_PC 	EQU	0FFH
TYPE_JR 	EQU	0FDH
TYPE_XT 	EQU	0FEH		;XT OR PORTABLE
TYPE_AT 	EQU	0FCH
ZERO		DW	0		;HANDY CONSTANT
ROMSEG		DW	0F000H		;MACHINE TYPE IS AT F000:FFFE
LAST_TIMER2	DW	0		;LAST VALUE LOADED INTO TIMER2
SIG_SW		DW	OFFSET $	;INDICATES <SIGNAL> OR <      > WRITTEN
SIG_REG 	DB	0		;SLOW SHIFT REG FOR RING/BUSY
SIG_CLK 	DB	0		;LOCAL CLOCK FOR RING/BUSY TESTS
SIG_ON		DB	'<SIGNAL>'	;LEGEND TO INDICATE A SIGNAL
SIG_OFF 	DB	'<      >'	;LEGEND TO INDICATE NO SIGNAL
SIG_LEN 	EQU	$-SIG_OFF

;------------------ASCII/BAUDOT TRANSLATE TABLES-----------------------;

;BAUDOT TO ASCII TABLE -- BIT 7 INDICATES NEW SHIFT STATE (FIGS/LTRS)

TABLE_BAUD_ASC	DB	8,'E',10,'A SIU',13,'DRJNFCK'		;LTRS
		DB	'TZLWHYPQOBG',0A0H,'MXV',80H
		DB	8,'3',10,'- ',7,'87',13,'$4',27H,',!:(' ;FIGS
		DB	'5")2#6019?&',0A0H,'./;',80H

CODE_FIGS	EQU	1BH	;BAUDOT CODE FOR FIGS SHIFT
CODE_LTRS	EQU	1FH	;BAUDOT CODE FOR LTRS SHIFT
CODE_LF 	EQU	02H	;BAUDOT CODE FOR LINE FEED
CODE_CR 	EQU	08H	;BAUDOT CODE FOR CARRIAGE RETURN

;IN THE FOLLOWING TABLE, BIT7=1 IS NO BAUDOT EQUIV, BIT6=1 MEANS EITHER SHFT
;BIT5=1 MEANS MUST BE FIGS SHIFT.

;			 0   1	 2   3	 4   5	 6   7
;			 8   9	 A   B	 C   D	 E   F

TABLE_ASC_BAUD	DB	80H,80H,80H,80H,80H,80H,80H,25H 	;00H-07H
		DB	40H,80H,42H,80H,80H,48H,80H,80H 	;08H-0FH
		DB	80H,80H,80H,80H,80H,80H,80H,80H 	;10H-17H
		DB	80H,80H,80H,80H,80H,80H,80H,80H 	;18H-1FH
		DB	44H,2DH,31H,34H,29H,80H,3AH,2BH 	;20H-27H
		DB	2FH,32H,80H,80H,2CH,23H,3CH,3DH 	;28H-2FH
		DB	36H,37H,33H,21H,2AH,30H,35H,27H 	;30H-37H
		DB	26H,38H,2EH,3EH,80H,80H,80H,39H 	;38H-3FH

		IF	FIGSTTY ;UPPERCASE ASCII XLAT TO TTY FIGS

		DB	80H,23H,39H,2EH,29H,21H,2DH,3AH 	;40H-47H
		DB	34H,26H,2BH,2FH,32H,3CH,2CH,38H 	;48H-4FH
		DB	36H,37H,2AH,25H,30H,27H,3EH,33H 	;50H-57H
		DB	3DH,35H,31H,80H,80H,80H,80H,80H 	;58H-5FH

		ELSE	;NORMAL XLAT OF UPPERCASE ASCII TO TTY LTRS

		DB	80H,03H,19H,0EH,09H,01H,0DH,1AH 	;40H-47H
		DB	14H,06H,0BH,0FH,12H,1CH,0CH,18H 	;48H-4FH
		DB	16H,17H,0AH,05H,10H,07H,1EH,13H 	;50H-57H
		DB	1DH,15H,11H,80H,80H,80H,80H,40H 	;58H-5FH

		ENDIF

		DB	80H,03H,19H,0EH,09H,01H,0DH,1AH 	;60H-67H
		DB	14H,06H,0BH,0FH,12H,1CH,0CH,18H 	;68H-6FH
		DB	16H,17H,0AH,05H,10H,07H,1EH,13H 	;70H-77H
		DB	1DH,15H,11H,80H,80H,80H,80H,40H 	;78H-7FH

;----------------------------MAIN PROGRAM------------------------------;

;INITIALIZE, REPEAT: ASK FOR PHONE #, CALL, UNTIL ^C

MAIN_ENTRY:	XOR	AX,AX		;PUSH A RETURN ADDRESS
		PUSH	DS		;AND SET UP SEGMENTS
		PUSH	AX
		MOV	AX,CS
		MOV	DS,AX
		MOV	ES,AX
		CALL	PRINT_BANNER
MAIN_LOOP:
		CALL	GET_PHONE_NO
		CALL	MAKE_A_CALL
		JMP	MAIN_LOOP

;---------BTDD - INTERFACE FROM COMPILED BASIC TO MAKE_A_CALL----------;

		PUBLIC	BTDD

;USAGE: CALL BTDD(N$)  'WHERE N$ IS PHONE NUMBER OR NULL ("").
;PROCESSING: MOVE N$ TO PHONE_NO AND CALL MAKE_A_CALL

BTDD PROC FAR
		PUSH	BP
		MOV	BP,SP
		PUSH	DS			;BASIC ASSUMES DS OK
		PUSH	CS
		POP	ES
		MOV	SI,WORD PTR [BP+6]	;ARG OFFSET IN DS
		MOV	CX,DS:WORD PTR [SI+0]	;GET STRING LENGTH
		MOV	SI,DS:WORD PTR [SI+2]	;GET STRING OFFSET
		CMP	CX,LENGTH PHONE_NO-1	;COMPARE TO MAX
		JC	BT02
		MOV	CX,LENGTH PHONE_NO-1
BT02:
		MOV	DI,OFFSET PHONE_NO	;MOVE THE NUMBER
		REP MOVSB
		MOV	AL,13			;FOLLOW WITH CR
		STOSB
		PUSH	CS			;GET DS WE WANT
		POP	DS
		CALL	MAKE_A_CALL		;MAKE THE CALL
		POP	DS
		POP	BP
		RET	2
BTDD ENDP

;---------------------MAIN TDD EMULATION ROUTINE---------------------;

MAKE_A_CALL:
		CLD
		PUSH	ES
		MOV	ES,ROMSEG	;SEGMENT
		MOV	BL,BYTE PTR ES:0FFFEH	 ;GET MACHINE TYPE
		MOV	MACHINE,BL	;AND SAVE IT
		POP	ES
		MOV	STACK_SAVE,SP	;SAVE STACK PTR FOR CANCEL PROCESSING
		MOV	SS_SAVE,SS

		CALL	PRINT_BANNER	;PRINT BANNER ONCE
		CALL	TIMER_INIT		;SET UP INTERRUPT ROUTINES

		CALL	DIAL_PHONE		;DIAL THE PHONE
		MOV	SIG_SW,OFFSET SIG_SW	;FORCE <SIGNAL> ONCE

;MAIN LOOP -- ONCE XMIT/RECV BEGINS STAY IN THAT MODE FOR GIVEN TIMEOUT.
;THE ONLY WAY OUT OF THIS LOOP IS VIA THE ^C INTERRUPT ROUTINE

RECEIVE1:	CALL	RECEIVE_TTY		;TRY TO RECEIVE A CHARACTER
		JZ	TRANSMIT1		;NONE

RECEIVE2:	CALL	CONSOLE_PUT		;PRINT THE CHARACTER
		MOV	OUR_CLOCK,0		;SET TIMEOUT

RECEIVE3:	CALL	RECEIVE_TTY		;TRY TO RECEIVE ANOTHER CHAR
		JNZ	RECEIVE2
		CMP	OUR_CLOCK,RECEIVE_TIMEOUT ;CHECK TIMEOUT
		JC	RECEIVE3		;TRY UNTIL EXPIRED

TRANSMIT1:	MOV	XSHIFT_STATE, 0FFH	;FORCE SHIFT 1ST TIME
		CALL	CONSOLE_GET		;TRY TO READ THE KEYBOARD
		JZ	SIGNAL1 		;NO, LOOK FOR RING/BUSY
		CALL	CARRIER_ON		;TURN ON THE CARRIER

TRANSMIT2:	CALL	CONSOLE_PUT		;ECHO (AL PRESERVED)
		CALL	TRANSMIT_TTY		;SEND THE CHARACTER
		MOV	OUR_CLOCK,0		;SET TIMEOUT

TRANSMIT3:	CALL	CONSOLE_GET		;LOOK FOR ANOTHER CHARACTER
		JNZ	TRANSMIT2		;SEND IT IF ANY
		CMP	OUR_CLOCK,SEND_TIMEOUT	;CHECK TIMEOUT
		JC	TRANSMIT3		;TRY UNTIL EXPIRED
		CALL	CARRIER_OFF		;TURN OFF CARRIER
		JMP	RECEIVE1		;AND ENTER RECEIVE MODE

SIGNAL1:	CALL	SIG_TEST		;GO TEST FOR RING/BUSY
		JMP	SHORT RECEIVE1		;KEEP TRYING

;---------------------PULSE DIALING ROUTINES------------------------;

;ASK USER FOR A PHONE NUMBER

GET_PHONE_NO:
		MOV	DX,OFFSET DIAL_PROMPT	;PROMPT USER
		MOV	AH,09H
		INT	21H
		MOV	DX,OFFSET PHONE_BUF	;AND READ THE NUMBER
		MOV	AH,0AH
		INT	21H
		RET

;PULSE DIAL BY TURNING CASSETTE MOTOR RELAY ON AND OFF

DIAL_PHONE:	PUSH	DI
		PUSH	DX
		CMP	PHONE_NO,13		;NULL PHONE NUMBER
		JNZ	DIAL_NUMBERS		;NO
		MOV	DX,0			;YES, JUST GO OFF-HOOK
		CALL	DIAL_FLIP
		JMP	DIAL_DONE

DIAL_NUMBERS:	MOV	DX,OFFSET DIAL_MSG	;PRINT DIALING MESSAGE
		MOV	AH,09H
		INT	21H
		MOV	SI,OFFSET PHONE_NO

		MOV	DX,DIAL_WAIT		;GO OFF HOOK AND WAIT A BIT
		CALL	DIAL_FLIP

DIAL_LOOP:	LODSB
		CMP	AL,13
		JZ	DIAL_DONE
		PUSH	AX
		CALL	CONSOLE_PUT
		POP	AX
		CMP	AL,','
		JZ	PAUSE_DIAL
		SUB	AL,'0'
		JC	DIAL_LOOP
		JNZ	DIAL19
		MOV	AL,10
DIAL19: 	CMP	AL,11
		JNC	DIAL_LOOP

		MOV	CL,AL
		MOV	CH,0

PULSE:		MOV	DX,DIAL_BREAK
		CALL	DIAL_FLIP
		MOV	DX,DIAL_MAKE
		CALL	DIAL_FLIP
		LOOP	PULSE
		MOV	DX,DIAL_SPACE
		CALL	DIAL_DELAY
		JMP	SHORT DIAL_LOOP

DIAL_DONE:	MOV	DX,OFFSET DIAL_ENDMSG
		MOV	AH,09H
		INT	21H
		POP	DX
		POP	DI
		RET

PAUSE_DIAL:	MOV	DX,DIAL_WAIT
		CALL	DIAL_DELAY
		JMP	SHORT DIAL_LOOP

DIAL_FLIP:	IN	AL,PPI_B
		XOR	AL,MOTOR_OFF
		OUT	PPI_B,AL

DIAL_DELAY:	MOV	OUR_CLOCK,0
DDWAIT: 	CMP	OUR_CLOCK,DX
		JC	DDWAIT
		RET

;-------------------CONSOLE I/O ROUTINES------------------------;

;CONSOLE_GET -- GET CHARACTER IN AL, ZF SET IF NONE
;INSERTS A LINE FEED AFTER CR (SEND OR RECVD) IF ONE ISN'T TYPED

CONSOLE_GET:
	MOV	AL, 0			;CHARACTER INSERTED LAST TIME?
	XCHG	AL, HOLD_CHAR
	OR	AL, AL
	JNZ	CG9			;YES
CG2:
	MOV	AH,0BH			;CHECK INPUT STATUS
	INT	21H
	OR	AL,AL
	JZ	CG9			;NOTHING, EXIT
	MOV	AH,08H			;CONSOLE INPUT W/O ECHO
	INT	21H
	OR	AL,AL			;CHECK FOR EXTENDED CODE
	JNZ	CG7			;RETURN IF NOT
	MOV	AH,08H			;EAT THE EXTENDED CODE
	INT	21H
	JMP	SHORT CG2		;AND CHECK STATUS AGAIN
CG7:
	CMP	LAST_CHAR, 13		;LAST CHARACTER A C/R?
	JNZ	CG9			;NO
	CMP	AL, 10			;IS THIS A LINE FEED?
	JZ	CG8			;YES, OK
	MOV	HOLD_CHAR, AL		;NO, INSERT A LINE FEED
	MOV	AL, 10
CG8:
	OR	AL, AL			;SET NON-ZERO
CG9:
	RET

;CONSOLE_PUT -- WRITE CHARACTER IN AL TO CONSOLE, PRESERVE AL

CONSOLE_PUT:
		PUSH	DX
		PUSH	AX
		MOV	LAST_CHAR,AL		;SAVE FOR CR/LF TEST
		CMP	AL,07H			;IS THIS BEL?
		JZ	PRINT_BEL		;YES PRINT [BEL]

		MOV	AH,02H			;CONSOLE OUTPUT
		MOV	DL,AL
		INT	21H
		JMP	SHORT CPRET
PRINT_BEL:					;PRINT <BEL>
		MOV	DX,OFFSET BEL_MSG
		MOV	AH,09H
		INT	21H
CPRET:
		MOV	SIG_SW,OFFSET SIG_SW	;FORCE <SIGNAL> NEXT TIME
		POP	AX
		POP	DX
		RET

;PRINT PROGRAM NAME, VERSION AND AUTHOR'S NAME FIRST TIME ONLY.

PRINT_BANNER:					;PRINT BANNER ONLY ONCE
		CMP	BAN_SW,0
		MOV	BAN_SW,0FFH
		JNZ	BPRET

		MOV	DX,OFFSET BANNER	;PRINT HELLO MESSAGE
		MOV	AH,09H
		INT	21H
BPRET:
		RET

;----------------------DOS INTERRUPT ROUTINES------------------------;

;FATAL ERROR INTERRUPT ROUTINE:
;CALL SYSTEM FATAL ERROR ROUTINE, IF USER SAYS ABORT, USE OUR ^C ROUTINE

FATAL_ERROR:					;ENTER ON INT 24H
		PUSHF
		CALL	CS:DWORD PTR ERR_SAVE	;CALL SYSTEM'S ROUTINE
		CMP	AL,2			;USER REQUESTED ABORT?
		JZ	BREAK_KEY		;YES, DO IT OUR WAY!
		IRET				;YES, RETURN TO SYSTEM

;CONTROL-C INTERRUPT ROUTINE:
;ON ^C, RESTORE SEG REGS AND STACK, CLEAN UP, WRITE MSG AND QUIT

BREAK_KEY:					;ENTER ON INT 23H
		CLI
		PUSH	CS			;GET ALL REGISTERS
		POP	DS			;BACK TO NORMAL
		PUSH	CS
		POP	ES
		MOV	SP,STACK_SAVE
		MOV	SS,SS_SAVE
		STI
		CLD

		CALL	TIMER_QUIT		;CLEAN UP VECTORS AND TIMERS

		MOV	DX,OFFSET END_MSG	;PRINT ENDING MESSAGE
		MOV	AH,09H
		INT	21H

		RET				;EXIT			HERE

;---------------------SIGNAL INDICATOR ROUTINE-------------------;

;TEST FOR NON-CARRIER SIGNALS SUCH AS RING/BUSY, DISPLAYING <SIGNAL>
;IN THE UPPER RIGHT CORNER OF THE SCREEN IF SUCH SIGNALS ARE
;PRESENT, OR <	    > IF THE LINE IS QUIET.  WHEN ACTUALLY TRANSMITTING
;OR RECEIVING, THIS DISPLAY IS NOT MAINTAINED, AND COULD SHOW EITHER
;<SIGNAL>, <	  >, OR BE ABSENT.  IT IS NEVER ERASED, BUT SIMPLY
;ALLOWED TO SCROLL OFF THE SCREEN.

;USES BIOS FUNCTIONS TO DISPLAY SO THEY WON'T GO THRU DOS
;AND GET WRITTEN TO THE PRINTER IF THE PRINTER IS ON.

SIG_TEST:	MOV	AL,BYTE PTR OUR_CLOCK+1 ;DO IT EVERY 256 TICKS
		CMP	AL,SIG_CLK
		JZ	SIG_RET

		MOV	SIG_CLK,AL
		MOV	AL,SHIFT_REG
		SHL	AL,1
		RCR	SIG_REG,1	;SHIFT INTO SLOW REG
		MOV	DX,OFFSET SIG_OFF
		JZ	SIG_PRT
		MOV	DX,OFFSET SIG_ON

SIG_PRT:	CMP	DX,SIG_SW	;DON'T PRINT IF ALREADY THERE
		JZ	SIG_RET
		MOV	SIG_SW,DX

		MOV	AH,15		;GET # COLUMNS IN AH
		INT	10H		;PAGE IN BH
		MOV	VID_PAGE,BH
		PUSH	AX

		MOV	AH,3		;GET CURSOR POSITION
		CALL	SIG_VID
		POP	AX		;RESTORE # COLUMNS
		PUSH	DX		;SAVE CURSOR POSITION

		MOV	DX,256-SIG_LEN	;SET NEW CURSOR POSITION
		ADD	DL,AH
		CALL	SIG_SET

		MOV	SI,SIG_SW	;NOW PRINT THE FLAG

		MOV	CX,SIG_LEN	;PRINT SIGNAL FLAG
PS1:		LODSB
		MOV	AH,14
		INT	10H
		LOOP	PS1
PSR:
		POP	DX		;RESTORE ORIGINAL CURSOR POSITION
SIG_SET:
		MOV	AH,2		;CODE TO SET CURSOR
SIG_VID:
		MOV	BH,VID_PAGE	;CURRENT VIDEO PAGE NUMBER
		INT	10H		;VIDEO FUNCTION INTERRUPT
SIG_RET:
		RET

;------------------SEND AND RECEIVE TTY ROUTINES----------------------;

;RECEIVE_TTY -- GET BAUDOT CHAR FROM BUFFER AND TRANSLATE TO ASCII

RECEIVE_TTY:
	PUSH	BX
	MOV	BX,BUFFOUT		;GET CIRCULAR BUFFER POINTER
	CMP	BX,BUFFIN		;EMPTY?
	JZ	RTTY9			;YES
	MOV	AL,BUFFER [BX]		;GET THE CHARACTER
	ADD	AL, SHIFT_STATE 	;AND ADD THE CURRENT SHIFT STATE
	INC	BL			;BUMP POINTER
	MOV	BYTE PTR BUFFOUT,BL	;AND RESTORE
	MOV	BX, OFFSET TABLE_BAUD_ASC
	XLAT	BYTE PTR [BX]		;TRANSLATE BAUDOT TO ASCII
	OR	AL, AL			;TEST SIGN (NOTE: NEVER ZERO)
	JNS	RTTY9			;OK, EXIT WITH ASCII VALUE
	AND	AL, 20H 		;ISOLATE SHIFT BIT
	MOV	SHIFT_STATE, AL 	;AND SAVE IT
	AND	AL, 0			;INDICATE NOTHING TO PRINT
RTTY9:
	POP	BX
	RET				;RETURN TO CALLER

;TRANSMIT_TTY -- TRANSLATE AL TO BAUDOT AND PLACE IN XMIT BUFFER

TRANSMIT_TTY:
	PUSH	BX
	MOV	BX, OFFSET TABLE_ASC_BAUD
	XLAT	BYTE PTR [BX]		;GET BAUDOT CHARACTER
	POP	BX
	MOV	AH, AL			;GET AL=BAUDOT, AH=SHIFT
	AND	AX, 0E01FH
	JS	TRTTY9			;GET OUT IF NO BAUDOT EQUIV
	TEST	AH, 40H 		;IS SHIFT STATE DON'T CARE?
	JZ	TRTTY3			;NO
	MOV	AH, SHIFT_STATE 	;YES, FORCE CURRENT=DESIRED
TRTTY3:
	CMP	AH, XSHIFT_STATE	;IS DESIRED SHIFT=CURRENT?
	MOV	XSHIFT_STATE, AH
	MOV	SHIFT_STATE, AH
	JZ	TRTTY7			;IF YES, GO SEND THE CHARACTER
	PUSH	AX			;SAVE THE CHARACTER
	MOV	AL, CODE_LTRS
	OR	AH, AH
	JZ	TRTTY5
	MOV	AL, CODE_FIGS
TRTTY5:
	CALL	TRTTY7
	POP	AX
TRTTY7:
	CMP	XMIT_CHAR,-1		;WAIT FOR EMPTY BUF
	JNZ	TRTTY7
	MOV	XMIT_CHAR,AL		;THEN LOAD BUFFER
	CMP	AL, CODE_LF		;BAUDOT LINE FEED?
	JNZ	TRTTY9			;NO
	MOV	XSHIFT_STATE, AL	;YES, FORCE SHIFT NEXT TIME
TRTTY9:
	RET

;-------------------HARDWARE INTERRUPT ROUTINES----------------------;

		ASSUME	ES:NOTHING

;MACRO PERFORMS END OF INTERRUPT PROCESSING

TRESUME 	MACRO
		LOCAL	L1

		ADD	SYSTEM_CLOCK,NEW_TIMER_TICK
		JC	L1

		MOV	AL,EOI_COMMAND	       ;;END OF INTERRUPT TO 8259
		OUT	INT_CONTROL,AL
		POP	AX
		POP	DS
		IRET

L1:		POP	AX			;;PASS TO IBM FOR TOD CLOCK
		POP	DS			;;(IBM DOES EOI)
		JMP	CS:TIMER_SAVE

		ENDM

;NMI INTERRUPT ROUTINE FOR PC JR -- CORRECTS CLOCK LOSS DUE TO NMI ROUTINE

NEW_NMI:	ADD	CS:OUR_CLOCK,JR_NMI_CORRECT	;FIX OUR CLOCKS,
		ADD	CS:INT_CLOCK,JR_NMI_CORRECT
		JMP	DWORD PTR CS:NMI_SAVE		;THEN GO TO IBM

;RECEIVE TIMER INTERRUPT ROUTINE -- DESERIALIZES DATA AND ADDS
;RECEIVED BAUDOT CHARACTER TO CIRCULAR RECEIVE BUFFER

RCV_TIMER_INT:	STI				;INTERRUPTS BACK ON
		PUSH	DS
		PUSH	AX
		MOV	AX,CS
		MOV	DS,AX

		INC	OUR_CLOCK		;ADD 1 TO OUR CLOCK
		INC	INT_CLOCK		;AND TO RECEIVE CLOCK

		IN	AL,PPI_C		;READ THE CASSETTE PORT
		REPT	CASS_SHIFTS		;SHIFT CORRECT NUMBER
		RCL	AL,1			;TO GET INTO CARRY BIT
		ENDM				;(FASTER THAN RCL AL,CL)
		MOV	AL,SHIFT_REG
		RCR	AL,1			;CASSETTE DATA SHIFTED IN
		MOV	SHIFT_REG,AL		;(WANT SHIFT_REG IN AL ANYWAY)

		JMP	WORD PTR RECV_TASK     ;PROCESS TIMER TASK

;THE FOLLOWING CODE RUNS AS A "SUBTASK", DISPATCHED BY THE RECEIVE	E
;TIMER INTERRUPT ROUTINE, ABOVE.

;NOTE: THIS SECTION HAS A LOT OF REPETITIVE CODE, AVOIDING JMPS.  IRP	S
;MACROS ARE USED TO GENERATE CODE TO SHIFT IN EACH DATA BIT.  THIS
;ELIMINATES THE NEED TO MAINTAIN A COUNTER AND THE ASSOCIATED OVERHEAD
;OF PUSHING ANOTHER REGISTER AT INTERRUPT TIME.  YOU CAN LOOK AT THIS
;AS A KIND OF STATE MACHINE, WHERE WORD PTR RECV_TASK (THE WHERE TO
;GO ADDRESS) GIVES THE CURRENT STATE (SUCH AS "WAITING FOR A START BIT",
;OR "WAITING TO SHIFT IN DATA BYTE 3", ETC.).

;LOOK FOR START BIT

RCV_TASK_WAT:	TRESUME

RCV_0:		MOV	RECV_TASK,OFFSET RCV_1 ;JMP HERE AFTER RCV CHAR

RCV_1:		CMP	AL,01010101B
		JNZ	RCV_TASK_WAT		;KEEP TRYING

HAVE_CARRIER:	MOV	INT_CLOCK,0		;RESET THE CLOCK
		MOV	RECV_TASK,OFFSET RCV_2 ;ESTABLISH NEW RESUME POINT

;RECEIVE DATA BITS

RCV_2:		CMP	INT_CLOCK,BAUD_RATE+BAUD_RATE/8
		JC	RCV_TASK_WAT		;DELAY TO 1ST DATA BIT
		SUB	INT_CLOCK,BAUD_RATE+BAUD_RATE/8
		MOV	TTY_WORK,0		;SET UP TO RECEIVE DATA BITS

		IRP	X,<V,W,X,Y,Z>		;SHIFT IN 5 BITS

		MOV	RECV_TASK,OFFSET Z0&X  ;;SET NEW RESUME POINT

Z0&X:		CMP	AL,01010101B		;;LOOK FOR SPACE
		JZ	Z1&X			;;HAVE ONE, NOTE CF=0
		CMP	INT_CLOCK,BAUD_RATE/3	;;ONLY TRY SO LONG
		JC	Z2&X
		STC				;;DIDN'T FIND IT, SET 1 BIT

Z1&X:		RCR	TTY_WORK,1		;;MOVE THE CARRY IN

		MOV	RECV_TASK,OFFSET Z1A&X ;;SET NEW RESUME POINT
Z1A&X:		CMP	INT_CLOCK,BAUD_RATE	;;SIT HERE FOR
		JNC	Z3&X			;;REST OF BIT TIME
Z2&X:		TRESUME
Z3&X:		SUB	INT_CLOCK,BAUD_RATE
		ENDM

;PLACE CHARACTER RECEIVED IN CIRCULAR RECEIVE BUFFER

		MOV	AL,TTY_WORK
		SHR	AL,1			;ONLY SHIFTED 5 BITS
		SHR	AL,1			;SO SHIFT OTHER 3
		SHR	AL,1
		PUSH	BX			;SAVE BX
		MOV	BX,BUFFIN		;GET BUFFER POINTER
		MOV	BUFFER [BX], AL 	;STORE CHAR IN BUFFER
		INC	BL			;BUMP, WRAP AT END
		MOV	BYTE PTR BUFFIN, BL	;SAVE NEW POINTER
		POP	BX			;RESTORE BX
		JMP	RCV_0

;TRANSMIT TIMER INTERRUPT
;WAITS FOR BAUDOT CHARACTER TO BE PLACED IN ONE BYTE TRANSMIT BUFFER
;THEN TRANSMITS THE BYTE SERIALLY.
;(SEE ALSO COMMENTS FOR RECEIVE TIMER INTERRUPT ABOVE)

XMT_TIMER_INT:	STI				;INTERRUPTS BACK ON
		PUSH	DS
		PUSH	AX
		MOV	AX,CS
		MOV	DS,AX
		INC	OUR_CLOCK		;BUMP THE CLOCKS
		INC	INT_CLOCK
		JMP	WORD PTR XMIT_TASK	;GO TO TRANSMIT TASK

;THE FOLLOWING ROUTINES ARE DISPATCHED BY THE TRANSMIT INTERRUPT
;ROUTINE, BY THE INDIRECT JUMP TO WORD PTR XMIT_TASK:

XMT_0:		MOV	XMIT_TASK,OFFSET XMT_1	;RESET TRANSMIT SUBTASK

XMT_1:		CMP	XMIT_CHAR,-1
		JNZ	XMT_2
XRESUME:	TRESUME 			;KEEP WAITING FOR CHAR

;SEND THE START BIT

XMT_2:		MOV	INT_CLOCK,0		;WAIT LENGTH OF START BIT
		MOV	AX,SPACE_TONE		;START BIT=SPACE
		CALL	WRITE_TIMER2
		MOV	XMIT_TASK,OFFSET XMT_3
XMT_3:		CMP	INT_CLOCK,BAUD_RATE
		JC	XRESUME

;SEND 5 DATA BITS

		IRP	X,<Q,R,S,T,U>		;START BIT PLUS 5 DATA BITS

		RCR	XMIT_CHAR,1		;GET A DATA BIT
		MOV	AX,MARK_TONE		;ASSUME ITS A 1
		JC	Z0&X
		MOV	AX,SPACE_TONE		;NO, ITS A ZERO

Z0&X:		CALL	WRITE_TIMER2		;SET THE CARRIER FREQ
		SUB	INT_CLOCK,BAUD_RATE	;(AVOID CREEPING TIMING ERRORS)
		MOV	XMIT_TASK,OFFSET Z1&X  ;SET NEW RETURN POINT
Z1&X:		CMP	INT_CLOCK,BAUD_RATE	;WAIT ONE BIT WIDTH
		JNC	Z2&X
Z1A&X:		TRESUME
Z2&X:
		ENDM

;SEND 1-1/2 STOP BITS

		SUB	INT_CLOCK,BAUD_RATE	;SEND 1-1/2 STOP BITS
		MOV	AX,MARK_TONE
		CALL	WRITE_TIMER2
		MOV	XMIT_TASK,OFFSET XMT_4
XMT_4:		CMP	INT_CLOCK,3*BAUD_RATE/2
		JNC	XMT_5
		TRESUME

XMT_5:		MOV	XMIT_CHAR,-1		;INDICATE XMIT BUFF EMPTY
		JMP	XMT_0			;WAIT FOR ANOTHER CHARACTER

		ASSUME	ES:TDD_CODE

;--------------------HARDWARE I/O ROUTINES------------------------;

		ASSUME	ES:NOTHING	;(MAY BE CALLED FROM INTERRUPT
					;ROUTINES, WHICH DON'T SET ES)

;ENABLE AND DISABLE ROUTINES -- HANDLE NMI FOR PC JUNIOR
;CLI AND STI WILL NOT DO THE TRICK ON THE JUNIOR!

DISABLE:	PUSH	AX
		CMP	MACHINE,TYPE_JR 	;TEST FOR PC JUNIOR
		JNZ	DIS2

		MOV	AL,00H			;IF PC JR, DISABLE NMI
		OUT	JR_NMI_PORT,AL

DIS2:		CLI				;DISABLE IRQ INTERRUPT
		JMP	SHORT ENA2

ENABLE: 	PUSH	AX
		STI

		CMP	MACHINE,TYPE_JR 	;TEST FOR PC JUNIOR
		JNZ	ENA2

; DON'T NEED TO READ NMI PORT BECAUSE WE STAY DISABLED FOR VERY SHORT PERIODS
; THIS WAY WE DON'T THROW AWAY A KEYSTROKE UNNECESSARILY
		MOV	AL,80H			;THEN ENABLE NMI INTERRUPTS
		OUT	JR_NMI_PORT,AL		;BY SETTING HI ORDER BIT

ENA2:		POP	AX
		RET

;ROUTINES TO TURN CARRIER TONE ON OR OFF AT CASSETTE INTERFACE.

CARRIER_ON:	PUSH	AX			;START CARRIER TONE
		PUSH	BX			;POINT BX TO WRITE TIMER ...
		MOV	AX,MARK_TONE		;SET TIMER FIRST
		CALL	FORCE_TIMER2
		MOV	XMIT_TASK,OFFSET XMT_0	;INITIALIZE TRANSMIT SUBTASK
		MOV	BX,OFFSET XMT_TIMER_INT ;... INT ROUTINE
		IN	AL,PPI_B		;TO MONITOR, ADD:
		IF	NOT MONITOR
		OR	AL,T2_GATE		;OR SPEAKER_DATA
		ELSE
		OR	AL,T2_GATE OR SPEAKER_DATA
		ENDIF
		JMP	SHORT CARRIER_EXIT

CARRIER_OFF:	PUSH	AX			;TURN OFF CARRIER TONE
		PUSH	BX
		MOV	RECV_TASK,OFFSET RCV_0	;INITIALIZE RECEIVE SUBTASK
		MOV	BX,OFFSET RCV_TIMER_INT ;POINT TO BX TO NORMAL INT
		IN	AL,PPI_B
		AND	AL,NOT (T2_GATE OR SPEAKER_DATA)

CARRIER_EXIT:	OUT	PPI_B,AL
		PUSH	ES
		MOV	ES,ZERO
		ASSUME	ES:ABSOLUTE_ZERO
		MOV	WORD PTR ES:TIMER_INT,BX
		POP	ES
		ASSUME	ES:NOTHING
		POP	BX
		POP	AX
		RET

;WRITE TIMER ROUTINES -- SET TIMER0 OR TIMER2 TO VALUE IN AX

WRITE_TIMER0:	PUSH	DX			;ENTER HERE FOR TIMER 0
		PUSH	AX

		MOV	DX,TIMER_0		;PORT ADDRESS
		MOV	AL,TIMER_0_MODE 	;MODE WORD FOR TIMER 0

		JMP	SHORT WRITE_TIMERX

WRITE_TIMER2:	CMP	LAST_TIMER2,AX		;AVOID REDUNDANT WRITES
		JNZ	FORCE_TIMER2		;TO TIMER 2
		RET

FORCE_TIMER2:	MOV	LAST_TIMER2,AX
		PUSH	DX			;ENTER HERE FOR TIMER 2
		PUSH	AX

		MOV	DX,TIMER_2		;PORT ADDRESS
		MOV	AL,TIMER_2_MODE 	;MODE WORD FOR TIMER 2

WRITE_TIMERX:	CALL	DISABLE 		;DON'T LET ANYONE IN HERE
		OUT	TIMER_MODE,AL		;SET MODE OF REQUESTED TIMER

		POP	AX			;WRITE LSB
		OUT	DX,AL
		MOV	AL,AH			;THEN MSB
		OUT	DX,AL

		CALL	ENABLE			;INTERRUPTS OK NOW
		POP	DX			;ALREADY POPPED AX, POP DX
		RET

		ASSUME	ES:TDD_CODE

;---------------INITIALIZATION AND DEINITIALIZATION-------------;

;SET UP INTERRUPT VECTORS AND INITIALIZE COUNTER/TIMER CHIP

TIMER_INIT:	CALL	DISABLE 		 ;NO INTERRUPTS WHILE WE FIDDLE
		PUSH	DS
		PUSH	ES

		MOV	DS,ZERO 		;SET DS TO ZERO
		ASSUME	DS:ABSOLUTE_ZERO

		MOV	DI,OFFSET TIMER_SAVE
		MOV	SI,OFFSET TIMER_INT
		MOVSW				;SAVE TIMER
		MOVSW

		MOV	SI,OFFSET BRK_INT
		MOVSW				;SAVE CTRL-C
		MOVSW

		MOVSW				;SAVE FATAL ERROR
		MOVSW

		CMP	MACHINE,TYPE_JR 	;CAPTURE NMI IF PC JR
		JNZ	INIJR
		MOV	SI,OFFSET NMI_INT
		MOVSW
		MOVSW

		MOV	WORD PTR NMI_INT[0],OFFSET NEW_NMI
		MOV	WORD PTR NMI_INT[2],CS

INIJR:		MOV	WORD PTR TIMER_INT[0],OFFSET RCV_TIMER_INT
		MOV	WORD PTR TIMER_INT[2],CS

		MOV	WORD PTR BRK_INT,OFFSET BREAK_KEY
		MOV	WORD PTR BRK_INT+2,CS

		MOV	WORD PTR ERR_INT,OFFSET FATAL_ERROR
		MOV	WORD PTR ERR_INT+2,CS

		MOV	AX,NEW_TIMER_TICK	;INITIALIZE TIMER 0
		CALL	WRITE_TIMER0

		IN	AL,PPI_B		;INITIALIZE CASSETTE PORT
		MOV	SAVE_PPI_B,AL		;(SAVE FOR QUIT ROUTINE)
		AND	AL,NOT (T2_GATE OR SPEAKER_DATA)
		OR	AL,MOTOR_OFF
		OUT	PPI_B,AL		;MOTOR OFF, T2 GATE, SPKR OFF

		JMP	SHORT TIMER_INITEND	;GO RESTORE ES AND RETURN

;DEINITIALIZE INTERRUPT VECTORS AND HARDWARE

TIMER_QUIT:	CALL	DISABLE 		;INTERRUPTS OFF FOR THIS
		PUSH	DS
		PUSH	ES

		MOV	ES,ZERO 		;SET ES TO ZERO
		ASSUME	ES:ABSOLUTE_ZERO,DS:TDD_CODE

		MOV	SI,OFFSET TIMER_SAVE
		MOV	DI,OFFSET TIMER_INT
		MOVSW
		MOVSW
		MOV	DI,OFFSET BRK_INT
		MOVSW				;RESTORE CTL-BRK
		MOVSW

		MOVSW				;AND FATAL ERROR
		MOVSW

		CMP	MACHINE,TYPE_JR 	;RESTORE NMI VECTOR IF PC JR
		JNZ	QUITJR
		MOV	DI,OFFSET NMI_INT
		MOVSW
		MOVSW

QUITJR: 	XOR	AX,AX			;RESTORE TIMER 0 TO IBM VALUE
		CALL	WRITE_TIMER0

		MOV	AL,SAVE_PPI_B		;RESTORE CASSETTE PORT
		OUT	PPI_B,AL

TIMER_INITEND:	POP	ES			;SET BACK ORIGINAL ES REG
		POP	DS			;AND DS
		CALL	ENABLE			;INTS OK NOW
		RET

		ASSUME	DS:TDD_CODE,ES:TDD_CODE

;----------------------------------------------------------------------;

TDD_CODE	ENDS

STACK		SEGMENT STACK 'STACK'
		DB	256 DUP(?)
STACK		ENDS

		END	MAIN_ENTRY
