/*
	mouse.c -
	Mouse routines adapted from 'The C Gazette', March and Summer 1988.
	For Microsoft C5.1.
*/

#define MOUSE_LIB

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <mouse.h>

int int_flag = 0;
int far _mouseInstalled = 0;
MOUSETRAP far *trap_data;

/*
	InitMouse() -
	Checks for the presense of a 2 or 3 button mouse. If present installs
	the mouse interrupt handler to trap button depressions and movement.
	Returns: 0 if no mouse installed, number of buttons if mouse present.
*/
int
InitMouse(mask)
int mask;
	{
	int buttons;
	extern void far handler();
	extern void far MouseData();
	void InstallTrap();
	int CheckMouse();

	trap_data = (MOUSETRAP far *)MouseData;
	trap_data->what = 0;
	if((buttons = CheckMouse()) == NO_MOUSE)
		return(0);

	InstallTrap(mask,	(unsigned)((long) handler >> 16), (unsigned) handler);
	return(buttons);
	}

int 
CheckMouse()						/* returns # mouse buttons		*/
	{									/* 0 = no mouse					*/
	union REGS inregs;

	inregs.x.ax = 0;
	callMDD;

	if(!inregs.x.ax)				/* AX = 0, no; AX = -1, yes	*/
		return(NO_MOUSE);
	else
		return(inregs.x.bx);	/* BX = # of buttons				*/
	}

void
CloseMouse()
	{									/* just to reset mouse status */
	union REGS inregs;

	inregs.x.ax = 0;
	callMDD;
	}

void
DisplayMCursor(mode)				/* toggle the display of mouse cursor */
int mode;
	{
	union REGS inregs;

	inregs.x.ax = mode;
	callMDD;
	}

int
CheckPosition(p_x, p_y)			/* Checks buttons pressed and position */
int *p_x,							/* of mouse. It is passed pointers to	*/
	 *p_y;							/* update coordinates and returns a		*/
	{									/* binary sum of buttons pressed.		*/
	union REGS inregs;

	inregs.x.ax = 3;
	callMDD;
	*p_x = inregs.x.cx;
	*p_y = inregs.x.dx;
	return(inregs.x.bx);
	}

void
PositionMCursor(x, y)			/* Position mouse cursor at x, y.		*/
int x, y;
	{
	union REGS inregs;

	inregs.x.ax = 4;
	inregs.x.cx = x;
	inregs.x.dx = y;
	callMDD;
	}

void
GetPress(button, p_x, p_y, p_presses)	/* Get # of presses and pos.	*/
int button;										/* Left 0, Ctr 4, Right 2		*/
int *p_x, *p_y,
	 *p_presses;								/* # presses since last call	*/
	{
	union REGS inregs;

	inregs.x.ax = 5;
	inregs.x.bx = button;
	callMDD;
	*p_x = inregs.x.cx;
	*p_y = inregs.x.dx;
	*p_presses = inregs.x.bx;
	}

void
GetRelease(button, p_x, p_y, p_presses)	/* Get # presses and pos.	*/
int button;											/* Left 0, Ctr 4, Right 2	*/
int *p_x, *p_y,
	 *p_presses;									/* Releases since last call*/
	{
	union REGS inregs;

	inregs.x.ax = 6;
	inregs.x.bx = button;
	callMDD;
	*p_x = inregs.x.cx;
	*p_y = inregs.x.dx;
	*p_presses = inregs.x.bx;
	}

void
LimitCursor(direction, lo, hi)				/* Limit cursor's range of motion */
int direction,										/* Vertical or Horizontal			 */
	 lo, hi;											/* Bounds.								 */
	{
	union REGS inregs;

	inregs.x.cx = lo;
	inregs.x.dx = hi;
	switch(direction)
		{
		case (HORIZ):
			inregs.x.ax = 7;
			break;
		case (VERT):
			inregs.x.ax = 8;
			break;
		default:
			return;
		}
	callMDD;
	}

void GraphicCursor(hot_x, hot_y, mask)	/* Define grahic cursor & hot spot */
int hot_x, hot_y;			/* Coordinates of hot spot	   */
unsigned far *mask;			/* Ptr to array of unsigned ints   */
{					/* (double words)		   */
	union REGS inregs;
	struct SREGS segregs;

	inregs.x.ax = 9;
	inregs.x.bx = hot_x;
	inregs.x.cx = hot_y;
	inregs.x.dx = FP_OFF(mask);
/* 19-Jun-90: NB - Bugfix: changed "ds" to "es" */
	segregs.es = FP_SEG(mask);
	int86x(0x33, &inregs, &inregs, &segregs);
	}

void
TextCursor(type, b1, b2)				/* Sets text cursor type & look		*/
int type;									/* Hardware or software					*/
unsigned int b1, b2;						/* Cursor parms							*/
	{
	union REGS inregs;

	inregs.x.ax = 10;
	inregs.x.bx = type;					/* soft = 0, hard = 1					*/
	inregs.x.cx = b1;						/* scan lines if type = 1,				*/
	inregs.x.dx = b2;						/*    else they are masks				*/
	callMDD;
	}

void
GetMickeys(p_x, p_y)						/* Get motion in mickeys since		*/
int *p_x, *p_y;							/* the last call. Mickey = 1/200"	*/
	{
	union REGS inregs;

	inregs.x.ax = 11;
	callMDD;
	*p_x = inregs.x.cx;					/* Left < 0, Right > 0					*/
	*p_y = inregs.x.dx;					/* Down < 0, Up > 0						*/
	}

void
InstallTrap(mask, trap_seg, trap_offset)
unsigned mask, trap_seg, trap_offset;
	{
	union REGS inregs;
	struct SREGS segregs;

	inregs.x.ax = 12;
	inregs.x.cx = mask;
	inregs.x.dx = trap_offset;
	segregs.es = trap_seg;
	int86x(0x33, &inregs, &inregs, &segregs);
	}

void
LightPenOn()
	{
	union REGS inregs;

	inregs.x.ax = 13;
	callMDD;
	}

void
LightPenOff()
	{
	union REGS inregs;

	inregs.x.ax = 14;
	callMDD;
	}

void
SetMickeysPerPixel(horz, vert)
int horz, vert;
	{
	union REGS inregs;

	inregs.x.ax = 15;
	inregs.x.cx = horz;
	inregs.x.dx = vert;
	callMDD;
	}

