/* 
ENUMWND.C

Microsoft C, Windows SDK:
cl -c -AS -Gsw -Oais -Zpe enuwnd.c winio.c wmhandlr.c
link enumwnd winio wmhandlr,enumwnd,nul,/nod slibcew libw,winio.def
rc winio.rc enumwnd.exe

Borland C++:
bcc -WS -G -O -Z -w-par -Hu enumwnd.c winio.c wmhandlr.c
copy winio.rc enumwnd.rc
rc winio.rc enumwnd.exe
*/

#include "windows.h"
#include <stdlib.h>
#include <string.h>
#include "winio.h"
#include "wmhandlr.h"

#define BUF_LEN     128

FARPROC enum_w = 0;
int num_wnd = 0;

void display_window(HWND hWnd, int level)
{
    RECT r;
    char *buf;
    int i;
    for (i=0; i<(int)level; i++)
        printf("   ");
    printf("%04X   ", hWnd);
    if (! (buf = malloc(BUF_LEN))) 
        return;
    if (GetClassName(hWnd, buf, BUF_LEN))
        printf("[%s]   ", buf);
    GetWindowRect(hWnd, &r);
    printf("(%d,%d,%d,%d)   ", r.left, r.top, r.right, r.bottom);
    if (GetWindowText(hWnd, buf, BUF_LEN))
        printf("<%s>", buf);
    putchar('\n');
    if (level == 0)
    {
        HANDLE hInst = GetWindowWord(hWnd, GWW_HINSTANCE);
        if (GetModuleFileName(hInst, buf, BUF_LEN))
            printf("   %s\n", buf);
    }
    free(buf);
}
    
/* MSC _export keyword: use instead of EXPORTS in .DEF file */
BOOL _export FAR PASCAL EnumW(HWND hWnd, DWORD level)
{
    static HWND seen[1024] = {0};
    HWND *ps;
    int i;
    
    /* cheap check for duplicates */
    for (i=0, ps=seen; i<num_wnd; i++, ps++)
        if (hWnd == *ps)
            return 1;
    if (num_wnd < 1024)
        seen[num_wnd++] = hWnd;

    display_window(hWnd, level);
    EnumChildWindows(hWnd, enum_w, level+1);
    return 1;   /* keep going */
}

void enumerate_windows(void)
{
    num_wnd = 0;
    winio_clear();
    winio_setpaint(FALSE);
    display_window(GetDesktopWindow(), 0);
    if (! EnumWindows(enum_w, 0))
        puts("EnumWindows failed");
    winio_setpaint(TRUE);
}
    
#define MENU_REFRESH    100
#define MENU_ABOUT      101

void exit_func(void)
{
    if (enum_w) FreeProcInstance(enum_w);
}

WMHANDLER prev_command;

long on_command(HWND hwnd, unsigned message, WORD wParam, LONG lParam)
{
    // can see where switch comes in: small now, tendency to grow though!
    switch (wParam)
    {
        case MENU_REFRESH:
            enumerate_windows();
            return 0;
        case MENU_ABOUT:
            MessageBox(hwnd, "Enumerate Windows\n"
                             "Version 1.0\n"
                             "(c) Andrew Schulman, April 1991\n"
                             "WINIO (c) David Maxey, April 1991",
                "Enumerate Windows", MB_OK);
            return 0;
        default:
            return (*prev_command)(hwnd, message, wParam, lParam);
    }
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    HWND hwnd;
    HMENU hmenu, hpopup;

    winio_settitle("Enumerate Windows");
    if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
        return 1;
    
    prev_command = wmhandler_set(WM_COMMAND, on_command);
    
    hpopup = CreatePopupMenu();
    AppendMenu(hpopup, MF_STRING, MENU_REFRESH, "&Refresh");
    AppendMenu(hpopup, MF_STRING, MENU_ABOUT, "&About...");
    hmenu = CreateMenu();
    AppendMenu(hmenu, MF_POPUP, hpopup, "&EnumWnd");
    hwnd = winio_hwnd();
    SetMenu(hwnd, hmenu);
    DrawMenuBar(hwnd);
    
    winio_setfont(ANSI_FIXED_FONT);
    atexit(exit_func);
    enum_w = MakeProcInstance((FARPROC) EnumW, hInstance);
    enumerate_windows();
    winio_end();
    return 0;
}

